@extends('layouts.app')
@section('style')
    <style>
        .v-select input[type=search], .v-select input[type=search]:focus {
            width: 50% !important;
        }
        .table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
            padding: 8px;
            padding: 4px 2px;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('menu.ImportExcel') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                
                <div class="pull-right">
                </div>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="tools text-center">
                        <a href="{{url('/')}}/import_file/simple_import_customer_with_opening_excel_fil.xlsx" style="text-decoration: none; color: black;"> --------
                           <button class="btn btn-success">
                           <i class="fa fa-download"></i>
                           @lang('layout.ImportExcelSample')
                           </button>
                        -------- </a>
                    </div>
                    <!-- BEGIN FORM-->
                    {{Form::open(['route'=>'customerImport.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'form-horizontal','id'=>'import-form'])}}
                        {{ csrf_field() }}
                        <div class="form-body">
                            <div class="col-md-12">
                                <div class="form-group" style="margin-top: 20px;">
                                    <label class="control-label col-md-5">@lang('layout.SelectFile') @lang('layout.Excel')
                                        :</label>
                                    <div class="col-md-7">
                                        {{Form::file('customer_file',null,['class' => 'form-control','placeholder' => __('layout.File')])}}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                            <button type="button" onClick="sendFormData(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                            </button>
                            <br/>
                            <br/>
                            <br/>
                            <br/>
                        </div>
                    {{Form::close()}}
                    <!-- end form -->
                </div>
                <div class="col-lg-4">
                    <ul class="text-danger">
                        <p class="text-danger">@lang('message.Info')</p>
                        <li class="text-danger">@lang('message.TipOne')</li>
                        <li class="text-danger">@lang('message.TipTwo')</li>
                        <li class="text-danger">@lang('message.TipThree')</li>
                    </ul>
                </div>
            </div>
            <div id="app" v-cloak>
                <h1 v-if="flag=='no'">@lang('layout.import_measure_msg')</h1>
                <div v-if="flag=='yes'" class="portlet-body form" style="margin-bottom:50%;">
                    
                    <div v-if="record.length>0">
                        <div style="overflow-x:scroll; width: 100%">
                            <!-- begint table -->
                            {{Form::open(['route'=>'customerImport.store','method'=>'POST','class'=>'form-horizontal','enctype'=>'multipart/form-data','id'=>'import-form-second'])}}
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-md-12 col-md-12">
                                    <div class="col-md-12" style="height: 400px;">
                                        <table id="table_content" class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th class="text-center" style="width:20px;">#</th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.Code')
                                                </th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.ReferenceNumber')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.FullName')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.FatherName')
                                                </th>
                                                <th class="text-center" style="min-width: 160px;">
                                                    @lang('layout.AccountsReceivable')
                                                </th>
                                                <th class="text-center" style="min-width: 160px;">
                                                    @lang('layout.AccountsPayable')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Gender')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Phone')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Class')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.PriceLevel')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Address')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Description')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.OpeningType')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Currency')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Rate')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Amount')
                                                </th> 
                                            </tr>
                                            </thead>
                                            <tr v-for="(obj,index) in record">
                                                <td class="td_one"><span class="badge badge3 badge-success badge-roundless">@{{index+1}} </span>
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" class="form-control" :name="'code['+index+']'" v-model="obj.code">
                                                </td>

                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'ref_no['+index+']'" v-model="obj.ref_no">
                                                </td>

                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'name['+index+']'" v-model="obj.name">
                                                </td>

                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'father_name['+index+']'" v-model="obj.father_name">
                                                </td>
                                                <td class="td_one">
                                                    <select class="form-control input-style" v-model="obj.receivable_id"
                                                            required="required" :name="'receivable_id['+index+']'" >
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option v-if="receivable_list" v-for="rec in (receivable_list?receivable_list:null)" :value="rec.id">
                                                            @{{rec.name}}
                                                        </option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <select class="form-control input-style" v-model="obj.payable_id"
                                                            required="required" :name="'payable_id['+index+']'" >
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option v-if="payable_list" v-for="pay in (payable_list?payable_list:null)" :value="pay.id">
                                                            @{{pay.name}}
                                                        </option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <div class="form-group">
                                                        <div class="col-md-12" >
                                                            <div style="border: 1px dotted ;">
                                                                <label class="radio-inline">
                                                                    <input type="radio" :name="'gender['+index+']'" :checked="obj.gender == 'male'" value="male"> @lang('layout.Male') </label>
                                                                <label class="radio-inline">
                                                                    <input type="radio" :name="'gender['+index+']'" :checked="obj.gender == 'female'" value="female" > @lang('layout.Female') </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'phone['+index+']'" v-model="obj.phone">
                                                </td>
                                                <td class="td_one">
                                                    <select class="form-control input-style" v-model="obj.class_id"
                                                            :name="'class_id['+index+']'" >
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option v-if="class_list" v-for="cla in (class_list?class_list:null)" :value="cla.id">
                                                            @{{cla.name}}
                                                        </option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <select class="form-control input-style" v-model="obj.price_level_id"
                                                            :name="'price_level_id['+index+']'" >
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option v-if="priceLevel_list" v-for="pri in (priceLevel_list?priceLevel_list:null)" :value="pri.id">
                                                            @{{pri.name}}
                                                        </option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'address['+index+']'" v-model="obj.address">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'description['+index+']'" v-model="obj.description">
                                                </td>
                                                <td class="td_one">
                                                    <div class="form-group">
                                                        <div class="col-md-12" >
                                                            <div style="border: 1px dotted ;">
                                                                <label class="radio-inline">
                                                                    <input type="radio" :name="'opening_type['+index+']'" :checked="obj.opening_type == 'receivable'" value="receivable"> @lang('layout.Receivable') </label>
                                                                <label class="radio-inline">
                                                                    <input type="radio" :name="'opening_type['+index+']'" :checked="obj.opening_type == 'payable'" value="payable" > @lang('layout.Payable') </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="td_one">
                                                    <v-select label="code" v-model="obj.currency" :options="currency_list">
                                                    </v-select>
                                                    <input type="hidden" :name="'currency['+index+']'" :value="(obj.currency==null)?null:obj.currency.code">
                                                </td>
                                                <td class="td_one">
                                                    <input type="" step="any" class="form-control" :name="'rate['+index+']'" ref="rate" @input="setNewRate(index)" :value="(obj.currency)?(obj.currency.rate):1">
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" step="any" class="form-control" :name="'amount['+index+']'" v-model="obj.amount">
                                                </td>

                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>

                            </div>


                            <!-- end table -->
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                            <button type="button" @click="sendFormData(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>

                        </div>
                        {{Form::close()}}
                    </div>
                </div>


            </div>

        </div>
    </div>

@endsection
@push('scripts')


    <script>
        Vue.component('v-select', VueSelect.VueSelect);

        var data ={!! $data !!};
        var receivable ={!! $receivable !!};
        var payable ={!! $payable !!};
        var priceLevel ={!! $priceLevel !!};
        var class_list ={!! $class !!};
        var currency ={!! $currency !!};

        new Vue({
            el: '#app',
            data: {
                flag: 'yes',
                record: data,
                receivable_list: receivable,
                priceLevel_list: priceLevel,
                payable_list: payable,
                class_list: class_list,
                currency_list: currency,
                cost_list: priceLevel,
                asset_list: payable,
                income_list: receivable,
                site_list: class_list,
                measure_list: currency,
                category_list: class_list,
                site_q: [],
            },
            methods: {
                setNewRate(index = null) {
                    if (this.record[index].currency) {
                        this.record[index].currency.rate = this.$refs.rate[index].value;
                    }
                },
                changeCost(e, index) {
                    this.record[index].cost = e.event.target.value;
                    return true;

                },
                changeAsset(e, index) {
                    this.record[index].asset = e.event.target.value;
                    return true;

                },
                sendFormData(e) {
                    var el = $(e);
                    var form = el.parents('form').get(0);
                    var data = $('#import-form').serialize();
                    console.log('test 22', data);
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: 'warning',
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    }).then((wichButton) => {
                        if (wichButton) {
                            //form.submit();
                            document.getElementById('import-form-second').submit();
                            return true;
                        }
                        return false;
                    });
                }
            },
            created: function () {
                console.log('ssssss', this.flag);
                for (var i = 0; i < this.record.length; i++) {
                    // for(var m=0;m<this.record[i].income_list.length;m++)
                    // {
                    //     console.log('ww',this.record[i].income_list[m].name);
                    // }
                }
            }
        });

        function sendFormData(e) {
            var el = $(e);
            var form = el.parents('form').get(0);
            var data = $('#import-form').serialize();
            console.log('test 22', data);
            swal({
                title: "@lang('layout.AreYouSure?')",
                icon: 'warning',
                buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                dangerMode: true,
            }).then((wichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            });
        }


        // to send inventory data

        function sendData(element) {
            e = $(e);
            var form = e.parents('form').get(0);
            swal({
                'title': "@lang('layout.AreYouSure?')",
                'icon': 'dander',
                'buttons': ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                danderMode: true
            }).then((whichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            })
        }

        // end inventory data

    </script>


@endpush