@extends('layouts.app')

@section('style')
    <style type="text/css">
        .modal-container {
            width: 60%;
            overflow-y: auto;
            max-height: 60%;
        }
    </style>
@stop
@section('content')
    @include('custome_reports.modal')
    <!-- app-->
    <div id="app" v-cloak>
        <form id="d_form" action="{{route('customeReport.store')}}" method="POST">
        {!! Form::token() !!}

        <!-- use the modal component, pass in the prop -->
            <modal v-if="showModal" @close="showModal = false">
                <div slot="body">
                    <div class="row">
                        <div class="form-group" id="dynamic_content">


                        </div>
                    </div>
                    <div class="row">

                        <div class="mt-checkbox-inline col-md-3" v-for="m in menus">

                            <div class="form-group">
                                <label class="mt-checkbox"> @{{m.name}}
                                    <input type="checkbox" v-model="m.check" :checked="m.check"/>
                                    <input type="hidden" name="col_id[]" :value="m.col_id">
                                    <input type="hidden" name="checked_col[]" :value="(m.check)?1:0">
                                    <span></span>
                                </label>

                            </div>
                        </div>
                    </div>


                </div>
                <div slot="footer">
                    <button type="button" class="btn default" @click="saveForm">
                        @lang('layout.Submit')
                    </button>
                    <button type="button" class="btn btn-danger" @click="close">
                        @lang('layout.Cancel')
                    </button>
                </div>
            </modal>
        </form>
    </div>
    <!-- app -->
    <div class="row">

        <div class="portlet light" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomeReport') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->


                <!-- BEGIN FinancialReport-->

                <!-- END FinancialReport-->

                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.StatementDetails') </div>
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.StatementDetails')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('statement')" id="account"
                                            class="btn default"> @lang('layout.StatementDetails') </button>


                                </div>

                                 <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('member_general_statement')" id="member_class"
                                            class="btn default"> @lang('layout.MemberGeneralStatement') </button>


                                </div>

                            </div>

                    </div>
                </div>

                <!-- BEGIN Account-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Account') </div>
                        
                    </div>
                    <div class="portlet-body">
                        
                            <div class="row">
                                <div class="col-md-4">@lang('layout.Account')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('account')" id="account"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('account_detail')"
                                            id="account_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.TransferAccount')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('transfer_account')"
                                            id="transfer_account" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('transfer_account_detail')"
                                            id="transfer_account_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.JournalEntry')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('journal_entry')"
                                            id="journal_entry" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('journal_entry_detail')"
                                            id="journal_entry_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.Discount')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('discount')" id="discount"
                                            class="btn default"> @lang('layout.Index') </button>
                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('discount_detail')"
                                            id="discount_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.CashBook')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('cash_book')" id="discount"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                               
                            </div>




                    </div>
                </div>
                <!-- END Account-->


                <!-- BEGIN Inventory-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Inventory') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Inventory')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('inventory')" id="inventory"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('inventory_detail')"
                                            id="inventory_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.Adjustment')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('adjustment')" id="adjustment"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('adjustment_detail')"
                                            id="adjustment_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.InventorySite')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('inventory_site')"
                                            id="inventory_site" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('inventory_site_detail')"
                                            id="inventory_site_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.InventoryCategory')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('inventory_category')"
                                            id="inventory_category" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('inventory_category_detail')"
                                            id="inventory_category_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.InventoryTransfer')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('inventory_transfer')"
                                            id="inventory_transfer" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('inventory_transfer_detail')"
                                            id="inventory_transfer_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.TransferAndLoading')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('transfer_and_loading')"
                                            id="inventory_transfer" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.AdvancePricing')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('advance_pricing')"
                                            id="advance_pricing" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('advance_pricing_detail')"
                                            id="advance_pricing_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.ItemExpense')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('item_expense')" id="item_expense"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('item_expense_detail')"
                                            id="item_expense_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('menu.ItemNoneCost')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('item_none_cost')" id="item_expense"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('item_none_cost_detail')"
                                            id="item_expense_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>


                    </div>
                </div>
                <!-- END Inventory-->

                <!-- BEGIN Services-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('menu.Services') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('menu.Services')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('services')" id="services"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('services_detail')"
                                            id="services_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.ServiceClass')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('service_class')"
                                            id="service_class" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('service_class_detail')"
                                            id="service_class_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.StorageRent')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('storage_rent')"
                                            id="service_class" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('storage_rent_detail')"
                                            id="service_class_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>



                    </div>
                </div>
                <!-- END Services-->

                <!-- BEGIN Assembly-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Assembly') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Assembly')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('assembly')" id="assembly"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('assembly_detail')"
                                            id="assembly_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.Build')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('build')" id="build"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('build_detail')" id="build_detail"
                                            class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>

                    </div>
                </div>
                <!-- END Assembly-->

                <!-- BEGIN Sale-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Sale') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Sale')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('sales')" id="sales"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('sales_detail')" id="sales_detail"
                                            class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.Invoice')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('invoice')" id="invoice"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('invoice_detail')"
                                            id="invoice_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.Refund')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('refund')" id="refund"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('refund_detail')"
                                            id="refund_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('menu.SalesOrder')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('sales_order')" id="sales_order"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('sales_order_detail')"
                                            id="sales_order_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.Estimates')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('estimates')" id="estimates"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('estimates_detail')"
                                            id="estimates_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>

                    </div>
                </div>
                <!-- END Sale-->


                <!-- BEGIN Purchase-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Purchase') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Purchase')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('purchase')" id="purchase"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('purchase_detail')"
                                            id="purchase_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.EnterBills')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('enter_bills')" id="enter_bills"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('enter_bills_detail')"
                                            id="enter_bills_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.Return')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('return')" id="return"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('return_detail')"
                                            id="return_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.PurchaseOrder')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('Purchase_order')"
                                            id="Purchase_order" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('Purchase_order_detail')"
                                            id="Purchase_order_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>


                    </div>
                </div>
                <!-- END Purchase-->

                <!-- BEGIN Expense-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Expense') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Expense')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('expense')" id="expense"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('expense_detail')"
                                            id="expense_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.DailyExpense')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('daily_expenses')"
                                            id="daily_expenses" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('daily_expenses_detail')"
                                            id="daily_expenses_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.ExpenseCategory')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('expense_category')"
                                            id="expense_category" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('expense_category_detail')"
                                            id="expense_category_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>


                    </div>
                </div>
                <!-- END Expense-->

                <!-- BEGIN Contract-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Contract') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Contract')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('contract')" id="contract"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('contract_detail')"
                                            id="contract_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.SendMoney')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('money_transfer')"
                                            id="money_transfer" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('money_transfer_detail')"
                                            id="money_transfer_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>


                    </div>
                </div>
                <!-- END Contract-->

                <!-- BEGIN Payment-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Payment') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Payment')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('payment')" id="payment"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('payment_detail')"
                                            id="payment_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>


                    </div>
                </div>
                <!-- END Payment-->

                <!-- BEGIN Receive-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Receive') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Receive')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('receive')" id="receive"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('receive_detail')"
                                            id="receive_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>


                    </div>
                </div>
                <!-- END Receive-->

                <!-- BEGIN Loan-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Loan') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Loan')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('loan')" id="loan"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('loan_detail')" id="loan_detail"
                                            class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>

                    </div>
                </div>
                <!-- END Loan-->

                <!-- BEGIN Employee-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('layout.Employee') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('layout.Employee')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('employee')" id="employee"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('employee_detail')"
                                            id="employee_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('layout.SalaryDetails')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('salary_details')"
                                            id="salary_details" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('salary_details_detail')"
                                            id="salary_details_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.Payroll')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('payroll')" id="payroll"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('payroll_detail')"
                                            id="payroll_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.PaySalary')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('pay_salary')" id="pay_salary"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('pay_salary_detail')"
                                            id="pay_salary_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>

                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.MemberGeneralStatement')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('member_general_statement')" id="member_class"
                                            class="btn default"> @lang('layout.MemberGeneralStatement') </button>


                                </div>
                              
                            </div>

                    </div>
                </div>
                <!-- END Employee-->


                <!-- BEGIN Customers-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('menu.Customers') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('menu.Customers')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('customers')" id="customers"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('customers_detail')"
                                            id="customers_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('menu.MemberClass')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('member_class')" id="member_class"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('member_class_detail')"
                                            id="member_class_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">@lang('layout.MemberGeneralStatement')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('member_general_statement')" id="member_class"
                                            class="btn default"> @lang('layout.MemberGeneralStatement') </button>


                                </div>
                              
                            </div>

                    </div>
                </div>
                <!-- END Customers-->

                <!-- BEGIN Vendor-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('menu.Vendor') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('menu.Vendor')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('vendor')" id="vendor"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('vendor_detail')"
                                            id="vendor_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>


                            <div class="row">
                                <div class="col-md-4">@lang('layout.MemberGeneralStatement')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('member_general_statement')" id="member_class"
                                            class="btn default"> @lang('layout.MemberGeneralStatement') </button>


                                </div>
                              
                            </div>

                    </div>
                </div>
                <!-- END Vendor-->

                <!-- BEGIN Owner-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('menu.Owner') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('menu.Owner')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('owner')" id="owner"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('owner_detail')" id="owner_detail"
                                            class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('menu.Drawing')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('drawing')" id="drawing"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('drawing_detail')"
                                            id="drawing_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>

                    </div>
                </div>
                <!-- END Owner-->

                <!-- BEGIN MemberTransfer-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('menu.MemberTransfer') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('menu.MemberTransfer')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('member_transfer')"
                                            id="member_transfer" class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('member_transfer_detail')"
                                            id="member_transfer_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>


                    </div>
                </div>
                <!-- END MemberTransfer-->

                <!-- BEGIN Transport-->
                <div class="portlet box default">
                    <div class="portlet-title">
                        <div class="caption">
                            <i></i>@lang('menu.Transport') </div>
                        
                    </div>
                    <div class="portlet-body">
                        <div class="row">
                                <div class="col-md-4">@lang('menu.Transport')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('transport')" id="transport"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('transport_detail')"
                                            id="transport_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-md-4">@lang('menu.Product')</div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('product')" id="product"
                                            class="btn default"> @lang('layout.Index') </button>


                                </div>
                                <div class="col-md-4">
                                    <button type="button" onClick="report_by_type_pdf('product_detail')"
                                            id="product_detail" class="btn default"> @lang('layout.Details') </button>
                                </div>
                            </div>


                    </div>
                </div>
                <!-- END Transport-->


            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        })
        // start app
        var vm = new Vue({
            el: '#app',
            data: {
                showModal: false,
                menus: []
            },
            methods: {
                ok: function () {
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                getModalContent(myData) {
                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example").persianDatepicker(modelDate());
                            from = $("#range-from-example").persianDatepicker(modelDate());

                            document.getElementById('dynamic_content').innerHTML = myData;
                        });
                    })
                },

                saveForm() {

                    var data = $('#d_form').serialize();
                    axios.post("{{route('customeReport.store')}}", data)
                        .then((res) => {
                            this.showModal = false;
                        })
                        .catch((erro) => {
                            console.log(erro);
                        })
                }
            },
        })


        function report_by_type_pdf(menu, type = null) {

            vm.menus = [];
            $('#show-modal').click();
            var myid = event.target.id;
            var type_id = myid;
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: "customeReport",
                    menu: menu,
                    type: type,
                }
            })
                .then(function (response) {
                    if (response.data.length > 0) {
                        vm.menus = response.data;
                    }
                    // console.log('Estatement',vm.menus)
                })
                .catch(function (error) {
                    console.log(error);
                });

            var myhtml = `<input type="hidden" name="menu" value="${menu}">
                    <input type="hidden" name="type" value="${type}">`;

            vm.getModalContent(myhtml);

        }


    </script>

@endpush