@extends('layouts.factor-master')


@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('menu.CurrencyExchange')</h3>
<table class="main-table">
    <tr>
        <th> @lang('layout.Number')</th>
        <th> @lang('layout.Type')</th>
        <th> @lang('layout.Customer')</th>
        <th> @lang('layout.Date')</th>
    </tr>
    <tr>
        <th class=""> {{ $currencyExch->number}} </th>
        <th class=""> {{ __('type.' . $currencyExch->type)}} </th>
        <th class=""> {{ $currencyExch->Member}} </th>
        <th>{{convertDate($currencyExch->Date)}} ----- {{$currencyExch->Date}}</th>
    </tr>
</table>
<table class="main-table" style="margin-top: 15px;">
    <tr>
        <th> @lang('layout.Account')</th>
        <th> @lang('layout.Currency')</th>
        <th> @lang('layout.Rate')</th>
        <th> @lang('layout.Amount')</th>
        <th>@lang('layout.Description')</th>
    </tr>
    <tr>
        <th class=""> {{ $currencyExch->Account}} </th>
        <th class=""> {{ $currencyExch->currency}} </th>
        <th class=""> {{ myRound($currencyExch->rate)}} </th>
        <th class=""><b> {{ myRound($currencyExch->amount)}} </b> </th>
        <th align="center">
            <?php
            $des = wordwrap($currencyExch->description, 60, "<br/>\n", false);
            echo $des;
            ?>
        </th>
    </tr>
</table>

<table class="main-table" style="margin-top: 15px;">
    <thead>
        <tr>
            <th width="30%"> @lang('layout.ExchangedAmount') </th>
            <th width="20%"> @lang('layout.ExchangedRate') </th>
            <th width="50%">@lang('layout.MohrAndSignature')</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <th>{{myRound($currencyExch->ex_amount)}} {{$currencyExch->ex_currency}}</th>
            <th>{{myRound($currencyExch->ex_rate)}}</th>
            <th style="height: 40px"></th>
        </tr>
    </tbody>
</table>

@if(company()['exchange_message'])
<table width="100%">
    <tr>
        <th style="font-size: 14px;">{!!company()['exchange_message']!!}</th>
    </tr>

    <tr>
        <th></th>
        <th></th>
    </tr>


</table>
@endif
@endsection