@extends('layouts.app')

@section('content')

<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.CurrencyExchangeDetails')
        </div>
        <div class=" pull-right">
            <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th>
                            <i class="fa  fa"></i> @lang('layout.Number')
                        </th>
                        <th>
                            <i class="fa  fa"></i> @lang('layout.ReferenceNumber')
                        </th>
                        <th>
                            <i class="fa fa-"></i> @lang('layout.Type')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th class="">
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Amount')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Rate')
                        </th>
                        <th>@lang('layout.TodayRate')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{ $currencyExch->number}} </td>
                        <td class=""> {{ $currencyExch->ref_no}} </td>
                        <td class=""> {{ __('type.'.$currencyExch->type) }} </td>
                        <td class=""> {{ convertDate($currencyExch->Date) }} </td>
                        <td class=""> {{$currencyExch->Account}} </td>
                        <td class=""> {{ myRound($currencyExch->amount)}} {{ $currencyExch->currency}} </td>
                        <td class=""> {{myRound($currencyExch->rate)}} </td>
                        <td class=""> {{myRound($currencyExch->sp_today_rate)}} </td>
                        {{-- <td class=""> {{myRound($currencyExch->sp_today_rate)}} </td> --}}
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.FatherName')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.SSN') / @lang('layout.PassportNumber')</th>
                        <th>@lang('layout.Address')</th>
                        <th>@lang('layout.MonetarySource')</th>
                        <th>@lang('layout.TransactionType')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{$currencyExch->Member}} </td>
                        <td class=""> {{$currencyExch->father_name}} </td>
                        <td class=""> {{$currencyExch->phone}} </td>
                        <td class=""> {{$currencyExch->ssn}} </td>
                        <td class=""> {{$currencyExch->d_address}} </td>
                        <td class=""> {{$currencyExch->monetary_source}} </td>
                        <td class=""> {{$currencyExch->trans_type}} </td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th>@lang('layout.ExchangedAccount')</th>
                        <th>@lang('layout.ExchangedAmount')</th>
                        <th>@lang('layout.ExchangedRate')</th>
                        <th>@lang('layout.TodayRate')</th>
                        <th>@lang('layout.ProfitAndLost')</th>
                        <th>@lang('layout.User')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{$currencyExch->ExAccount}} </td>
                        <td class=""> {{ myRound($currencyExch->ex_amount)}} {{ $currencyExch->ex_currency}} </td>
                        <td class=""> {{myRound($currencyExch->ex_rate)}} </td>
                        <td class=""> {{myRound($currencyExch->ex_today_rate)}} </td>
                        <td class=""> {{myRound($currencyExch->gl_amount)}} </td>
                        <td class=""> {{$currencyExch->username}} </td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th>
                            <i class="fa fa-bars"></i> @lang('layout.Description')
                        </th>
                        <th>
                            <i class="fa fa-bars"></i> @lang('layout.Description')1
                        </th>
                        <th>
                            <i class="fa fa-bars"></i> @lang('layout.Description')2
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{ $currencyExch->description }} </td>
                        <td class=""> {{ $currencyExch->description1 }} </td>
                        <td class=""> {{ $currencyExch->description2 }} </td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover" id="loan_table" >
                <thead> 
                    <tr>
                        @if(systemConfig()[29] == 1)
                        <th>
                            <i class="fa "></i> @lang('layout.TransactionConfirm')
                        </th> 
                        <th>
                            <i class="fa "></i> @lang('layout.Description')
                        </th>   
                        <th>
                            <i class="fa "></i> @lang('layout.Status')
                        </th>  
                        @endif      
                    </tr>
                </thead>
                <tbody>
                <tr>  
                    @if(systemConfig()[29] == 1)
                    @if($currencyExch->transaction_confirm)
                    <td class="">
                        @lang('layout.yes')
                    </td>
                    @else
                    <td class="">
                        @lang('layout.no')
                    </td>
                    @endif
                    <td class="">
                        {{$currencyExch->position_description}}
                    </td>
                    <td class="">
                    @if($currencyExch->position_status == 'accept')
                    @lang('type.accept')
                    @elseif($currencyExch->position_status == 'true')
                    @lang('type.pending') &nbsp;&nbsp;&nbsp;&nbsp;
                    @if (getPositionCurrencyAmount() > $currencyExch->exchanged_amount)
                    <form action="{{route('currencyExchange.position_status', ['id' => $currencyExch->id, 'type' => 'accupt'])}}" method="post" class="inline">
                        <input type="hidden" name="_method" value="PATCH" />
                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                        <input type="text" name="position_description" required style="width: 40%;" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <label class="mt-checkbox mt-checkbox-outline"  style="color: green;">
                            <input type="radio" value="accupt" required name="type"><span></span> @lang('layout.Accept')
                        </label>
                        &nbsp;&nbsp;
                        <label class="mt-checkbox mt-checkbox-outline" style="color: red;">
                            <input type="radio" value="reject" required name="type"><span></span> @lang('layout.Reject')
                        </label>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <button type="button" onclick="regForm(this)" class="btn btn-info " title="{{__('layout.Submit')}}" role="button">{{__('layout.Submit')}}</button>
                    </form>
                    {{-- &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <form action="{{route('currencyExchange.position_status', ['id' => $currencyExch->id, 'type' => 'false'])}}" method="post" class="inline">
                        <input type="hidden" name="_method" value="PATCH" />
                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                        <input type="text" name="position_description" style="width: 35%;" />
                        <button type="button" onclick="regForm(this)" class="btn btn-warning " title="{{__('type.on')}}" role="button"><span class="fa fa-ban"></button>
                    </form>   --}}
                    @endif
                    @elseif($currencyExch->position_status == 'reject')
                        @lang('type.Rejected')
                    @elseif($currencyExch->position_status == 'false')
                        @lang('type.cancel')
                    @endif
                    </td>
                    @endif
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>



<div class="row hidden-print">
    <div class="tabbable tabbable-tabdrop">

        <ul class="nav nav-tabs">

            <li class="active">
                <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
            </li>
        </ul>
        <div class="tab-content">

            <div class="tab-pane active" id="tab2">
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="redirect_route" value="currencyExchange.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$currencyExch->id}}">
                                        <input type="hidden" name="path" value="uploads/currencyExchange">
                                        <input type="hidden" name="table_name" value="currency_exchanges">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" rows="8" class="form-control" style="resize: none;"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                        <div>
                                                            <span class="btn default btn-file">
                                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                <input type="hidden" value="" name=""><input type="file" name="photo"> 
                                                            </span>
                                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>
                                                        <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                                            <img src="" alt=""> </div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 150px; line-height: 10px;"> </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margin-top-10 text-center">
                                            <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.AttachmentTitle')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.Action')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>

@endsection

@push('scripts')

<script>
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#attachment').DataTable({
            ajax: {
                url: '{{route("currencyExchange.show",$currencyExch->id)}}',
                data: {
                    type: 'attachment'
                }
            },

            scrollCollapse: true,
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                {
                    data: 'title',
                    name: 'attachments.title'
                },
                {
                    data: 'description',
                    name: 'attachments.description'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                },
            ]
        });



    });
</script>
@endpush