@extends('layouts.app')
@section('content')
@include("layouts.Cmodal")
@include('loans.modal')
<style type="text/css">
    hr {
        border-top: 1px solid #b1adad;
    }
</style>
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allCurrencyExchangeReports'" @closed="closeModal">
        <div slot="body"> 
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            -----------------------------------------------> 
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectMember') </label>
                                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member"> </v-select>
                                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectType') </label>
                                            <select name="type_name" id="" class="form-control">
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="SaleCurrency">@lang('layout.SaleCurrency')</option>
                                                <option value="BuyCurrency">@lang('layout.BuyCurrency')</option>
                                            </select>
                                        </div> 
                                        <div class="col-md-4">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                                            <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label class="control-label ">@lang('layout.SelectClass')</label>
                                        <v-select class="vue-select2"
                                                  v-model="selected_class"
                                                  label="name"
                                                  :options="member_class">
                                        </v-select>
                                        <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                                    </div>
                                    @if(systemConfig()[29] == 1) 
                                    <div class="col-md-3">
                                        <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline"> 
                                                <input type="checkbox" name="transaction_confirm" value="On">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                    <div class="col-md-4" style="padding-right: 0px !important; padding-left: 0px !important;">
                                        @if(getFinancialClass() =='true') 
                                        @permission('financialClass-list')
                                        <div class="col-md-12">
                                            <label class="control-label"> @lang('menu.FinancialClass')</label>
                                            <select name="financial_class_id" class="form-control" >
                                                <option value="">@lang('layout.SelectClass')</option>
                                                <option value="Unclassified">Unclassified</option>
                                                <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                            </select>
                                        </div>
                                        @endpermission
                                        @endif
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-8" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="currency_exchanges_index">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <!-- <label> @{{ row.Name }}</label>
                                                          <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                         <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                              <span class="slider round"></span>
                                                        </label> -->
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
        </div>
    </report-modal>
</div>
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('menu.CurrencyExchange') &nbsp; &nbsp; &nbsp; </span>
            </div>
            <div class="tools"></div>
            <div class="pull-right">
                <span onclick="getRecord();" class="btn blue">
                    <i class="fa fa-refresh"></i>
                </span>
                @permission(['currencyExchange-export'])
                <span id="anchore-modal">
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                    </a>
                </span>
                @endpermission
                <!-- <a href="{{route('currencyExchange.create')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a> -->
                @permission(['currencyExchange-create'])
                <span id="create-modal">
                    <a href="#" @click.prevent="showModal">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </span>
                @endpermission
            </div>
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
        </div>
        <div class="portlet-body">
            <!-- BEGIN FORM-->
            @permission(['currencyExchange-create'])
            {!! Form::open(array('route' => 'currencyExchange.store','method'=>'POST','class'=>'form-horizontal','id'=>'loan-submit')) !!}
            {{ csrf_field() }}
            <div class="form-body col-md-12" id="app" v-cloak>
                <div class="row" v-show="show_create" style="margin-bottom: 20px; border-bottom: 2px solid rgba(172, 171, 171, 0.877);padding-bottom: 20px;">
                    <input type="hidden" name="position_status" v-model="position_status" >
                    <div class="col-lg-8 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-12">
                                <div class="col-lg-4">
                                    <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                    <div class="md-radio-inline">
                                        <div class="md-radio">
                                            <input type="radio" id="radio1" name="type" v-model="loanType" value="BuyCurrency" class="md-radiobtn" checked="">
                                            <label for="radio1">
                                                <span class="inc"></span>
                                                <span class="check"></span>
                                                <span class="box"></span> @lang('layout.BuyCurrency') 
                                            </label>
                                        </div>
                                        <div class="md-radio">
                                            <input type="radio" id="radio2" name="type" v-model="loanType" value="SaleCurrency" class="md-radiobtn">
                                            <label for="radio2">
                                                <span class="inc"></span>
                                                <span class="check"></span>
                                                <span class="box"></span> @lang('layout.SaleCurrency') 
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" v-model="number">
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" v-model='ref_no'>
                                    <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                            </div>
                            <div class="col-lg-12" style="background-color: #edfeff; padding-bottom: 15px;border-radius: 10px;">
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select v-model="selectedCurrency" label="code" :options="currency" @input="setSize(selectedCurrency.code), get_exchange()"> </v-select>
                                    <input type="hidden" name="sp_currency" v-bind:value="selectedCurrency.code" />
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Rate') </label>
                                    <div :class="{'has-error':selectedCurrency.rate < 0}">
                                        <!-- <div class="input-group"> -->
                                        <input v-model="selected_rate" :readonly="selectedCurrency.code == '{{getHomeCurrency()["code"]}}'" class="form-control" type="number" step="any" min="0" @keyup="check_code(paymentCurrency.code), get_exchange()" @click="check_code(paymentCurrency.code), get_exchange()">
                                        <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                        </div> -->
                                        <input type="hidden" name="sp_rate" :value="selected_rate">
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Amount') <span v-if="amount_to_word" class="text-danger">( @{{amount_to_word}} )</span></label>
                                    <vue-numeric
                                        class="form-control"
                                        v-model="amount"
                                        :max="99999999999999"
                                        :currency="selectedCurrency.code"
                                        :precision="precision()"
                                        @input="get_exchange(), getTranslateToWord()"
                                        >
                                    </vue-numeric>
                                    <input type="hidden" name="sp_amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                    <span class="required">@{{ errors.first('sp_amount') }}</span>
                                    
                                </div>
                                <div class="col-lg-12" style="padding: 0px !important;">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="sp_account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)" required v-validate="'required'" data-vv-as="@lang('layout.Account')">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                            </option>
                                        </select>
                                        <span class="required">@{{ errors.first('sp_account_id') }}</span>
                                    </div>
                                    <div class="col-md-6">
                                        <span v-if="checkLoan" v-show="false">
                                            @{{balance = Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))}}
                                        </span>
                                        <span v-else v-show="false">
                                            @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                        </span>
                                        <label class="control-label">@lang('layout.Balance')</label>
                                        <div class="input-group">
                                            <input class="form-control" disabled :value="balance.toFixed(precision())">
                                            <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12" style="background-color: #f2ffed; padding-bottom: 15px;border-radius: 10px;margin-top: 5px;">
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.ExchangedCurrency')</label>
                                    <v-select v-model="paymentCurrency" label="code" :options="currency1" @input="setPaymentSize(paymentCurrency.code), get_exchange(), getTranslateToWordExchange()"> </v-select>
                                    <input type="hidden" name="ex_currency" v-bind:value="paymentCurrency.code" />
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.ExchangedRate') </label>
                                    <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                        <!-- <div class="input-group"> -->
                                        <input v-model="selected_rate1" :readonly="paymentCurrency.code == '{{getHomeCurrency()["code"]}}'" class="form-control" type="number" min="0" step="any" @input="get_exchange()">
                                        <!-- <span class="input-group-addon">@{{paymentCurrency.code}}</span>
                                        </div> -->
                                        <input type="hidden" name="ex_rate" :value="selected_rate1">
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <vue-numeric
                                        class="form-control"
                                        v-model="exchange_amount"
                                        :max="99999999999999"
                                        :currency="paymentCurrency.code"
                                        :precision="precision()"
                                        @input="set_rate(), getTranslateToWordExchange()"
                                        >
                                    </vue-numeric>
                                    <input type="hidden" name="ex_amount" v-model="exchange_amount" v-validate="'required'" data-vv-as="@lang('layout.Amount')" class="form-control" min="0" step="any">
                                    <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(4)">
                                    
                                    <span class="required">@{{ errors.first('ex_amount') }}</span>
                                    {{-- <span v-if="exchange_amount_to_word" >@{{exchange_amount_to_word}}</span> --}}
                                </div>
                                <div class="col-lg-12" style="padding: 0px !important;">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.ExchangedAccount')</label>
                                        <select class="form-control" name="ex_account_id" v-model="defaultExAccount" v-on:change="testEX(defaultExAccount)" required v-validate="'required'" data-vv-as="@lang('layout.Account')">
                                            <option v-for="Account in exAccountUpdate" :value="Account.id">@{{ Account.name }}
                                            </option>
                                        </select>
                                        <span class="required">@{{ errors.first('ex_account_id') }}</span>
                                    </div>
                                    <div class="col-md-6">
                                        <span v-if="loanType == 'BuyCurrency'" v-show="false">
                                            @{{exBalance = Number(selectedExBank.balance)-(Number(exchange_amount)-Number(defaultAmount)) }}
                                        </span>
                                        <span v-else v-show="false">
                                            @{{exBalance = Number(selectedExBank.balance)+(Number(exchange_amount)-Number(defaultAmount))}}
                                        </span>
        
        
                                        <label class="control-label">@lang('layout.Balance')</label>
                                        <div class="input-group">
                                            <input class="form-control" disabled :value="exBalance.toFixed(precision())">
                                            <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="col-lg-4" v-if="d_member">
                                    <label class="control-label ">@lang('layout.Member')</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <input type="checkbox" v-model="d_member">
                                            <span></span>
                                        </span>
                                        <v-select class="vue-select2" v-model="selectedMember" @search="MemberSearch" @input="getSummary()" label="name" :options="member">
                                        </v-select>
                                        <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')" >
                                        <span class="required">@{{ errors.first('member_id') }}</span>
                                        <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                    </div>
                                </div>
                                <div class="col-lg-4" v-if="!d_member">
                                    <label class="control-label ">@lang('layout.Name')</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <input type="checkbox" v-model="d_member">
                                            <span></span>
                                        </span>
                                        <input type="text" name="member_name"  class="form-control" v-validate="'required'" data-vv-as="@lang('layout.Name')" >
                                        <span class="required">@{{ errors.first('member_name') }}</span>
                                    </div>
                                </div>
                                <div class="col-lg-4" v-if="!d_member">
                                    <label class="control-label">@lang('layout.FatherName')</label>
                                    <input type="text" class="form-control" autocomplete="off" name="father_name" >
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text"  class="form-control date" autocomplete="off" name="date">
                                </div>
                                <div v-if="!d_member">
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Phone')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="phone" v-validate="'required'" data-vv-as="@lang('layout.Phone')" >    
                                        <span class="required">@{{ errors.first('phone') }}</span>
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.SSN') / @lang('layout.PassportNumber')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="ssn_number">
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Address')</label>
                                        <input type="text" class="form-control" autocomplete="off" name="address">
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label ">@lang('layout.Income')</label>
                                    <v-select class="vue-select2" v-model="selectedIncome" label="name" :options="income">
                                    </v-select>
                                    <input type="hidden" name="income_id" :value="(!selectedIncome)?null:selectedIncome.id" >
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label ">@lang('layout.UnitCostAccount')</label>
                                    <v-select class="vue-select2" v-model="selectedCost" label="name" :options="cost">
                                    </v-select>
                                    <input type="hidden" name="cost_id" :value="(!selectedCost)?null:selectedCost.id" >
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label">@lang('layout.MonetarySource')</label>
                                    {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                </div>
                                <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.TransactionType')</label>
                                        {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                    </div>
                                    @if(systemConfig()[29] == 1)
                                        <div class="col-lg-4">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <div class="col-md-12 mt-checkbox">
                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                    <input type="checkbox" name="transaction_confirm" value="On" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')" >
                                                    <span></span>
                                                </label>
                                            </div>
                                            <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                        </div>
                                    @endif
                                    @if(getTelegramBot()=="true")
                                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12" style="display: flex; justify-content: center;align-items: center; flex-direction: column;">
                                        <label class="control-label"> <span class="fa fa-telegram" style="color:rgb(14 177 177);"></span> @lang('layout.Telegram')</label>
                                        <div class="mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="telegram" value="ok" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                    @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')                    
                                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                        <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox"  name="whatsapp" value="5" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-12 col-sm-12" style="margin-bottom: 10px;">
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                            <div class="row">
                                <div class="col-lg-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    <span v-if="description1 == false" class="btn " @click="description1 = true">@lang('layout.More')....</button>
                                </div>
                                @if(getWhatsApp() =='true')                    
                                    <!-- <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                        <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox"  name="whatsapp" value="2" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div> -->
                                @endif
                            </div>
                            <div class="row" v-if="description1 == true">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')1</label>
                                    {!! Form::textarea('description1', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    <span v-if="description2 == false" class="btn " @click="description2 = true">@lang('layout.More')....</button>
                                </div>
                            </div>
                            <div class="row"v-if="description2 == true" style="padding: 0% 0% 2% 0%;">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')2</label>
                                    {!! Form::textarea('description2', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                            <div class="row">
                                <div class="dashboard-stat2 col-lg-12" v-if="all_currency">
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th colspan="2" style="background-color: #add8e6; text-align: center;">@lang('layout.TodayRate') -- @lang('layout.BaseCurrency') ( {!! getHomeCurrency()["code"] !!} )</th>
                                            </tr>
                                            <tr>
                                                <th class="text-center" style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                <th class="text-center" style="background-color: #add8e6;">@lang('layout.Rate')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <span>
                                                <tr v-for="crr in all_currency" class="text-center">
                                                    <span v-if="selectedCurrency">
                                                        <td v-if="selectedCurrency.code == crr.code">
                                                            @{{ crr.code }}
                                                        </td>
                                                        <td v-if="selectedCurrency.code == crr.code">
                                                            @{{(crr.rate)}} <input type="hidden" name="sp_today_rate" :value="crr.rate" />
                                                        </td>
                                                    </span>
                                                    <span v-if="selectedCurrency && paymentCurrency">
                                                        <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                            @{{ crr.code }}
                                                        </td>
                                                        <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                            @{{(crr.rate)}}
                                                        </td>
                                                        <td v-if="paymentCurrency.code == crr.code" v-show="false">
                                                            <input type="hidden" name="ex_today_rate" :value="crr.rate" />
                                                        </td>
                                                    </span>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="dashboard-stat2" v-if="selectedMember">
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                <th class="text-center" style="background-color: #add8e6;">@lang('layout.Payable')</th>
                                                <th class="text-center" style="background-color: #add8e6;">@lang('layout.Receivable')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <span>
                                                <tr v-for="summ in summary" class="text-center">
                                                    <td>
                                                        @{{ summ.currency }}
                                                    </td>
                                                    <td class=""> @{{ format_number(Number(summ.payment)) }}</td>
                                                    <td>
                                                        @{{format_number(Number(summ.invoice)) }}
                                                    </td>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                    @if(systemConfig()[22] == 1) 
                                    <br/>
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th style="background-color: #add8e6;text-align: center;" v-if="selectedMember.risk_step">
                                                    @lang('layout.RiskStep')
                                                </th>
                                                <th v-if="selectedMember.risk_step == 'High'" style="background-color: #ff5353;text-align: center;" > @lang('type.High')</th>
                                                <th v-if="selectedMember.risk_step == 'Medium'" style="background-color: #ffe291;text-align: center;" > @lang('type.Medium')</th>
                                                <th v-if="selectedMember.risk_step == 'Low'" style="background-color: #8aff9a;text-align: center;" > @lang('type.Low')</th>
                                            </tr>
                                        </thead>
                                    </table>    
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                        </div>
                    </div>
                    <div class="row" v-show="show_create" >
                        <div class="col-lg-12 text-center">
                            <br>
                            <button v-if="isError ==false" type="button" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                            <button v-if="isError ==false" type="button" class="btn blue" :disabled="disabled" @click="checkAmount($event)">@lang('layout.SaveAndNew')</button>
                            <a @click="show_create = false, clearData()" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                    <cmodal :show='showModal' @close="showModal=false">
                    </cmodal>
                </div>
            </div>
            {!! Form::close() !!}
            @endpermission
            <!-- END FORM-->
            <!-- start list -->
            <table class="table table-striped table-bordered table-hover" id="loan" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th width="1%">#</th>
                        <th width="1%">@lang('layout.Number')</th>
                        <th width="1%">@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.ExchangedAccount')</th>
                        <th>@lang('layout.ExchangedAmount')</th>
                        <th>@lang('layout.ExchangedRate')</th>
                        <th>@lang('layout.ProfitAndLost')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Date')</th>
                        @if(systemConfig()[29] == 1)
                        <th>@lang('layout.Status')</th>
                        @endif
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>
<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    Vue.component("v-select", VueSelect.VueSelect);
    Vue.use(VueNumeric.default);
    function printVoucher(id,sendWhatsapp = null) {
        var a = document.createElement('a');
        a.href = "{{url('currencyExchangePrintVoucher')}}/" + id + "/" + sendWhatsapp;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
    function sendVoucherToWhatsapp(id,sendWhatsapp) {
        if (id && sendWhatsapp) {
			axios.get("{{url('currencyExchangePrintVoucher')}}/" + id + "/1", {
				// params: {
					// method_name: 'SearchMember',
					// class_id: class_id
				// }
			})
			.then(function(response) {
				// console.log(response);
				if (response.data) {
				if (sendWhatsapp == 1) {
					var a = document.createElement('a');
					a.href = "https://wa.me/?text=" + response.data;
					a.target = "_blank";
					document.body.appendChild(a);
					a.click();
					document.body.removeChild(a);
				}
				if (sendWhatsapp == 2) {
					var a = document.createElement('a');
					a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
					a.target = "_blank";
					document.body.appendChild(a);
					a.click();
					document.body.removeChild(a);
				}
				}
			})
			.catch(function(error) {
				console.log(error);
			})
		}
    }
    /**
     * we load approperiat datable according
     * to it's site_id
     */
    var my_table = 0;
    $(document).ready(function() {
        getRecord();
    });
    function getRecord() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        if (my_table != 0) {
            my_table.destroy();
        }
        my_table = $('#loan').DataTable({
            ajax: '{{route("currencyExchange.index")}}',
            pageLength: '{{getPageRows()}}',
            order: [
                ["{{orderByColumn()=='number'?0:13}}", "{{getRowOrder()}}"]
            ],
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            destroy: true,
            paging: true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [
                {
                    data: 'id',
                    name: 'currency_exchanges.id',
                    searchable: false
                },
                {
                    data: 'number',
                    name: 'currency_exchanges.number'
                },
                {
                    data: 'ref_no',
                    name: 'currency_exchanges.ref_no'
                },
                {
                    data: 'type',
                    name: 'type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'Member',
                    name: 'currency_exchanges.d_name'
                },
                {
                    data: 'Account',
                    name: 'accounts.name',
                },
                {
                    data: 'amount',
                    name: 'transactions.amount'
                },
                {
                    data: 'currency',
                    name: 'transactions.unit'
                },
                {
                    data: 'rate',
                    name: 'rate',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'ExAccount',
                    name: 'ex_account.name'
                },
                {
                    data: 'ex_amount',
                    name: 'ex_amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'ex_rate',
                    name: 'ex_rate',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'gl_amount',
                    name: 'gl_amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'username',
                    name: 'users.name',
                },
                {
                    data: 'Date',
                    name: 'date',
                    searchable: false
                },
                @if(systemConfig()[29] == 1)
                {
                    data: 'position_status',
                    name: 'position_status',
                    searchable: false
                },
                @endif
                {
                    data: 'description',
                    name: 'currency_exchanges.description'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    }
    // for new modal
    var cust_rep = {!!customeReportNewData('currency_exchanges_index') !!};
    var currency2 ={!! $currency!!}
    var member_class  = {!!json_encode($member_class)!!}
    var vu = new Vue({
        el: '#print-modal',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            is_show: false,
            pdfRoute: '{!!route("currencyExchange.report") !!}',
            excelRoute: '{!! route("currencyExchange.report") !!}',
            selectedMember: null,
            member: [],
            currency: currency2,
            selectedCurrency: null,
            financial_classes: {!!getFinancialClassList()!!},
            selected_class:null,
            member_class:member_class,
            customReportData: [
                {
                    Name: '@lang("layout.ReferenceNumber")',
                    column_name: 'reference_number',
                    checkedColumn: (cust_rep.reference_number) ? 'checked' : '',
                    column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''
                },
                {
                    Name: '@lang("layout.Type")',
                    column_name: 'type',
                    checkedColumn: (cust_rep.type) ? 'checked' : '',
                    column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''
                },
                {
                    Name: '@lang("layout.Description")',
                    column_name: 'description',
                    checkedColumn: (cust_rep.description) ? 'checked' : '',
                    column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''
                },
                {
                    Name: '@lang("layout.Description")1',
                    column_name: 'description1',
                    checkedColumn: (cust_rep.description1) ? 'checked' : '',
                    column_percentage:(cust_rep.description1___percent)?cust_rep.description1___percent:''
                },
                {
                    Name: '@lang("layout.Description")2',
                    column_name: 'description2',
                    checkedColumn: (cust_rep.description2) ? 'checked' : '',
                    column_percentage:(cust_rep.description2___percent)?cust_rep.description2___percent:''
                },
                {
                    Name: '@lang("layout.Date")',
                    column_name: 'date',
                    checkedColumn: (cust_rep.date) ? 'checked' : '',
                    column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''
                },
                {
                    Name: '@lang("layout.Member")',
                    column_name: 'member',
                    checkedColumn: (cust_rep.member) ? 'checked' : '',
                    column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''
                },
                {
                    Name: '@lang("layout.Amount")',
                    column_name: 'amount',
                    checkedColumn: (cust_rep.amount) ? 'checked' : '',
                    column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''
                },
                // {
                //     Name: '@lang("layout.Currency")',
                //     column_name: 'currency',
                //     checkedColumn: (cust_rep.currency) ? 'checked' : ''
                // },
                {
                    Name: '@lang("layout.Rate")',
                    column_name: 'rate',
                    checkedColumn: (cust_rep.rate) ? 'checked' : '',
                    column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''
                },
                {
                    Name: '@lang("layout.Account")',
                    column_name: 'account',
                    checkedColumn: (cust_rep.account) ? 'checked' : '',
                    column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''
                },
                {
                    Name: '@lang("layout.Total")',
                    column_name: 'total',
                    checkedColumn: (cust_rep.total) ? 'checked' : '',
                    column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''
                },
                {
                    Name: '@lang("layout.TodayRate")',
                    column_name: 'todayRate',
                    checkedColumn: (cust_rep.todayRate) ? 'checked' : '',
                    column_percentage:(cust_rep.todayRate___percent)?cust_rep.todayRate___percent:''
                },
                {
                    Name: '@lang("layout.ExchangedAccount")',
                    column_name: 'exchangedAccount',
                    checkedColumn: (cust_rep.exchangedAccount) ? 'checked' : '',
                    column_percentage:(cust_rep.exchangedAccount___percent)?cust_rep.exchangedAccount___percent:''
                },
                {
                    Name: '@lang("layout.ExchangedAmount")',
                    column_name: 'exchangedAmount',
                    checkedColumn: (cust_rep.exchangedAmount) ? 'checked' : '',
                    column_percentage:(cust_rep.exchangedAmount___percent)?cust_rep.exchangedAmount___percent:''
                },
                {
                    Name: '@lang("layout.ExchangedRate")',
                    column_name: 'exchangedRate',
                    checkedColumn: (cust_rep.exchangedRate) ? 'checked' : '',
                    column_percentage:(cust_rep.exchangedRate___percent)?cust_rep.exchangedRate___percent:''
                },
                {
                    Name: '@lang("layout.ProfitAndLost")',
                    column_name: 'profitAndLost',
                    checkedColumn: (cust_rep.profitAndLost) ? 'checked' : '',
                    column_percentage:(cust_rep.profitAndLost___percent)?cust_rep.profitAndLost___percent:''
                },
                {
                    Name: '@lang("layout.MonetarySource")',
                    column_name: 'monetary_source',
                    checkedColumn: (cust_rep.monetary_source) ? 'checked' : '',
                    column_percentage:(cust_rep.monetary_source___percent)?cust_rep.monetary_source___percent:''
                },
                {
                    Name: '@lang("layout.TransactionType")',
                    column_name: 'trans_type',
                    checkedColumn: (cust_rep.trans_type) ? 'checked' : '',
                    column_percentage:(cust_rep.trans_type___percent)?cust_rep.trans_type___percent:''
                },
                {
                    Name: '@lang("layout.User")',
                    column_name: 'user',
                    checkedColumn: (cust_rep.user) ? 'checked' : '',
                    column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''
                },
                {
                    Name: '@lang("layout.TransactionConfirm")',
                    column_name: 'transaction_confirm',
                    checkedColumn: (cust_rep.transaction_confirm) ? 'checked' : '',
                    column_percentage:(cust_rep.transaction_confirm___percent)?cust_rep.transaction_confirm___percent:''
                },
                {
                    Name: '@lang("layout.Currency")',
                    column_name: 'currencyExchangeReport',
                    checkedColumn: (cust_rep.currencyExchangeReport) ? 'checked' : '',
                    column_percentage:(cust_rep.currencyExchangeReport___percent)?cust_rep.currencyExchangeReport___percent:''
                },
                {
                    Name: '@lang("layout.Amount")',
                    column_name: 'amountExchangeReport',
                    checkedColumn: (cust_rep.amountExchangeReport) ? 'checked' : '',
                    column_percentage:(cust_rep.amountExchangeReport___percent)?cust_rep.amountExchangeReport___percent:''
                },
                {
                    Name: '@lang("layout.Amount") $',
                    column_name: 'amountExchangeReport1',
                    checkedColumn: (cust_rep.amountExchangeReport1) ? 'checked' : '',
                    column_percentage:(cust_rep.amountExchangeReport1___percent)?cust_rep.amountExchangeReport1___percent:''
                },
                {
                    Name: '@lang("layout.AverageRate") $',
                    column_name: 'averageRateExchangeReport',
                    checkedColumn: (cust_rep.averageRateExchangeReport) ? 'checked' : '',
                    column_percentage:(cust_rep.averageRateExchangeReport___percent)?cust_rep.averageRateExchangeReport___percent:''
                },
                {
                    Name: '@lang("layout.BuyCurrency")',
                    column_name: 'buyCurrencyExchangeReport',
                    checkedColumn: (cust_rep.buyCurrencyExchangeReport) ? 'checked' : '',
                    column_percentage:(cust_rep.buyCurrencyExchangeReport___percent)?cust_rep.buyCurrencyExchangeReport___percent:''
                },
                {
                    Name: '@lang("layout.SaleCurrency")',
                    column_name: 'SaleCurrencyExchangeReport',
                    checkedColumn: (cust_rep.SaleCurrencyExchangeReport) ? 'checked' : '',
                    column_percentage:(cust_rep.SaleCurrencyExchangeReport___percent)?cust_rep.SaleCurrencyExchangeReport___percent:''
                },
                {
                    Name: '@lang("layout.ProfitAndLost")',
                    column_name: 'profitAndLostExchangeReport',
                    checkedColumn: (cust_rep.profitAndLostExchangeReport) ? 'checked' : '',
                    column_percentage:(cust_rep.profitAndLostExchangeReport___percent)?cust_rep.profitAndLostExchangeReport___percent:''
                },
            ],
            cust_rep: cust_rep
        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;  
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vu.member = [];
                        vu.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                vu.getDate(vu.period);
                    // console.log(12);
                }), 2e2);
            },
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    vu.from_date = null;
                    vu.to_date = null;
                    if (response.data) {
                        vu.from_date = response.data.start;
                        vu.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    vu.period = 'CustomDates';
                    vu.from_date = null;
                    vu.to_date = null;
                    })
                } else {
                    vu.from_date = null;
                    vu.to_date = null;
                }
                }
            },
        }
    });
    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vu.$data.is_show = true;
            }
        }
    });
    new Vue({
        el: '#create-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.show_create = true;
            }
        }
    });
    // /for new modal
    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload()
            }
        }
    });
    //begin new member
    var cm = Vue.component("cmodal", {
        template: '#cmodal-template',
        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        created() {
            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Customer") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }
                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {
                vm.showModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        "code": datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },
                    dataType: 'json',
                }).done(function(response) {
                    if (response) {
                        vm.selectedMember = response.customer;
                    }
                }).fail(function(error) {
                    console.log('error', error);
                });
            }
        }
    });
    var Banks = {!! $bank!!}
    var Currency ={!! $currency!!}
    var Currency1 ={!! $currency!!}
    var one = {!!json_encode(getHomeCurrency())  !!};
    var two = {!! json_encode(getHomeCurrency())  !!};
    var code = '{!! getHomeCurrency()["code"] !!}';
    let rates ={!! $rates !!};
    let income = {!!$income!!};
    let cost = {!!$cost!!};
    let all_currency = {!!$currencies!!};
    var vm = new Vue({
        el: '#app',
        data: {
            all_currency: all_currency,
            selectedCurrencyTemp: null,
            paymentCurrency: two,
            selectedCurrency2: null,
            // currency1:{!! json_encode(getCurrencies()) !!},
            currency1: [],
            selected_rate: 0,
            selected_rate1: 0,
            exchange_amount: null,
            currency_len: 'col-md-12',
            rate_len: 'col-md-0',
            pcurrency_len: 'col-md-12',
            prate_len: 'col-md-0',
            first_currency: 0,
            second_currency: 0,
            lastAmount: null,
            description1: false,
            description2: false,
            position_status: false,
            code: code,
            selectedCurrency: one,
            currency: {!!json_encode(getCurrencies()) !!},
            bankes: {!!$banks!!},
            exBankes: {!!$banks!!},
            number: "{{$number}}",
            old_number: "{{$number}}",
            selectedBank: null,
            selectedExBank: null,
            show_create: false,
            disabled: false,
            defaultExValue: 0,
            defaultValue: 0,
            defaultAmount: 0,
            defaultAccount: 0,
            defaultExAccount: 0,
            amount: null,
            amount_to_word: null,
            exchange_amount_to_word: null,
            balance: 0,
            exBalance: 0,
            loanType: 'BuyCurrency',
            listAccounts: [],
            currencyList: Currency,
            selectedMember: null,
            income: income,
            selectedIncome: null,
            cost: cost,
            selectedCost: null,
            type: 'bank',
            account: {},
            ref_no: '',
            msg: '',
            d_member: false,
            isError: false,
            showModal: false,
            summary: [],
            member: []
        },
        computed: {
            accountUpdate() {
                this.defaultAccount = null;
                var b = _.clone(Banks)
                var test = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                } else {
                    this.defaultValue = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            this.defaultAccount = this.defaultValue;
                            break;
                        }
                    }

                }
                return test;
            },
            exAccountUpdate() {
                this.defaultExAccount = null;
                var b = _.clone(Banks)
                var test = b.filter((account) => {
                    return (new RegExp(this.paymentCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                
                if (test.length > 0) {
                    this.defaultExValue = test[0].id;
                }else{
                    this.defaultExValue = 0;
                }
                for (var x in this.exBankes) {
                    for (z in this.exBankes[x]) {
                        if (this.exBankes[x][z] == this.defaultExValue && z == 'id') {
                            this.selectedExBank = this.exBankes[x];
                            this.defaultExAccount = this.defaultExValue;
                    // console.log(12, test, this.paymentCurrency.code, this.defaultExValue, x, z, this.selectedExBank, this.defaultExAccount);
                            break;
                        }
                    }
                }
                return test;
            },
            checkLoan() {
                var x = (this.loanType == 'BuyCurrency') ? true : false;
                return x;
            },
        },
        mounted: function() {
            this.setSize(this.selectedCurrency.code)
            if (income.length > 0) {
                this.selectedIncome = income[0];
            }
            if (cost.length > 0) {
                this.selectedCost = cost[0];
            }
        },
        created() {
            this.setRates();
        },
        methods: {
            setRates() {
                let c = _.clone(Currency);
                let c1 = _.clone(Currency1);
                Currency = [];
                Currency1 = [];
                c.forEach((a) => {
                    rates.forEach((rate) => {
                        if (a.code == rate.code)
                            Currency.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                static_rate: a.static_rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });
                    });
                });
                c1.forEach((a) => {
                    rates.forEach((rate) => {
                        if (a.code == rate.code)
                            Currency1.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                static_rate: a.static_rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });
                    });
                });
                // for ensuring for each currency rate is defined
                c.forEach((a) => {
                    let found = false;
                    Currency.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }
                    });
                    if (!found) {
                        Currency.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            static_rate: a.static_rate,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });
                c1.forEach((a) => {
                    let found = false;
                    Currency1.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }
                    });
                    if (!found) {
                        Currency1.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            static_rate: a.static_rate,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });
                this.currency = Currency;
                this.currency1 = Currency1;
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);  
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.member = [];
                        vm.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
            getSummary() {
                if (vm.selectedMember) {
                    var id = vm.selectedMember.id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            } else {
                                vm.summary = [];
                            }
                        })
                        .catch(function(error) {
                            vm.summary = [];
                            console.log(error);
                        });
                }
            },
            getTranslateToWord() {
                var vm = this;
                vm.amount_to_word = null;
                if (vm.amount) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'translateNumberToWord',
                            amount: vm.amount,
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            // console.log(132, response.data, vm.amount);
                            vm.amount_to_word = response.data;
                            vm.getTranslateToWordExchange();
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                }
            },
            getTranslateToWordExchange() {
                var vm = this;
                vm.exchange_amount_to_word = null;
                if (vm.exchange_amount) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'translateNumberToWord',
                            amount: vm.exchange_amount,
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            // console.log(132, response.data, vm.amount);
                            vm.exchange_amount_to_word = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                }
            },

            // get_exchange() {
            //     var vm = this;
            //     if (vm.selected_rate > 0) {
            //         vm.exchange_amount = myRound((vm.amount * vm.selected_rate1) / vm.selected_rate);
            //     }
            // },

            get_exchange() {
                var vv = this;
                if (vv.selected_rate > 0) {
                    @if(systemConfig()[30] == 1)
                    if (vv.paymentCurrency && vv.selectedCurrency) { 
                        vv.exchange_amount = myRound(((vv.amount / vv.selectedCurrency.static_rate * vv.selected_rate) * vv.paymentCurrency.static_rate) / vv.selected_rate1);
                    }
                        @else 
                        vv.exchange_amount = myRound((vv.amount * vv.selected_rate1) / vv.selected_rate);
                        @endif
                } 

            },
            // set_rate() {
            //     var vm = this;
            //     if (vm.exchange_amount > 0) {
            //         if (this.paymentCurrency.code == '{{getHomeCurrency()["code"]}}') {
            //             vm.selected_rate = myRound(vm.amount/vm.exchange_amount);
            //         }else{
            //             vm.selected_rate1 = myRound((vm.exchange_amount) / (vm.amount / vm.selected_rate));
            //         }
            //     }
            // },  
            set_rate() { 
            let vm = this; 
            if (vm.paymentCurrency.code == vm.selectedCurrency.code) {
                if (vm.exchange_amount > 0 && vm.amount > 0) {
                    vm.amount = myRound(vm.exchange_amount);
                }
            }
            else if (vm.paymentCurrency.code == vm.code && !vm.gain_loss_status && !vm.averageRate) {
                if (vm.exchange_amount > 0 && vm.amount > 0) {
                    @if(systemConfig()[30] == 1)
                        vm.selected_rate = Number.parseFloat((vm.exchange_amount / vm.amount) * vm.selectedCurrency.static_rate).toFixed(7);
                    @else
                        vm.selected_rate = Number.parseFloat((vm.amount) / (vm.exchange_amount)).toFixed(7);
                    @endif
                }
            }
            else {
                if (vm.exchange_amount > 0) {
                    @if(systemConfig()[30] == 1)
                        if (vm.gain_loss_status && vm.selected_rate1 > 0 && vm.selected_rate > 0) {
                            vm.amount = myRound(((vm.exchange_amount / vm.paymentCurrency.static_rate * vm.selected_rate1) * vm.selectedCurrency.static_rate) / vm.selected_rate);
                        } else {
                            vm.selected_rate1 = Number.parseFloat(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate) / vm.exchange_amount) * vm.paymentCurrency.static_rate).toFixed(7);
                        }
                    @else
                        if (vm.gain_loss_status && vm.selected_rate1 > 0 && vm.selected_rate > 0) {
                            vm.amount = myRound((vm.exchange_amount / vm.selected_rate1) * (vm.selected_rate));
                        } else {
                            vm.selected_rate1 = Number.parseFloat((vm.exchange_amount) / (vm.amount / vm.selected_rate)).toFixed(7);
                        }
                    @endif
                }
            }
            },

            




            setSize(selected_code) {
                this.paymentCurrency = this.selectedCurrency;
                // this.selected_rate = this.selectedCurrency.exchange_rate;
                this.selected_rate = this.selectedCurrency.exchange_rate;
                this.selected_rate1 = this.selectedCurrency.exchange_rate;
                // this.selected_rate1 = this.selectedCurrency.exchange_rate;
                // if (selected_code == this.code) {
                //     this.currency_len = 'col-md-12';
                //     this.rate_len = 'col-md-0';
                // } else {
                //     this.currency_len = 'col-md-6';
                //     this.rate_len = 'col-md-6';
                // }
                // this.pcurrency_len = this.currency_len;
                // this.prate_len = this.rate_len;
            },
            setPaymentSize(selected_code) {
                // this.selected_rate = this.paymentCurrency.exchange_rate;
                this.selected_rate1 = this.paymentCurrency.exchange_rate;

                // if (selected_code == this.code) {
                //     this.pcurrency_len = 'col-md-12';
                //     this.prate_len = 'col-md-0';
                // } else {
                //     this.pcurrency_len = 'col-md-6';
                //     this.prate_len = 'col-md-6';
                // }
            },
            check_code(code) {
                if (this.paymentCurrency.code == this.selectedCurrency.code) {
                    // this.selected_rate1 = this.selected_rate;
                }

            },
            checkRefNo() {
                //console.log(vm.ref_no)
                var chack = 'false';
                var ref_no = vm.ref_no;
                if (ref_no != null) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                ref_no: vm.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'loans'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                // vm.temp_items=response.data;
                                vm.msg = "@lang('layout.DuplicateData')";
                                vm.isError = true;
                            } else {
                                vm.msg = 'no';
                                vm.isError = false;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        vm.disabled = true; 
                        if (vm.paymentCurrency && vm.selectedCurrency) {
                            if (vm.loanType == "BuyCurrency") {
                                var currencies = vm.paymentCurrency.code;
                                var currency = vm.paymentCurrency;
                                var amount = vm.exchange_amount;
                            } else {
                                var currencies = vm.selectedCurrency.code;
                                var currency = vm.selectedCurrency;
                                var amount = vm.amount;
                            }
                            var base_amount = 0;
                            @if(systemConfig()[30] == 1)
                                if (amount && currency.rate > 0 && currency.static_rate > 0) {
                                    base_amount = myRound((amount * currency.rate) / currency.static_rate);
                                }
                            @else
                                if (amount && currency.rate > 0) {
                                    base_amount = myRound(amount / currency.rate);
                                }
                            @endif
                            // console.log(bank , currencies , expense , date_value , amount_check);
                            axios.get("{{route('currencyExchange.checkAmount')}}", {
                            params: {
                                currencies: currencies,
                                amount: amount,
                                base_amount: base_amount,
                            }}).then(function (response) {
                            if (response.data) {
                                if (response.data.position) {
                                    swal({
                                    title: "{{__('layout.AmountIsMoreThenYourPermission')}}",
                                    text: "",  
                                    icon: "warning",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                    warningMode: true,
                                    })
                                    .then((willDelete) => {
                                        if (willDelete) {
                                            vm.position_status = true;
                                            vm.disabled = false; 
                                            vm.submitForm1();
                                        } else {
                                            vm.disabled = false; 
                                        }
                                    });
                                } else {
                                    vm.position_status = false;  
                                    vm.submitForm1();   
                                    vm.disabled = false;
                                }                                 
                            }else{
                                vm.position_status = false;                               
                                vm.submitForm1();   
                                vm.disabled = false;       
                            }
                            }) .catch(function (error) {
                                vm.disabled = false; 
                                console.log(error);
                            }) 
                        } else {
                            vm.disabled = false;
                        } 
                        // vm.submitForm1();
                        // regForm(e.target);
                    }
                });
            },
            submitForm1() {
                vm.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("loan-submit").submit()
                    } else {
                        vm.disabled = false;
                    }
                });
            },
            saveAndNew() {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        vm.disabled = true;
                        var url = "{{route('currencyExchange.store')}}";
                        form_id = 'loan-submit';
                        var data = $('#' + form_id).serialize();
                        toggleBlock(true);
                        axios.post(url, data)
                            .then(function(response) {
                                toggleBlock(0);
                                if (response.data.result == 1) {
                                    $('#' + form_id).trigger('reset');
                                    toastr.success('', response.data.message);
                                    vm.number = Number(vm.old_number) + 1;
                                    vm.old_number = Number(vm.old_number) + 1;
                                    vm.loanType = 'BuyCurrency';
                                    vm.amount = null;
                                    vm.ref_no = null;
                                    vm.selectedMember = null;
                                    getRecord();
                                    // location.reload();
                                    vm.disabled = false;
                                } else {
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                    vm.disabled = false;
                                }
                            })
                            .catch(function(error) {
                                toggleBlock(0);
                                console.log(error);
                                var message = "{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('', message);
                                vm.disabled = false;
                            });
                    }
                })
            },
            checkAmount() {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        vm.disabled = true; 
                        if (vm.paymentCurrency && vm.selectedCurrency) {
                            
                            if (vm.loanType == "BuyCurrency") {
                                var currencies = vm.paymentCurrency.code;
                                var currency = vm.paymentCurrency;
                                var amount = vm.exchange_amount;
                            } else {
                                var currencies = vm.selectedCurrency.code;
                                var currency = vm.selectedCurrency;
                                var amount = vm.amount;
                            }
                            var base_amount = 0;
                            @if(systemConfig()[30] == 1)
                                if (amount && currency.rate > 0 && currency.static_rate > 0) {
                                    base_amount = myRound((amount * currency.rate) / currency.static_rate);
                                }
                            @else
                                if (amount && currency.rate > 0) {
                                    base_amount = myRound(amount / currency.rate);
                                }
                            @endif
                            // console.log(bank , currencies , expense , date_value , amount_check);
                            axios.get("{{route('currencyExchange.checkAmount')}}", {
                            params: {
                                currencies: currencies,
                                amount: amount,
                                base_amount: base_amount,
                            }}).then(function (response) {
                            if (response.data) {
                                if (response.data.position) {
                                    swal({
                                    title: "{{__('layout.AmountIsMoreThenYourPermission')}}",
                                    text: "",  
                                    icon: "warning",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                    warningMode: true,
                                    })
                                    .then((willDelete) => {
                                        if (willDelete) {
                                            vm.position_status = true;
                                            vm.disabled = false; 
                                            vm.saveAndNew();
                                        } else {
                                            vm.disabled = false; 
                                        }
                                    });
                                } else {
                                    vm.position_status = false;  
                                    vm.saveAndNew();   
                                    vm.disabled = false;
                                }                                 
                            }else{
                                vm.position_status = false;                               
                                vm.saveAndNew();   
                                vm.disabled = false;       
                            }
                            }) .catch(function (error) {
                                vm.disabled = false; 
                                console.log(error);
                            }) 
                        } else {
                            vm.disabled = false;
                        } 
                    }
                })
            },
            clearData: function() {
                $('#loan-submit').trigger('reset');
                vm.loanType = 'BuyCurrency';
                vm.amount = null;
                vm.ref_no = null;
                vm.selectedMember = null;
                vm.amount_to_word = null;
                vm.exchange_amount_to_word = null;
            },
            onComplete: function() {
                document.getElementById("account-form").submit()
                //                this.$emit('on-complete')
                //                alert('Yay. Done!');
            },
            submitform() {
                swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("bill-submit").submit()
                        } else {}
                    });
            },
            test(defaultAccount) {
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == defaultAccount && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            break;
                        }
                    }
                }
            },
            testEX(defaultAccount) {
                for (var x in this.exBankes) {
                    for (z in this.exBankes[x]) {
                        if (this.exBankes[x][z] == defaultAccount && z == 'id') {
                            this.selectedExBank = this.exBankes[x];
                            break;
                        }
                    }
                }
            },
        }
    });
</script>
@endpush