@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CurrencyExchangeEdit')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div> 
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($currencyExch, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['currencyExchange.update',$currencyExch->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body  col-md-12" v-cloak>
                    <div class="row">
                        <div class="col-lg-8 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                            <div class="row" style="padding: 0.5% 1%;">
                                <div class="col-lg-12">
                                    <div class="col-lg-4">
                                        <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                        <div class="md-radio-inline">
                                            <div class="md-radio">
                                                <input type="radio" id="radio1" name="type" v-model="currencyExchType" value="BuyCurrency" class="md-radiobtn" checked="">
                                                <label for="radio1">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> @lang('layout.BuyCurrency') 
                                                </label>
                                            </div>
                                            <div class="md-radio">
                                                <input type="radio" id="radio2" name="type" v-model="currencyExchType" value="SaleCurrency" class="md-radiobtn">
                                                <label for="radio2">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> @lang('layout.SaleCurrency') 
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" name="number" class="form-control" v-model="number">
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" name="ref_no" class="form-control" v-model='ref_no'>
                                        <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                    </div>
                                </div>
                                <div class="col-lg-12" style="background-color: #edfeff; padding-bottom: 15px;border-radius: 10px;">
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select v-model="selectedCurrency" label="code" :options="currency" @Click.native="setSize(selectedCurrency.code), get_exchange()" 
                                        @keyup.native="setSize(selectedCurrency.code), get_exchange()"> </v-select>
                                        <input type="hidden" name="sp_currency" v-bind:value="selectedCurrency.code" />
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <!-- <div class="input-group"> -->
                                            <input v-model="selected_rate" :readonly="selectedCurrency.code == '{{getHomeCurrency()["code"]}}'" class="form-control" type="number" step="any" min="0" @keyup="check_code(paymentCurrency.code), get_exchange()" @click="check_code(paymentCurrency.code), get_exchange()">
                                            <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                            </div> -->
                                            <input type="hidden" name="sp_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.TodayRate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <input name="sp_today_rate" v-model="sp_today_rate" :readonly="selectedCurrency.code == '{{getHomeCurrency()["code"]}}'" class="form-control" type="number" step="any" min="0">
                                        </div>
                                    </div>
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.Amount') <span v-if="amount_to_word" class="text-danger">( @{{amount_to_word}} )</span></label>
                                            <vue-numeric
                                                class="form-control"
                                                v-model="amount"
                                                :max="99999999999999"
                                                :currency="selectedCurrency.code"
                                                :precision="precision()"
                                                @input="get_exchange(), getTranslateToWord()"
                                                >
                                            </vue-numeric>
                                            <input type="hidden" name="sp_amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                            <span class="required">@{{ errors.first('sp_amount') }}</span>
                                            
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <select class="form-control" name="sp_account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-lg-4">
                                            <span v-if="checkLoan" v-show="false">
                                                @{{balance = Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))}}
                                            </span>
                                            <span v-else v-show="false">
                                                @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                            </span>
                                            <label class="control-label">@lang('layout.Balance')</label>
                                            <div class="input-group">
                                                <input class="form-control" disabled :value="balance.toFixed(precision())">
                                                <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12" style="background-color: #f2ffed; padding-bottom: 15px;border-radius: 10px;margin-top: 5px;">
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.ExchangedCurrency')</label>
                                        <v-select v-model="paymentCurrency" label="code" :options="currency1" @Click.native="setPaymentSize(paymentCurrency.code), get_exchange(), getTranslateToWordExchange()"
                                        @keyup.native="setPaymentSize(paymentCurrency.code), get_exchange(), getTranslateToWordExchange()"> </v-select>
                                        <input type="hidden" name="ex_currency" v-bind:value="paymentCurrency.code" />
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.ExchangedRate') </label>
                                        <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                            <!-- <div class="input-group"> -->
                                            <input v-model="selected_rate1" :readonly="paymentCurrency.code == '{{getHomeCurrency()["code"]}}'" class="form-control" type="number" min="0" step="any" @input="get_exchange()">
                                            <!-- <span class="input-group-addon">@{{paymentCurrency.code}}</span>
                                            </div> -->
                                            <input type="hidden" name="ex_rate" :value="selected_rate1">
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.TodayRate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <input name="ex_today_rate" v-model="ex_today_rate" :readonly="paymentCurrency.code == '{{getHomeCurrency()["code"]}}'" class="form-control" type="number" min="0" step="any">
                                        </div>
                                    </div>
                                    <div class="col-lg-12" style="padding: 0px !important;">
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                            <vue-numeric
                                                class="form-control"
                                                v-model="exchange_amount"
                                                :max="99999999999999"
                                                :currency="paymentCurrency.code"
                                                :precision="precision()"
                                                @input="set_rate(), getTranslateToWordExchange()"
                                                >
                                            </vue-numeric>
                                            <input type="hidden" name="ex_amount" v-model="exchange_amount" v-validate="'required'" data-vv-as="@lang('layout.Amount')" class="form-control" min="0" step="any">
                                            <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(4)">
                                            <span class="required">@{{ errors.first('ex_amount') }}</span>
                                            {{-- <span v-if="exchange_amount_to_word" >@{{exchange_amount_to_word}}</span> --}}
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.ExchangedAccount')</label>
                                            <select class="form-control" name="ex_account_id" v-model="defaultExAccount" v-on:change="testEX(defaultExAccount)">
                                                <option v-for="Account in exAccountUpdate" :value="Account.id">@{{ Account.name }}
                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-lg-4">
                                            <span v-if="currencyExchType == 'BuyCurrency'" v-show="false">
                                                @{{exBalance = Number(selectedExBank.balance)-(Number(exchange_amount)-Number(defaultAmount)) }}
                                            </span>
                                            <span v-else v-show="false">
                                                @{{exBalance = Number(selectedExBank.balance)+(Number(exchange_amount)-Number(defaultAmount))}}
                                            </span>
                                            <label class="control-label">@lang('layout.Balance')</label>
                                            <div class="input-group">
                                                <input class="form-control" disabled :value="exBalance.toFixed(precision())">
                                                <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="col-lg-4" v-if="d_member">
                                        <label class="control-label ">@lang('layout.Member')</label>
                                        <div class="input-group">
                                            <span class="input-group-addon">
                                                <input type="checkbox" v-model="d_member">
                                                <span></span>
                                            </span>
                                            <v-select class="vue-select2" v-model="selectedMember" @search="MemberSearch" @input="getSummary()" label="name" :options="member">
                                            </v-select>
                                            <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')" >
                                            <span class="required">@{{ errors.first('member_id') }}</span>
                                            <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                <i class="fa fa-plus" style="color: white"></i>
                                            </span> 
                                        </div>
                                    </div>
                                    <div class="col-lg-4" v-if="!d_member">
                                        <label class="control-label ">@lang('layout.Name')</label>
                                        <div class="input-group">
                                            <span class="input-group-addon">
                                                <input type="checkbox" v-model="d_member">
                                                <span></span>
                                            </span>
                                            <input type="text" name="member_name" value="{{$currencyExch->Member}}"  class="form-control" v-validate="'required'" data-vv-as="@lang('layout.Name')" >
                                            <span class="required">@{{ errors.first('member_name') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-4" v-if="!d_member">
                                        <label class="control-label">@lang('layout.FatherName')</label>
                                        <input type="text" class="form-control" value="{{$currencyExch->father_name}}" autocomplete="off" name="father_name">
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" id="getdate" class="form-control date" value="{{$currencyExch->Date}}" autocomplete="off" name="date">
                                    </div>
                                    <div v-if="!d_member">
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.Phone')</label>
                                            <input type="text" class="form-control" value="{{$currencyExch->phone}}" autocomplete="off" name="phone" v-validate="'required'" data-vv-as="@lang('layout.Phone')" >
                                            <span class="required">@{{ errors.first('phone') }}</span>
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.SSN') / @lang('layout.PassportNumber')</label>
                                            <input type="text" class="form-control" value="{{$currencyExch->ssn}}" autocomplete="off" name="ssn_number">
                                        </div>
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.Address')</label>
                                            <input type="text" class="form-control" value="{{$currencyExch->d_address}}" autocomplete="off" name="address">
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label ">@lang('layout.Income')</label>
                                        <v-select class="vue-select2" v-model="selectedIncome" label="name" :options="income">
                                        </v-select>
                                        <input type="hidden" name="income_id" :value="(!selectedIncome)?null:selectedIncome.id" >
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label ">@lang('layout.UnitCostAccount')</label>
                                        <v-select class="vue-select2" v-model="selectedCost" label="name" :options="cost">
                                        </v-select>
                                        <input type="hidden" name="cost_id" :value="(!selectedCost)?null:selectedCost.id" >
                                    </div>
                                    <div class="col-md-4">
                                        <label class="control-label">@lang('layout.MonetarySource')</label>
                                        {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                    </div>
                                    <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                        <div class="col-lg-4">
                                            <label class="control-label">@lang('layout.TransactionType')</label>
                                                {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                        </div>
                                        @if(systemConfig()[29] == 1)
                                            <div class="col-lg-2">
                                                <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                                <div class="col-md-12 mt-checkbox">
                                                    <label class="mt-checkbox mt-checkbox-outline"> 
                                                        <input type="checkbox" name="transaction_confirm" v-model="show_transaction_confirm_checked" value="On" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')">
                                                        <span></span>
                                                    </label>
                                                </div>
                                                <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-12 col-sm-12" style="margin-bottom: 10px;">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')1</label>
                                        {!! Form::textarea('description1', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div>
                                </div>
                                <div class="row" style="padding: 0% 0% 2% 0%;">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')2</label>
                                        {!! Form::textarea('description2', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="row">
                                    <div class="dashboard-stat2" v-if="all_currency">
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th colspan="2" style="background-color: #add8e6; text-align: center;">@lang('layout.TodayRate') -- @lang('layout.BaseCurrency') ( {!! getHomeCurrency()["code"] !!} )</th>
                                                </tr>
                                                <tr>
                                                    <th style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                    <th style="background-color: #add8e6;">@lang('layout.Rate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span>
                                                    <tr v-for="crr in all_currency">
                                                        <span v-if="selectedCurrency">
                                                            <td v-if="selectedCurrency.code == crr.code">
                                                                @{{ crr.code }}
                                                            </td>
                                                            <td v-if="selectedCurrency.code == crr.code">
                                                                @{{(crr.rate)}} <input type="hidden" name="sp_today_rate1" :value="crr.rate" />
                                                            </td>
                                                        </span>
                                                        <span v-if="selectedCurrency && paymentCurrency">
                                                            <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                                @{{ crr.code }}
                                                            </td>
                                                            <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                                @{{(crr.rate)}}
                                                            </td>
                                                            <td v-if="paymentCurrency.code == crr.code" v-show="false">
                                                                <input type="hidden" name="ex_today_rate1" :value="crr.rate" />
                                                            </td>
                                                        </span>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="dashboard-stat2" v-if="selectedMember">
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                    <th style="background-color: #add8e6;">@lang('layout.Payable')</th>
                                                    <th style="background-color: #add8e6;">@lang('layout.Receivable')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span>
                                                    <tr v-for="summ in summary">
                                                        <td>
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                        <td>
                                                            @{{format_number(Number(summ.invoice)) }}
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                        @if(systemConfig()[22] == 1) 
                                        <br/>
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th style="background-color: #add8e6;text-align: center;" v-if="selectedMember.risk_step">
                                                        @lang('layout.RiskStep')
                                                    </th>
                                                    <th v-if="selectedMember.risk_step == 'High'" style="background-color: #ff5353;text-align: center;" > @lang('type.High')</th>
                                                    <th v-if="selectedMember.risk_step == 'Medium'" style="background-color: #ffe291;text-align: center;" > @lang('type.Medium')</th>
                                                    <th v-if="selectedMember.risk_step == 'Low'" style="background-color: #8aff9a;text-align: center;" > @lang('type.Low')</th>
                                                </tr>
                                            </thead>
                                        </table>    
                                        @endif
                                    </div>
                                </div>
                                <div class="row">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 text-center">
                                <br>
                                <button v-if="isError ==false" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Update')</button>
                                <a href="{{route('currencyExchange.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                <hr />
                            </div>
                        </div>
                    </div>

                    
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);

        var Banks ={!! $bank!!};
        var code = "{!! getHomeCurrency()["code"] !!}";
        let all_currency = {!!$currencies!!};
        let income = {!!$income!!};
        let cost = {!!$cost!!};

        let vu = new Vue({
            el: '#app',
            data: {
                all_currency: all_currency,
                selectedCurrency: null,
                paymentCurrency: null,
                summary: [], 
                selectedCurrency2: null,
                currency:[],
                currency1:[],
                bankes: {!! $banks !!},
                selectedBank: null,
                selected_rate:{!!$currencyExch->rate!!},
                selected_rate1:{!!$currencyExch->ex_rate!!},
                sp_today_rate:{!!$currencyExch->sp_today_rate!!},
                ex_today_rate:{!!$currencyExch->ex_today_rate!!},
                defaultAccount: "{{ $currencyExch->account_id }}",
                listAccounts: [],
                selectedMember: null,
                newAmount: null,
                amount:{!!$currencyExch->amount!!},
                exchange_amount:{!!$currencyExch->ex_amount!!},
                
                account: {},
                exBankes: {!!$banks!!},
                selectedExBank: null,
                defaultExValue: 0,
                defaultExAccount: "{{ $currencyExch->ex_account_id }}",
                balance: 0,
                exBalance: 0,
                income: income,
                selectedIncome: null,
                cost: cost,
                selectedCost: null,
                amount_to_word: null,
                exchange_amount_to_word: null,
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                selectedType: "{!! $currencyExch->type !!}",
                defaultValue: 0,
                defaultAmount:{!!$currencyExch->amount!!},
                firstAccount: "{{ $currencyExch->account_id }}",
                secondAccount: "{{ $currencyExch->ex_account_id }}",
                show_transaction_confirm_checked: "{{$currencyExch->transaction_confirm == 'On'}}",
                ref_no: "{{$currencyExch->ref_no}}",
                number: "{{$currencyExch->number}}",
                msg: '',
                d_member: false,
                isError: false,
                payment_type: "{{$currencyExch->payment_type}}",
                currencyExch:{!! $currencyExch !!},
                old_payment_type:"{{$currencyExch->payment_type}}",
                summary: [],
                member: [],
                currencyExchType: '{{$currencyExch->type}}',
                loanKind: (this.currencyExchType == 'getLoan')? true:false,

            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0) {
                        this.defaultValue = test[0].id;
                    } else {
                        this.defaultValue = 0;
                    }
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {


                            if (this.firstAccount != -1) {
                                if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.firstAccount;
                                    this.firstAccount = -1;
                                    break;
                                }
                            }
                            else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                break;
                            }
                        }

                    }
                    return test;
                },
                exAccountUpdate() {
                    var b = _.clone(Banks)
                    var test = b.filter((account) => {
                        return (new RegExp(this.paymentCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    
                    if (test.length > 0) {
                        this.defaultExValue = test[0].id;
                    }else{
                        this.defaultExValue = 0;
                    }

                    for (var x in this.exBankes) {
                        for (z in this.exBankes[x]) {
                            if (this.secondAccount != -1) {
                                if (this.exBankes[x][z] == this.secondAccount && z == 'id') {
                                    this.selectedExBank = this.exBankes[x];
                                    this.defaultExAccount = this.secondAccount;
                                    this.secondAccount = -1;
                                    break;
                                }
                            } else if (this.exBankes[x][z] == this.defaultExValue && z == 'id') {
                                this.selectedExBank = this.exBankes[x];
                                this.defaultExAccount = this.defaultExValue;
                                break;
                            }
                        }

                    }
                    return test;
                },
                checkLoan() {
                    var x = (this.currencyExchType == 'BuyCurrency') ? true : false;
                    return x;
                },

            },
            created() {
                this.checkSelected();
                
                if(this.currencyExch.income_account_id)
                {
                    this.selectedIncome=_.find(this.income,(v)=>v.id==this.currencyExch.income_account_id);
                }
                if(this.currencyExch.cost_account_id)
                {
                    this.selectedCost=_.find(this.cost,(v)=>v.id==this.currencyExch.cost_account_id);
                }
                defaultValue = "{{ $currencyExch->account_id }}";
				
                @if($selectedMember)
                    this.selectedMember = {!! $selectedMember !!};
                    this.d_member = true;
                @endif

				// if(this.selected_rate > 0){
				// 		this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate);
				// 	}

                this.currency = all_currency;
                this.currency1 = all_currency;

                this.getTranslateToWord();
            },
            methods: {

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.member = [];
                            vu.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                
                getSummary() {
                    if (vu.selectedMember) {
                        var id = vu.selectedMember.id;
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'memberStatment',
                                    member_id: id,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    vu.summary = response.data;
                                } else {
                                    vu.summary = [];
                                }
                            })
                            .catch(function(error) {
                                vu.summary = [];
                                console.log(error);
                            });
                    }
                },

                getTranslateToWord() {
                    var vm = this;
                    vm.amount_to_word = null;
                    if (vm.amount) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'translateNumberToWord',
                                amount: vm.amount,
                            }
                        })
                        .then(function(response) {
                            if (response.data) {
                                // console.log(132, response.data, vm.amount);
                                vm.amount_to_word = response.data;
                                vm.getTranslateToWordExchange();
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }
                },
                getTranslateToWordExchange() {
                    var vm = this;
                    vm.exchange_amount_to_word = null;
                    if (vm.exchange_amount) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'translateNumberToWord',
                                amount: vm.exchange_amount,
                            }
                        })
                        .then(function(response) {
                            if (response.data) {
                                // console.log(132, response.data, vm.amount);
                                vm.exchange_amount_to_word = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }
                },

                checkRefNo() {

                    //console.log(vu.ref_no)

                    var chack = 'false';
                    var ref_no = vu.ref_no;
                    if (ref_no != null) {


                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    ref_no: vu.ref_no,
                                    method_name: 'Search_ref_no',
                                    table_name: 'loans'
                                },
                            })
                            .then(function (response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    vu.msg = "@lang('layout.DuplicateData')";
                                    vu.isError = true;
                                }
                                else {
                                    vu.msg = 'no';
                                    vu.isError = false;

                                }


                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }

                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },


                
				// get_exchange() {
                //     let vu = this;
				// 	if(vu.selected_rate > 0){
				// 		vu.exchange_amount = myRound((vu.amount* vu.selected_rate1)/vu.selected_rate);
				// 	}
				// },


            get_exchange() {
                var vm = this;
                        if (vm.selected_rate > 0) {
                            @if(systemConfig()[30] == 1)
                            if (vm.paymentCurrency && vm.selectedCurrency) { 
                                // console.log(vm.amount );
                                vm.exchange_amount = myRound(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate) * vm.paymentCurrency.static_rate) / vm.selected_rate1);
                                // console.log(vm.exchange_amount);
                            }
                            @else 
                                vm.exchange_amount = myRound((vm.amount * vm.selected_rate1) / vm.selected_rate);
                            @endif
                        }
            }, 
            set_rate() {
                var vm = this;
                if(vm.exchange_amount > 0){
                        @if(systemConfig()[30] == 1)
                                vm.selected_rate1 = myRound(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate) / vm.exchange_amount) * vm.paymentCurrency.static_rate);
                        @else 
                                vm.selected_rate1 = myRound((vm.exchange_amount) / (vm.amount / vm.selected_rate));
                        @endif 
                    }
            },
 
                
                checkSelected() {
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for (var x in allCarrencies) {
                        for (z in allCarrencies[x]) {
                            if (allCarrencies[x][z] == "{!! $currencyExch->currency !!}") {
                                this.selectedCurrency = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }
                            if (allCarrencies[x][z] == "{!! $currencyExch->ex_currency !!}") {
                                this.paymentCurrency = allCarrencies[x];
                                // this.selected_rate1   = this.paymentCurrency.exchange_rate;
                            }
                        }
                    }

                },
                setSize(selected_code) {
                    // this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    for (var x in all_currency) {
                        if (this.all_currency[x].code == this.selectedCurrency.code) {
                            this.sp_today_rate = this.all_currency[x].rate;
                        }
                    }
                    
                    // this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    // if (selected_code == this.code) {
                    //     this.currency_len = 'col-md-12';
                    //     this.rate_len = 'col-md-0';
                    // } else {
                    //     this.currency_len = 'col-md-6';
                    //     this.rate_len = 'col-md-6';
                    // }
                    // this.pcurrency_len = this.currency_len;
                    // this.prate_len = this.rate_len;
                },
                setPaymentSize(selected_code) {
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    for (var x in all_currency) {
                        if (this.all_currency[x].code == this.paymentCurrency.code) {
                            this.ex_today_rate = this.all_currency[x].rate;
                        }
                    }

                    // if (selected_code == this.code) {
                    //     this.pcurrency_len = 'col-md-12';
                    //     this.prate_len = 'col-md-0';
                    // } else {
                    //     this.pcurrency_len = 'col-md-6';
                    //     this.prate_len = 'col-md-6';
                    // }
                },
                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        // this.selected_rate1 = this.selected_rate;
                    }

                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                break;
                            }
                        }
                    }
                },
                testEX(defaultAccount) {
                    for (var x in this.exBankes) {
                        for (z in this.exBankes[x]) {
                            if (this.exBankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedExBank = this.exBankes[x];
                                break;
                            }
                        }

                    }
                },
            }
        });
    </script>


@endpush
 