@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('menu.Others')</h3>
                <div>
                    <div class="btn-group">
                        @permission('currency-create')
                        <a href="{{route('currency.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn btn-success dropdown-toggle" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @permission('currency-create')
                            <li>
                                <a href="{{route('currency.create')}}">@lang('menu.Currency')</a>
                            </li>
                            @endpermission
                            @permission('FinancialPlanning-list')
                            <li>
                                <a href="{{route('budgets.create')}}">@lang('menu.Budgets')</a>
                            </li>
                            @endpermission
                            @permission('ToDo-create')
                            <li>
                                <a href="{{route('toDoList.create')}}">@lang('layout.ToDo')</a>
                            </li>
                            @endpermission
                            @permission('attachmentsManagement-create')
                            <li>
                                <a href="{{route('attachment.create')}}">@lang('menu.AttachmentsManagement')</a>
                            </li>
                            @endpermission
                            @permission('Litter-create')
                            <li>
                                <a href="{{route('litter.create')}}">@lang('menu.Litter')</a>
                            </li>
                            @endpermission
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @permission('currency-list')
                <a href="{{route('currency.index')}}"   class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Currency')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($currency) {{$currency}} @else @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[22] != 1)
                @permission('measure-list')
                <a href="{{route('measure.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.UnitMeasure')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-calculator"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$measure}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @permission('FinancialPlanning-list')
                <a href="{{route('budgets.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Budgets')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-reorder"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission(['settings-list'])
                <a href="{{route('systemSetting.create')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Settings')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-cog"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission(['note-list'])
                <a href="{{route('note.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Note')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-pencil-square-o"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($noteList) {{$noteList}} @else @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission(['ToDo-list'])
                <a href="{{route('toDoList.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ToDo')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(32, 57, 87, 1);" class="icon-bag"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($toDoList) {{$toDoList}} @else @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission(['ChitChat-list'])
                <a href="{{route('messaging.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ChitChat')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(110, 140, 168, 1);" class="fa fa-comments-o"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($messaginges) {{$messaginges}} @else @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('payrollPriceLevel-list')
                <a href="{{route('tablesInfo.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.SystemTableInfo')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(77, 94, 137, 1);" class="fa fa-info"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('attachmentsManagement-list')
                <a href="{{route('attachment.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.AttachmentsManagement')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;font-weight: bold;color: rgba(44, 160, 28, 1);" class="fa fa-archive"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$attachment}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('Litter-list')
                <a href="{{route('litter.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Litter')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 166, 164, 1);" class="fa fa-archive"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$litters}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('Offer-list')
                <a href="{{route('offer.index')}}"class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Offer')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 131, 128, 1);" class="fa fa-archive"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$offerList}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(getTelegramBot()=="true")
                @permission('Telegram-list')
                <a href="{{route('telegram.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Telegram')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 193, 191, 1);" class="fa fa-telegram"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                <a href="{{route('help.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Help')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgb(58, 97, 144)" class="fa fa-question-circle"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush