@extends('layouts.app')
@section('content')


<!-- END PAGE HEADER-->


<!-- BEGIN TAB PORTLET-->
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.CurrencyList') </span>
            </div>
            <div class="tools"> </div>
            <div class="btn-group pull-right">


                @permission('currency-edit')
                    <a href="{{route('rate.edit')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                             @lang('menu.CurrencyRate') <i class="fa "></i>
                        </button></a>
                @endpermission
                
                @permission('currency-create')
                    <a href="{{route('currency.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                             @lang('layout.AddNew') <i class="fa fa-plus-circle"></i>
                        </button></a>
                @endpermission


  
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="currency">
                   <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Code')</th>
                        <th>@lang('layout.Symbol')</th>
                        <th>@lang('layout.StaticRate')</th>
                        <th>@lang('layout.ExchangeRate')</th>
                        {{--<th>@lang('layout.CreatedAt')</th>--}}
                        <th width="7%">@lang('layout.Actions')</th>
                    </tr>
                    </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>
<!-- END CONTENT BODY -->
@stop

@push('scripts')

<script>

    jQuery(document).ready(function() {
        $(function() {
           let x = $('#currency').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{route("currency.index")}}',
                pageLength:'{{getPageRows()}}',
                columns: [
                  /*  { data: 'id', name: 'id' },*/
                    {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                    { data: 'name', name: 'name' },
                    { data: 'code', name: 'code' },
                    { data: 'symbol', name: 'symbol' },
                    { data: 'static_rate', name: 'static_rate' },
                    { data: 'exchange_rate', name: 'exchange_rate' },
//                    { data: 'updated_at', name: 'Updated_at' },
//                    { data: 'created_at', name: 'created_at' },
                    { data: 'actions', name: 'actions', orderable:false, searchable:false }
                ],
            });
           // let data = x.columns(5).data();
           // console.log(x.rows(columns[{data: 'exchange_rate'}]).nodes().length)
           // alert('the table has' + data);
        });
    });
</script>
<!-- END INTERNAL SCRIPT -->
@endpush
