@extends('layouts.app')
@section('style')

    <style type="text/css">
        .modal-container{
            width: 30%;
        }
    </style>
@stop
@section('content')
    @include('invoices.modal')

    <div class="row">
        <div class="col-lg-12 margin-tb">
            <div class="pull-left">
                <h2>@lang('layout.EditRates')</h2>
            </div>
            <div class="pull-right">
                <button class="btn green  btn-outline" data-toggle="modal" href="#draggable_p">
                    @lang('layout.HelpFactor')
                    <i class="fa fa-info">
                    </i>
                </button> 
                  <div class="btn-group btn-group-devided">
                        
                        <button class="btn red" onclick = "window.history.back();">
                            @lang('layout.Back')
                            <i class="fa fa-mail-reply">
                            </i>
                        </button> 
                        <span>
                        </span>
                    </div>

            </div>
        </div>
    </div>
    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif



<div class="modal fade draggable-modal" id="draggable_p" tabindex="-1" role="basic"
    aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    @lang('layout.HelpCurrency0')
                </div>
                <div class="modal-body">
                  <div class="row">
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency1'):</p>
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency3')</p>
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency2')</p>
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency4'):</p>
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency5')</p>
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency6')</p>
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency7')</p>
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency8')</p>
                    <p>&nbsp;&nbsp;@lang('layout.HelpCurrency9')</p>
                  </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn red-thunderbird" id="close_modals" data-dismiss="modal">
                       @lang('layout.Close')
                    </button>
                    
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

          {!! Form::open(['route' => 'rate.update','method'=>'POST']) !!}

                <p>@lang('layout.BaseCurrencyis:') {{getHomeCurrency()["code"]}} {{currency()->name}}</p>
                 <div class="col-xs-5 col-sm-8 col-md-5">
                   <strong>@lang('layout.CurrencyName')</strong>
                </div>
                <div class="col-xs-5 col-sm-8 col-md-5">
                   <strong>@lang('layout.ExchangeRate')</strong>
                </div>
             @foreach(currency()->getCurrencies() as $currency)

             @if(getHomeCurrency()["code"] != $currency['code'])
            <div class="row">
                <div class="col-xs-5 col-sm-8 col-md-5">
                    <div class="form-group">
                      
                        <input type="text" class="form-control" readonly name="currency[]" value="{{$currency['name']}}">
                        <input type="hidden" name="currency_id[]" value="{{$currency['id']}}">
                    </div>
                </div>
                <div class="col-xs-5 col-sm-8 col-md-5">
                    <div class="form-group">
                       
                        <input type="text" name="exchange_rate[]" class="form-control" value="{{$currency['exchange_rate']}}">
                    </div>
                </div>    
            </div>
            @endif
            @endforeach
            <div class="col-xs-12 col-sm-12 col-md-3">
                <button type="submit" class="btn btn-primary">@lang('layout.Update')</button>
            </div>
        {!!Form::close()!!}
        <br />
        <br />
<!-- BEGIN TAB PORTLET-->

<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>

                <span class="caption-subject bold uppercase">@lang('layout.CurrencyList')</span>
            </div>
            <div class="tools"> </div>
                <div class="pull-right">
                    {{-- {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="LatestRate"/>
                    <input type="hidden" name="qut" value="in"/>

                    <input type="hidden" name="id" value=""/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="LatestRate"/>
                    <input type="hidden" name="qut" value="in"/>
                    <input type="hidden" name="id" value=""/>
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}} --}}
                    <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    <button type="button" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                  
                </div> 
            </div>
        
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="rate-datatable" cellspacing="0">
                   <thead>
                    <tr>
                        <th>@lang('layout.ID')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.ExchangeRate')</th>
                        <th>@lang('layout.Date')</th>
                    </tr>
                    </thead>
            </table>
        </div>

    </div>
</div>
    <!-- END EXAMPLE TABLE PORTLET-->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="currency_rate_details"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control" id="range-from-example" name="from_date" autocomplete="off">
                                   
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control" id="range-to-example" name="to_date" autocomplete="off">
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>

     <!-- Modal -->
<div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="currency_rate_details"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false" >
            <div slot="body">
                
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control" id="range-from-example2" name="from_date" autocomplete="off">
                                   
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control" id="range-to-example2" name="to_date" autocomplete="off">
                                 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
<!-- END CONTENT BODY -->
   
{{-- @endsection --}}
@stop
@push('scripts')

<script>
    $(document).ready(function() {

        $('#rate-datatable').DataTable( {
            ajax:           '{{route("rate.show_rate")}}',
            scrollCollapse: true,
            order: [[ 0, "desc" ]],
            serverSide: true,
            paging:         true,
            columns: [
                { data: 'id', name: 'id' },
                { data: 'currency_id', name: 'currency_id' },
                { data: 'user_id', name: 'user_id', orderable:false,searchable:false },
                { data: 'exchange_rate', name: 'exchange_rate',orderable:false,searchable:false },
                { data: 'date', name: 'date',orderable:false,searchable:false },
                
//             { data: 'measure_unit_id', name: 'quantity' },
//             { data: 'measure_unit', name: 'rate' },

            ]
        });
    });

  var Modal=Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });
  new Vue({
    el:'#app',
    data: {
        showModal: false,
    },
    methods: {
        ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample : function(){

                    //Your other code that launches the modal
                    this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                        var to, from;
                        to = $("#range-to-example").persianDatepicker({
                            altField: '#range-to-example-alt',
                            altFormat: 'u',
                            initialValue: false,
                            observer: true,
                            format: 'YYYY/MM/DD',
                            autoClose:true,
                           
                        });
                        from = $("#range-from-example").persianDatepicker({
                            altField: '#range-from-example-alt',
                            altFormat: 'u',
                            initialValue: false,
                            observer: true,
                            format: 'YYYY/MM/DD',
                            autoClose:true,
                     
                        });
                    });
                })
            }
        }
    });
  $('#print_pdf_all').on('click',function(e){
        $('#show-modal').click();
        e.preventDefault();
    })
    new Vue({
    el:'#app2',
    data: {
        showModal: false,
    },
    methods: {
        ok:function(){
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close:function(e)
            {
                this.showModal = !this.showModal;
            },
            editExample2 : function(){

                    //Your other code that launches the modal
                    this.showModal= true;
                this.$nextTick(function(){
                    $(document).ready(function(){
                        var to, from;
                        to = $("#range-to-example2").persianDatepicker({
                            altField: '#range-to-example-alt2',
                            altFormat: 'u',
                            initialValue: false,
                            observer: true,
                            format: 'YYYY/MM/DD',
                            autoClose:true,
                           
                        });
                        from = $("#range-from-example2").persianDatepicker({
                            altField: '#range-from-example-alt2',
                            altFormat: 'u',
                            initialValue: false,
                            observer: true,
                            format: 'YYYY/MM/DD',
                            autoClose:true,
                     
                        });
                    });
                })
            }
        }
    });
    $('#excell_all').on('click',function(e){
        $('#show-modal2').click();
        e.preventDefault();
    })
</script>
<!-- END INTERNAL SCRIPT -->
@endpush
