@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 80% !important;
    }
</style>
@endsection
@section('content')
@include('contracts.modal')
<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract_profitandlost" />
    <input type="hidden" name="id" value="{{$contract->id}}" />
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">

                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <label class="control-label">@lang('layout.WagonNumber')</label>
                        <v-select label="name" :options="{{ json_encode($wagon) }}" v-model="selected_wagon"></v-select>
                        <input type="hidden" name="wagon_number" :value="(this.selected_wagon==null)?null:selected_wagon.name">
                    </div>
                </div>
                <div class="form-group">
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->
<!-- BEGIN CONTENT -->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'contract_loading_index'"
        @closed="closeModal">
        <div slot="body">
            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">

                    <ul class="nav nav-tabs">

                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        <input type="hidden" name="type" value="contract_loading" />
                                        <input type="hidden" name="id" value="{{$contract->id}}" />
                                         
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Site') </label>
                                            <select name="site_id" id="" class="form-control">
                                                <option value="">@lang('layout.SelectSite')</option>
                                                @foreach($loadingSites as $row)
                                                <option value="{{$row['id']}}">{{$row['name']}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.ItemName') </label>
                                            <select name="item_id" id="" class="form-control">
                                                <option value="">@lang('layout.Select')</option>
                                                @foreach($loadingItem as $row)
                                                <option value="{{$row['id']}}">{{$row['name']}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.Measure') </label>
                                            <select name="measure" id="" class="form-control">
                                                <option value="">@lang('layout.Select')</option>
                                                @foreach($measure as $row)
                                                <option value="{{$row['id']}}">{{$row['name']}}</option>
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.Location') </label>
                                            <v-select label="name" v-model="loadingLocationSel" :options="loadingLocation"></v-select>
                                            <input type="hidden" name="location" :value="(!loadingLocationSel)?null:loadingLocationSel.name">
                                        </div>
                                        
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.FilterAs') </label>
                                            <select name="type_filter" class="form-control">
                                                <option value="inventory"> @lang('layout.Inventory') </option>
                                                <option value="source"> @lang('layout.Source') </option>
                                            </select>
                                        </div> 

                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Source') </label>
                                            <v-select label="name" v-model="loadingSourceSel" :options="loadingSource"></v-select>
                                            <input type="hidden" name="source" :value="(!loadingSourceSel)?null:loadingSourceSel.name">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Destination') </label>
                                            <v-select label="name" v-model="loadingDestinationSel" :options="loadingDestination"></v-select>
                                            <input type="hidden" name="destination" :value="(!loadingDestinationSel)?null:loadingDestinationSel.name">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="control-label">@lang('layout.Driver') </label>
                                            <v-select label="name" @search="MemberSearch" :options="driver" v-model="selected_driver"></v-select>
                                            <input type="hidden" name="driver_id" v-validate="" data-vv-as="@lang('layout.Driver')" :value="!selected_driver?null:selected_driver.id">
                                            
                                        </div>
                                        <div class="col-md-6">
                                            <label>&nbsp;</label>
                                            <label>@lang('layout.Discharged')</label>
                                            <input class="mt-checkbox" type="checkbox" name="discharged">
                                        </div>
                                      
                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                           
                                            <div class="col-md-12" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example"
                                                            v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example"
                                                            v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_loading_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margin-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>


        </div>
    </report-modal>
</div>
<!-- BEGIN CONTENT -->
<div id="print-modaltwo">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_showtwo" :value-type="'contract_profitandlost'"
        @closed="closeModal">
        <div slot="body">
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        <input type="hidden" name="type" value="contract_loading" />
                                        <input type="hidden" name="id" value="{{$contract->id}}" /> 
                                        <div class="col-md-6" style="margin-bottom: 10px;">
                                            <label class="control-label">@lang('layout.Type') </label>
                                            <select name="summary" class="form-control">
                                                <option value=""> @lang('layout.Select') </option>
                                                <option value="summary"> @lang('layout.Summary') </option>
                                            </select>
                                        </div> 
                                        <div class="col-md-6" style="margin-bottom: 10px;">
                                            <label class="control-label">@lang('layout.FilterAs') </label>
                                            <select name="type_filter" class="form-control">
                                                <option value="inventory"> @lang('layout.Inventory') </option>
                                                <option value="source"> @lang('layout.Source') </option>
                                            </select>
                                        </div> 
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.WagonNumber') </label>
                                            <v-select label="name" :options="{{ json_encode($wagon) }}" v-model="selected_wagon"></v-select>
                                            <input type="hidden" name="wagon_number" :value="(this.selected_wagon==null)?null:selected_wagon.name">
                                        </div> 
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example2" name="from_date" autocomplete="off"> 
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example2" name="to_date" autocomplete="off">
                                                </div>
                                            </div> 
                                        </div>
                                    </div> 
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detai_index">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.Contract')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important; margin-right:0 !important;" v-for="(row,itemIndex) in cust_repcontractes">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div> 
                                        <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
 
                                    <form id="saveCustomeReport" role="form"action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detai_item_index"> 
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.ItemDetails')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important; padding: 0px;" v-for="(row,itemIndex) in cust_repItemDetailses">
                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                         @csrf
                                        <input type="hidden" name="part_name" value="contract_detila_purchase_index"> 
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.Purchase')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repPurchases">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_item_report_hand_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.OnHand') @lang('layout.Inventory')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repOnHandes">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_item_inventory_transfer_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.InventoryTransfer')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repInventoryTransferes">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detail_item_build_index"> 


                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.Build')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repBuildes">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>


                                         <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_noncost_detai_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.ItemNoneCost')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repItemNoneCosts">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>

                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_loading_detail_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.Loading')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repLoadinges">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                             <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detail_overload_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.OverLoad')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repOverLoades">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                              <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detail_load_drop_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.LoadDrop')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repLoadDropess">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>

                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detai_fined_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.Fine')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repFines">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                                
                                            </div>
                                        </div>
                                        
                                        
                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detai_adjustmentList_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.AdjustmentList')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repAdjustmentLists">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detail_expense_index"> 
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.Expense')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in  cust_repExpenses">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    {{-- Start Of Daily Expense --}}
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_details_daily_expense_index"> 
                                       <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.DailyExpense')</h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in  cust_repItemDailyExpenses">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- End of Daily Expense........................................................ --}}
                                    
                                    {{-- Start Of Payroll Form --}}
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_details_payroll_index"> 
                                       <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('menu.PayrollForm')</h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in  cust_repItemPayrollExpenses">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- End of Payroll form........................................................ --}}

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_details_item_expense_index"> 
                                       <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.ItemExpense')</h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in  cust_repItemExpenses">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                          
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detail_member_transfer_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.MemberTransfer')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in  cust_repMemberTransferes">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    
                                    {{-- <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detail_member_transfer_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('layout.ItemExpense')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repMemberTransferes">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                          <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form> --}}

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_details_deposite_withdraw_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;">  @lang('menu.DepositAndWithdrawal')  </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repDepositAndWithdrawals">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                         <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detail_sale_service_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.Sale') @lang('layout.Service') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repSaleServices">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detai_sales_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.Sales') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repSaless">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                          
                                        </div>
                                   
                                         <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- Start of Procurement .................................................................... --}}

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_detai_procurement_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.Procurement') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_repProcurememntes">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                          
                                        </div>
                                   
                                         <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- End of  Procuremtnt .................................................................--}}

                                    {{-- Start of Return Expense .................................................................... --}}
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_return_expense_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.ReturnExpense') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_return_expenses">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                          
                                        </div>
                                   
                                         <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- End of  Return Expense .................................................................--}}

                                    {{-- Start of ngo_project .................................................................... --}}
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_ngo_project_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.NGOProjectExpenses') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in cust_ngo_projects">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                          
                                        </div>
                                   
                                         <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- End of ngo_project .................................................................--}}

                                    {{-- Start of Transfer Box .................................................................... --}}
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_transfer_box_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.TransferBox') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in transfer_boxes">
                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                          
                                        </div>
                                   
                                         <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- End of Transfer Box .................................................................--}} 

                                    {{-- Start of receive .................................................................... --}}
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_recieve_index"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.Recevies') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in receives_contract_index">
                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr> 
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div> 
                                        </div> 
                                            <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- End of receive .................................................................--}}

                                    {{-- Start of customsExpense .................................................................... --}}
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="contract_details_customsExpense"> 

                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px;"> @lang('layout.CustomsExpense') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in contract_customsExpenseData">
                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    
                                            <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                    {{-- End of customsExpense .................................................................--}}

                                    {{-- <div class="margin-top-10"> --}}
                                        <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                        {{-- <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i
                                                class="fa fa-save"></i> </button>
                                    </div> --}}
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

<div id="print-modal1" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show1" :value-type="'loading'" @closed="closeModal">

        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                        <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>

<div id="print_customsExpense-modal" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show1" :value-type="'contractCustomsExpense'" @closed="closeModal">

        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                        <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>
<!-- END PAGE HEADER-->
<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract_profitandlost" />
    <input type="hidden" name="id" value="{{$contract->id}}" />
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">

                </div>
            </div>
            <div class="row">
                <div class="form-group">

                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.WagonNumber') </label>
                        <input type="text" name="wagon_number" class="form-control">

                    </div>

                </div>
                <div class="form-group">
                    <!--    <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                           
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example" name="to_date">
                          
                        </div>
                    </div>
                </div> -->
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->
<div id="loading_app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract_loading" />
    <input type="hidden" name="id" value="{{$contract->id}}" />
    <button id="loading-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" :pdf-route="pdfRoute" :excel-route="excelRoute"
    :value-type="'contract_loading_index'">
        <div slot="body">
            <div class="row">
                <div class="tabbable tabbable-tabdrop">
                <ul class="nav nav-tabs">

                    <li class="active">
                        <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                    </li>
                    @if(systemConfig()[2] != 0 )
                    @permission(['customreport-list'])
                    <li class="">
                        <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                    </li>
                    @endpermission
                    @endif
                </ul>

                <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Site') </label>
                        <select name="site_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectSite')</option>
                            @foreach($loadingSites as $row)
                            <option value="{{$row['id']}}">{{$row['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Location') </label>
                        <v-select label="name" v-model="loadingLocationSel" :options="loadingLocation"></v-select>
                        <input type="hidden" name="location" :value="(!loadingLocationSel)?null:loadingLocationSel.name">
                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Source') </label>
                        <v-select label="name" v-model="loadingSourceSel" :options="loadingSource"></v-select>
                        <input type="hidden" name="source" :value="(!loadingSourceSel)?null:loadingSourceSel.name">
                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Destination') </label>
                        <v-select label="name" v-model="loadingDestinationSel" :options="loadingDestination"></v-select>
                        <input type="hidden" name="destination" :value="(!loadingDestinationSel)?null:loadingDestinationSel.name">
                    </div>
                    <div class="col-md-6">
                        <label class="control-label">@lang('layout.Driver') </label>
                        <v-select label="name" @search="MemberSearch" :options="driver" v-model="selected_driver"></v-select>
                        <input type="hidden" name="driver_id" v-validate="" data-vv-as="@lang('layout.Driver')" :value="!selected_driver?null:selected_driver.id">
                        
                    </div>
                    <div class="col-md-6">
                        <label>&nbsp;</label>
                        <label>@lang('layout.Discharged')</label>
                        <input class="mt-checkbox" type="checkbox" name="discharged">
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-body">

                            <form id="saveCustomeReport" role="form"
                                action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                @csrf
                                <input type="hidden" name="part_name" value="contract_loading_index">
 
                                <div class="col-md-12 col-sm-12 col-xs-12">

                                    <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important;padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                        <div class="form-group">
                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                        </div>
                                    </div>
                                </div>  
                                <div class="margiv-top-10">
                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                    <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->
<!-- app -->
<div id="app2" v-cloak>
    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract_item_expense" />
    <input type="hidden" name="id" value="{{$contract->id}}" />
    <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">

                </div>
            </div>

            <div class="row">
                <div class="form-group">

                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.WagonNumber') </label>
                        <input type="text" name="wagon_number" class="form-control">

                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Category') </label>
                        <select name="ex_category_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectCategory')</option>
                            @foreach($ex_category as  $rec)
                                <option value="{{$rec->id}}">{{$rec->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-md-12">
                        <!--  <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example2" name="from_date">
                           
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example2" name="to_date">
                          
                        </div>
                    </div> -->
                    </div>
                </div>
            </div>

        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->
<div id="app3" v-cloak>
    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract_item_expense" />


    <input type="hidden" name="id" value="{{$contract->id}}" />
    <button id="show-modal3" style="display: none" type="button" @click="editExample3">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">

                </div>
            </div>

            <div class="row">
                <div class="form-group">

                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.WagonNumber') </label>
                        <input type="text" name="wagon_number" class="form-control">

                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Category') </label>
                        <select name="ex_category_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectCategory')</option>
                            @foreach($ex_category as  $rec)
                                <option value="{{$rec->id}}">{{$rec->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-md-12">
                        <!--  <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example2" name="from_date">
                           
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example2" name="to_date">
                          
                        </div>
                    </div> -->
                    </div>
                </div>
            </div>

        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.ContractInformation') &nbsp;&nbsp; <span style="color: red">({{ $contract->contract_no}})</span> &nbsp;&nbsp;
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
            {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active" >
                        <a href="#CustomerDetailss" data-toggle="tab"> @lang('layout.ContractInformation') </a>
                    </li>
                    <li>
                        <a href="#tab_15_2" data-toggle="tab"> @lang('layout.ContractStatement')</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="CustomerDetailss" style="padding: 10px;">
                        <div style="display: flex; justify-content: center; gap: 5px;">
                            <div class="col-lg-5" style="border: 1px solid rgba(185, 185, 185, 0.571);border-radius: 5px;padding: 10px 0px;">
                                <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                                    <thead>
                                        <tr>
                                            <th class="text-center">
                                                {{-- <i class="fa fa-bars"></i>  --}}
                                                @lang('layout.ContractNumber')
                                            </th>
                                            <th class="text-center">
                                                {{-- <i class="fa fa-edit"></i> --}}
                                                @lang('layout.ContractName')
                                            </th>
                                            <th class="text-center">
                                                @lang('layout.Amount') @lang('layout.Differ')
                                            </th>
                                            @if(getmine() == 'true')
                                            {{-- <th>
                                                @lang('layout.Percentage')
                                            </th>
                                            <th>
                                                @lang('layout.PerPercentPrice')
                                            </th> --}}
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center"> {{ $contract->contract_no}} </td>
                                            <td class="text-center"> {{ $contract->company_name}} </td>
                                            <td class="text-center"> {{ $contract->pos_neg_amount}} @if($contract->pos_neg_type == 'positive') + @endif @if($contract->pos_neg_type == 'negative') - @endif</td>
                                            @if(getmine() == 'true')
                                            {{-- <td class=""> {{ $contract->percentage}}</td>
                                            <td class=""> {{ $contract->per_percent_price}}</td> --}}
                                            @endif
                                        </tr>
                                    </tbody>
                                </table>
                                <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                                    <thead>
                                        <tr>
                                            <th class="text-center">
                                                {{-- <i class="fa fa-edit"></i>  --}}
                                                @lang('layout.Vendor')
                                            </th>
                                            <th class="text-center">
                                                {{-- <i class="icon-phone"></i>  --}}
                                                @lang('layout.Phone')
                                            </th>
                                            <th class="text-center">
                                                {{-- <i class="fa fa-credit-card"></i>  --}}
                                                @lang('layout.Address')
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center"> {{ $contract->name}} </td>
                                            <td class="text-center"> {{ $contract->phone}}</td>
                                            <td class="text-center"> {{ $contract->address1}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-lg-3" style="border: 1px solid rgba(185, 185, 185, 0.571);border-radius: 5px;padding: 10px 0px;">
                                <table class="table  table-bordered table-advance">
                                    <thead>
                                        <tr>
                                            <th class="text-center">
                                                <i class=" fa "></i> @lang('layout.Date')
                                            </th>
                                            <td class="text-center" style="background-color: white !important; color: black !important;"> 
                                                {{ convertDate($contract->Date)}}  
                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="text-center">
                                                <i class=" fa "></i> @lang('layout.StartDate')
                                            </th>
                                            <td class="text-center" style="background-color: white !important; color: black !important;"> 
                                                {{ convertDate($contract->start_date)}}  
                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="text-center">
                                                <i class=" fa "></i> @lang('layout.EndDate')
                                            </th>
                                            <td class="text-center" style="background-color: white !important; color: black !important;"> 
                                                {{ convertDate($contract->end_date)}}  
                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="text-center">
                                                <i class=" fa "></i> @lang('layout.BourseDate')
                                            </th>
                                            <td class="text-center" style="background-color: white !important; color: black !important;"> 
                                                {{ convertDate($contract->bourse_date)}}  
                                            </td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-lg-4" style="border: 1px solid rgba(185, 185, 185, 0.571);border-radius: 5px;padding: 10px 0px;">
                                <table class="table  table-bordered table-advance">
                                    <thead>
                                        <tr>
                                            <th class="text-center">
                                                {{-- <i class=" fa fa-text-width"></i>  --}}
                                                @lang('layout.Description')
                                            </th>
                                            <th class="text-center">
                                                {{-- <i class=" fa fa-text-width"></i>  --}}
                                                @lang('layout.Memo')
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center"> {{ $contract->description}}  </td>
                                            <td class="text-center"> {{ $contract->memo}}  </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                            <thead>
                                
                            </thead>
                            <tbody>
                                
                            </tbody>
                        </table>
                    </div>
                    <div class="tab-pane" id="tab_15_2">
                        <table class="table table-striped table-bordered table-advance table-hover" id="table_payment">
                            <thead>
                                <tr>
                                    <th class="">
                                        <i class="fa  "></i> @lang('layout.TotalSentAmount')
                                    </th>
                                    <th class="">
                                        <i class="fa  "></i> @lang('layout.TotalItem')
                                    </th>
                                    <th>
                                        <i class="fa  "></i> @lang('layout.TotalExpense')
                                    </th>
                                    <th>
                                        <i class="fa  "></i> @lang('layout.TotalCashReceipts')
                                    </th>
                                    <th>
                                        <i class="fa  "></i> @lang('layout.AverageRate')
                                    </th>
                                    <th>
                                        <i class="fa fa-credit-card"></i> @lang('layout.TotalRemain')
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class=""> {{ $totalSendt}} </td>
                                    <td class=""> {{ $totalPrice}} </td>
                                    <td class=""> {{ $totalExpense}}</td>
                                    <td class=""> {{ $totalCashReceipts}}</td>
                                    <td class=""> {{ $rateAverage}}</td>
                                    <td class=""> {{ $contractMoney}}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
            <!-- '''''''''''''''''''''''' -->
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ContractDetails')</span>
                </div>
                <div class="tools"></div>
                <div class="actions">
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="anchore-modal" class="btn  btn-success">
                            <i class="fa fa-print"></i> @lang('layout.Loading')
                        </a>
                    </span>
                    <button type="button" id="anchore-modaltwo"  @click.prevent="showModaltwo" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.ProfitAndLost') </button>
                </div>
            </div>
            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    @if(systemConfig()[19] != 1)
                    <li class="active">
                        <a href="#expense" data-toggle="tab" id="expensesd"> @lang('layout.Expense') <i class="fa "></i></a>
                    </li>
                    <li>
                        <a href="#contract-items" data-toggle="tab" id="contract-item"> @lang('layout.ItemDetails') <i class="fa "></i> </a>
                    </li>
                    @permission('purchase-list')
                    <li>
                        <a href="#item" data-toggle="tab" id="items"> @lang('layout.PurchaseDetails') <i class="fa "></i> </a>
                    </li>
                    @endpermission
                    @permission('transferAndLoading-list')
                    <li>
                        <a href="#load_item" data-toggle="tab" id="load_items"> @lang('layout.Loading') <i class="fa "></i> </a>
                    </li>
                    @endpermission
                    @permission('transferAndLoading-list')
                    <li>
                        <a href="#over_load" data-toggle="tab" id="over_loads"> @lang('layout.OverLoad') <i class="fa "></i> </a>
                    </li>
                    @endpermission
                    @permission('transferAndLoading-list')
                    <li>
                        <a href="#LoadDrop" data-toggle="tab" id="LoadDrops"> @lang('layout.LoadDrop') <i class="fa "></i> </a>
                    </li>
                    @endpermission
                    @permission('adjustment-list')
                    <li>
                        <a href="#Westage" data-toggle="tab" id="Westages"> @lang('layout.Westage') <i class="fa "></i> </a>
                    </li>
                    @endpermission
                    @permission('inventoryTransfer-list')
                    <li>
                        <a href="#inventoryTransfer" data-toggle="tab" id="inventoryTransfers"> @lang('layout.InventoryTransfer') <i class="fa "></i> </a>
                    </li>
                    @endpermission
                    @endif
                    @permission('sendMoney-list')
                    <li>
                        <a href="#sentmoney" data-toggle="tab" id="money"> @lang('layout.SendMoney') <i class="fa  "></i></a>
                    </li>
                    @endpermission
                    @permission('loan-list')
                    <li>
                        <a href="#depositeandwithdraw" data-toggle="tab" id="deposite"> @lang('menu.DepositAndWithdrawal') <i class="fa  "></i></a>
                    </li>
                    @endpermission
                    @permission('memberTransfer-list')
                    <li>
                        <a href="#memberTransfer" data-toggle="tab" id="member_transfer"> @lang('menu.MemberTransfer') <i class="fa  "></i></a>
                    </li>
                    @endpermission
                    @permission('sendMoney-list')
                    <li>
                        <a href="#loans" data-toggle="tab" id="redirect"> @lang('layout.ReturnMoney') <i class="fa  "></i></a>
                    </li>
                    @endpermission
                    @if(systemConfig()[19] != 1)
                    @permission('ProjectInvoice-list')
                    <li>
                        <a href="#sold_item_tab" data-toggle="tab" id="sold_item"> @lang('layout.ContractSalesItems') </a>
                    </li>
                    @endpermission
                    
                    @permission('shareholder-list')
                    <li>
                        <a href="#shareholder_tab" data-toggle="tab" id="shareholder"> @lang('layout.Shareholder') </a>
                    </li>
                    @endpermission
                    @permission('itemexpense-list')
                    <li>
                        <a href="#item_expense_tab" data-toggle="tab" id="item_expense"> @lang('layout.ItemExpense') </a>
                    </li>
                    @endpermission
                    @permission('customsExpense-list')
                    <li>
                        <a href="#customsExpense_tab" data-toggle="tab" id="customsExpense"> @lang('layout.CustomsExpense') </a>
                    </li>
                    @endpermission
                    @if(getContractLoadingDate()=="true")
                    <li>
                        <a href="#loadingDate_tab" data-toggle="tab" id="loadingDate"> @lang('layout.LoadingDate') </a>
                    </li>
                    @endif
                    @endif
                    @permission('payroll-list')
                    <li>
                        <a href="#payrollContract" data-toggle="tab" id="payrollTabContract"> @lang('menu.Payroll') <i class="fa  "></i></a>
                    </li>
                    @endpermission
                    @permission('journalEntry-list')
                    <li>
                        <a href="#journalContract" data-toggle="tab" id="journalTabContract"> @lang('menu.JournalEntry') <i class="fa  "></i></a>
                    </li>
                    @endpermission
                    <li>
                        <a href="#attachments_tab" data-toggle="tab" id="attachments"> @lang('layout.Attachments') </a>
                    </li>
                    @permission('dailyExpenses-list')
                    <li>
                        <a href="#daily_expense_tab" data-toggle="tab" id="daily_expenses"> @lang('layout.DailyExpense') </a>
                    </li>
                    @endpermission
                    @permission('payroll-list')
                    <li>
                        <a href="#payroll_form_tab" data-toggle="tab" id="payroll_form"> @lang('menu.PayrollForm') </a>
                    </li>
                    @endpermission
                    @permission('procurement-list')
                    <li>
                        <a href="#Procurement_tab" data-toggle="tab" id="Procurement"> @lang('layout.Procurement') </a>
                    </li>
                    @endpermission
                    @permission('pay-list')
                    <li>
                        <a href="#Payment_tab" data-toggle="tab" id="Payment"> @lang('layout.Pyments') </a>
                    </li>
                    @endpermission
                    @permission('ReturnExpense-list')
                    <li>
                        <a href="#return_expense_tab" data-toggle="tab" id="ReturnExpense"> @lang('layout.ReturnExpense') </a>
                    </li>
                    @endpermission
                    @permission('ProjectInvoice-list')
                    <li>
                        <a href="#return_sales_services_tab" data-toggle="tab" id="SaleService"> @lang('layout.Sale') @lang('layout.Service') </a>
                    </li> 
                    @endpermission
                    @permission('OrderReceiveAndPayment-list')
                    <li>
                        <a href="#ngo_project_expense" data-toggle="tab" id="ngo_project_expenses"> @lang('layout.NGOProjectExpenses') </a>
                    </li>
                    @endpermission
                    @permission('transferAccounts-list')
                    <li>
                        <a href="#transfer_box" data-toggle="tab" id="transfer_boxes"> @lang('layout.TransferBox') </a>
                    </li>
                    @endpermission
                    @permission('receive-list')
                    <li>
                        <a href="#receives_project" data-toggle="tab" id="receive_project"> @lang('menu.Receive') </a>
                    </li>
                    @endpermission
                    @permission('drawing-list')
                    <li>
                        <a href="#OwnersEquity" data-toggle="tab" id="owners_equity"> @lang('layout.OwnersEquity') </a>
                    </li>
                    @endpermission

                </ul>
                <div class="tab-content">
                    {{-- <div class="tab-pane" id="qut-in">
                          <div class="row">
                          <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                              <div class="portlet-title">
                                <div class="caption font-dark">
                                  <i class="icon-settings font-dark"></i>
                                  <span class="caption-subject bold uppercase">@lang('layout.QutIn')</span>
                                </div>
                                <div class="actions">
                                  {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="Purchase_Details" />
                    <input type="hidden" name="qut" value="in" />

                    <input type="hidden" name="id" value="{{$contract->p_id}}" />
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="Purchase_Details" />
                    <input type="hidden" name="qut" value="in" />
                    <input type="hidden" name="id" value="{{$contract->p_id}}" />
                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="qut-in-table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.SiteName')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Date')</th>

                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
</div> --}}


<div class="tab-pane active" id="expense">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.Expense')</span>
            </div>
            <div class="actions">
                {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="contractDetailsExpense" />
                <input type="hidden" name="qut" value="in" />

                <input type="hidden" name="id" value="{{$contract->id}}" />
                <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                {{Form::close()}}
                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="contractDetailsExpense" />
                <input type="hidden" name="qut" value="in" />
                <input type="hidden" name="id" value="{{$contract->id}}" />
                <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                {{Form::close()}}
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="expense-table">
                <thead>
                    <tr>
                        <th>@lang('layout.ExpenseCategory')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->

</div>


<div class="tab-pane" id="item">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.PurchaseDetails')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contractDetailsItem" />
                    <input type="hidden" name="qut" value="in" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contractDetailsItem" />
                    <input type="hidden" name="qut" value="in" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="purchase-item-table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.BourseDate')</th>
                            <th>@lang('layout.SiteName')</th>
                            <th>@lang('layout.Item')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.Cost')</th>
                            <th>@lang('layout.Differ')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>


<div class="tab-pane" id="load_item">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Loading')</span>
                </div>
                <div class="pull-right">
                    <span id="anchore-modal1">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="load-item-table">
                    <thead>
                        <tr>
                            <th style="min-width: 100px">@lang('layout.Driver') </th>
                            <th style="min-width: 100px">@lang('layout.Transporter_name') </th>
                            <th style="min-width: 100px">@lang('layout.VehicleName')/@lang('layout.NumberWagon')</th>
                            <th style="min-width: 100px">@lang('layout.TankerNumber')</th>
                            <th style="min-width: 100px">@lang('layout.DriverType')</th>
                            <th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
                            <th style="min-width: 100px">@lang('layout.TransitNumber') </th>
                            <th style="min-width: 100px">@lang('layout.SourcePlace') </th>
                            <th style="min-width: 100px">@lang('layout.Destination') </th>
                            <th style="min-width: 100px">@lang('layout.LoadingDate') </th>
                            <th style="min-width: 100px">@lang('layout.Discharge') </th>
                            <th style="min-width: 100px">@lang('layout.DischargeDate') </th>
                            <th style="min-width: 100px">@lang('layout.ItemName') </th>
                            <th style="min-width: 100px">@lang('layout.Site') </th>
                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                            <th>@lang('layout.Quantity') </th>
                            <th>@lang('layout.RentQuantity') </th>
                            <th>@lang('layout.Price') </th>
                            <th>@lang('layout.Currency') </th>
                            <th>@lang('layout.Rate') </th>
                            <th>@lang('layout.TotalTransferFee') </th>
                            <th>@lang('layout.Action') </th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>



<div class="tab-pane" id="over_load">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.OverLoad')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="over_load_detail" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="over_load_detail" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="overload-table">
                    <thead>
                        <tr>
                            <th style="min-width: 100px">@lang('layout.Date') </th>
                            <th style="min-width: 100px">@lang('layout.ItemName') </th>
                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                            <th style="min-width: 100px">@lang('layout.Quantity') </th>
                            <th style="min-width: 100px">@lang('layout.Price')</th>
                            <th style="min-width: 100px">@lang('layout.Total')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>


<div class="tab-pane" id="LoadDrop">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.LoadDrop')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="load_drop_detail" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="load_drop_detail" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="LoadDrop-table">
                    <thead>
                        <tr>
                            <th style="min-width: 100px">@lang('layout.Date') </th>
                            <th style="min-width: 100px">@lang('layout.ItemName') </th>
                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                            <th style="min-width: 100px">@lang('layout.Quantity') </th>
                            <th style="min-width: 100px">@lang('layout.Price')</th>
                            <th style="min-width: 100px">@lang('layout.Total')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

<div class="tab-pane" id="Westage">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.AdjustmentList')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="westage_detail" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="westage_detail" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="Westage-table">
                    <thead>
                        <tr>
                            <th style="min-width: 100px">@lang('layout.ReferenceNumber') </th>
                            <th style="min-width: 100px">@lang('layout.Description') </th>
                            <th style="min-width: 100px">@lang('layout.Date') </th>
                            <th style="min-width: 100px">@lang('layout.ItemName') </th>
                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                            <th style="min-width: 100px">@lang('layout.Quantity') </th>
                            <th style="min-width: 100px">@lang('layout.Price')</th>
                            <th style="min-width: 100px">@lang('layout.Total')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

<div class="tab-pane" id="inventoryTransfer">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InventoryTransfer')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="westage_detail" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <!-- <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel') -->
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="westage_detail" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <!-- <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button> -->
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="inventoryTransfer-table">
                    <thead>
                        <tr>
                            <td>
                                <div class="center"> @lang('layout.Transfer') #</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.Date')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.From') @lang('layout.Contract')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.WagonNumber')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.to') @lang('layout.Contract')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.WagonNumber')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.Item')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.FromSite')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.ToSite')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.Measure')</div>
                            </td>
                            <td>
                                <dev calss="center"> @lang('layout.Quantity')</div>
                            </td>
                            <td>
                                <dev calss="center"> @lang('layout.UnitCost')</div>
                            </td>
                            <td>
                                <div class="center"> @lang('layout.Total')</div>
                            </td>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>


<div class="tab-pane" id="contract-items">
    <div class="tab-pane" id="tab_16_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemDetails')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_item_detail" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_item_detail" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="contract-item-table">
                    <thead>
                        <tr>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.SiteName')</th>
                            <th>@lang('layout.Cost')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.PurchasedQuantity')</th>
                            <th>@lang('layout.Remain')</th>
                            @if(getmine() == 'true')
                            <th>@lang('layout.SalePrice')</th>
                            @endif
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>


    {{-- <div class="tab-pane" id="item">
        <div class="tab-pane" id="tab_15_1">
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="purchase-item-table">
                    <thead>
                        <tr> 
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.SiteName')</th>
                            <th>@lang('layout.Item')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.Cost')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div> --}}


<div class="tab-pane" id="sentmoney">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.SendMoney')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="sendMoney" />
                    <input type="hidden" name="type_name" value="send" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="sendMoney" />
                    <input type="hidden" name="type_name" value="send" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="sentmoney-table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Commission')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Total')
                                <span>{{getHomeCurrency()["code"]}}</span>
                            </th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>


          
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

{{--   Withdraw     --}}

<div class="tab-pane" id="depositeandwithdraw">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('menu.DepositAndWithdrawal')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="allLoanReports" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="allLoanReports" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="depositeandwithdraw-table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Member')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

{{-- End of Withdraw --}}

{{--   Payrolls     --}}

<div class="tab-pane" id="payrollContract">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('menu.Payroll')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_payrolls" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_payrolls" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="payrollContract-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.BasicSalary')</th>
                            <th>@lang('layout.Tax')</th>
                            <th>@lang('layout.WorkedDay')</th>
                            <th>@lang('layout.AbsentDays')</th>
                            <th>@lang('layout.NetPayable')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.FromDate')</th>
                            <th>@lang('layout.ToDate')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Actions')</th> 
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
</div>

{{-- End of Payrolls --}}


{{--   Payrolls     --}}





<div class="tab-pane" id="journalContract">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('menu.JournalEntry')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_journal" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_journal" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="journalContract-table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Debit')</th>
                            <th>@lang('layout.Credit')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
</div>

{{-- Start of daily_expense_tab for Report............................................ --}}
<div class="tab-pane" id="daily_expense_tab">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.DailyExpense')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_daily_expense" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_daily_expense" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="daily_expense_tab_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Record')</th>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.ExpenseAccount')</th>
                            <th>@lang('layout.Category')</th>
                            <th>@lang('layout.BankAccount')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.OverdueDate')</th>
                            <th>@lang('layout.Hour')</th>
                            @if(systemConfig()[5] != 0 )
                            <th>@lang('layout.Status')</th>
                            @endif
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
</div>

{{-- End of daily_expense_tab for Report .......................................... --}}


{{-- End of Payrolls --}}
{{-- Start of payroll_form_tab for Report............................................ --}}
<div class="tab-pane" id="payroll_form_tab">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('menu.PayrollForm')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_payrol_form" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_payrol_form" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="payroll_form_tab_table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Name')</th>
                            @if(systemConfig()[5] != 0 )
                            <th>@lang('layout.Project')</th>
                            @endif
                            <th>@lang('layout.NetPayable')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.FromDate')</th>
                            <th>@lang('layout.ToDate')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
</div>

{{-- End of payroll_form_tab for Report .......................................... --}}
{{-- End of Payrolls --}}



{{-- End of Procurement --}}

{{-- Start of Procurement_form for Report............................................ --}}
<div class="tab-pane" id="Procurement_tab">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Procurement')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_procurement" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_procurement" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="Procurement_tab_table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.Account')</th> 
                            <th>@lang('layout.ItemName')</th> 
                            <th>@lang('layout.Inventory')</th> 
                            <th>@lang('layout.Measure')</th> 
                            <th>@lang('layout.Quantity')</th> 
                            <th>@lang('layout.Amount')</th> 
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Employee')</th>
                            @if(systemConfig()[5] != 0 )
                                <th>@lang('layout.Project')</th>
                            @endif
                            <th>@lang('layout.WagonNumber')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
</div>

{{-- End of Procurement_form for Report .......................................... --}}
{{-- End of Procurement --}}

{{-- Start of Payments_form for Report............................................ --}}
<div class="tab-pane" id="Payment_tab">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Pyments')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_payment" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_payment" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="Payment_tab_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th> 
                            <th>@lang('layout.ReferenceNumber')</th> 
                            <th>@lang('layout.Name')</th> 
                            <th>@lang('layout.Account')</th> 
                            <th>@lang('layout.Currency')</th> 
                            <th>@lang('layout.Rate')</th> 
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Type')</th>
                            @if(systemConfig()[20] != 0 )
                                <th>@lang('layout.Contract')</th>
                            @endif
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.OverdueDate')</th>
                            <th>@lang('layout.Hour')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
</div>
{{-- End of Payments_form for Report .......................................... --}}


{{-- Start of Return Expense for Report............................................ --}}
<div class="tab-pane" id="return_expense_tab">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Pyments')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_return_expense" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_return_expense" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="return_expense_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number') </th>
                            <th>@lang('layout.Date') </th>
                            <th>@lang('layout.Description') </th>
                            <th>@lang('layout.ReferenceNumber') </th>
                            <th>@lang('layout.Account') </th>
                            <th>@lang('layout.Vendor') </th>
                            <th>@lang('layout.ExpenseAccount') </th>
                            <th>@lang('layout.Type') </th>
                            <th>@lang('layout.Amount') </th> 
                            <th>@lang('layout.Currency') </th> 
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
</div>
{{-- End of Return Expense for Report .......................................... --}}




 {{-- Ngo Porject Expense Start For project..................................... --}}
 <div class="tab-pane" id="ngo_project_expense">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
      <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.NGOProjectExpenses')</span>
          </div>
          <div class="actions">
 
            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="ngo_expense_project"/>
            <input type="hidden" name="id" value="{{$contract->id}}"/>
            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
            {{Form::close()}}

            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="ngo_expense_project" />

            <input type="hidden" name="id" value="{{$contract->id}}" />
            <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
            </button>
            {{Form::close()}}


          </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="ngo_project_expense_table">
                    <thead>
                        <tr>
                          <th>@lang('layout.Number') </th>
                          <th>@lang('layout.Date') </th>
                          <th>@lang('layout.Description') </th>
                          <th>@lang('layout.Item') </th>
                          <th>@lang('layout.Measure') </th>
                          <th>@lang('layout.Quantity') </th>
                          <th>@lang('layout.Price') </th>
                          <th>@lang('layout.Member') </th>
                          <th>@lang('layout.Currency') </th> 
                          <th>@lang('layout.Rate') </th> 
                          <th>@lang('layout.Total') </th> 
                          <th>@lang('layout.User') </th> 
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>  
{{-- End of Ngo Porject Expense ........................................... --}}


 {{-- Ngo Porject Expense Start For project..................................... --}}
 <div class="tab-pane" id="transfer_box">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
      <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.TransferBox')</span>
          </div>
          <div class="actions">
 
            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="contract_transfer_box"/>
            <input type="hidden" name="id" value="{{$contract->id}}"/>
            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
            {{Form::close()}}

            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="contract_transfer_box" />

            <input type="hidden" name="id" value="{{$contract->id}}" />
            <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
            </button>
            {{Form::close()}}


          </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="transfer_box_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number') </th>
                            <th>@lang('layout.FromAccount') </th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.FromRate')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.ToAccount')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.ToRate')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Date')</th>
                            @if(systemConfig()[5] != 0 )
                            <th>@lang('layout.Project')</th>
                            @endif
                            <th>@lang('layout.ReferenceName')</th>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>  
{{-- End of Ngo Porject Expense ........................................... --}}

 {{-- Receive Expense Start For project..................................... --}}
 <div class="tab-pane" id="receives_project">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
      <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.ReceiveList')</span>
          </div>
          <div class="actions">
 
            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="contract_receive"/>
            <input type="hidden" name="id" value="{{$contract->id}}"/>
            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
            {{Form::close()}}

            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="contract_receive" /> 
            <input type="hidden" name="id" value="{{$contract->id}}" />
            <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
            </button>
            {{Form::close()}}


          </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="receive_project_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.OverdueDate')</th>
                            <th>@lang('layout.Hour')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.PaymentType')</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>  
{{-- End of Receive Expense ........................................... --}}
 {{-- owners equity part start ..................................... --}}
@permission('drawing-list')
<div class="tab-pane" id="OwnersEquity">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
      <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.OwnersEquity')</span>
          </div>
          <div class="actions">
 
            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="owners_equity"/>
            <input type="hidden" name="id" value="{{$contract->id}}"/>
            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
            {{Form::close()}}

            {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="owners_equity" /> 
            <input type="hidden" name="id" value="{{$contract->id}}" />
            <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
            </button>
            {{Form::close()}}


          </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="owners_equity_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Equity')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>  
@endpermission
{{-- owners equity part end........................................... --}}





{{-- Start of Sales Services for Report............................................................ --}}
<div class="tab-pane" id="return_sales_services_tab">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Pyments')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_sales_services" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_sales_services" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="return_sales_services_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.SaleNumber') </th>
                            <th>@lang('layout.Date') </th>
                            <th>@lang('layout.Description') </th>
                            <th>@lang('layout.Customer') </th>
                            <th>@lang('layout.WagonNumber') </th>
                            <th>@lang('layout.Service') </th>
                            <th>@lang('layout.Measure') </th>
                            <th>@lang('layout.Quantity') </th>
                            <th>@lang('layout.Price') </th> 
                            <th>@lang('layout.Total') </th> 
                            <th>@lang('layout.Currency') </th> 
                            <th>@lang('layout.User') </th> 
                        </tr> 
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
</div>
{{-- End of Sales Services for Report .......................................................... --}}











<div class="tab-pane" id="memberTransfer">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('menu.MemberTransfer')</span>
            </div>
            <div class="actions">
                {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="memberTransferList" />
                <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                </button>
                {{Form::close()}}
                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                <input type="hidden" name="type" value="memberTransferList" />
                <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                {{Form::close()}}
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="memberTransfer-table">
                <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.FromMember')</th>
                        <th>@lang('layout.ToMember')</th>
                        <th>@lang('layout.Receivable')</th>
                        <th>@lang('layout.Payable') </th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<div class="tab-pane" id="loans">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ReturnMoney')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="sendMoney" />
                    <input type="hidden" name="type_name" value="return" />
                    <input type="hidden" name="id" value="{{$contract->p_id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="sendMoney" />
                    <input type="hidden" name="type_name" value="return" />
                    <input type="hidden" name="id" value="{{$contract->p_id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="ReturnedMoney">
                    <thead>
                        <tr>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Commission')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Total')
                                <span>{{getHomeCurrency()["code"]}}</span>
                            </th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

<div class="tab-pane" id="sold_item_tab">
    <div class="tab-pane" id="tab_15_11">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ContractSalesItems')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="projectInvoicelist" />
                    <input type="hidden" name="contract_id" value="{{$contract->p_id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="projectInvoicelist" />
                    <input type="hidden" name="contract_id" value="{{$contract->p_id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>

            </div>
            <div class="portlet-body"> 
                <table class="table table-striped table-bordered table-hover" id="sold_item_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.SaleNumber')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Price')
                                <span>{{getHomeCurrency()["code"]}}</span>
                            </th>
                            <th>@lang('layout.Total')
                                <span>{{getHomeCurrency()["code"]}}</span>
                            </th>

                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

<div class="tab-pane" id="shareholder_tab">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Shareholder')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_share_holders" />
                    <input type="hidden" name="qut" value="in" />

                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_share_holders" />
                    <input type="hidden" name="qut" value="in" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="shareholder_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Shareholder')</th>
                            <th>@lang('layout.Percentage')</th>


                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>


<div class="tab-pane" id="item_expense_tab">
    <div class="tab-pane" id="">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemExpense')</span>
                </div>
                <div class="actions">

                    <button type="button" id="contract_item_expense_excel" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>


                    <button type="button" id="contract_item_expense_pdf" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="item_expense_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.FromDate')</th>
                            <th>@lang('layout.ToDate')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.ExpenseType')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Category')</th>
                            <th>@lang('layout.Total')</th>


                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

<div class="tab-pane" id="customsExpense_tab">
    <div class="tab-pane" id="">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.CustomsExpense')</span>
                </div>
                <div class="pull-right">
                    <span id="customsExpense-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="customsExpense_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Vendor')</th>
                            <th>@lang('layout.Vehicle')</th>
                            <th>@lang('layout.Item')</th>
                            <th>@lang('layout.Quantity') (@lang('layout.SeamerTonnage'))</th>
                            <th>@lang('layout.CustomsQuantity')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Hour')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

<div class="tab-pane" id="loadingDate_tab">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.LoadingDate')</span>
                </div>
                <div class="actions">
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_loading_date" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                    </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="contract_loading_date" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    {{Form::close()}}
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="loadingDate_table">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>

<div class="tab-pane" id="attachments_tab">
    <div class="tab-pane" id="tab_15_1">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                </div>

            </div>
            <div class="portlet-body">
                <div class="portlet light bordered">
                    <div class="portlet-body">

                        <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="redirect_route" value="contract.show">
                            <input type="hidden" name="foreign_data_id" value="{{$contract->id}}">
                            <input type="hidden" name="path" value="uploads/Contract">
                            <input type="hidden" name="table_name" value="contracts">

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                        <input type="text" name="title" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-7">
                                    <div class="form-group">
                                        <div class="fileinput fileinput-new" data-provides="fileinput">
                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                <img src="" alt=""> </div>
                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                            <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                    <input type="hidden" value="" name=""><input type="file" name="photo"> </span>

                                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="margiv-top-10">
                                <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                            </div>
                        </form>
                    </div>
                </div>
                <table class="table table-striped table-bordered table-hover" id="attachment">
                    <thead>
                        <tr>
                            <th>@lang('layout.AttachmentTitle')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Action')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->

    </div>
</div>


</div>
</div>
</div>
</div>
</div>
@endsection
@include('print.modal')
@push('scripts')
<script>
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';


        $('#item_expense_table').DataTable({
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax: {
                url: '{{route("contract.show",$contract->id)}}',
                data: {
                    type: 'item_expense'
                }
            },
            columns: [{
                    data: 'number',
                    name: 'number',
                    searchable: false
                },
                {
                    data: 'from_date',
                    name: 'from_date',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'to_date',
                    name: 'to_date',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'description',
                    name: 'description',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'item_name',
                    name: 'items.name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'measure',
                    name: 'measure',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'quantity',
                    name: 'quantity',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'category',
                    name: 'category',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'currency',
                    name: 'currency',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'rate',
                    name: 'rate',
                    orderable: false,
                    searchable: false
                },

                {
                    data: 'amount',
                    name: 'amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'itemExpenseCategory',
                    name: 'itemExpenseCategory',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'total',
                    name: 'total',
                    orderable: false,
                    searchable: false
                },


            ]

        });

    });
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';


        $('#shareholder_table').DataTable({
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax: {
                url: '{{route("contract.show",$contract->id)}}',
                data: {
                    type: 'shareholder'
                }
            },
            columns: [{
                    data: 'member_name',
                    name: 'member_name'
                },
                {
                    data: 'percentage',
                    name: 'percentage',
                    orderable: false,
                    searchable: false
                },
            ]
        });

    });
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#sold_item_table').DataTable({
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax: {
                url: '{{route("contract.show",$contract->id)}}',
                data: {
                    type: 'sold_item'
                }
            },
            columns: [{
                    data: 'number',
                    name: 'sales.number'
                },   
                {
                    data: 'description',
                    name: 'sales.description'
                },
                {
                    data: 'item_name',
                    name: 'items.name'
                },
                {
                    data: 'qut_out',
                    name: 'qut_out',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'price',
                    name: 'price',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'total',
                    name: 'total',
                    orderable: false,
                    searchable: false
                },
            ]
        });

    });
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#expense-table').DataTable({
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax: {
                url: '{{route("contract.show",$contract->id)}}',
                data: {
                    type: 'expenses'
                }
            },
            columns: [{
                    data: 'expense_account',
                    name: 'expense_account'
                },
                {
                    data: 'amount',
                    name: 'amount'
                },
                {
                    data: 'Currency',
                    name: 'Currency'
                },
                {
                    data: 'rate',
                    name: 'rate'
                },
                {
                    data: 'base',
                    name: 'base'
                },
                {
                    data: 'Date',
                    name: 'Date'
                },
                {
                    data: 'description',
                    name: 'description'
                },
            ]
        });
    });
    // Contract Date
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#customsExpense').on('shown.bs.tab', function(event) {
            $('#customsExpense_table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'customsExpense'
                    }
                },
                columns: [
                    {data: 'number', name: 'customs_expenses.number'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'rate', name: 'transactions.rate', searchable: false},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'account', name: 'accounts.name'},
                    {data: 'member', name: 'members.name'},
                    {data: 'vehicle_name', name: 'vehicle_name', searchable: false},
                    {data: 'item', name: 'items.name'},
                    {data: 'quantity', name: 'customs_expenses.quantity'},
                    {data: 'customs_quantity', name: 'customs_expenses.customs_quantity'},
                    {data: 'measure', name: 'measure_units.name'},
                    {data: 'date', name: 'customs_expenses.date', searchable: false},
                    {data: 'hour', name: 'purchases.hour', searchable: false},
                    {data: 'expense_type', name: 'customs_expenses.expense_type', orderable: false, searchable: false},
                    {data: 'description', name: 'customs_expenses.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#items').on('shown.bs.tab', function(event) {
            $('#purchase-item-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'purchased_item'
                    }
                },
                columns: [{
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'Date',
                        name: 'Date'
                    },
                    {
                        data: 'bourse_date',
                        name: 'bourse_date'
                    },
                    {
                        data: 'siteName',
                        name: 'siteName'
                    },
                    {
                        data: 'Item',
                        name: 'Item'
                    },
                    {
                        data: 'qut_in',
                        name: 'qut_in'
                    },
                    {
                        data: 'Measure',
                        name: 'Measure'
                    },
                    {
                        data: 'cost',
                        name: 'cost'
                    },
                    {
                        data: 'contract_differ',
                        name: 'contract_differ'
                    },
                    {
                        data: 'currency',
                        name: 'currency'
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#load_items').on('shown.bs.tab', function(event) {
            $('#load-item-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'load_item'
                    }
                },
                columns: [{
                        data: 'driver_name',
                        name: 'driver_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'other_driver_name',
                        name: 'other_driver_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'vehicle_name',
                        name: 'vehicle_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'tanker_name',
                        name: 'tanker_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'driver_type',
                        name: 'driver_type',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'cmr_number',
                        name: 'cmr_number',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'transit_number',
                        name: 'transit_number',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'source',
                        name: 'source',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'destination',
                        name: 'destination',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'loading_date',
                        name: 'loading_details.loading_date',
                        searchable: false
                    },
                    {
                        data: 'state',
                        name: 'loading_details.state'
                    },
                    {
                        data: 'discharge_date',
                        name: 'inventory_transfer_infos.discharge_date',
                        searchable: false
                    },
                    {
                        data: 'items',
                        name: 'items.name'
                    },
                    {
                        data: 'site',
                        name: 'inventory_sites.name'
                    },
                    {
                        data: 'measure',
                        name: 'measure',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'qty',
                        name: 'qty',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rent_quantity',
                        name: 'rent_quantity',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'total_transfer_fee',
                        name: 'total_transfer_fee',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Currency',
                        name: 'Currency',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Rate',
                        name: 'Rate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Total',
                        name: 'Total',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#over_loads').on('shown.bs.tab', function(event) {
            $('#overload-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'over_load'
                    }
                },
                columns: [{
                        data: 'Date',
                        name: 'Date',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'item_name',
                        name: 'item_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Measure',
                        name: 'Measure',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'qut_in',
                        name: 'qut_in',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'price',
                        name: 'price',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'total',
                        name: 'total',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#LoadDrops').on('shown.bs.tab', function(event) {
            $('#LoadDrop-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'LoadDrop'
                    }
                },
                columns: [{
                        data: 'Date',
                        name: 'Date',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'item_name',
                        name: 'item_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Measure',
                        name: 'Measure',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'qut_out',
                        name: 'qut_out',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'price',
                        name: 'price',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'total',
                        name: 'total',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#Westages').on('shown.bs.tab', function(event) {
            $('#Westage-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'Westage'
                    }
                },
                columns: [
                    {
                        data: 'ref_no',
                        name: 'ref_no',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'description',
                        name: 'description',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Date',
                        name: 'Date',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'item_name',
                        name: 'item_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Measure',
                        name: 'Measure',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'qut_out',
                        name: 'qut_out',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'price',
                        name: 'price',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'total',
                        name: 'total',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });
        
        $('#inventoryTransfers').on('shown.bs.tab', function(event) {
            $('#inventoryTransfer-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'inventoryTransfer'
                    }
                },
                columns: [
                    {
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'Date',
                        name: 'Date',
                        orderable: true,
                        searchable: false
                    },
                    {
                        data: 'from_conract',
                        name: 'from_conract'
                    },
                    {
                        data: 'from_wagon_number',
                        name: 'from_wagon_number'
                    },
                    {
                        data: 'to_conract',
                        name: 'to_conract'
                    },
                    {
                        data: 'to_wagon_number',
                        name: 'to_wagon_number'
                    },
                    {
                        data: 'ItemName',
                        name: 'ItemName'
                    },
                    {
                        data: 'from_site',
                        name: 'from_site'
                    },
                    {
                        data: 'to_site',
                        name: 'to_site'
                    },
                    {
                        data: 'Measure',
                        name: 'Measure',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'quantity',
                        name: 'quantity',
                        orderable: true,
                        searchable: false
                    },
                    {
                        data: 'cost',
                        name: 'cost',
                        orderable: true,
                        searchable: false
                    },
                    {
                        data: 'total',
                        name: 'total',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#contract-item').on('shown.bs.tab', function(event) {
            $('#contract-item-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'contract_item'
                    }
                },
                columns: [{
                        data: 'item_name',
                        name: 'item_name'
                    },
                    {
                        data: 'item_measure',
                        name: 'item_measure'
                    },
                    {
                        data: 'site_name',
                        name: 'site_name'
                    },
                    {
                        data: 'cost',
                        name: 'cost'
                    },
                    {
                        data: 'qty',
                        name: 'qty'
                    },
                    {
                        data: 'qut_in',
                        name: 'qut_in'
                    },
                    {
                        data: 'remain',
                        name: 'remain'
                    },
                    @if(getmine() == 'true')
                    {
                        data: 'sale_price',
                        name: 'sale_price'
                    },
                    @endif
                    {
                        data: 'description',
                        name: 'description'
                    },
                ]
            });
        });
    });
    // Sent Money Table
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#money').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#sentmoney-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'SentMoney'
                    }
                },
                columns: [{
                        data: 'Date',
                        name: 'Date'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'commAmount',
                        name: 'commAmount'
                    },
                    {
                        data: 'Currency',
                        name: 'Currency'
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                    {
                        data: 'dollarAmount',
                        name: 'dollarAmount'
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },
                ]
            });
        });
    });
    // Member Transfer Table

    // Sent Withdraw Table
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#deposite').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#depositeandwithdraw-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'depositeandwithdraw'
                    }
                },
                columns: [{
                        data: 'loan_number',
                        name: 'loans.number'
                    },
                    {
                        data: 'ref_no',
                        name: 'loans.ref_no'
                    },
                    {
                        data: 'Date',
                        name: 'loans.date'
                    },
                    {
                        data: 'Member',
                        name: 'members.name'
                    },
                    {
                        data: 'Account',
                        name: 'account',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'amount',
                        name: 'transactions.amount'
                    },
                    {
                        data: 'currency',
                        name: 'transactions.unit'
                    },
                    {
                        data: 'rate',
                        name: 'rate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'type',
                        name: 'loans.type',
                        searchable: false
                    },
                    {
                        data: 'username',
                        name: 'username',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'description',
                        name: 'loans.description'
                    }
                ]
            });
        });
    });
    // Member Withdraw Table   

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#payrollTabContract').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#payrollContract-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: { type: 'payrolls_contract'}
                },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'Employee', name: 'Employee'},
                    {data: 'BasicSalary', name: 'BasicSalary'},
                    {data: 'tax_amount', name: 'tax_amount', orderabel: false, searchable: false},
                    {data: 'Worked_Days', name: 'Worked_Days', orderabel: false, searchable: false},
                    {data: 'absent_day', name: 'absent_day', orderabel: false, searchable: false},
                    {data: 'Net_Payable', name: 'Net_Payable', orderabel: false, searchable: false},
                    {data: 'Curreny', name: 'Curreny', orderabel: false, searchable: false},
                    {data: 'Date', name: 'Date', searchable: false},
                    {data: 'From_Date', name: 'From_Date', orderabel: false, searchable: false},
                    {data: 'To_Date', name: 'To_Date', orderabel: false, searchable: false},
                    {data: 'username', name: 'users.name', orderabel: false, searchable: false},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', orderabel: false, searchable: false}
                ]
            });
        });
    });    
    

    
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#journalTabContract').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#journalContract-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: { type: 'journal_contract'}
                },
                columns: [
                { data: 'Account', name: 'Account' },
                { data: 'currency', name: 'currency' },
                { data: 'debit', name: 'debit' },
                { data: 'credit', name: 'credit' },
                { data: 'Description', name: 'Description' },
                ]
            });
        });
    });
    

    // Start of Daily Expense Script.....................................................
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#daily_expenses').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#daily_expense_tab_table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: { type: 'daily_expense'}
                },
                columns: [ 
                    {data: 'id', name: 'daily_expenses.id', searchable: false},
                    {data: 'number', name: 'daily_expenses.number'},
                    {data: 'Description', name: 'daily_expenses.description'},
                    {data: 'expense_account', name: 'exA.name'},
                    {data: 'Name', name: 'expense_categories.name' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'Bank', name: 'accounts.name'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'Currency', name: 'Currency', orderable: false, searchable: false},
                    {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                    {data: 'Date', name: 'daily_expenses.Date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'overdue_date', name: 'daily_expenses.overdue_date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'hour', name: 'daily_expenses.hour'},
                    @if(systemConfig()[5] != 0 )
                    {data: 'status', name: 'daily_expenses.status', searchable: false},
                    @endif
                    {data: 'username', name: 'username', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });
    });
    
    // End of Daily Expense Script ..........................................................




    // Start of Daily payroll_form Script.....................................................
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#payroll_form').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#payroll_form_tab_table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: { type: 'payrol_form'}
                },
                columns: [
                    { data: 'id',          name: 'payrolls.id' },
                    { data: 'number',          name: 'payrolls.number' },
                    { data: 'Employee',          name: 'members.name' },
                    @if(systemConfig()[5] != 0 )
                    {data: 'project_name', name: 'project_name', orderabel: false, searchable: false},
                    @endif
                    { data: 'Net_Payable', name: 'Net_Payable', orderabel:false,searchable:false },
                    { data: 'currency', name: 'currency' , orderabel:false,searchable:false},
                    { data: 'From_Date', name: 'From_Date', orderabel:false,searchable:false },
                    { data: 'To_Date',  name: 'To_Date', orderabel:false,searchable:false },
                    { data: 'description',  name: 'description' },
                    { data: 'user', name: 'users.name' },
                    { data: 'actions',  name: 'actions', orderabel:false,searchable:false },
                ]
            });
        });
    });
    
    // End of Daily payroll_form Script ..........................................................




    // Start of Daily Procurement Script.....................................................
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#Procurement').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#Procurement_tab_table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: { type: 'procurement'}
                },
                columns: [
                    { data: 'procurement_number', name: 'procurement_number' },
                    { data: 'site', name: 'site' },
                    { data: 'measure', name: 'measure' },
                    { data: 'quantity', name: 'quantity' },
                    { data: 'item', name: 'item' },
                    { data: 'name', name: 'name' },
                    { data: 'total_cost', name: 'total_cost' },
                    { data: 'dates', name: 'dates' },
                    { data: 'employee', name: 'employee' },
                    @if(systemConfig()[5] != 0 )
                    { data: 'project_name', name: 'project_name' },
                    @endif
                    { data: 'wagon_number', name: 'wagon_number' },
                    { data: 'description', name: 'description' },
                    { data: 'user', name: 'user' },
 
                ]
            });
        });
    });
    // End of Daily Procurement Script ..........................................................
    
    // Start of Payments Script.....................................................
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#Payment').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#Payment_tab_table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: { type: 'payments'}
                },
                columns: [
                    {data: 'number', name: 'payments.number'},
                    {data: 'ref_Number', name: 'payments.ref_no'},
                    {data: 'Name', name: 'members.name'},
                    {data: 'Account', name: 'accounts.name'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                    {data: 'commAmount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'Payment_type', name: 'Payment_type', orderable: false, searchable: false},
                    @if(systemConfig()[20] != 0 )
                        {data: 'contractname', name: 'contractname'},
                    @endif
                    {data: 'Date', name: 'payments.date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'overdue_date', name: 'payments.overdue_date'},
                    {data: 'hour', name: 'payments.hour', searchable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'Description', name: 'payments.description' @if(getGeneralSearch()) , searchable: false @endif},
                ]
            });
        });
    });
    // End of Payments Script ..........................................................

    // Start of Return Expense Script.....................................................
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#ReturnExpense').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#return_expense_table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: { type: 'return_expense'}
                },
                columns: [
                { data: 'number', name: 'number' },
                { data: 'date', name: 'date' },
                { data: 'description', name: 'description' },
                { data: 'expense_ref', name: 'expense_ref' },
                { data: 'bank', name: 'bank' },
                { data: 'member_name', name: 'member_name' },
                { data: 'account', name: 'account' },
                { data: 'type', name: 'type' },
                { data: 'amount', name: 'amount' },
                { data: 'Currency', name: 'Currency' }
                ]
            });
        });
    });
    // End of Return Expense Script ..........................................................
   


    
// NGOProjectExpenses Startfor the project ......................................
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#ngo_project_expenses').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#ngo_project_expense_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("contract.show",$contract->id)}}',
                data:{type:'ngo_project_expenses'}
                },
              columns: [  
                { data: 'number', name: 'number' },
                { data: 'date', name: 'date' },
                { data: 'description', name: 'description' },
                { data: 'name', name: 'name' },
                { data: 'measure_name', name: 'measure_name' },
                { data: 'quantity', name: 'quantity' },
                { data: 'price', name: 'price' },
                { data: 'member', name: 'member' },
                { data: 'currency', name: 'currency' },
                { data: 'rate', name: 'rate' },
                { data: 'amount', name: 'amount' },
                { data: 'user', name: 'user' }
              ]
          });  
          });
}); 
// End of NGOProjectExpenses for the projects ................................................................................



// NGOProjectExpenses Startfor the project ......................................
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#transfer_boxes').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#transfer_box_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("contract.show",$contract->id)}}',
                data:{type:'transfer_boxes'}
                },
              columns: [  
                {data: 'number', name: 'transfer_accounts.number'},
                {data: 'From_account', name: 'from_a.name'},
                {data: 'from_currency', name: 'from.unit'},
                {data: 'from_rate', name: 'from.rate'},
                {data: 'amount', name: 'from.amount'},
                {data: 'to_Account', name: 'to_a.name'},
                {data: 'to_currency', name: 'to.unit'},
                {data: 'to_rate', name: 'to.rate'},
                {data: 'to_amount', name: 'to.amount'},
                {data: 'Date', name: 'transfer_accounts.Date'},
                @if(systemConfig()[5] != 0 )
                {data: 'project', name: 'projects.name'},
                @endif
                {data: 'referencen_name', name: 'referencen_name'},
                {data: 'referencen_number', name: 'referencen_number'},
                {data: 'username', name: 'users.name'},
                {data: 'Description', name: 'transfer_accounts.description'},
              ]
          });  
          });
}); 
// End of NGOProjectExpenses for the projects ................................................................................

// Receive Startfor the project ......................................
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#receive_project').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#receive_project_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("contract.show",$contract->id)}}',
                data:{type:'receive_project'}
                },
                columns: [
                    {data: 'number', name: 'receivable_payments.number'},
                    {data: 'ref_no', name: 'receivable_payments.ref_no'},
                    {data: 'member_name', name: 'member_name'},
                    {data: 'account', name: 'accounts.name'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'type', name: 'type', searchable: false},
                    {data: 'amount', name: 'transactions.amount' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'date', name: 'receivable_payments.date' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'overdue_date', name: 'receivable_payments.overdue_date'},
                    {data: 'hour', name: 'receivable_payments.hour',searchable: false},
                    {data: 'username', name: 'users.name'},
                    {data: 'description', name: 'receivable_payments.description' @if(getGeneralSearch()) , searchable: false @endif},
                    {data: 'payment_status', name: 'payment_status', orderable: false, searchable: false},
                ]
          });  
          });
}); 
// End of Receive for the projects ................................................................................
// owners equity part start......................................
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
      $('#owners_equity').on('shown.bs.tab', function(event){
          // alert('adads');
       $('#owners_equity_table').DataTable({  
              scrollCollapse: true,
              responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
              serverSide: true,
              paging: true,
              retrieve: true,
              ajax:{
                url: '{{route("contract.show",$contract->id)}}',
                data:{type:'owners_equity'}
                },
                columns: [
                    {data: 'number', name: 'drawings.number'},
                    {data: 'name', name: 'members.name'},
                    {data: 'account', name: 'accounts.name'},
                    {data: 'drawing_account', name: 'drawing_account', orderable: false, searchable: false},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'date', name: 'date'},
                    {data: 'description', name: 'description'},
                    {data: 'username', name: 'users.name'},
                ]
          });  
          });
}); 
// owners equity part end................................................................................


   
    // Start of Sales services Script.....................................................
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#SaleService').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#return_sales_services_table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: { type: 'sale_service'}
                },
                columns: [
                { data: 'number', name: 'number' },
                { data: 'date', name: 'date' },
                { data: 'description', name: 'description' },
                { data: 'customer', name: 'customer' },
                { data: 'wagon_number', name: 'wagon_number' },
                { data: 'name', name: 'name' },
                { data: 'measure', name: 'measure' },
                { data: 'qty', name: 'qty' },
                { data: 'price_currency', name: 'price_currency' },
                { data: 'total_currency', name: 'total_currency' },
                { data: 'currency', name: 'currency' },
                { data: 'user', name: 'user' },
                ]
            });
        });
    });
    // End of Sales services Script ..........................................................


    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#member_transfer').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#memberTransfer-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'memberTransfer'
                    }
                },
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'oname', name: 'oname'},
                    {data: 'nname', name: 'nname'},
                    {data: 'amount', name: 'amount'},
                    {data: 'namount', name: 'namount'},
                    {data: 'currency', name: 'currency'},
                    {data: 'rate', name: 'rate'},
                    {data: 'date', name: 'date'},
                    {data: 'hour', name: 'hour'},
                    {data: 'username', name: 'username'},
                    {data: 'description', name: 'description'},
                ]
            });
        });
    });
    // returned money
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#redirect').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#ReturnedMoney').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'ReturnedMoney'
                    }
                },
                columns: [{
                        data: 'Date',
                        name: 'Date'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'commAmount',
                        name: 'commAmount'
                    },
                    {
                        data: 'Currency',
                        name: 'Currency'
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                    {
                        data: 'dollarAmount',
                        name: 'dollarAmount'
                    },
                    {
                        data: 'description',
                        name: 'description'
                    },
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

        $('#attachment').DataTable({
            ajax: {
                url: '{{route("contract.show",$contract->id)}}',
                data: {
                    type: 'attachment'
                }
            },

            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                {
                    data: 'title',
                    name: 'attachments.title'
                },
                {
                    data: 'description',
                    name: 'attachments.description'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                },
            ]
        });
    });    
    
    //loadingDate
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#loadingDate').on('shown.bs.tab', function(event) {
            $('#loadingDate_table').DataTable({
                ajax: {
                    url: '{{route("contract.show",$contract->id)}}',
                    data: {
                        type: 'loading_date'
                    }
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {
                        data: 'number',
                        name: 'contract_loading_dates.number'
                    },
                    {
                        data: 'date',
                        name: 'contract_loading_dates.date'
                    },
                    {
                        data: 'description',
                        name: 'contract_loading_dates.description'
                    }
                ]
            });
        });
    });


    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });
     // start app
    new Vue({
        el: '#app',
        data: {
            showModal: false,
            selected_wagon: null,
           

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {

                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    
    $('#profit_and_lost').on('click', function(e) {
        $('#show-modal').click();
        e.preventDefault();
    });

    

    // start loading_app
    var loadingSource = {!!json_encode($loadingSource)!!};
    var loadingDestination = {!!json_encode($loadingDestination)!!};
    var loadingLocation = {!!json_encode($loadingLocation)!!};
    var cust_rep = {!!customeReportNewData('contract_loading_index')!!};

    var cust_repcontract = {!!customeReportNewData('contract_detai_index')!!};
    var cust_repItemDetails = {!!customeReportNewData('contract_detai_item_index')!!};
    var cust_repPurchase = {!!customeReportNewData('contract_detila_purchase_index')!!};
    var cust_repOnHand = {!!customeReportNewData('contract_item_report_hand_index')!!};
    var cust_repInventoryTransfer = {!!customeReportNewData('contract_item_inventory_transfer_index')!!};
    var cust_repBuild = {!!customeReportNewData('contract_detail_item_build_index')!!};
    var cust_repItemNoneCost = {!!customeReportNewData('contract_noncost_detai_index')!!};
    var cust_repLoading = {!!customeReportNewData('contract_loading_detail_index')!!};
    var cust_repOverLoad = {!!customeReportNewData('contract_detail_overload_index')!!};
    var cust_repLoadDrop = {!!customeReportNewData('contract_detail_load_drop_index')!!};
    var cust_repFine = {!!customeReportNewData('contract_detai_fined_index')!!};
    var cust_repAdjustmentList = {!!customeReportNewData('contract_detai_adjustmentList_index')!!};
    var cust_repExpense = {!!customeReportNewData('contract_detail_expense_index')!!};
    var cust_repItemExpense = {!!customeReportNewData('contract_details_item_expense_index')!!}; 
    var cust_repItemDailyExpense = {!!customeReportNewData('contract_details_daily_expense_index')!!}; 
    var cust_repItemPayrollExpense = {!!customeReportNewData('contract_details_payroll_index')!!}; 
    var cust_repMemberTransfer = {!!customeReportNewData('contract_detail_member_transfer_index')!!};
    var cust_repDepositAndWithdrawal = {!!customeReportNewData('contract_details_deposite_withdraw_index')!!};
    var cust_repSaleService = {!!customeReportNewData('contract_detail_sale_service_index')!!};
    var cust_repSales = {!!customeReportNewData('contract_detai_sales_index')!!};
    var cust_repProcurememnt = {!!customeReportNewData('contract_detai_procurement_index')!!};
    var cust_return_expense = {!!customeReportNewData('contract_return_expense_index')!!};
    var cust_ngo_project = {!!customeReportNewData('contract_ngo_project_index')!!};
    var transfer_box = {!!customeReportNewData('contract_transfer_box_index')!!};
    var receive_contract = {!!customeReportNewData('contract_recieve_index')!!};
    var contract_customsExpense = {!!customeReportNewData('contract_details_customsExpense')!!};




    let mvv = new Vue({
        el: '#loading_app',
        data: {
            showModal: false,
            loadingSource: loadingSource,
            loadingSourceSel: null,
            loadingDestination: loadingDestination,
            loadingDestinationSel: null,
            loadingLocation: loadingLocation,
            loadingLocationSel: null,
            pdfRoute: '{!!route('contractLoading.report') !!}',
            excelRoute: '{!! route('contractLoading.report') !!}',
            driver: [],
            selected_driver: null,
            // customReportData:
                // [
                // {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                // {Name: '@lang("layout.LitterNumber")', column_name: 'litter_number',checkedColumn:(cust_rep.litter_number)?'checked':'',column_percentage:(cust_rep.litter_number___percent)?cust_rep.litter_number___percent:''},
                // {Name: '@lang("layout.LitterCategory")', column_name: 'litter_category',checkedColumn:(cust_rep.litter_category)?'checked':'',column_percentage:(cust_rep.litter_category___percent)?cust_rep.litter_category___percent:''},
                //  {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                //  {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                //  {Name: '@lang("layout.LitterTitle")', column_name: 'litter_title',checkedColumn:(cust_rep.litter_title)?'checked':'',column_percentage:(cust_rep.litter_title___percent)?cust_rep.litter_title___percent:''},
                //  {Name: '@lang("layout.Title")', column_name: 'title',checkedColumn:(cust_rep.title)?'checked':'',column_percentage:(cust_rep.title___percent)?cust_rep.title___percent:''},
                //  {Name: '@lang("layout.ReferenceDepartment")', column_name: 'reference_department',checkedColumn:(cust_rep.reference_department)?'checked':'',column_percentage:(cust_rep.reference_department___percent)?cust_rep.reference_department___percent:''},
                //  {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                //  {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
                //  {Name: '@lang("layout.Result")', column_name: 'result',checkedColumn:(cust_rep.result)?'checked':'',column_percentage:(cust_rep.result___percent)?cust_rep.result___percent:''},
                 
                
                //   ],
                //   cust_rep:cust_rep

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {

                        $(".date").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Driver'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        mvv.driver = [];
                        mvv.driver = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
        },
    });
    $('#contract_loading').on('click', function(e) {
        $('#loading-modal').click();
        e.preventDefault();
    });


    new Vue({
        el: '#app2',
        data: {
            showModal: false,

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample2: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#contract_item_expense_excel').on('click', function(e) {
        $('#show-modal2').click();
        e.preventDefault();
    });


    new Vue({
        el: '#app3',
        data: {
            showModal: false,

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample3: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });

    var vm1 = new Vue({
        el: '#print-modal1',
        data: {
            is_show1: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
        },
        methods: {
            closeModal: function() {
                this.is_show1 = !this.is_show1
            },


        }
    });

    new Vue({
        el: '#anchore-modal1',
        methods: {
            showModal: function() {
                console.log('trr')
                vm1.$data.is_show1 = true;

            }
        }
    });

    var customs_vm = new Vue({
        el: '#print_customsExpense-modal',
        data: {
            is_show1: false,
            pdfRoute: '{!!route('customsExpense.report') !!}',
            excelRoute: '{!! route('customsExpense.report') !!}',
        },
        methods: {
            closeModal: function() {
                this.is_show1 = !this.is_show1
            },


        }
    });

    new Vue({
        el: '#customsExpense-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                customs_vm.$data.is_show1 = true;

            }
        }
    });

    $('#contract_item_expense_pdf').on('click', function(e) {
        $('#show-modal3').click();
        e.preventDefault();
    });

    Vue.component('v-select', VueSelect.VueSelect);
    // var loadingSource = {!!json_encode($loadingSource)!!};
    // var loadingDestination = {!!json_encode($loadingDestination)!!};
    // var loadingLocation = {!!json_encode($loadingLocation)!!};
    // var cust_rep = {!!customeReportNewData('litter_index')!!};

    var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                loadingSource: loadingSource,
                loadingSourceSel: null,
                loadingDestination: loadingDestination,
                loadingDestinationSel: null,
                loadingLocation: loadingLocation,
                loadingLocationSel: null,
                 pdfRoute: '{!!route('contractLoading.report') !!}',
                excelRoute: '{!! route('contractLoading.report') !!}',
                selected_member:null,
                memberlist:[],
                driver: [],
                selected_driver: null,
                customReportData:
                [
                
                {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
                {Name: '@lang("layout.PaletNumber")', column_name: 'plate_number',checkedColumn:(cust_rep.plate_number)?'checked':'',column_percentage:(cust_rep.plate_number___percent)?cust_rep.plate_number___percent:''},
                {Name: '@lang("layout.SourcePlace")', column_name: 'source_place',checkedColumn:(cust_rep.source_place)?'checked':'',column_percentage:(cust_rep.source_place___percent)?cust_rep.source_place___percent:''},
                {Name: '@lang("layout.Destination")', column_name: 'destination',checkedColumn:(cust_rep.destination)?'checked':'',column_percentage:(cust_rep.destination___percent)?cust_rep.destination___percent:''},
                 {Name: '@lang("layout.LoadingDate")', column_name: 'loading_date',checkedColumn:(cust_rep.loading_date)?'checked':'',column_percentage:(cust_rep.loading_date___percent)?cust_rep.loading_date___percent:''},
                 {Name: '@lang("layout.DischargeDate")', column_name: 'discharge_date',checkedColumn:(cust_rep.discharge_date)?'checked':'',column_percentage:(cust_rep.discharge_date___percent)?cust_rep.discharge_date___percent:''},
                 {Name: '@lang("layout.Discharge")', column_name: 'discharge',checkedColumn:(cust_rep.discharge)?'checked':'',column_percentage:(cust_rep.discharge___percent)?cust_rep.discharge___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                 {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.LoadQuantity")', column_name: 'load_quantity',checkedColumn:(cust_rep.load_quantity)?'checked':'',column_percentage:(cust_rep.load_quantity___percent)?cust_rep.load_quantity___percent:''},
                 {Name: '@lang("layout.DischargeQuantity")', column_name: 'discharge_quantity',checkedColumn:(cust_rep.discharge_quantity)?'checked':'',column_percentage:(cust_rep.discharge_quantity___percent)?cust_rep.discharge_quantity___percent:''},
                 {Name: '@lang("layout.Differ")', column_name: 'differ',checkedColumn:(cust_rep.differ)?'checked':'',column_percentage:(cust_rep.differ___percent)?cust_rep.differ___percent:''},
                 {Name: '@lang("layout.OverLoad")', column_name: 'over_load',checkedColumn:(cust_rep.over_load)?'checked':'',column_percentage:(cust_rep.over_load___percent)?cust_rep.over_load___percent:''},
                 {Name: '@lang("layout.LoadDrop")', column_name: 'load_drop',checkedColumn:(cust_rep.load_drop)?'checked':'',column_percentage:(cust_rep.load_drop___percent)?cust_rep.load_drop___percent:''},
                 {Name: '@lang("layout.FinedAmount")', column_name: 'fined_amount',checkedColumn:(cust_rep.fined_amount)?'checked':'',column_percentage:(cust_rep.fined_amount___percent)?cust_rep.fined_amount___percent:''},
                 {Name: '@lang("layout.TotalTransferFee")', column_name: 'total_transfer_fee',checkedColumn:(cust_rep.total_transfer_fee)?'checked':'',column_percentage:(cust_rep.total_transfer_fee___percent)?cust_rep.total_transfer_fee___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total_loading',checkedColumn:(cust_rep.total_loading)?'checked':'',column_percentage:(cust_rep.total_loading___percent)?cust_rep.total_loading___percent:''},

                  ],
                  cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
               

                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                MemberSearch: _.debounce((search, loading) => {
                loading(true);
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Driver'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.driver = [];
                        vm.driver = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });





        // These Codes are related to the modal Two ..............................................
        
    var vmtwo = new Vue({
        el: '#print-modaltwo',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            is_showtwo: false,
            selected_wagon : null,
            loadingSource: loadingSource,
            loadingSourceSel: null,
            index:0,
            loadingDestination: loadingDestination,
            loadingDestinationSel: null,
            loadingLocation: loadingLocation,
            loadingLocationSel: null,
            pdfRoute: '{!!route('contractProfitandLost.report') !!}',
            excelRoute: '{!! route('contractProfitandLost.report') !!}',
            selected_member:null, 
            memberlist:[],
            driver: [],
            selected_driver: null,
            cust_repcontractes:
            [  
            {Name: '@lang("layout.ContractNumber")', column_name: 'contract_detail_number',checkedColumn:(cust_repcontract.contract_detail_number)?'checked':'',column_percentage:(cust_repcontract.contract_detail_number___percent)?cust_repcontract.contract_detail_number___percent:''},
            {Name: '@lang("layout.ContractName")', column_name: 'contract_detail_name',checkedColumn:(cust_repcontract.contract_detail_name)?'checked':'',column_percentage:(cust_repcontract.contract_detail_name___percent)?cust_repcontract.contract_detail_name___percent:''},
            {Name: '@lang("layout.Vendor")', column_name: 'contract_detail_vendor',checkedColumn:(cust_repcontract.contract_detail_vendor)?'checked':'',column_percentage:(cust_repcontract.contract_detail_vendor___percent)?cust_repcontract.contract_detail_vendor___percent:''},
            {Name: '@lang("layout.Phone")', column_name: 'contract_detail_phone',checkedColumn:(cust_repcontract.contract_detail_phone)?'checked':'',column_percentage:(cust_repcontract.contract_detail_phone___percent)?cust_repcontract.contract_detail_phone___percent:''},
            {Name: '@lang("layout.Address")', column_name: 'contract_detail_address',checkedColumn:(cust_repcontract.contract_detail_address)?'checked':'',column_percentage:(cust_repcontract.contract_detail_address___percent)?cust_repcontract.contract_detail_address___percent:''},
            {Name: '@lang("layout.Email")', column_name: 'contract_detail_email',checkedColumn:(cust_repcontract.contract_detail_email)?'checked':'',column_percentage:(cust_repcontract.contract_detail_email___percent)?cust_repcontract.contract_detail_email___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'contract_detail_description',checkedColumn:(cust_repcontract.contract_detail_description)?'checked':'',column_percentage:(cust_repcontract.contract_detail_description___percent)?cust_repcontract.contract_detail_description___percent:''},
            {Name: '@lang("layout.User")', column_name: 'contract_detail_user',checkedColumn:(cust_repcontract.contract_detail_user)?'checked':'',column_percentage:(cust_repcontract.contract_detail_user___percent)?cust_repcontract.contract_detail_user___percent:''},
            {Name: '@lang("layout.TotalInHomeCurrency")', column_name: 'contract_detail_total_base',checkedColumn:(cust_repcontract.contract_detail_total_base)?'checked':'',column_percentage:(cust_repcontract.contract_detail_total_base___percent)?cust_repcontract.contract_detail_total_base___percent:''},
            ],
                cust_repcontract:cust_repcontract,
                cust_repItemDetailses:
            [
            {Name: '@lang("layout.ItemName")', column_name: 'item_contract_details_name',checkedColumn:(cust_repItemDetails.item_contract_details_name)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_name___percent)?cust_repItemDetails.item_contract_details_name___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'item_contract_details_measure',checkedColumn:(cust_repItemDetails.item_contract_details_measure)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_measure___percent)?cust_repItemDetails.item_contract_details_measure___percent:''},
            {Name: '@lang("layout.SiteName")', column_name: 'item_contract_details_site_name',checkedColumn:(cust_repItemDetails.item_contract_details_site_name)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_site_name___percent)?cust_repItemDetails.item_contract_details_site_name___percent:''},
            {Name: '@lang("layout.Cost")', column_name: 'item_contract_details_cost',checkedColumn:(cust_repItemDetails.item_contract_details_cost)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_cost___percent)?cust_repItemDetails.item_contract_details_cost___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'item_contract_details_quantity',checkedColumn:(cust_repItemDetails.item_contract_details_quantity)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_quantity___percent)?cust_repItemDetails.item_contract_details_quantity___percent:''},
            {Name: '@lang("layout.PurchasedQuantity")', column_name: 'item_contract_details_purchased_quantity',checkedColumn:(cust_repItemDetails.item_contract_details_purchased_quantity)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_purchased_quantity___percent)?cust_repItemDetails.item_contract_details_purchased_quantity___percent:''},
            {Name: '@lang("layout.Remain")', column_name: 'item_contract_details_remain',checkedColumn:(cust_repItemDetails.item_contract_details_remain)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_remain___percent)?cust_repItemDetails.item_contract_details_remain___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'item_contract_details_description',checkedColumn:(cust_repItemDetails.item_contract_details_description)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_description___percent)?cust_repItemDetails.item_contract_details_description___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'item_contract_details_total',checkedColumn:(cust_repItemDetails.item_contract_details_total)?'checked':'',column_percentage:(cust_repItemDetails.item_contract_details_total___percent)?cust_repItemDetails.item_contract_details_total___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'Total',checkedColumn:(cust_repItemDetails.Total)?'checked':'',column_percentage:(cust_repItemDetails.Total___percent)?cust_repItemDetails.Total___percent:''},
            ],
                cust_repItemDetails:cust_repItemDetails,
                cust_repPurchases:
            [
            {Name: '@lang("layout.PurchaseNumber")', column_name: 'purchase_number',checkedColumn:(cust_repPurchase.purchase_number)?'checked':'',column_percentage:(cust_repPurchase.purchase_number___percent)?cust_repPurchase.purchase_number___percent:''},
            {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number',checkedColumn:(cust_repPurchase.wagon_number)?'checked':'',column_percentage:(cust_repPurchase.wagon_number___percent)?cust_repPurchase.wagon_number___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repPurchase.date)?'checked':'',column_percentage:(cust_repPurchase.date___percent)?cust_repPurchase.date___percent:''},
            {Name: '@lang("layout.BourseDate")', column_name: 'bourse_date',checkedColumn:(cust_repPurchase.bourse_date)?'checked':'',column_percentage:(cust_repPurchase.bourse_date___percent)?cust_repPurchase.bourse_date___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repPurchase.description)?'checked':'',column_percentage:(cust_repPurchase.description___percent)?cust_repPurchase.description___percent:''},
            {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_repPurchase.item)?'checked':'',column_percentage:(cust_repPurchase.item___percent)?cust_repPurchase.item___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'meaasure',checkedColumn:(cust_repPurchase.meaasure)?'checked':'',column_percentage:(cust_repPurchase.meaasure___percent)?cust_repPurchase.meaasure___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'curreny',checkedColumn:(cust_repPurchase.curreny)?'checked':'',column_percentage:(cust_repPurchase.curreny___percent)?cust_repPurchase.curreny___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repPurchase.quantity)?'checked':'',column_percentage:(cust_repPurchase.quantity___percent)?cust_repPurchase.quantity___percent:''},
            {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_repPurchase.rate)?'checked':'',column_percentage:(cust_repPurchase.rate___percent)?cust_repPurchase.rate___percent:''},
            {Name: '@lang("layout.Cost")', column_name: 'cost',checkedColumn:(cust_repPurchase.cost)?'checked':'',column_percentage:(cust_repPurchase.cost___percent)?cust_repPurchase.cost___percent:''},
            {Name: '@lang("layout.Differ")', column_name: 'differ',checkedColumn:(cust_repPurchase.differ)?'checked':'',column_percentage:(cust_repPurchase.differ___percent)?cust_repPurchase.differ___percent:''},
            {Name: '@lang("layout.TotalPurchaseCost")', column_name: 'total_purchase_cost',checkedColumn:(cust_repPurchase.total_purchase_cost)?'checked':'',column_percentage:(cust_repPurchase.total_purchase_cost___percent)?cust_repPurchase.total_purchase_cost___percent:''},
            {Name: '@lang("layout.Expense")', column_name: 'expense',checkedColumn:(cust_repPurchase.expense)?'checked':'',column_percentage:(cust_repPurchase.expense___percent)?cust_repPurchase.expense___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repPurchase.total)?'checked':'',column_percentage:(cust_repPurchase.total___percent)?cust_repPurchase.total___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user_purchase',checkedColumn:(cust_repPurchase.user_purchase)?'checked':'',column_percentage:(cust_repPurchase.user_purchase___percent)?cust_repPurchase.user_purchase___percent:''},
            {Name: '@lang("layout.Driver")', column_name: 'purchaseDriver',checkedColumn:(cust_repPurchase.purchaseDriver)?'checked':'',column_percentage:(cust_repPurchase.purchaseDriver___percent)?cust_repPurchase.purchaseDriver___percent:''},
            {Name: '@lang("layout.PaletNumber")', column_name: 'purchasePaletNumber',checkedColumn:(cust_repPurchase.purchasePaletNumber)?'checked':'',column_percentage:(cust_repPurchase.purchasePaletNumber___percent)?cust_repPurchase.purchasePaletNumber___percent:''},
            {Name: '@lang("layout.PerCurrency")', column_name: 'purchasePerCurrency',checkedColumn:(cust_repPurchase.purchasePerCurrency)?'checked':'',column_percentage:(cust_repPurchase.purchasePerCurrency___percent)?cust_repPurchase.purchasePerCurrency___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'purchaseTotal',checkedColumn:(cust_repPurchase.purchaseTotal)?'checked':'',column_percentage:(cust_repPurchase.purchaseTotal___percent)?cust_repPurchase.purchaseTotal___percent:''},
            ],
                cust_repPurchase:cust_repPurchase,
                cust_repOnHandes:
            [           
            {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number',checkedColumn:(cust_repOnHand.wagon_number)?'checked':'',column_percentage:(cust_repOnHand.wagon_number___percent)?cust_repOnHand.wagon_number___percent:''},
            {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_repOnHand.item)?'checked':'',column_percentage:(cust_repOnHand.item___percent)?cust_repOnHand.item___percent:''},
            {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_repOnHand.site)?'checked':'',column_percentage:(cust_repOnHand.site___percent)?cust_repOnHand.site___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repOnHand.measure)?'checked':'',column_percentage:(cust_repOnHand.measure___percent)?cust_repOnHand.measure___percent:''},
            {Name: '@lang("layout.OnHand")', column_name: 'on_hand',checkedColumn:(cust_repOnHand.on_hand)?'checked':'',column_percentage:(cust_repOnHand.on_hand___percent)?cust_repOnHand.on_hand___percent:''},
            {Name: '@lang("layout.UnitCost")', column_name: 'unit_cost',checkedColumn:(cust_repOnHand.unit_cost)?'checked':'',column_percentage:(cust_repOnHand.unit_cost___percent)?cust_repOnHand.unit_cost___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repOnHand.total)?'checked':'',column_percentage:(cust_repOnHand.total___percent)?cust_repOnHand.total___percent:''},
            {Name: '@lang("layout.PerCurrency")', column_name: 'inventoryPerCurrency',checkedColumn:(cust_repOnHand.inventoryPerCurrency)?'checked':'',column_percentage:(cust_repOnHand.inventoryPerCurrency___percent)?cust_repOnHand.inventoryPerCurrency___percent:''},
            ],
                cust_repOnHand:cust_repOnHand,
                cust_repInventoryTransferes:
            [
            {Name: '@lang("layout.Transfer")', column_name: 'transfer',checkedColumn:(cust_repInventoryTransfer.transfer)?'checked':'',column_percentage:(cust_repInventoryTransfer.transfer___percent)?cust_repInventoryTransfer.transfer___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repInventoryTransfer.date)?'checked':'',column_percentage:(cust_repInventoryTransfer.date___percent)?cust_repInventoryTransfer.date___percent:''},
            {Name: '@lang("layout.From")', column_name: 'from',checkedColumn:(cust_repInventoryTransfer.from)?'checked':'',column_percentage:(cust_repInventoryTransfer.from___percent)?cust_repInventoryTransfer.from___percent:''},
            {Name: '@lang("layout.to")', column_name: 'to',checkedColumn:(cust_repInventoryTransfer.to)?'checked':'',column_percentage:(cust_repInventoryTransfer.to___percent)?cust_repInventoryTransfer.to___percent:''},
            {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number',checkedColumn:(cust_repInventoryTransfer.wagon_number)?'checked':'',column_percentage:(cust_repInventoryTransfer.wagon_number___percent)?cust_repInventoryTransfer.wagon_number___percent:''},
            {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_repInventoryTransfer.item)?'checked':'',column_percentage:(cust_repInventoryTransfer.item___percent)?cust_repInventoryTransfer.item___percent:''},
            {Name: '@lang("layout.FromSite")', column_name: 'from_Site',checkedColumn:(cust_repInventoryTransfer.from_Site)?'checked':'',column_percentage:(cust_repInventoryTransfer.from_Site___percent)?cust_repInventoryTransfer.from_Site___percent:''},
            {Name: '@lang("layout.ToSite")', column_name: 'to_site',checkedColumn:(cust_repInventoryTransfer.to_site)?'checked':'',column_percentage:(cust_repInventoryTransfer.to_site___percent)?cust_repInventoryTransfer.to_site___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repInventoryTransfer.measure)?'checked':'',column_percentage:(cust_repInventoryTransfer.measure___percent)?cust_repInventoryTransfer.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repInventoryTransfer.quantity)?'checked':'',column_percentage:(cust_repInventoryTransfer.quantity___percent)?cust_repInventoryTransfer.quantity___percent:''},
            {Name: '@lang("layout.UnitCost")', column_name: 'unit_cost',checkedColumn:(cust_repInventoryTransfer.unit_cost)?'checked':'',column_percentage:(cust_repInventoryTransfer.unit_cost___percent)?cust_repInventoryTransfer.unit_cost___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repInventoryTransfer.total)?'checked':'',column_percentage:(cust_repInventoryTransfer.total___percent)?cust_repInventoryTransfer.total___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user_inventory_transfer',checkedColumn:(cust_repInventoryTransfer.user_inventory_transfer)?'checked':'',column_percentage:(cust_repInventoryTransfer.user_inventory_transfer___percent)?cust_repInventoryTransfer.user_purchase___percent:''},
            ],
                cust_repInventoryTransfer:cust_repInventoryTransfer,
                cust_repBuildes:
            [
            {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number',checkedColumn:(cust_repBuild.wagon_number)?'checked':'',column_percentage:(cust_repBuild.wagon_number___percent)?cust_repBuild.wagon_number___percent:''},
            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_repBuild.number)?'checked':'',column_percentage:(cust_repBuild.number___percent)?cust_repBuild.number___percent:''},
            {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_repBuild.item_name)?'checked':'',column_percentage:(cust_repBuild.item_name___percent)?cust_repBuild.item_name___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repBuild.measure)?'checked':'',column_percentage:(cust_repBuild.measure___percent)?cust_repBuild.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repBuild.quantity)?'checked':'',column_percentage:(cust_repBuild.quantity___percent)?cust_repBuild.quantity___percent:''},
            {Name: '@lang("layout.Cost")', column_name: 'cost',checkedColumn:(cust_repBuild.cost)?'checked':'',column_percentage:(cust_repBuild.cost___percent)?cust_repBuild.cost___percent:''},
            {Name: '@lang("layout.ItemExpense")', column_name: 'item_expense',checkedColumn:(cust_repBuild.item_expense)?'checked':'',column_percentage:(cust_repBuild.item_expense___percent)?cust_repBuild.item_expense___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repBuild.description)?'checked':'',column_percentage:(cust_repBuild.description___percent)?cust_repBuild.description___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repBuild.date)?'checked':'',column_percentage:(cust_repBuild.date___percent)?cust_repBuild.date___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repBuild.total)?'checked':'',column_percentage:(cust_repBuild.total___percent)?cust_repBuild.total___percent:''},
            ],
                cust_repBuild:cust_repBuild,
                cust_repItemNoneCosts:
            [
            {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number',checkedColumn:(cust_repItemNoneCost.wagon_number)?'checked':'',column_percentage:(cust_repItemNoneCost.wagon_number___percent)?cust_repItemNoneCost.wagon_number___percent:''},
            {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_repItemNoneCost.reference_number)?'checked':'',column_percentage:(cust_repItemNoneCost.reference_number___percent)?cust_repItemNoneCost.reference_number___percent:''},
            {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_repItemNoneCost.item_name)?'checked':'',column_percentage:(cust_repItemNoneCost.item_name___percent)?cust_repItemNoneCost.item_name___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repItemNoneCost.measure)?'checked':'',column_percentage:(cust_repItemNoneCost.measure___percent)?cust_repItemNoneCost.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repItemNoneCost.quantity)?'checked':'',column_percentage:(cust_repItemNoneCost.quantity___percent)?cust_repItemNoneCost.quantity___percent:''},
            {Name: '@lang("layout.Cost")', column_name: 'cost',checkedColumn:(cust_repItemNoneCost.cost)?'checked':'',column_percentage:(cust_repItemNoneCost.cost___percent)?cust_repItemNoneCost.cost___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repItemNoneCost.date)?'checked':'',column_percentage:(cust_repItemNoneCost.date___percent)?cust_repItemNoneCost.date___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repItemNoneCost.description)?'checked':'',column_percentage:(cust_repItemNoneCost.description___percent)?cust_repItemNoneCost.description___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repItemNoneCost.total)?'checked':'',column_percentage:(cust_repItemNoneCost.total___percent)?cust_repItemNoneCost.total___percent:''},
                ],
                cust_repItemNoneCost:cust_repItemNoneCost,
                cust_repLoadinges:
            [
            {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_repLoading.driver)?'checked':'',column_percentage:(cust_repLoading.driver___percent)?cust_repLoading.driver___percent:''},
            {Name: '@lang("layout.PaletNumber")', column_name: 'plate_number',checkedColumn:(cust_repLoading.plate_number)?'checked':'',column_percentage:(cust_repLoading.plate_number___percent)?cust_repLoading.plate_number___percent:''},
            {Name: '@lang("layout.TankerNumber")', column_name: 'tanker_number',checkedColumn:(cust_repLoading.tanker_number)?'checked':'',column_percentage:(cust_repLoading.tanker_number___percent)?cust_repLoading.tanker_number___percent:''},
            // {Name: '@lang("layout.DriverType")', column_name: 'driver_type',checkedColumn:(cust_repLoading.driver_type)?'checked':'',column_percentage:(cust_repLoading.driver_type___percent)?cust_repLoading.driver_type___percent:''},
            {Name: '@lang("layout.WayBillNumber")', column_name: 'way_bill_number',checkedColumn:(cust_repLoading.way_bill_number)?'checked':'',column_percentage:(cust_repLoading.way_bill_number___percent)?cust_repLoading.way_bill_number___percent:''},
            {Name: '@lang("layout.SourcePlace")', column_name: 'source_place',checkedColumn:(cust_repLoading.source_place)?'checked':'',column_percentage:(cust_repLoading.source_place___percent)?cust_repLoading.source_place___percent:''},
            {Name: '@lang("layout.Destination")', column_name: 'destination',checkedColumn:(cust_repLoading.destination)?'checked':'',column_percentage:(cust_repLoading.destination___percent)?cust_repLoading.destination___percent:''},
            {Name: '@lang("layout.LoadingDate")', column_name: 'loading_date',checkedColumn:(cust_repLoading.loading_date)?'checked':'',column_percentage:(cust_repLoading.loading_date___percent)?cust_repLoading.loading_date___percent:''},
            {Name: '@lang("layout.DischargeDate")', column_name: 'discharge_date',checkedColumn:(cust_repLoading.discharge_date)?'checked':'',column_percentage:(cust_repLoading.discharge_date___percent)?cust_repLoading.discharge_date___percent:''},
            {Name: '@lang("layout.Discharge")', column_name: 'discharge',checkedColumn:(cust_repLoading.discharge)?'checked':'',column_percentage:(cust_repLoading.discharge___percent)?cust_repLoading.discharge___percent:''},
            {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_repLoading.item_name)?'checked':'',column_percentage:(cust_repLoading.item_name___percent)?cust_repLoading.item_name___percent:''},
            {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_repLoading.site)?'checked':'',column_percentage:(cust_repLoading.site___percent)?cust_repLoading.site___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repLoading.measure)?'checked':'',column_percentage:(cust_repLoading.measure___percent)?cust_repLoading.measure___percent:''},
            {Name: '@lang("layout.LoadQuantity")', column_name: 'load_quantity',checkedColumn:(cust_repLoading.load_quantity)?'checked':'',column_percentage:(cust_repLoading.load_quantity___percent)?cust_repLoading.load_quantity___percent:''},
            {Name: '@lang("layout.RentQuantity")', column_name: 'rent_quantity',checkedColumn:(cust_repLoading.rent_quantity)?'checked':'',column_percentage:(cust_repLoading.rent_quantity___percent)?cust_repLoading.rent_quantity___percent:''},
            {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_repLoading.price)?'checked':'',column_percentage:(cust_repLoading.price___percent)?cust_repLoading.price___percent:''},
            // {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_repLoading.currency)?'checked':'',column_percentage:(cust_repLoading.currency___percent)?cust_repLoading.currency___percent:''},
            // {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_repLoading.rate)?'checked':'',column_percentage:(cust_repLoading.rate___percent)?cust_repLoading.rate___percent:''},
            {Name: '@lang("layout.TotalTransferFee")', column_name: 'total_transfer_free',checkedColumn:(cust_repLoading.total_transfer_free)?'checked':'',column_percentage:(cust_repLoading.total_transfer_free___percent)?cust_repLoading.total_transfer_free___percent:''},
            {Name: '@lang("layout.DischargeQuantity")', column_name: 'discharge_quantity',checkedColumn:(cust_repLoading.discharge_quantity)?'checked':'',column_percentage:(cust_repLoading.discharge_quantity___percent)?cust_repLoading.discharge_quantity___percent:''},
            {Name: '@lang("layout.Differ")', column_name: 'differ',checkedColumn:(cust_repLoading.differ)?'checked':'',column_percentage:(cust_repLoading.differ___percent)?cust_repLoading.differ___percent:''},
            {Name: '@lang("layout.OverLoad")', column_name: 'over_load',checkedColumn:(cust_repLoading.over_load)?'checked':'',column_percentage:(cust_repLoading.over_load___percent)?cust_repLoading.over_load___percent:''},
            {Name: '@lang("layout.LoadDrop")', column_name: 'load_drop',checkedColumn:(cust_repLoading.load_drop)?'checked':'',column_percentage:(cust_repLoading.load_drop___percent)?cust_repLoading.load_drop___percent:''},
            {Name: '@lang("layout.FinedAmount")', column_name: 'fined_amount',checkedColumn:(cust_repLoading.fined_amount)?'checked':'',column_percentage:(cust_repLoading.fined_amount___percent)?cust_repLoading.fined_amount___percent:''},
            {Name: '@lang("layout.FinedAmount")', column_name: 'fined_amounttwo',checkedColumn:(cust_repLoading.fined_amounttwo)?'checked':'',column_percentage:(cust_repLoading.fined_amounttwo___percent)?cust_repLoading.fined_amounttwo___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user_loading',checkedColumn:(cust_repLoading.user_loading)?'checked':'',column_percentage:(cust_repLoading.user_loading___percent)?cust_repLoading.user_loading___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total_loading',checkedColumn:(cust_repLoading.total_loading)?'checked':'',column_percentage:(cust_repLoading.total_loading___percent)?cust_repLoading.total_loading___percent:''},

                ],
                cust_repLoading:cust_repLoading,
            

                cust_repOverLoades:
            [
            
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repOverLoad.date)?'checked':'',column_percentage:(cust_repOverLoad.date___percent)?cust_repOverLoad.date___percent:''},
            {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_repOverLoad.item)?'checked':'',column_percentage:(cust_repOverLoad.item___percent)?cust_repOverLoad.item___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repOverLoad.measure)?'checked':'',column_percentage:(cust_repOverLoad.measure___percent)?cust_repOverLoad.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repOverLoad.quantity)?'checked':'',column_percentage:(cust_repOverLoad.quantity___percent)?cust_repOverLoad.quantity___percent:''},
            {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_repOverLoad.price)?'checked':'',column_percentage:(cust_repOverLoad.price___percent)?cust_repOverLoad.price___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repOverLoad.total)?'checked':'',column_percentage:(cust_repOverLoad.total___percent)?cust_repOverLoad.total___percent:''},
            {Name: '@lang("layout.PaletNumber")', column_name: 'plate_number',checkedColumn:(cust_repOverLoad.plate_number)?'checked':'',column_percentage:(cust_repOverLoad.plate_number___percent)?cust_repOverLoad.plate_number___percent:''},
            {Name: '@lang("layout.User")', column_name: 'over_loades_user',checkedColumn:(cust_repOverLoad.over_loades_user)?'checked':'',column_percentage:(cust_repOverLoad.over_loades_user___percent)?cust_repOverLoad.over_loades_user___percent:''},

                ],
                cust_repOverLoad:cust_repOverLoad,


                
                cust_repLoadDropess:
            [
            
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repLoadDrop.date)?'checked':'',column_percentage:(cust_repLoadDrop.date___percent)?cust_repLoadDrop.date___percent:''},
            {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_repLoadDrop.item)?'checked':'',column_percentage:(cust_repLoadDrop.item___percent)?cust_repLoadDrop.item___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repLoadDrop.measure)?'checked':'',column_percentage:(cust_repLoadDrop.measure___percent)?cust_repLoadDrop.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repLoadDrop.quantity)?'checked':'',column_percentage:(cust_repLoadDrop.quantity___percent)?cust_repLoadDrop.quantity___percent:''},
            {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_repLoadDrop.price)?'checked':'',column_percentage:(cust_repLoadDrop.price___percent)?cust_repLoadDrop.price___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repLoadDrop.total)?'checked':'',column_percentage:(cust_repLoadDrop.total___percent)?cust_repLoadDrop.total___percent:''},
            {Name: '@lang("layout.PaletNumber")', column_name: 'plate_number',checkedColumn:(cust_repLoadDrop.plate_number)?'checked':'',column_percentage:(cust_repLoadDrop.plate_number___percent)?cust_repLoadDrop.plate_number___percent:''},
        
            {Name: '@lang("layout.User")', column_name: 'loaddrop_user',checkedColumn:(cust_repLoadDrop.loaddrop_user)?'checked':'',column_percentage:(cust_repLoadDrop.loaddrop_user___percent)?cust_repLoadDrop.loaddrop_user___percent:''},

            ],
                cust_repLoadDrop:cust_repLoadDrop,


                cust_repFines:
            [
            
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repFine.date)?'checked':'',column_percentage:(cust_repFine.date___percent)?cust_repFine.date___percent:''},
            {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_repFine.item)?'checked':'',column_percentage:(cust_repFine.item___percent)?cust_repFine.item___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repFine.measure)?'checked':'',column_percentage:(cust_repFine.measure___percent)?cust_repFine.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repFine.quantity)?'checked':'',column_percentage:(cust_repFine.quantity___percent)?cust_repFine.quantity___percent:''},
            {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_repFine.price)?'checked':'',column_percentage:(cust_repFine.price___percent)?cust_repFine.price___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repFine.total)?'checked':'',column_percentage:(cust_repFine.total___percent)?cust_repFine.total___percent:''},
            {Name: '@lang("layout.PaletNumber")', column_name: 'plate_number',checkedColumn:(cust_repFine.plate_number)?'checked':'',column_percentage:(cust_repFine.plate_number___percent)?cust_repFine.plate_number___percent:''},
            {Name: '@lang("layout.User")', column_name: 'fines_user',checkedColumn:(cust_repFine.fines_user)?'checked':'',column_percentage:(cust_repFine.fines_user___percent)?cust_repFine.fines_user___percent:''},

                ],
                cust_repFine:cust_repFine,


                cust_repAdjustmentLists:
            [
            
            {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_repAdjustmentList.reference_number)?'checked':'',column_percentage:(cust_repAdjustmentList.reference_number___percent)?cust_repAdjustmentList.reference_number___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repAdjustmentList.date)?'checked':'',column_percentage:(cust_repAdjustmentList.date___percent)?cust_repAdjustmentList.date___percent:''},
            {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_repAdjustmentList.item_name)?'checked':'',column_percentage:(cust_repAdjustmentList.item_name___percent)?cust_repAdjustmentList.item_name___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repAdjustmentList.measure)?'checked':'',column_percentage:(cust_repAdjustmentList.measure___percent)?cust_repAdjustmentList.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repAdjustmentList.quantity)?'checked':'',column_percentage:(cust_repAdjustmentList.quantity___percent)?cust_repAdjustmentList.quantity___percent:''},
            {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_repAdjustmentList.price)?'checked':'',column_percentage:(cust_repAdjustmentList.price___percent)?cust_repAdjustmentList.price___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repAdjustmentList.total)?'checked':'',column_percentage:(cust_repAdjustmentList.total___percent)?cust_repAdjustmentList.total___percent:''},
            {Name: '@lang("layout.User")', column_name: 'adj_user',checkedColumn:(cust_repAdjustmentList.adj_user)?'checked':'',column_percentage:(cust_repAdjustmentList.adj_user___percent)?cust_repAdjustmentList.adj_user___percent:''},

                ],
                cust_repAdjustmentList:cust_repAdjustmentList,



                cust_repExpenses:
            [
            
            {Name: '@lang("layout.ExpenseCategory")', column_name: 'expense_category',checkedColumn:(cust_repExpense.expense_category)?'checked':'',column_percentage:(cust_repExpense.expense_category___percent)?cust_repExpense.expense_category___percent:''},
            {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_repExpense.amount)?'checked':'',column_percentage:(cust_repExpense.amount___percent)?cust_repExpense.amount___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_repExpense.currency)?'checked':'',column_percentage:(cust_repExpense.currency___percent)?cust_repExpense.currency___percent:''},
            {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_repExpense.rate)?'checked':'',column_percentage:(cust_repExpense.rate___percent)?cust_repExpense.rate___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repExpense.date)?'checked':'',column_percentage:(cust_repExpense.date___percent)?cust_repExpense.date___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repExpense.description)?'checked':'',column_percentage:(cust_repExpense.description___percent)?cust_repExpense.description___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user_expense',checkedColumn:(cust_repExpense.user_expense)?'checked':'',column_percentage:(cust_repExpense.user_expense___percent)?cust_repExpense.user_expense___percent:''},

                ],
                cust_repExpense:cust_repExpense,


                
                cust_repItemExpenses:
            [
            {Name: '@lang("layout.PartNumber")', column_name: 'part_number',checkedColumn:(cust_repItemExpense.part_number)?'checked':'',column_percentage:(cust_repItemExpense.part_number___percent)?cust_repItemExpense.part_number___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repItemExpense.description)?'checked':'',column_percentage:(cust_repItemExpense.description___percent)?cust_repItemExpense.description___percent:''},
            {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_repItemExpense.item_name)?'checked':'',column_percentage:(cust_repItemExpense.item_name___percent)?cust_repItemExpense.item_name___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repItemExpense.measure)?'checked':'',column_percentage:(cust_repItemExpense.measure___percent)?cust_repItemExpense.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repItemExpense.quantity)?'checked':'',column_percentage:(cust_repItemExpense.quantity___percent)?cust_repItemExpense.quantity___percent:''},
            {Name: '@lang("layout.ExpenseType")', column_name: 'expense_type',checkedColumn:(cust_repItemExpense.expense_type)?'checked':'',column_percentage:(cust_repItemExpense.expense_type___percent)?cust_repItemExpense.expense_type___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_repItemExpense.currency)?'checked':'',column_percentage:(cust_repItemExpense.currency___percent)?cust_repItemExpense.currency___percent:''},
            {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_repItemExpense.rate)?'checked':'',column_percentage:(cust_repItemExpense.rate___percent)?cust_repItemExpense.rate___percent:''},
            {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_repItemExpense.amount)?'checked':'',column_percentage:(cust_repItemExpense.amount___percent)?cust_repItemExpense.amount___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repItemExpense.date)?'checked':'',column_percentage:(cust_repItemExpense.date___percent)?cust_repItemExpense.date___percent:''},
            {Name: '@lang("layout.FromDate")', column_name: 'from_date',checkedColumn:(cust_repItemExpense.from_date)?'checked':'',column_percentage:(cust_repItemExpense.from_date___percent)?cust_repItemExpense.from_date___percent:''},
            {Name: '@lang("layout.ToDate")', column_name: 'to_date',checkedColumn:(cust_repItemExpense.to_date)?'checked':'',column_percentage:(cust_repItemExpense.to_date___percent)?cust_repItemExpense.to_date___percent:''},
            {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_repItemExpense.category)?'checked':'',column_percentage:(cust_repItemExpense.category___percent)?cust_repItemExpense.category___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repItemExpense.total)?'checked':'',column_percentage:(cust_repItemExpense.total___percent)?cust_repItemExpense.total___percent:''},
            {Name: '@lang("layout.PaletNumber")', column_name: 'plate_number',checkedColumn:(cust_repItemExpense.plate_number)?'checked':'',column_percentage:(cust_repItemExpense.plate_number___percent)?cust_repItemExpense.plate_number___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user_item',checkedColumn:(cust_repItemExpense.user_item)?'checked':'',column_percentage:(cust_repItemExpense.user_item___percent)?cust_repItemExpense.user_item___percent:''},

            ],
            cust_repItemExpense:cust_repItemExpense,



                cust_repItemDailyExpenses:
            [

            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_repItemDailyExpense.number)?'checked':'',column_percentage:(cust_repItemDailyExpense.number___percent)?cust_repItemDailyExpense.number___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repItemDailyExpense.description)?'checked':'',column_percentage:(cust_repItemDailyExpense.description___percent)?cust_repItemDailyExpense.description___percent:''},
            {Name: '@lang("layout.ExpenseAccount")', column_name: 'expense_account',checkedColumn:(cust_repItemDailyExpense.expense_account)?'checked':'',column_percentage:(cust_repItemDailyExpense.expense_account___percent)?cust_repItemDailyExpense.expense_account___percent:''},
            {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_repItemDailyExpense.category)?'checked':'',column_percentage:(cust_repItemDailyExpense.category___percent)?cust_repItemDailyExpense.category___percent:''},
            {Name: '@lang("layout.BankAccount")', column_name: 'bak_account',checkedColumn:(cust_repItemDailyExpense.bak_account)?'checked':'',column_percentage:(cust_repItemDailyExpense.bak_account___percent)?cust_repItemDailyExpense.bak_account___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_repItemDailyExpense.currency)?'checked':'',column_percentage:(cust_repItemDailyExpense.currency___percent)?cust_repItemDailyExpense.currency___percent:''},
            {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_repItemDailyExpense.rate)?'checked':'',column_percentage:(cust_repItemDailyExpense.rate___percent)?cust_repItemDailyExpense.rate___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repItemDailyExpense.date)?'checked':'',column_percentage:(cust_repItemDailyExpense.date___percent)?cust_repItemDailyExpense.date___percent:''},
            {Name: '@lang("layout.OverdueDate")', column_name: 'over_due_date',checkedColumn:(cust_repItemDailyExpense.over_due_date)?'checked':'',column_percentage:(cust_repItemDailyExpense.over_due_date___percent)?cust_repItemDailyExpense.over_due_date___percent:''},
            {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_repItemDailyExpense.hour)?'checked':'',column_percentage:(cust_repItemDailyExpense.hour___percent)?cust_repItemDailyExpense.hour___percent:''},
            {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_repItemDailyExpense.status)?'checked':'',column_percentage:(cust_repItemDailyExpense.status___percent)?cust_repItemDailyExpense.status___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_repItemDailyExpense.user)?'checked':'',column_percentage:(cust_repItemDailyExpense.user___percent)?cust_repItemDailyExpense.user___percent:''},
    
            ],
            cust_repItemDailyExpense:cust_repItemDailyExpense,
                cust_repItemPayrollExpenses:
            [
            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_repItemPayrollExpense.number)?'checked':'',column_percentage:(cust_repItemPayrollExpense.number___percent)?cust_repItemPayrollExpense.number___percent:''},
            {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_repItemPayrollExpense.name)?'checked':'',column_percentage:(cust_repItemPayrollExpense.name___percent)?cust_repItemPayrollExpense.name___percent:''},
            {Name: '@lang("layout.Project")', column_name: 'project',checkedColumn:(cust_repItemPayrollExpense.project)?'checked':'',column_percentage:(cust_repItemPayrollExpense.project___percent)?cust_repItemPayrollExpense.project___percent:''},
            {Name: '@lang("layout.NetPayable")', column_name: 'net_payable',checkedColumn:(cust_repItemPayrollExpense.net_payable)?'checked':'',column_percentage:(cust_repItemPayrollExpense.net_payable___percent)?cust_repItemPayrollExpense.net_payable___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_repItemPayrollExpense.currency)?'checked':'',column_percentage:(cust_repItemPayrollExpense.currency___percent)?cust_repItemPayrollExpense.currency___percent:''},
            {Name: '@lang("layout.FromDate")', column_name: 'from_date',checkedColumn:(cust_repItemPayrollExpense.from_date)?'checked':'',column_percentage:(cust_repItemPayrollExpense.from_date___percent)?cust_repItemPayrollExpense.from_date___percent:''},
            {Name: '@lang("layout.ToDate")', column_name: 'to_date',checkedColumn:(cust_repItemPayrollExpense.to_date)?'checked':'',column_percentage:(cust_repItemPayrollExpense.to_date___percent)?cust_repItemPayrollExpense.to_date___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'desciption',checkedColumn:(cust_repItemPayrollExpense.desciption)?'checked':'',column_percentage:(cust_repItemPayrollExpense.desciption___percent)?cust_repItemPayrollExpense.desciption___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_repItemPayrollExpense.user)?'checked':'',column_percentage:(cust_repItemPayrollExpense.user___percent)?cust_repItemPayrollExpense.user___percent:''},
            ],
            cust_repItemPayrollExpense:cust_repItemPayrollExpense,

            cust_repMemberTransferes:
            [
            
            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_repMemberTransfer.number)?'checked':'',column_percentage:(cust_repMemberTransfer.number___percent)?cust_repMemberTransfer.number___percent:''},
            {Name: '@lang("layout.FromMember")', column_name: 'from_member',checkedColumn:(cust_repMemberTransfer.from_member)?'checked':'',column_percentage:(cust_repMemberTransfer.from_member___percent)?cust_repMemberTransfer.from_member___percent:''},
            {Name: '@lang("layout.ToMember")', column_name: 'to_member',checkedColumn:(cust_repMemberTransfer.to_member)?'checked':'',column_percentage:(cust_repMemberTransfer.to_member___percent)?cust_repMemberTransfer.to_member___percent:''},
            {Name: '@lang("layout.Receivable")', column_name: 'receivable',checkedColumn:(cust_repMemberTransfer.receivable)?'checked':'',column_percentage:(cust_repMemberTransfer.receivable___percent)?cust_repMemberTransfer.receivable___percent:''},
            {Name: '@lang("layout.Payable")', column_name: 'payable',checkedColumn:(cust_repMemberTransfer.payable)?'checked':'',column_percentage:(cust_repMemberTransfer.payable___percent)?cust_repMemberTransfer.payable___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_repMemberTransfer.currency)?'checked':'',column_percentage:(cust_repMemberTransfer.currency___percent)?cust_repMemberTransfer.currency___percent:''},
            {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_repMemberTransfer.rate)?'checked':'',column_percentage:(cust_repMemberTransfer.rate___percent)?cust_repMemberTransfer.rate___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repMemberTransfer.date)?'checked':'',column_percentage:(cust_repMemberTransfer.date___percent)?cust_repMemberTransfer.date___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repMemberTransfer.description)?'checked':'',column_percentage:(cust_repMemberTransfer.description___percent)?cust_repMemberTransfer.description___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user_tansfer',checkedColumn:(cust_repMemberTransfer.user_tansfer)?'checked':'',column_percentage:(cust_repMemberTransfer.user_tansfer___percent)?cust_repMemberTransfer.user_tansfer___percent:''},

            ],
            cust_repMemberTransfer:cust_repMemberTransfer,


            cust_repDepositAndWithdrawals:
            [
            
            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_repDepositAndWithdrawal.number)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.number___percent)?cust_repDepositAndWithdrawal.number___percent:''},
            {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_repDepositAndWithdrawal.reference_number)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.reference_number___percent)?cust_repDepositAndWithdrawal.reference_number___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repDepositAndWithdrawal.date)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.date___percent)?cust_repDepositAndWithdrawal.date___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repDepositAndWithdrawal.description)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.description___percent)?cust_repDepositAndWithdrawal.description___percent:''},
            {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_repDepositAndWithdrawal.member)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.member___percent)?cust_repDepositAndWithdrawal.member___percent:''},
            {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_repDepositAndWithdrawal.account)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.account___percent)?cust_repDepositAndWithdrawal.account___percent:''},
            {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_repDepositAndWithdrawal.amount)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.amount___percent)?cust_repDepositAndWithdrawal.amount___percent:''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_repDepositAndWithdrawal.currency)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.currency___percent)?cust_repDepositAndWithdrawal.currency___percent:''},
            {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_repDepositAndWithdrawal.rate)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.rate___percent)?cust_repDepositAndWithdrawal.rate___percent:''},
            {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_repDepositAndWithdrawal.type)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.type___percent)?cust_repDepositAndWithdrawal.type___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user_withdraw',checkedColumn:(cust_repDepositAndWithdrawal.user_withdraw)?'checked':'',column_percentage:(cust_repDepositAndWithdrawal.user_withdraw___percent)?cust_repDepositAndWithdrawal.user_withdraw___percent:''},

            ],
            cust_repDepositAndWithdrawal:cust_repDepositAndWithdrawal,


            cust_repSaleServices:
            [
            
            {Name: '@lang("layout.SaleNumber")', column_name: 'sale_number',checkedColumn:(cust_repSaleService.sale_number)?'checked':'',column_percentage:(cust_repSaleService.sale_number___percent)?cust_repSaleService.sale_number___percent:''},
            {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_repSaleService.customer)?'checked':'',column_percentage:(cust_repSaleService.customer___percent)?cust_repSaleService.customer___percent:''},
            {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number',checkedColumn:(cust_repSaleService.wagon_number)?'checked':'',column_percentage:(cust_repSaleService.wagon_number___percent)?cust_repSaleService.wagon_number___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repSaleService.date)?'checked':'',column_percentage:(cust_repSaleService.date___percent)?cust_repSaleService.date___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repSaleService.description)?'checked':'',column_percentage:(cust_repSaleService.description___percent)?cust_repSaleService.description___percent:''},
            {Name: '@lang("layout.Service")', column_name: 'service',checkedColumn:(cust_repSaleService.service)?'checked':'',column_percentage:(cust_repSaleService.service___percent)?cust_repSaleService.service___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repSaleService.measure)?'checked':'',column_percentage:(cust_repSaleService.measure___percent)?cust_repSaleService.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repSaleService.quantity)?'checked':'',column_percentage:(cust_repSaleService.quantity___percent)?cust_repSaleService.quantity___percent:''},
            {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_repSaleService.price)?'checked':'',column_percentage:(cust_repSaleService.price___percent)?cust_repSaleService.price___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repSaleService.total)?'checked':'',column_percentage:(cust_repSaleService.total___percent)?cust_repSaleService.total___percent:''},
            {Name: '@lang("layout.User")', column_name: 'usersale_services',checkedColumn:(cust_repSaleService.usersale_services)?'checked':'',column_percentage:(cust_repSaleService.usersale_services___percent)?cust_repSaleService.usersale_services___percent:''},
            ],
            cust_repSaleService:cust_repSaleService,


            cust_repSaless:
            [
            
            {Name: '@lang("layout.SaleNumber")', column_name: 'sale_number',checkedColumn:(cust_repSales.sale_number)?'checked':'',column_percentage:(cust_repSales.sale_number___percent)?cust_repSales.sale_number___percent:''},
            {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_repSales.customer)?'checked':'',column_percentage:(cust_repSales.customer___percent)?cust_repSales.customer___percent:''},
            {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number',checkedColumn:(cust_repSales.wagon_number)?'checked':'',column_percentage:(cust_repSales.wagon_number___percent)?cust_repSales.wagon_number___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repSales.date)?'checked':'',column_percentage:(cust_repSales.date___percent)?cust_repSales.date___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repSales.description)?'checked':'',column_percentage:(cust_repSales.description___percent)?cust_repSales.description___percent:''},
            {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_repSales.item)?'checked':'',column_percentage:(cust_repSales.item___percent)?cust_repSales.item___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repSales.measure)?'checked':'',column_percentage:(cust_repSales.measure___percent)?cust_repSales.measure___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repSales.quantity)?'checked':'',column_percentage:(cust_repSales.quantity___percent)?cust_repSales.quantity___percent:''},
            {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_repSales.price)?'checked':'',column_percentage:(cust_repSales.price___percent)?cust_repSales.price___percent:''},
            {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repSales.total)?'checked':'',column_percentage:(cust_repSales.total___percent)?cust_repSales.total___percent:''},
            {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_repSales.driver)?'checked':'',column_percentage:(cust_repSales.driver___percent)?cust_repSales.driver___percent:''},
            {Name: '@lang("layout.VehicleName")', column_name: 'vehicle_name',checkedColumn:(cust_repSales.vehicle_name)?'checked':'',column_percentage:(cust_repSales.vehicle_name___percent)?cust_repSales.vehicle_name___percent:''},
            {Name: '@lang("layout.User")', column_name: 'users_sale',checkedColumn:(cust_repSales.users_sale)?'checked':'',column_percentage:(cust_repSales.users_sale___percent)?cust_repSales.users_sale___percent:''},
            ],
            cust_repSales:cust_repSales, 
            cust_repProcurememntes:
            [
            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_repProcurememnt.number)?'checked':'',column_percentage:(cust_repProcurememnt.number___percent)?cust_repProcurememnt.number___percent:''},
            {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_repProcurememnt.item_name)?'checked':'',column_percentage:(cust_repProcurememnt.item_name___percent)?cust_repProcurememnt.item_name___percent:''},
            {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_repProcurememnt.account)?'checked':'',column_percentage:(cust_repProcurememnt.account___percent)?cust_repProcurememnt.account___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repProcurememnt.date)?'checked':'',column_percentage:(cust_repProcurememnt.date___percent)?cust_repProcurememnt.date___percent:''},
            {Name: '@lang("layout.Contract")', column_name: 'contract',checkedColumn:(cust_repProcurememnt.contract)?'checked':'',column_percentage:(cust_repProcurememnt.contract___percent)?cust_repProcurememnt.contract___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_repProcurememnt.description)?'checked':'',column_percentage:(cust_repProcurememnt.description___percent)?cust_repProcurememnt.description___percent:''},
            {Name: '@lang("layout.Employee")', column_name: 'employee',checkedColumn:(cust_repProcurememnt.employee)?'checked':'',column_percentage:(cust_repProcurememnt.employee___percent)?cust_repProcurememnt.employee___percent:''},
            {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repProcurememnt.quantity)?'checked':'',column_percentage:(cust_repProcurememnt.quantity___percent)?cust_repProcurememnt.quantity___percent:''},
            {Name: '@lang("layout.TotalAmount")', column_name: 'total_amount',checkedColumn:(cust_repProcurememnt.total_amount)?'checked':'',column_percentage:(cust_repProcurememnt.total_amount___percent)?cust_repProcurememnt.total_amount___percent:''},
            {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_repProcurememnt.user)?'checked':'',column_percentage:(cust_repProcurememnt.user___percent)?cust_repProcurememnt.user___percent:''},
            {Name: '@lang("layout.Inventory")', column_name: 'inventory',checkedColumn:(cust_repProcurememnt.inventory)?'checked':'',column_percentage:(cust_repProcurememnt.inventory___percent)?cust_repProcurememnt.inventory___percent:''},
            {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_repProcurememnt.measure)?'checked':'',column_percentage:(cust_repProcurememnt.measure___percent)?cust_repProcurememnt.measure___percent:''},
            {Name: '@lang("layout.Cost")', column_name: 'cost',checkedColumn:(cust_repProcurememnt.cost)?'checked':'',column_percentage:(cust_repProcurememnt.cost___percent)?cust_repProcurememnt.cost___percent:''},
            ],
            cust_repProcurememnt:cust_repProcurememnt,

            cust_return_expenses:
            [
                {Name: '@lang("layout.Account")', column_name: 'contract_return_expense_account',checkedColumn:(cust_return_expense.contract_return_expense_account)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_account___percent)?cust_return_expense.contract_return_expense_account___percent:''},
                {Name: '@lang("layout.Type")', column_name: 'contract_return_expense_type',checkedColumn:(cust_return_expense.contract_return_expense_type)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_type___percent)?cust_return_expense.contract_return_expense_type___percent:''},
                {Name: '@lang("layout.Description")', column_name: 'contract_return_expense_description',checkedColumn:(cust_return_expense.contract_return_expense_description)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_description___percent)?cust_return_expense.contract_return_expense_description___percent:''},
                {Name: '@lang("layout.Amount")', column_name: 'contract_return_expense_amount',checkedColumn:(cust_return_expense.contract_return_expense_amount)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_amount___percent)?cust_return_expense.contract_return_expense_amount___percent:''},
                {Name: '@lang("layout.Date")', column_name: 'contract_return_expense_date',checkedColumn:(cust_return_expense.contract_return_expense_date)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_date___percent)?cust_return_expense.contract_return_expense_date___percent:''},
                {Name: '@lang("layout.Number")', column_name: 'contract_return_expense_number',checkedColumn:(cust_return_expense.contract_return_expense_number)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_number___percent)?cust_return_expense.contract_return_expense_number___percent:''},
                {Name: '@lang("layout.Vendor")', column_name: 'contract_return_expense_vendor',checkedColumn:(cust_return_expense.contract_return_expense_vendor)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_vendor___percent)?cust_return_expense.contract_return_expense_vendor___percent:''},
                {Name: '@lang("layout.ExpenseAccount")', column_name: 'contract_return_expense_expense_account',checkedColumn:(cust_return_expense.contract_return_expense_expense_account)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_expense_account___percent)?cust_return_expense.contract_return_expense_expense_account___percent:''},
                {Name: '@lang("layout.ReferenceNumber")', column_name: 'contract_return_expense_reference_number',checkedColumn:(cust_return_expense.contract_return_expense_reference_number)?'checked':'',column_percentage:(cust_return_expense.contract_return_expense_reference_number___percent)?cust_return_expense.contract_return_expense_reference_number___percent:''},
                    
                ],
                cust_return_expense:cust_return_expense,

                cust_ngo_projects:
                [
                {Name: '@lang("layout.Date")', column_name: 'contract_ngo_project_date',checkedColumn:(cust_ngo_project.contract_ngo_project_date)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_date___percent)?cust_ngo_project.contract_ngo_project_date___percent:''},
                {Name: '@lang("layout.Description")', column_name: 'contract_ngo_project_description',checkedColumn:(cust_ngo_project.contract_ngo_project_description)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_description___percent)?cust_ngo_project.contract_ngo_project_description___percent:''},
                {Name: '@lang("layout.Item")', column_name: 'contract_ngo_project_item',checkedColumn:(cust_ngo_project.contract_ngo_project_item)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_item___percent)?cust_ngo_project.contract_ngo_project_item___percent:''},
                {Name: '@lang("layout.Measure")', column_name: 'contract_ngo_project_measure',checkedColumn:(cust_ngo_project.contract_ngo_project_measure)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_measure___percent)?cust_ngo_project.contract_ngo_project_measure___percent:''},
                {Name: '@lang("layout.Quantity")', column_name: 'contract_ngo_project_quantity',checkedColumn:(cust_ngo_project.contract_ngo_project_quantity)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_quantity___percent)?cust_ngo_project.contract_ngo_project_quantity___percent:''},
                {Name: '@lang("layout.Price")', column_name: 'contract_ngo_project_price',checkedColumn:(cust_ngo_project.contract_ngo_project_price)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_price___percent)?cust_ngo_project.contract_ngo_project_price___percent:''},
                {Name: '@lang("layout.Member")', column_name: 'contract_ngo_project_member',checkedColumn:(cust_ngo_project.contract_ngo_project_member)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_member___percent)?cust_ngo_project.contract_ngo_project_member___percent:''},
                {Name: '@lang("layout.Currency")', column_name: 'contract_ngo_project_currency',checkedColumn:(cust_ngo_project.contract_ngo_project_currency)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_currency___percent)?cust_ngo_project.contract_ngo_project_currency___percent:''},
                {Name: '@lang("layout.Rate")', column_name: 'contract_ngo_project_rate',checkedColumn:(cust_ngo_project.contract_ngo_project_rate)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_rate___percent)?cust_ngo_project.contract_ngo_project_rate___percent:''},
                {Name: '@lang("layout.Total")', column_name: 'contract_ngo_project_total',checkedColumn:(cust_ngo_project.contract_ngo_project_total)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_total___percent)?cust_ngo_project.contract_ngo_project_total___percent:''},
                {Name: '@lang("layout.User")', column_name: 'contract_ngo_project_user',checkedColumn:(cust_ngo_project.contract_ngo_project_user)?'checked':'',column_percentage:(cust_ngo_project.contract_ngo_project_user___percent)?cust_ngo_project.contract_ngo_project_user___percent:''},      
                ],
                cust_ngo_project:cust_ngo_project,

                transfer_boxes:  
                [
                {Name: '@lang("layout.Number")', column_name: 'contract_transfer_box_number',checkedColumn:(transfer_box.contract_transfer_box_number)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_number___percent)?transfer_box.contract_transfer_box_number___percent:''},
                {Name: '@lang("layout.FromAccount")', column_name: 'contract_transfer_box_from_account',checkedColumn:(transfer_box.contract_transfer_box_from_account)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_from_account___percent)?transfer_box.contract_transfer_box_from_account___percent:''},
                {Name: '@lang("layout.Currency")', column_name: 'contract_transfer_box_currency',checkedColumn:(transfer_box.contract_transfer_box_currency)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_currency___percent)?transfer_box.contract_transfer_box_currency___percent:''},
                {Name: '@lang("layout.FromRate")', column_name: 'contract_transfer_box_from_rate',checkedColumn:(transfer_box.contract_transfer_box_from_rate)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_from_rate___percent)?transfer_box.contract_transfer_box_from_rate___percent:''},
                {Name: '@lang("layout.Amount")', column_name: 'contract_transfer_box_from_amount',checkedColumn:(transfer_box.contract_transfer_box_from_amount)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_from_amount___percent)?transfer_box.contract_transfer_box_from_amount___percent:''},
                {Name: '@lang("layout.ToAccount")', column_name: 'contract_transfer_box_to_account',checkedColumn:(transfer_box.contract_transfer_box_to_account)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_to_account___percent)?transfer_box.contract_transfer_box_to_account___percent:''},
                {Name: '@lang("layout.Currency")', column_name: 'contract_transfer_box_to_currency',checkedColumn:(transfer_box.contract_transfer_box_to_currency)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_to_currency___percent)?transfer_box.contract_transfer_box_to_currency___percent:''},
                {Name: '@lang("layout.ToRate")', column_name: 'contract_transfer_box_to_rate',checkedColumn:(transfer_box.contract_transfer_box_to_rate)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_to_rate___percent)?transfer_box.contract_transfer_box_to_rate___percent:''},
                {Name: '@lang("layout.Amount")', column_name: 'contract_transfer_box_to_amount',checkedColumn:(transfer_box.contract_transfer_box_to_amount)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_to_amount___percent)?transfer_box.contract_transfer_box_to_amount___percent:''},
                {Name: '@lang("layout.BaseCurrency")', column_name: 'contract_transfer_box_to_base_amount',checkedColumn:(transfer_box.contract_transfer_box_to_base_amount)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_to_base_amount___percent)?transfer_box.contract_transfer_box_to_base_amount___percent:''},
                {Name: '@lang("layout.Date")', column_name: 'contract_transfer_box_date',checkedColumn:(transfer_box.contract_transfer_box_date)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_date___percent)?transfer_box.contract_transfer_box_date___percent:''},
                {Name: '@lang("layout.Project")', column_name: 'contract_transfer_box_project',checkedColumn:(transfer_box.contract_transfer_box_project)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_project___percent)?transfer_box.contract_transfer_box_project___percent:''},
                {Name: '@lang("layout.ReferenceName")', column_name: 'contract_transfer_box_reference_name',checkedColumn:(transfer_box.contract_transfer_box_reference_name)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_reference_name___percent)?transfer_box.contract_transfer_box_reference_name___percent:''},
                {Name: '@lang("layout.ReferenceNumber")', column_name: 'contract_transfer_box_reference_number',checkedColumn:(transfer_box.contract_transfer_box_reference_number)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_reference_number___percent)?transfer_box.contract_transfer_box_reference_number___percent:''},
                {Name: '@lang("layout.User")', column_name: 'contract_transfer_box_user',checkedColumn:(transfer_box.contract_transfer_box_user)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_user___percent)?transfer_box.contract_transfer_box_user___percent:''},
                {Name: '@lang("layout.Description")', column_name: 'contract_transfer_box_description',checkedColumn:(transfer_box.contract_transfer_box_description)?'checked':'',column_percentage:(transfer_box.contract_transfer_box_description___percent)?transfer_box.contract_transfer_box_description___percent:''},
                
                ],
                transfer_box:transfer_box,


                receives_contract_index:   
                [ 
                {Name: '@lang("layout.Number")', column_name: 'receivenumber',checkedColumn:(receive_contract.receivenumber)?'checked':'',column_percentage:(receive_contract.receivenumber___percent)?receive_contract.receivenumber___percent:''},
                {Name: '@lang("layout.ReferenceNumber")', column_name: 'receive_reference_number',checkedColumn:(receive_contract.receive_reference_number)?'checked':'',column_percentage:(receive_contract.receive_reference_number___percent)?receive_contract.receive_reference_number___percent:''},
                {Name: '@lang("layout.Type")', column_name: 'receive_type',checkedColumn:(receive_contract.receive_type)?'checked':'',column_percentage:(receive_contract.receive_type___percent)?receive_contract.receive_type___percent:''},
                {Name: '@lang("layout.Description")', column_name: 'receive_description',checkedColumn:(receive_contract.receive_description)?'checked':'',column_percentage:(receive_contract.receive_description___percent)?receive_contract.receive_description___percent:''},
                {Name: '@lang("layout.Date")', column_name: 'receive_date',checkedColumn:(receive_contract.receive_date)?'checked':'',column_percentage:(receive_contract.receive_date___percent)?receive_contract.receive_date___percent:''},
                {Name: '@lang("layout.Hour")', column_name: 'receive_hour',checkedColumn:(receive_contract.receive_hour)?'checked':'',column_percentage:(receive_contract.receive_hour___percent)?receive_contract.receive_hour___percent:''},
                {Name: '@lang("layout.OverdueDate")', column_name: 'receive_overdue_date',checkedColumn:(receive_contract.receive_overdue_date)?'checked':'',column_percentage:(receive_contract.receive_overdue_date___percent)?receive_contract.receive_overdue_date___percent:''},
                {Name: '@lang("layout.Name")', column_name: 'receive_name',checkedColumn:(receive_contract.receive_name)?'checked':'',column_percentage:(receive_contract.receive_name___percent)?receive_contract.receive_name___percent:''},
                {Name: '@lang("layout.MemberClass")', column_name: 'receive_class',checkedColumn:(receive_contract.receive_class)?'checked':'',column_percentage:(receive_contract.receive_class___percent)?receive_contract.receive_class___percent:''},
                {Name: '@lang("layout.Address")', column_name: 'receive_address',checkedColumn:(receive_contract.receive_address)?'checked':'',column_percentage:(receive_contract.receive_address___percent)?receive_contract.receive_address___percent:''},
                {Name: '@lang("layout.Amount")', column_name: 'receive_amount',checkedColumn:(receive_contract.receive_amount)?'checked':'',column_percentage:(receive_contract.receive_amount___percent)?receive_contract.receive_amount___percent:''},
                {Name: '@lang("layout.Currency")', column_name: 'receive_currency',checkedColumn:(receive_contract.receive_currency)?'checked':'',column_percentage:(receive_contract.receive_currency___percent)?receive_contract.receive_currency___percent:''},
                {Name: '@lang("layout.Rate")', column_name: 'receive_rate',checkedColumn:(receive_contract.receive_rate)?'checked':'',column_percentage:(receive_contract.receive_rate___percent)?receive_contract.receive_rate___percent:''},
                {Name: '@lang("layout.ExchangedAmount")', column_name: 'receive_exchanged_amount',checkedColumn:(receive_contract.receive_exchanged_amount)?'checked':'',column_percentage:(receive_contract.receive_exchanged_amount___percent)?receive_contract.receive_exchanged_amount___percent:''},
                {Name: '@lang("layout.Account")', column_name: 'receive_account',checkedColumn:(receive_contract.receive_account)?'checked':'',column_percentage:(receive_contract.receive_account___percent)?receive_contract.receive_account___percent:''},
                {Name: '@lang("layout.Total")', column_name: 'receive_total',checkedColumn:(receive_contract.receive_total)?'checked':'',column_percentage:(receive_contract.receive_total___percent)?receive_contract.receive_total___percent:''},
                {Name: '@lang("layout.User")', column_name: 'receive_user',checkedColumn:(receive_contract.receive_user)?'checked':'',column_percentage:(receive_contract.receive_user___percent)?receive_contract.receive_user___percent:''},
                {Name: '@lang("layout.Contract")', column_name: 'receive_contract',checkedColumn:(receive_contract.receive_contract)?'checked':'',column_percentage:(receive_contract.receive_contract___percent)?receive_contract.receive_contract___percent:''},
                ],
                receive_contract:receive_contract,

                contract_customsExpenseData:
                [
                {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(contract_customsExpense.record)?'checked':'',column_percentage:(contract_customsExpense.record___percent)?contract_customsExpense.record___percent:''},
                {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(contract_customsExpense.number)?'checked':'',column_percentage:(contract_customsExpense.number___percent)?contract_customsExpense.number___percent:''},
                {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(contract_customsExpense.date)?'checked':'',column_percentage:(contract_customsExpense.date___percent)?contract_customsExpense.date___percent:''},
                {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(contract_customsExpense.hour)?'checked':'',column_percentage:(contract_customsExpense.hour___percent)?contract_customsExpense.hour___percent:''},
                {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(contract_customsExpense.member)?'checked':'',column_percentage:(contract_customsExpense.member___percent)?contract_customsExpense.member___percent:''},
                {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(contract_customsExpense.description)?'checked':'',column_percentage:(contract_customsExpense.description___percent)?contract_customsExpense.description___percent:''},
                {Name: '@lang("layout.Vehicle")', column_name: 'vehicle',checkedColumn:(contract_customsExpense.vehicle)?'checked':'',column_percentage:(contract_customsExpense.vehicle___percent)?contract_customsExpense.vehicle___percent:''},
                {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(contract_customsExpense.type)?'checked':'',column_percentage:(contract_customsExpense.type___percent)?contract_customsExpense.type___percent:''},
                {Name: '@lang("layout.CustomsQuantity")', column_name: 'customsQuantity',checkedColumn:(contract_customsExpense.customsQuantity)?'checked':'',column_percentage:(contract_customsExpense.customsQuantity___percent)?contract_customsExpense.customsQuantity___percent:''},
                {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(contract_customsExpense.category)?'checked':'',column_percentage:(contract_customsExpense.category___percent)?contract_customsExpense.category___percent:''},
                {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(contract_customsExpense.currency)?'checked':'',column_percentage:(contract_customsExpense.currency___percent)?contract_customsExpense.currency___percent:''},
                {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(contract_customsExpense.rate)?'checked':'',column_percentage:(contract_customsExpense.rate___percent)?contract_customsExpense.rate___percent:''},
                {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(contract_customsExpense.total)?'checked':'',column_percentage:(contract_customsExpense.total___percent)?contract_customsExpense.total___percent:''},
                    
                {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(contract_customsExpense.account)?'checked':'',column_percentage:(contract_customsExpense.account___percent)?contract_customsExpense.account___percent:''},
                {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(contract_customsExpense.item)?'checked':'',column_percentage:(contract_customsExpense.item___percent)?contract_customsExpense.item___percent:''},
                {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(contract_customsExpense.measure)?'checked':'',column_percentage:(contract_customsExpense.measure___percent)?contract_customsExpense.measure___percent:''},
                {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(contract_customsExpense.quantity)?'checked':'',column_percentage:(contract_customsExpense.quantity___percent)?contract_customsExpense.quantity___percent:''},
                {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(contract_customsExpense.user)?'checked':'',column_percentage:(contract_customsExpense.user___percent)?contract_customsExpense.user___percent:''},
                {Name: '@lang("layout.ExpenseCategory")', column_name: 'cost_category',checkedColumn:(contract_customsExpense.cost_category)?'checked':'',column_percentage:(contract_customsExpense.cost_category___percent)?contract_customsExpense.cost_category___percent:''},
                ],
                contract_customsExpense:contract_customsExpense,
        },
        methods: {
            closeModal: function () {
                this.is_showtwo = !this.is_showtwo;
            }, 
            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                vmtwo.getDate(vmtwo.period);
                    // console.log(12);
                }), 2e2);
            },
            MemberSearch: _.debounce((search, loading) => {
            loading(true);
            
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Driver'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    mvv.driver = [];
                    mvv.driver = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    vmtwo.from_date = null;
                    vmtwo.to_date = null;
                    if (response.data) {
                        vmtwo.from_date = response.data.start;
                        vmtwo.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    vmtwo.period = 'CustomDates';
                    vmtwo.from_date = null;
                    vmtwo.to_date = null;
                    })
                } else {
                    vmtwo.from_date = null;
                    vmtwo.to_date = null;
                }
                }
            },
        }
    });

        var anchor = new Vue({
            el: '#anchore-modaltwo',
            methods: {
                showModaltwo: function () {
                    console.log('trr')
                    vmtwo.$data.is_showtwo = true;
                }
            }
        });
</script>
@endpush