@extends('layouts.factor-master')
<?php 
    $reportTitle =  __('layout.Sale') . __('layout.Service');
?>
@section('content')
    <?php
    $report=customeReport('payments','index');
    ?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.Sale') @lang('layout.Service')</h3>
    <table class="main-table">
    <tr>  
        <td>
            @lang('layout.Contract'):  {{$info->company_name}}
        </td>
    </tr>
    </table>
    @if(count($data) > 0)
        <table class="main-table">
            <thead>
                <tr>
                    <th>@lang('layout.Record')</th>
                    <th>@lang('layout.SaleNumber') </th>
                    <th>@lang('layout.Date') </th>
                    <th>@lang('layout.Description') </th>
                    <th>@lang('layout.Customer') </th>
                    <th>@lang('layout.WagonNumber') </th>
                    <th>@lang('layout.Service') </th>
                    <th>@lang('layout.Measure') </th>
                    <th>@lang('layout.Quantity') </th>
                    <th>@lang('layout.Price') </th> 
                    <th>@lang('layout.Total') </th> 
                    <th>@lang('layout.Currency') </th> 
                    <th>@lang('layout.User') </th> 
                </tr>
            </thead>
            <tbody>
                <?php
                    $count = 0;
                    $total = 0;
                ?>
                @foreach($data AS $record) 
                    <tr>
                        <td class="center">{{++$count}}</td>
                        <td class="center">{{$record->number}}</td>
                        <td class="center">{{convertDate($record->date)}}</td>
                        <td class="center">{{$record->description}}</td>
                        <td class="center">{{$record->customer}}</td>
                        <td class="center">{{$record->wagon_number}}</td>
                        <td class="center">{{$record->name}}</td>
                        <td class="center">{{$record->measure}}</td>
                        <td class="center">{{$record->qty}}</td>
                        <td class="center">{{myRound($record->price_currency)}}</td>
                        <td class="center">{{myRound($record->total_currency)}}</td>
                        <td class="center">{{$record->currency}}</td>
                        <td class="center">{{$record->user}}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection