@extends('layouts.factor-master')
<?php 
    $reportTitle = __('layout.PaymentReport');
?>
@section('content')
    <?php
    $report=customeReport('payments','index');
    ?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.PaymentReport')</h3>
    <table class="main-table">
    <tr>  
        <td>
            @lang('layout.Contract'):  {{$info->company_name}}
        </td>
    </tr>
    </table>
    @if(count($data) > 0)
        <table class="main-table">
            <thead>
                <tr class="bg">
                    <td class="center"><div>@lang('layout.Record')</div></td>
                    <td class="center"><div>@lang('layout.Number')</div></td>
                    <td class="center"><div>@lang('layout.ReferenceNumber')</div></td>
                    <td class="center"><div>@lang('layout.Name')</div></td>
                    <td class="center"><div>@lang('layout.Account')</div></td>
                    <td class="center"><div>@lang('layout.Currency')</div></td>
                    <td class="center"><div>@lang('layout.Rate')</div></td>
                    <td class="center"><div>@lang('layout.Amount')</div></td>
                    <td class="center"><div>@lang('layout.Type')</div></td>
                    @if(systemConfig()[20] != 0 )
                    <td class="center"><div>@lang('layout.Contract')</div></td>
                    @endif
                    <td class="center"><div>@lang('layout.Date')</div></td>
                    <td class="center"><div>@lang('layout.OverdueDate')</div></td>
                    <td class="center"><div>@lang('layout.Hour')</div></td>
                    <td class="center"><div>@lang('layout.User')</div></td>
                    <td class="center"><div>@lang('layout.Description')</div></td>
                </tr>
            </thead>
            <tbody>
                <?php
                    $count = 0;
                    $total = 0;
                ?>
                @foreach($data AS $record) 
                    <?php
                    $total += $record->total;
                    $count = 0;
                    ?>
                    <tr>
                        <td class="center">{{++$count}}</td>
                        <td class="center">{{$record->number}}</td>
                        <td class="center">{{$record->ref_Number}}</td>
                        <td class="center">{{$record->Name}}</td>
                        <td class="center">{{$record->Account}}</td>
                        <td class="center">{{$record->currency}}</td>
                        <td class="center">{{$record->Rate}}</td>
                        <td class="center">{{$record->commAmount}}</td>
                        <td class="center">{{$record->Payment_type}}</td>
                        <td class="center">{{$record->contractname}}</td>
                        <td class="center">{{$record->Date}}</td>
                        <td class="center">{{$record->overdue_date}}</td>
                        <td class="center">{{$record->hour}}</td>
                        <td class="center">{{$record->user}}</td>
                        <td class="center">{{$record->Description}}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection