@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.ContructReport')</h3>
@if($from_date || $to_date || $member_name)
<table class="main-table">
    <tr>
        @if($member_name)<td>@lang('layout.Vendor'): {{ $member_name }}</td>@endif
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
<br>
@endif

<table class="main-table">

    <thead>
        <tr class="bg">

            <!-- <td><div class="center"> #</div></td> -->
            <td class="center"> @lang('layout.Code')</td>
            <td class="center">@lang('layout.Date')</td>
            <td class="center">@lang('layout.Description')</td>
            <td class="center">@lang('layout.ContractName')</td>
            <td class="center">@lang('layout.Bank')</td>
            <td class="center">@lang('layout.Amount')</td>
            <td class="center">@lang('layout.Currency')</td>
            <td class="center">@lang('layout.Rate')</td>
            <td class="center">@lang('layout.Total') {{getHomeCurrency()[getCurrencyType()]}}</td>
            <td class="center"> @lang('layout.Status')</td>
            <td class="center"> @lang('layout.User')</td>

        </tr>
    </thead>
    <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
    @foreach($data AS $record)
    <tr>
        <?php

            $total_home_currency += $record->Amount / $record->Rate;
            if($record->Currency)
            {

                if (array_key_exists($record->Currency, $currencies)) {
                    $currencies[$record->Currency] = $currencies[$record->Currency] + $record->Amount;
                } else {
    
                    $currencies[$record->Currency] = $record->Amount;
                }
            }
            ?>
    <tr>
        <!-- <td class="center">{{++$count}}</td> -->
        <td class="center">{{$record->Contract_Code}}</td>
        <td class="center">{{convertDate($record->Date)}}</td>
        <td class="center">{{$record->description}}</td>
        <td class="center">{{$record->Contract_Name}}</td>

        <td class="center">{{$record->Account}}</td>
        <td class="center">{{myRound($record->Amount)}}</td>
        <td class="center">{{$record->Currency}}</td>
        <td class="center">{{$record->Rate}}</td>
        <td class="center">{{myRound($record->totalInDollar)}}</td>
        <td class="center">
            @if($record->status == "Active")
            {{__('layout.Active')}}
            @else
            {{__('layout.Closed')}}
            @endif
        </td>
        <td class="center">{{$record->user}}</td>
    </tr>
    @endforeach

</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="3">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> @lang('layout.Record') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
        $count = 0;
        foreach($currencies As $key=>$currency )
        {
        ?>
    <tr>
        <td>
            <div class="center">{{++$count}}</div>
        </td>
        <td>
            <div class="center">{{$key}}</div>
        </td>
        <td>
            <div class="center">{{myRound($currency)}}</div>
        </td>

    </tr>
    <?php
        }
        ?>
    <tr>
        <td colspan="2">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td>
            <div class="center">{{myRound($total_home_currency)}}   {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>

    </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->


@endsection