@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 60% !important;
    }
</style>
@endsection
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
        :value-type="'contract'"
        @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                    ----Begin Report Body And Custome Report-------
                    ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['EmployeeRewards-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">            
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.ContractNumber') </label>
                                                    <input type="number" name="number" class="form-control">
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.SelectMember') </label>
                                                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                                                    </v-select>
                                                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.Details') </label>
                                                   <select name="details" id="" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="details"> @lang('layout.Details') </option>
                                                   </select>
                                                </div>

                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.Date')</label>
                                                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                        <option value="CustomDates">@lang('type.CustomDates')</option>
                                                        <option value="Today">@lang('type.Today')</option>
                                                        <option value="Yesterday">@lang('type.Yesterday')</option>
                                                        <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                        <option value="LastWeek">@lang('type.LastWeek')</option>
                                                        <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                        <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                        <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                        <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                        <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                        <option value="ThisYear">@lang('type.ThisYear')</option>
                                                        <option value="YearToDate">@lang('type.YearToDate')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-12" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                                                                     
    
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
    
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="contract_index">
    
                                          
                                            <div class="col-md-12 col-sm-12 col-xs-12">
    
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
    
                                                    <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
    
    
                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                    </div>
                                                </div>
                                            </div>
                                         
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
    
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                        class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
    
                        </div>
                    </div>
                </div>
    
    
            </div>
        </report-modal>
    </div>
    
    
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ContractList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('contract-export')

                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                </span>

                    @endpermission
                    @permission('contract-create')
                    <a href="{{route('contract.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="contracts">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Code')</th>
                        <th>@lang('layout.ContractName')</th>
                        <th>@lang('layout.Vendor')</th>
                        <th>@lang('layout.Bank')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Total')
                            <span>{{getHomeCurrency()['code']}}</span>
                        </th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;
        var cust_rep = {!!customeReportNewData('contract_index')!!};

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#contracts').DataTable({
                ajax: '{{route("contract.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:8}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'contracts.id', searchable: false},
                    {data: 'Contract_Code', name: 'contracts.contract_no'},
                    {data: 'Contract_Name', name: 'contracts.company_name'},
                    {data: 'Customer', name: 'members.name'},
                    {data: 'Account', name: 'accounts.name'},
                    {data: 'Amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'Currency', name: 'contracts.currency'},
                    {data: 'Rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'totalInDollar', name: 'totalInDollar', orderable: false, searchable: false},
                    {data: 'Date', name: 'date', searchable: false},
                    {data: 'Status', name: 'contracts.status'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ]
            });
        });
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                member:[],
                customReportData:
                [
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.ContractName")', column_name: 'contract_name',checkedColumn:(cust_rep.contract_name)?'checked':'',column_percentage:(cust_rep.contract_name___percent)?cust_rep.contract_name___percent:''},
                 {Name: '@lang("layout.Vendor")', column_name: 'vendor',checkedColumn:(cust_rep.vendor)?'checked':'',column_percentage:(cust_rep.vendor___percent)?cust_rep.vendor___percent:''},
                 {Name: '@lang("layout.Bank")', column_name: 'bank',checkedColumn:(cust_rep.bank)?'checked':'',column_percentage:(cust_rep.bank___percent)?cust_rep.bank___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
                 {Name: '@lang("layout.Percentage")', column_name: 'percentage',checkedColumn:(cust_rep.percentage)?'checked':'',column_percentage:(cust_rep.percentage___percent)?cust_rep.percentage___percent:''},
                 {Name: '@lang("layout.PerPercentPrice")', column_name: 'per_percent_price',checkedColumn:(cust_rep.per_percent_price)?'checked':'',column_percentage:(cust_rep.per_percent_price___percent)?cust_rep.per_percent_price___percent:''},
                 
                 {Name: '@lang("layout.TotalQuantity")', column_name: 'total_quantity',checkedColumn:(cust_rep.total_quantity)?'checked':'',column_percentage:(cust_rep.total_quantity___percent)?cust_rep.total_quantity___percent:''},
                 {Name: '@lang("layout.ReceivedQuantity")', column_name: 'received_quantity',checkedColumn:(cust_rep.received_quantity)?'checked':'',column_percentage:(cust_rep.received_quantity___percent)?cust_rep.received_quantity___percent:''},
                 {Name: '@lang("layout.ReminedQuantity")', column_name: 'remined_quantity',checkedColumn:(cust_rep.remined_quantity)?'checked':'',column_percentage:(cust_rep.remined_quantity___percent)?cust_rep.remined_quantity___percent:''},
                 {Name: '@lang("layout.ContractAmount")', column_name: 'contract_amount',checkedColumn:(cust_rep.contract_amount)?'checked':'',column_percentage:(cust_rep.contract_amount___percent)?cust_rep.contract_amount___percent:''},
                 {Name: '@lang("layout.PaydAmount")', column_name: 'payd_amount',checkedColumn:(cust_rep.payd_amount)?'checked':'',column_percentage:(cust_rep.payd_amount___percent)?cust_rep.payd_amount___percent:''},
                 {Name: '@lang("layout.TotalAmount")', column_name: 'total_amount',checkedColumn:(cust_rep.total_amount)?'checked':'',column_percentage:(cust_rep.total_amount___percent)?cust_rep.total_amount___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total1',checkedColumn:(cust_rep.total1)?'checked':'',column_percentage:(cust_rep.total1___percent)?cust_rep.total1___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                        

                  ],
                  cust_rep:cust_rep

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.member = [];
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime())
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // register modal component

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush
