@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
    <style>
    </style>
@stop
@section('content')
    @include("layouts.Cmodal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateContract') </span>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($contract,['method' => 'PATCH','route' => ['contract.update',$contract->id],'files'=> true,'id'=>'contract-form'])!!}
                {{ csrf_field() }} 
                <div class="form-body">
                    <div class="row" style="margin-bottom: 0px; padding: 10px;">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 50px;">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.ContractName')</label>
                                    {{Form::text('company_name',null,['class' => 'form-control','placeholder' => __('layout.ContractName'),'v-validate'=>'"required"','data-vv-as'=>__('layout.ContractName')])}}
                                    <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.ContractCode')</label>
                                    {{Form::text('contract_no',null,['class' => 'form-control'])}}
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <div class="input-group">
                                        <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                                        </v-select>
                                        <input type="hidden" name="member_id"
                                               v-model.number="(!selectedMember)?null:selectedMember.id"
                                               v-validate="'required'" data-vv-as="@lang('layout.SelectMember')">
                                        <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                    </div>

                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input class="form-control date" id="range-from-example" name="date"
                                           value="{{$contract->Date}}" autocomplete="off">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.StartDate')</label>
                                    <input type="text" class="form-control date" autocomplete="off" value="{{$contract->start_date}}" name="start_date">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="currency"
                                              v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" v-validate="'required'"
                                           data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                    <span class="required">@{{ errors.first('currency') }}</span>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Rate')</label>

                                    <input type="number" name="currency_rate" v-validate="'required'"
                                           data-vv-as="@lang('layout.Rate')"
                                           v-model="!selected_currency?0:selected_currency.rate" class="form-control"
                                           :class="{'has-error':rate<=0}">
                                    <span class="required">@{{ errors.first('currency_rate') }}</span>

                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <v-select label="name" :options="approperiateBank" v-model="selected_banks"></v-select>
                                    <input type="hidden" name="account_id" :value="(this.selected_banks==null)?null:selected_banks.id">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    {{Form::number('amount',null,['class' => 'form-control','v-validate'=>"''",'data-vv-as'=>__('layout.Amount')])}}
                                    <span class="required">@{{ errors.first('amount') }}</span>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.EndDate')</label>
                                    <input type="text" class="form-control date" name="end_date" value="{{$contract->end_date}}" autocomplete="off">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('menu.PlattsCategory')</label>
                                    <v-select label="name" v-model="selectedPlattsCategory" :options="plattsCategory" placeholder="@lang('layout.Select')"></v-select>
                                    <input type="hidden" name="platts_category_id" :value="(!selectedPlattsCategory)?null:selectedPlattsCategory.id">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Amount') @lang('layout.Differ') + -</label>
                                    <div class="input-group" style="width: 100%;">
                                        {{Form::number('pos_neg_amount',null,['class' => 'form-control','v-validate'=>"''",'data-vv-as'=>__('layout.Amount')])}}
                                        <span class="input-group-addon" style="padding: 0px 0px;" >&nbsp;</span>
                                        <select name="pos_neg_type" v-model="pos_neg_type" class="form-control input-group-addon"  style="background-color: #d4fbff">
                                            <option value="null">@lang('layout.Select') + -</option> 
                                            <option value="positive">@lang('layout.PositiveAmount') + </option>
                                            <option value="negative">@lang('layout.NegativeAmount') - </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.BourseDate')</label>
                                    <input type="text" class="form-control date" name="bourse_date" value="{{$contract->bourse_date}}" autocomplete="off">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="">
                                        <label class="control-label">@lang('layout.Memo')</label>
                                        <textarea name="memo" class="form-control" rows="1">{{$contract->memo}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="row">
                                {{-- <div class="col-md-3">
                                    <label class="control-label">@lang('layout.MainShareholder')</label>
                                    <v-select label="name" v-model="selected_owner" :options="owner"
                                              placeholder="@lang('layout.Select')"></v-select>
                                    <input type="hidden" name="owner_id"
                                           :value="(!selected_owner)?null:selected_owner.id">
                                </div> --}}
                            </div>
                            <div class="row">
                                @if(getmine() == 'true')
                                {{-- <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Percentage') %</label>
                                    {!! Form::number('all_percentage', null, array('placeholder' => __('layout.Percentage'),'class' => 'form-control')) !!}
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.PerPercentPrice')</label>
                                    {!! Form::number('per_percent_price', null, array('placeholder' => __('layout.PerPercentPrice'),'class' => 'form-control')) !!}
                                </div> --}}
                                @endif
                            </div>
                            <div class="row">
                            </div>
                        </div>


                    </div>

                    <!-- begin item -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;padding: 20px 10px;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center">#</th>
                                <th class="text-center" v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                <th class="text-center" style="min-width: 130px">@lang('layout.ItemName') </th>
                                <!-- <th style="min-width: 100px">@lang('layout.SiteName') </th> -->
                                <th class="text-center" v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th class="text-center" v-show="showWhat('expire_date')=='yes'" style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                <th class="text-center" style="min-width: 100px">@lang('layout.Quantity') </th>
                                <!-- <th style="min-width: 100px">@lang('layout.OnHand') </th> -->
                                <th class="text-center" v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue') </th>

                                <th class="text-center" style="min-width: 100px">@lang('layout.Measure') </th>
                                <th class="text-center" style="min-width: 100px">@lang('layout.NewCost') </th>
                                @if(getmine() == 'true')
                                <th class="text-center" style="min-width: 100px">@lang('layout.SalePrice') </th>
                                @endif
                                <th class="text-center" v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                <th class="text-center" style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td class="text-center">@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" @Click.native="setIndex(index)" v-model="item.item"
                                              :options="temp_items" @search="onItemSearch"></v-select>
                                    <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.ItemName')"
                                           :value="(!item.item)?null:item.item.id">
                                    <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                </td>
                            <!--   <td class="highlight">
                                      <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                         <option value="null">@lang('layout.Select')</option>
                                         <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                      </select>
                                        <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                  </td> -->
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input class="form-control purchase_description" type="text"
                                           placeholder="@lang('layout.Description')" name="inventory_description[]" >
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
                                    <input type="text" placeholder="@lang('layout.ExpireDate')" name="expire_date[]"
                                           class="date form-control">
                                </td>
                                <td>


                                    <input type="number" :name="'quantity['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.Quantity')"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                    <span class="required">@{{ errors.first('quantity['+index+']') }}</span>
                                </td>

                                <!--  <td>
                                    @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                 </td> -->
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)"
                                               ref="in" @input="setNewRate(index)" class="form-control">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                </td>
                                @if(getmine() == 'true')
                                <td>
                                    <input type="number" name="sale_price[]" v-model.number="(item.item==null)?null:item.sale_price" class="form-control input-style input-number" placeholder="@lang('layout.SalePrice')">
                                </td>
                                @endif
                                <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               class="form-control">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                        @{{selected_currency.symbol}}
                                      </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                        %
                                      </span>
                                    </div>

                                </td>

                                <td>
                                    <div>
                                        <div class="input-group">
                                            <input type="number" class="form-control inner_input"
                                                   :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate,discountIsAmount,item.item.discount, null, null, null, selected_currency.static_rate)"
                                                   placeholder="@lang('layout.Total')" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash text-danger" style="vertical-align: middle;text-align: center;cursor: pointer;"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                {{-- <td></td> --}}
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>

                    </div>
                    <span v-if="inventories.length==0">
                         <button type="button" @click="addNew('inventory',0)" class="btn btn-success"><i
                                     class="fa fa-plus"></i></button>
                      </span>

                    <!-- end item -->

                    <!-- begin shareholder -->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                        <tr>
                            <th class="text-center" style="min-width: 8px;"> #</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.Shareholder')</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>
                            <th></th>

                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(record,index) in shareholderData">
                            <td class="text-center">@{{index+1}}</td>
                            <td class="highlight">
                                <v-select label="name" v-model="record.selected" :options="(record.shareholder_list)"
                                          @click.native="addNew('shareholder',index)"
                                          placeholder="@lang('layout.Select')">

                                </v-select>
                                <input type="hidden" name="shareholder_id[]"
                                       :value="(record.selected==null)?null:record.selected.id">
                            </td>

                            <td>
                                <input class="form-control" type="number" name="percentage[]"
                                       v-model.number="record.percentage" placeholder="@lang('layout.Percentage')">
                            </td>

                            <td class="text-center">
                                <span v-on:click="deleteItem('shareholder',index)"><i
                                            class="paddint-both glyphicon glyphicon-trash text-danger" style="cursor: pointer;"></i></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <!-- end shareholder -->

                    <!-- Begin Loading Date -->
                    @if(getContractLoadingDate()=="true")
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th style="background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.LoadingDate')</th>
                            </tr>
                            <tr>
                                <th class="text-center" style="min-width: 8px;background-color: rgb(84, 199, 211);color: #ffffff;" class="installment"> #</th>
                                <th class="text-center" style="min-width: 80px;background-color: rgb(84, 199, 211);color: #ffffff;"> @lang('layout.Number')</th>
                                <th class="text-center" style="min-width: 80px;background-color: rgb(84, 199, 211);color: #ffffff;"> @lang('layout.LoadingDate')</th>
                                <th class="text-center" style="min-width: 120px;background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.Description')</th>
                                <th style="background-color: rgb(84, 199, 211);color: #ffffff;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(item,index) in loading_dates">
                                <td>@{{index+1}}</td>
                                <td>
                                    <input type="number" class="form-control" name="loading_date_number[]" @click="addNew('loading_date','index')" v-model="(item==null)?null:item.number">
                                </td>
                                <td>
                                    <date_picker :name="'loading_date['+index+']'" v-model="(item==null)?null:item.date"></date_picker>
                                </td>
                                <td class="highlight">
                                    <textarea  :name="'loading_date_description['+index+']'" v-model="(item==null)?null:item.description" class="form-control"  @keyup="addNew('loading_date',index)" v-on:click="addNew('loading_date',index)" ></textarea>
                                </td>
                                <td v-if="loading_dates.length>1">
                                    <span v-on:click="deleteItem('loading_date',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: rgb(255, 255, 255);">
                                <td>
                                    <center>
                                        <button type="button" class="btn btn-success" @click="addNew('loading_date','index')">
                                            <i class="fa fa-plus" ></i>
                                        </button>
                                    </center>
                                </td> 
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                    @endif
                    <!-- End Loading Date -->


                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                <!--   <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> -->

                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>

                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>

                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        Vue.component('v-select', VueSelect.VueSelect);
                //begin new member
                Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    classes: [],
                    selectedClass: null,
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selectedMember = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var banks = {!! $banks!!}
        
        var currency = {!! $currency!!}
        var shareholder ={!! $shareholder!!};
        var owner ={!! $owner!!};
        var inventory_category = {!! $inventory_category !!};
        var contract = {!! $contract !!};
        var contractShareholder ={!! $contractShareholder!!};
        var selectedLoadingDate ={!! $selectedLoadingDate!!};
        let plattsCategory = {!! $plattsCategory !!};

        var v = new Vue({
            el: '#app',
            data: {
                contract: contract,
                currency: currency,
                selected_currency: {!!json_encode(getHomeCurrency()) !!},
                plattsCategory: plattsCategory,
                selectedPlattsCategory: null,
                listAccounts: [],
                member: [],
                selectedMember:{!! $selectedVendor !!},
                selected_item:{!! $selectedItem !!},
                type: 'bank',
                banks: banks,
                selected_banks: null,
                shareholder: shareholder,
                contractShareholder: contractShareholder,
                owner: owner,
                selected_owner: null,
                pos_neg_type: null,
                shareholderData: [],
                rate: 0,
                temp_items: [],
                inventory_category: inventory_category,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,
                inventories: [],
                discountFiled: 0,
                discountIsAmount: true,
                selectedLoadingDate:selectedLoadingDate,
                loading_dates:[],
                showModal:false
            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    return this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },


                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }


                        }
                        // this.totalAmountes=sum;

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    return sum;
                },


                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                this.selected_owner = _.find(this.owner, (o) => o.id == this.contract.owner_id);

                for (var i = 0; i < this.contractShareholder.length; i++) {
                    var percent = this.contractShareholder[i].percentage;
                    var s = _.find(this.shareholder, (o) => o.id == this.contractShareholder[i].shareholder_id);
                    this.shareholderData.push({percentage: percent, shareholder_list: this.shareholder, selected: s});
                }
                for (var m = 2; m > this.contractShareholder.length; m--) {
                    this.shareholderData.push({percentage: 0, shareholder_list: this.shareholder, selected: null});
                }

				if(contract.currency != null){
					this.selected_currency = _.find(currency, (c) => c.code == contract.currency);
				} else if(contract.unit != null){
					this.selected_currency = _.find(currency, (c) => c.code == contract.unit);
				}
                this.selected_currency.rate = contract.rate;

                if(contract.platts_category_id != null){
					this.selectedPlattsCategory = _.find(plattsCategory, (c) => c.id == contract.platts_category_id);
				}

                this.pos_neg_type = contract.pos_neg_type;
                // initialize the selected item
                // initialize the selected item
                for (var i = 0; i < this.selected_item.length; i++) {
                    console.log('item', this.selected_item);
                    this.inventories.push({
                        item: this.selected_item[i],
                        item_category: this.selected_item[i].item_category, 
                        sale_price:this.selected_item[i].sale_price
                    });
                }
                for (var m = 1; m > this.selected_item.length; m--) {
                    this.inventories.push({item: null, item_category: this.selected_iventory_category, sale_price:null});
                }

                // initialize payments

                for (var j = 0; j < this.banks.length; j++) {
                    if (this.banks[j].id == this.contract.account_id) {
                        this.selected_banks = this.banks[j];
                    }
                }

                // end payment

                for (var i = 0; i < this.selectedLoadingDate.length; i++) {
                        this.loading_dates.push({
                            date:this.selectedLoadingDate[i].date,
                            description:this.selectedLoadingDate[i].description,
                            number:this.selectedLoadingDate[i].number
                        });


                }
                for (var w = 1; w > this.selectedInstallment.length; w--) {
                    this.loading_dates.push({
                        date:null,
                        description:null,
                        number:null
                    });
                } 


            },
            methods:
                {

                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // set new price
                    setNewRate(index) {

                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            @endif
                        }
                    },
                    // begin item search

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Vendor'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.member = [];
                                v.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: "itemSearchPurchase",
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {

                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {

                            let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchPurchase',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }

                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: this.selected_iventory_category, sale_price:null});
                                }
                            }
                            if (type == 'shareholder') {

                                if (this.shareholderData[index + 1] == undefined) {
                                    //this.temp_items=[];
                                    this.shareholderData.push({
                                        percentage: 0,
                                        shareholder_list: this.shareholder,
                                        selected: null
                                    });
                                }
                            }
                            if (type == 'loading_date') {
                                if (this.loading_dates[index + 1] == undefined) {
                                    this.loading_dates.push({
                                        loading_date:null,
                                        loading_date_description:null,
                                        loading_date_number:null
                                    });
                                }
                            }
                        }

                    },


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'shareholder') {
                                this.shareholderData.splice(index, 1);
                            }
                            if(type == 'loading_date'){
                                this.loading_dates.splice(index,1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {


                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("contract-form").submit()

                            }
                            else {

                            }
                        });

                    },

                    defaultValue() {

                        this.inventories = [
                            {item: null, item_category: this.selected_iventory_category},
                        ];


                        this.discountFiled = 0;
                        this.temp_items = [];
                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    var url = "{{route('contract.store')}}";
                                    form_id = 'purchase-form';
                                    var data = $('#' + form_id).serialize();

                                    axios.post(url, data)
                                        .then(function (response) {

                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                //$('#success-sound')[0].play();
                                                toastr.success('', response.data.message);

                                                v.defaultValue();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush