@extends('layouts.factor-master')

@section('content')
 
<h3 class="table-caption" style="text-align: center;">@lang('layout.DaylyexpenseReport')</h3>


@if($info && $info !=[])
<table  class="main-table">
   
    <tr>
     <td>
       <span>@lang('layout.Number')</span> :
       <span>{{$info->contract_no}}</span>
     </td>
     <td>
       <span>@lang('menu.Contract')</span> :
       <span>{{$info->company_name}}</span>
     </td>
     
   </tr>
</table>
<br>
@endif

 <table class="main-table">
      <thead>
      <tr class="bg"> 
        <th>@lang('layout.Record')</th>
        <th>@lang('layout.Number')</th>
        <th>@lang('layout.Description')</th>
        <th>@lang('layout.ExpenseAccount')</th>
        <th>@lang('layout.Category')</th>
        <th>@lang('layout.BankAccount')</th>
        <th>@lang('layout.Amount')</th>
        <th>@lang('layout.Currency')</th>
        <th>@lang('layout.Rate')</th>
        <th>@lang('layout.Date')</th>
        <th>@lang('layout.OverdueDate')</th>
        <th>@lang('layout.Hour')</th>
        @if(systemConfig()[5] != 0 )
        <th>@lang('layout.Status')</th>
        @endif
        <th>@lang('layout.User')</th>    
    </tr>
</thead>
<?php
      $count = 0;
      ?>
    @foreach($data AS $record)
    <tr>
        <td  class="center">{{++$count}}</td>
        <td class="center">{{$record->number}}</td>
        <td class="center">{{$record->description}}</td>
        <td class="center">{{$record->expense_account}}</td>
        <td  class="center">{{$record->Name}}</td>
        <td class="center">{{$record->Bank}}</td>
        <td class="center">{{$record->amount}}</td>
        <td class="center">{{$record->Currency}}</td>
        <td class="center">{{myRound($record->Rate)}}</td>
        <td  class="center">{{convertDate($record->Date)}}</td>
        <td class="center">{{convertDate($record->overdue_date)}}</td>
        <td class="center">{{(date_format(date_create($record->hour), 'H:i'))}}</td>
        @if(systemConfig()[5] != 0 )
        <td class="center"> {{__('type.'.$record->status)}}</td>
        @endif
       <td class="center">{{$record->username}}</td>
    </tr>
    @endforeach
</table>

  <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection
