@extends('layouts.factor-master')

@section('content')



    <h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseDetails')</h3>
    <table style="width: 100%; margin-bottom: 10px;">
        @if($info && $info !=[])

            <tr>
                <td>
                    <span>@lang('layout.ContractNumber')</span>:
                    <span>{{$info->contract_no}}</span>
                </td>
                <td>
                    <span>@lang('layout.MemberName')</span>:
                    <span>{{$info->name}}</span>
                </td>
                <td>
                    <span>@lang('layout.ContractName')</span>:
                    <span>{{$info->company_name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Amount')</span>:
                    <span>{{$info->amount}}</span>
                </td>
                <td>
                    <span>@lang('layout.Differ')</span>:
                    <span> {{ $info->pos_neg_amount}} @if($info->pos_neg_type == 'positive') + @endif @if($info->pos_neg_type == 'negative') - @endif</span>
                </td>
                <td>
                    <span>@lang('layout.Description')</span>:
                    <span>{{$info->description}}</span>
                </td>
            </tr>

        @endif

    </table>


    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Number')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.BourseDate')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Description')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.ItemName')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.SiteName')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Contract') @lang('layout.Rate')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Cost')</div>
            </td>
            {{-- <td>
                <div class="center"> @lang('layout.Contract') @lang('layout.Differ')</div>
            </td> --}}
            <td>
                <div class="center"> @lang('layout.Differ')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.TotalPurchaseCost')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>

        </tr>
        </thead>
        <?php
        $count = 0;
        $total_cost = 0;
        $differ = 0;

        // dd($data);
        ?>
        @foreach($data AS $record)
            <?php
            $total_cost += $record->total_base;
            $differ += (($record->base_contract_differ) * $record->qut_in);
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{convertDate($record->Date)}}</td>
                <td class="center">{{convertDate($record->bourse_date)}}</td>
                <td class="center">{{$record->description}}</td>
                <td class="center">{{$record->Item}}</td>
                <td class="center">{{$record->siteName}}</td>
                <td class="center">{{$record->Measure}}</td>
                <td class="center">{{$record->qut_in}}</td>
                <td class="center">{{$record->currency}}</td>
                <td class="center">{{myRound($record->contract_cost)}}</td>
                <td class="center">{{myRound($record->cost - $record->contract_differ)}}</td>
                <td class="center">{{myRound($record->contract_differ)}}</td>
                <td class="center">{{myRound($record->cost)}}</td>
                {{-- <td class="center">{{myRound($record->cost - $record->contract_cost)}}</td> --}}
                <td class="center">{{myRound($record->total)}}</td>
            </tr>
        @endforeach
    </table>

    <table class="main-table">
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Total') @lang('layout.Cost')</div>
            </td>
            <td>
                <div class="center"> {{myRound($total_cost)}} {{getHomeCurrency()["code"]}}</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total') @lang('layout.Differ')</div>
            </td>
            <td>
            <div class="center" style="font-size:27px; color: {{($differ>0)? 'red;' : 'green;'}}"> {{myRound($differ)}} {{getHomeCurrency()["code"]}}</div>
            </td>
        </tr>
    </table>

@endsection