@extends('layouts.factor-master')

@section('content')
 
<h3 class="table-caption" style="text-align: center;">@lang('menu.Payroll')</h3>


@if($info && $info !=[])
<table  class="main-table">
   
    <tr>
     <td>
       <span>@lang('layout.Number')</span> :
       <span>{{$info->contract_no}}</span>
     </td>
     <td>
       <span>@lang('menu.Contract')</span> :
       <span>{{$info->company_name}}</span>
     </td>
     
   </tr>
</table>
<br>
@endif

 <table class="main-table">
      <thead>
      <tr class="bg"> 
    <th>@lang('layout.Record')</th>
      <th> @lang('layout.FromDate')</th>
     <th> @lang('layout.ToDate')</th>
    <th> @lang('layout.Name') </th>
      <th> @lang('layout.BasicSalary')</th>
      <th> @lang('layout.Tax')</th>
      <th> @lang('layout.NetPayable')</th>
     <th> @lang('layout.Currency')</th>
    <th> @lang('layout.Description')</th> 
    <th> @lang('layout.User')</th>
    </tr>
  </thead>
    <?php

    $count = 0;
     $total_home_currency=0;
     $currencies=[];
    ?>
    @foreach($data AS $record)
      <?php
  $total_home_currency+=$record->exchanged_amount;

  if(array_key_exists($record->Currency, $currencies))
  {

    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;

  }
  ?>

    <tr>
     <td  class="center">{{++$count}}</td>
    <td  class="center">{{convertDate($record->From_Date)}}</td>
     <td  class="center">{{convertDate($record->To_Date)}}</td>
     <td class="center">{{$record->Employee}}</td>
    <td  class="center">{{$record->BasicSalary}} <span>{{$record->SalaryCurrency}}</span></td>
    <td  class="center">{{myRound($record->tax_amount)}} {{$record->tax_currency}}</td>
    <td  class="center">{{myRound($record->Amount)}}</td>
    <td  class="center">{{$record->Currency}}</td>
    <td  class="center">{{$record->description}}</td>
    <td  class="center">{{$record->user}}</td>
    </tr>
    @endforeach
</table>



<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()["code"]}}</div></td>

</tr>
</table>
  <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection
