@extends('layouts.factor-master')
@section('content')
<?php
  $report = customeReportNew('contract_loading_index');
    $_driver= !in_array('driver', $report);
    $_plate_number= !in_array('plate_number', $report);
    $_source_place= !in_array('source_place', $report);
    $_destination= !in_array('destination', $report);
    $_loading_date= !in_array('loading_date', $report);
    $_discharge_date= !in_array('discharge_date', $report);
    $_discharge= !in_array('discharge', $report);
    $_item_name= !in_array('item_name', $report);
    $_site= !in_array('site', $report);
    $_measure= !in_array('measure', $report);
    $_load_quantity= !in_array('load_quantity', $report);
    $_discharge_quantity= !in_array('discharge_quantity', $report);
    $_differ= !in_array('differ', $report);
    $_over_load= !in_array('over_load', $report);
    $_load_drop= !in_array('load_drop', $report);
    $_fined_amount= !in_array('fined_amount', $report);
    $_total_transfer_fee= !in_array('total_transfer_fee', $report);
    $_total_loading = !in_array('total_loading', $report);
 
  $report_percent = customeReportNewPercent('contract_loading_index');
    $_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
    $_plate_number_percent= (array_key_exists('plate_number___percent', $report_percent))?$report_percent['plate_number___percent']:null;
    $_source_place_percent= (array_key_exists('source_place___percent', $report_percent))?$report_percent['source_place___percent']:null;
    $_destination_percent= (array_key_exists('destination___percent', $report_percent))?$report_percent['destination___percent']:null;
    $_loading_date_percent= (array_key_exists('loading_date___percent', $report_percent))?$report_percent['loading_date___percent']:null;
    $_discharge_date_percent= (array_key_exists('discharge_date___percent', $report_percent))?$report_percent['discharge_date___percent']:null;
    $_discharge_percent= (array_key_exists('discharge___percent', $report_percent))?$report_percent['discharge___percent']:null;
    $_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null;
    $_site_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null;
    $_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
    $_load_quantity_percent= (array_key_exists('load_quantity___percent', $report_percent))?$report_percent['load_quantity___percent']:null;
    $_discharge_quantity_percent= (array_key_exists('discharge_quantity___percent', $report_percent))?$report_percent['discharge_quantity___percent']:null;
    $_differ_percent= (array_key_exists('differ___percent', $report_percent))?$report_percent['differ___percent']:null;
    $_over_load_percent= (array_key_exists('over_load___percent', $report_percent))?$report_percent['over_load___percent']:null;
    $_load_drop_percent= (array_key_exists('load_drop___percent', $report_percent))?$report_percent['load_drop___percent']:null;
    $_fined_amount_percent= (array_key_exists('fined_amount___percent', $report_percent))?$report_percent['fined_amount___percent']:null;
    $_total_transfer_fee_percent= (array_key_exists('total_transfer_fee___percent', $report_percent))?$report_percent['total_transfer_fee___percent']:null;
    $_total_loading_percent= (array_key_exists('total_loading___percent', $report_percent))?$report_percent['total_loading___percent']:null;
    // dd($_record_percent);
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ContructReport')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th   class="center" >
                <div > @lang('layout.ContractNumber') </div>
            </th>
            <th   class="center" >
                <div > @lang('layout.ContractName') </div>
            </th>
            <th   class="center" >
                <div > @lang('layout.Vendor') </div>
            </th>
            <th  class="center" >
                <div > @lang('layout.Phone') </div>
            </th>
            <th  class="center" >
                <div > @lang('layout.Address') </div>
            </th>
            <th  class="center" >
                <div > @lang('layout.Email') </div>
            </th>
            <th  class="center" >
                <div > @lang('layout.Description') </div>
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=""> {{ $contract->contract_no}} </td>
            <td class=""> {{ $contract->company_name}} </td>
            <td class=""> {{ $contract->name}} </td>
            <td class=""> {{ $contract->phone}}</td>
            <td class=""> {{ $contract->address}}</td>
            <td class=""> {{ $contract->email}}</td>
            <td class=""> {{ $contract->description}}</td>
        </tr>
    </tbody>
</table>
<hr />
<h3>@lang('layout.Loading')</h3>
@if($location || $source || $destination || $member_name || $inventorySite_name || $item_name || $measure_name)
<table class="main-table">
    <tr>

        @if($location)
        <td> @lang('layout.Location'):  {{$location}} </td>,
        @endif
        @if($source)
        <td> @lang('layout.SourcePlace'):  {{$source}} </td>,
        @endif
        @if($destination)
        <td>  @lang('layout.Destination'):   {{$destination}} </td>,
        @endif
        @if($member_name)
        <td>  @lang('layout.Driver'):  {{$member_name}} </td>,
        @endif
        @if($inventorySite_name)
        <td>  @lang('layout.Site'):  {{$inventorySite_name}} </td>,
        @endif

        @if($item_name)
        <td>  @lang('layout.ItemName'):  {{$item_name}} </td>,
        @endif
        
        @if($measure_name)
        <td>  @lang('layout.Measure'):  {{$measure_name}} </td>,
        @endif

    </tr>
</table>
@endif
<br>
<table class="main-table">
    <thead>
       
    </thead>
    <?php
    $count = 0;
    $totales = 0;
    $qty = 0;
    $QtyOut = 0;
    $Differ = 0;
    $overLoad = 0;
    $leakage = 0;
    $fined = 0;
    $fined_amount = 0;
    $colspan = 12;
    $currencies_in=[]; 
    $total_fined=[]; 
    $total_base_fined_dollar = 0;
    $total_base_rent_amount = 0;

    $cospanSite = 22;
    $qtySite = 0;
    $QtyOutSite = 0;
    $DifferSite = 0;
    $overLoadSite = 0;
    $leakageSite = 0;
    $finedSite = 0;
    $fined_amountSite = 0;
    $rentQuantitySite = 0;
    $totalesSite = 0;
    $totalBaseAmountSite = 0; 

    $colspanSiteSource = 10;
    $colspanSiteDestination = 11;
    
    ?>

    @if(!$_driver)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_plate_number)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_source_place)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_destination)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_loading_date)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_discharge_date)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_discharge)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_item_name)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_site)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_measure)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_load_quantity)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_discharge)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_differ)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_over_load)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_load_drop)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_fined_amount)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif
    @if(!$_total_transfer_fee)   <?php  $cospanSite = $cospanSite-1;  ?>       @endif


       {{-- Colspan for the source and destination --}}
       @if(!$_driver)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_plate_number)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_source_place)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_destination)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_loading_date)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_discharge_date)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_discharge)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_item_name)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_site)   <?php  $colspanSiteSource = $colspanSiteSource-1;  ?>       @endif
       @if(!$_measure)   <?php  $colspanSiteDestination = $colspanSiteDestination-1;  ?>       @endif
       @if(!$_load_quantity)   <?php  $colspanSiteDestination = $colspanSiteDestination-1;  ?>       @endif
       @if(!$_discharge)   <?php  $colspanSiteDestination = $colspanSiteDestination-1;  ?>       @endif
       @if(!$_differ)   <?php  $colspanSiteDestination = $colspanSiteDestination-1;  ?>       @endif
       @if(!$_over_load)   <?php  $colspanSiteDestination = $colspanSiteDestination-1;  ?>       @endif
       @if(!$_load_drop)   <?php  $colspanSiteDestination = $colspanSiteDestination-1;  ?>       @endif
       @if(!$_fined_amount)   <?php  $colspanSiteDestination = $colspanSiteDestination-1;  ?>       @endif
       @if(!$_total_transfer_fee)   <?php  $colspanSiteDestination = $colspanSiteDestination-1;  ?>       @endif
   
     
    @if(!$_driver)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_plate_number)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_source_place)    <?php  $colspan = $colspan-1;  ?>       @endif
     @if(!$_destination)    <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_loading_date)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_discharge_date)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_discharge)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_item_name)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_site)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_measure)  <?php  $colspan = $colspan-1;  ?>       @endif

    
    @if($type_filter != 'inventory')
    <?php $loadingDetailsSite = $sor_des ?>
    @endif   

    @foreach($loadingDetailsSite as $keys =>  $loadingDetailsSit)
    <tr>
        @if($type_filter == 'inventory')
        <td colspan="{{$cospanSite}}" style="font-size: 24px;height: 70px;background-color: rgb(88, 194, 233);color:white" class="center">@lang('layout.SiteName'): {{$loadingDetailsSit->site}}</td>
        @else 
        <td colspan="{{$colspanSiteSource}}" style="font-size: 24px;height: 70px;background-color: rgb(88, 194, 233);color:white" class="center">@lang('layout.Source'): {{$loadingDetailsSit['source']}}</td>
        <td colspan="{{$colspanSiteDestination}}" style="font-size: 24px;height: 70px;background-color: rgb(88, 194, 233);color:white" class="center">@lang('layout.Destination'): {{$loadingDetailsSit['destination']}}</td>
        @endif
    </tr>
    <tr class="bg">
      <td>
          <div class="center"> @lang('layout.Record') </div>
      </td>
      <td>
          <div class="center"> @lang('layout.Number') </div>
      </td>
      @if(!$member_name)
      @if($_driver)<th  @if($_driver_percent) width="{{$_driver_percent}}%" @endif>@lang('layout.Driver') </th> @endif
      @endif
      <!-- <th >@lang('layout.Transporter_name') </th> -->
      @if($_plate_number)<th @if($_plate_number_percent) width="{{$_plate_number_percent}}%" @endif>@lang('layout.PaletNumber')</th> @endif
      <!-- <th >@lang('layout.TankerNumber')</th>
      <th >@lang('layout.DriverType')</th>
      <th >@lang('layout.WayBillNumber') </th> -->
      <!-- <th >@lang('layout.TransitNumber') </th> -->
      @if(!$source) @if($_source_place)<th  @if($_source_place_percent) width="{{$_source_place_percent}}%" @endif>@lang('layout.SourcePlace') </th> @endif @endif
      @if(!$destination)  @if($_destination)<th  @if($_destination_percent) width="{{$_destination_percent}}%" @endif>@lang('layout.Destination') </th> @endif @endif
      @if($_loading_date)<th  @if($_loading_date_percent) width="{{$_loading_date_percent}}%" @endif>@lang('layout.LoadingDate') </th> @endif
      @if($_discharge)<th  @if($_discharge_percent) width="{{$_discharge_percent}}%" @endif>@lang('layout.Discharge') </th> @endif
      @if($_discharge_date)<th  @if($_discharge_date_percent) width="{{$_discharge_date_percent}}%" @endif>@lang('layout.DischargeDate') </th> @endif
      @if(!$item_name) @if($_item_name)<th  @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif>@lang('layout.ItemName') </th> @endif @endif
      @if(!$inventorySite_name) @if($_site)<th  @if($_site_percent) width="{{$_site_percent}}%" @endif>@lang('layout.Site') </th> @endif @endif
      @if(!$measure_name) @if($_measure)<th  @if($_measure_percent) width="{{$_measure_percent}}%" @endif>@lang('layout.Measure') </th> @endif @endif
      @if($_load_quantity)<th @if($_load_quantity_percent) width="{{$_load_quantity_percent}}%" @endif>@lang('layout.LoadQuantity') </th> @endif
      @if($_discharge_quantity)<th @if($_discharge_quantity_percent) width="{{$_discharge_quantity_percent}}%" @endif>@lang('layout.DischargeQuantity') </th> @endif
      @if($_differ)<th @if($_differ_percent) width="{{$_differ_percent}}%" @endif>@lang('layout.Differ') </th> @endif
      @if($_over_load)<th @if($_over_load_percent) width="{{$_over_load_percent}}%" @endif>@lang('layout.OverLoad') </th> @endif
      @if($_load_drop)<th @if($_load_drop_percent) width="{{$_load_drop_percent}}%" @endif>@lang('layout.LoadDrop') </th> @endif
      @if($_fined_amount)<th @if($_fined_amount_percent) width="{{$_fined_amount_percent}}%" @endif>@lang('layout.FinedAmount')</th> @endif
      @if($_fined_amount)<th >@lang('layout.FinedAmount')</th> @endif
      @if($_fined_amount)<th >@lang('layout.FinedAmount') {{getHomeCurrency()['code']}}</th> @endif
      @if($_total_transfer_fee)<th @if($_total_transfer_fee_percent) width="{{$_total_transfer_fee_percent}}%" @endif>@lang('layout.TotalTransferFee') </th> @endif
      @if($_total_transfer_fee)<th @if($_total_transfer_fee_percent) width="{{$_total_transfer_fee_percent}}%" @endif>@lang('layout.TotalTransferFee') {{getHomeCurrency()['code']}} </th> @endif
    </tr>
    @php 
         $filterItem = $loadingDetails->filter(function($loadingDetails) use ($loadingDetailsSit, $keys, $type_filter){
            if($type_filter == 'inventory'){
                return $loadingDetails->site_id == $loadingDetailsSit->site_id;
            } else {
                return $loadingDetails->source.'_'.$loadingDetails->destination == $keys;
            }
        });


        $totalesSite = $filterItem->reduce(function($carry, $items){
            $rate = $items->Rate >0 ? $items->Rate:  1; 
            return $carry + ($items->Total/ $rate);
        }, 0);


        $totalBaseAmountSite = $filterItem->reduce(function($carry, $items){
            $rate = $items->Rate >0 ? $items->Rate:  1; 
            return $carry + ($items->Total/ $rate);
        }, 0);

        $totalBaseAmountSite = $filterItem->reduce(function($carry, $items){
            $rate = $items->Rate >0 ? $items->Rate:  1; 
            return $carry + ($items->Total/ $rate); 
        }, 0);
        $total_base_fined_dollarSite = $filterItem->reduce(function($carry, $items){
            $rate = $items->Rate >0 ? $items->Rate:  1; 
            return $carry + ($items->fined_amount * $rate)/$rate; 
        }, 0);
        
        $total_base_rent_amountSite = $filterItem->reduce(function($carry, $items){
            $rate = $items->Rate >0 ? $items->Rate:  1; 
            return $carry + ($items->Total/ $rate); 
        }, 0);
        // total_base_fined_dollarSite


        // $totalesSite = ((double)$filterItem->sum('Total')  / (double)$filterItem->sum('Rate'));
        $qtySite = ((double)$filterItem->sum('qty'));
        $rentQuantitySite = ((double)$filterItem->sum('rent_quantity'));
        $QtyOutSite = $filterItem->sum('QtyOut') + $filterItem->sum('overLoad');
        $DifferSite = $filterItem->sum('QtyOut') + $filterItem->sum('overLoad') - $filterItem->sum('qty');
        $overLoadSite = $filterItem->sum('overLoad');
        $leakageSite = $filterItem->sum('leakage');
        $finedSite = $filterItem->sum('fined');
        $fined_amountSite = ((float)$filterItem->sum('fined_amount'));
        // $totalBaseAmountSite = $filterItem->sum('Total')/$filterItem->sum('Rate'); 
    @endphp

    @foreach($filterItem AS $srecord)
    <?php
      $totales += ($srecord->Total / $srecord->Rate);
      $qty += ($srecord->qty);
      $QtyOut += ($srecord->QtyOut + $srecord->overLoad);
      $Differ += (($srecord->QtyOut + $srecord->overLoad) - $srecord->qty);
      $overLoad += ($srecord->overLoad);
      $leakage += ($srecord->leakage);
      $fined += ($srecord->fined);
      $fined_amount += ((float)$srecord->fined_amount);

      if($srecord['Total']>0){
          if(array_key_exists($srecord['Currency'], $currencies_in))
          {
              $currencies_in[$srecord['Currency']]['Total']=$currencies_in[$srecord['Currency']]['Total']+$srecord['Total'];
              $currencies_in[$srecord['Currency']]['base_amount']=$currencies_in[$srecord['Currency']]['base_amount']+($srecord['Total']/$srecord['Rate']);
          }
          else
          {
              $currencies_in[$srecord['Currency']]['Total']=$srecord['Total'];
              $currencies_in[$srecord['Currency']]['base_amount']=($srecord['Total']/$srecord['Rate']);
          }
      }

      if($srecord['fined_amount']>0){
          if(array_key_exists($srecord['Currency'], $total_fined))
          {
              $total_fined[$srecord['Currency']]['fined_amount']=$total_fined[$srecord['Currency']]['fined_amount']+$srecord['fined_amount'] * $srecord['Rate'];
              $total_fined[$srecord['Currency']]['base_fined']=$total_fined[$srecord['Currency']]['base_fined']+($srecord['fined_amount'] * $srecord['Rate']/$srecord['Rate']);
          }
          else
          {
              $total_fined[$srecord['Currency']]['fined_amount']=$srecord['fined_amount'] * $srecord['Rate'];
              $total_fined[$srecord['Currency']]['base_fined']=($srecord['fined_amount'] * $srecord['Rate']/$srecord['Rate']);
          }    
      } 

      $total_base_fined_dollar = myRound((float)$total_base_fined_dollar + (float)$srecord->fined_amount * (float)$srecord->Rate/($srecord->Rate));
      $total_base_rent_amount = ($total_base_rent_amount + ($srecord->Total/$srecord->Rate));

    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$srecord->part_number}}</td>
        @if($srecord->driver_type == 'OwnDriver')
        @if(!$member_name)
        @if($_driver)  <td class="center">{{$srecord->driver_name}}</td> @endif
        @endif
        @if($_plate_number) <td class="center">{{$srecord->vehicle_palet_number}}</td> @endif
        @else
        @if(!$member_name)
        @if($_driver) <td class="center">{{$srecord->other_driver_name}}</td> @endif
        @endif
       @if($_plate_number)  <td class="center">{{$srecord->other_vehicle_name}}</td> @endif
        @endif
        <!-- <td class="center">{{$srecord->tanker_palet_number}}</td> -->
        <!-- <td class="center">{{ __('layout.' . $srecord->driver_type)  }}</td> -->
        <!-- <td class="center">{{$srecord->cmr_number}}</td> -->
        <!-- <td class="center">{{$srecord->transit_number}}</td> -->
         @if(!$source) @if($_source_place) <td class="center">{{$srecord->source}}</td> @endif @endif
         @if(!$destination) @if($_destination) <td class="center">{{$srecord->destination}}</td> @endif @endif
        @if($_loading_date) <td class="center"> {{convertDate($srecord->loading_date)}} </td> @endif
       @if($_discharge)  
       @if($srecord->state == 'On')
        <td class="center">@lang('layout.Not')</td>
        @else
        <td class="center">@lang('layout.yes')</td>
        @endif @endif
        @if($_discharge_date) <td class="center"> {{convertDate($srecord->discharge_date)}} </td> @endif
        @if(!$item_name)  @if($_item_name) <td class="center">{{$srecord->items}}</td> @endif @endif
        @if(!$inventorySite_name) @if($_site) <td class="center">{{$srecord->site}}</td>  @endif @endif
        @if(!$measure_name)  @if($_measure) <td class="center">{{$srecord->measure}}</td> @endif @endif
        @if($_load_quantity) <td class="center">{{myRound($srecord->qty)}}</td> @endif
        @if($_discharge_quantity) <td class="center">{{myRound($srecord->QtyOut + $srecord->overLoad)}}</td> @endif
        @if($_differ) <td class="center">{{myRound(($srecord->QtyOut + $srecord->overLoad) - ($srecord->qty))}}</td> @endif
        @if($_over_load) <td class="center">{{myRound($srecord->overLoad)}}</td> @endif
        @if($_load_drop) <td class="center">{{myRound($srecord->leakage)}}</td> @endif
        @if($_fined_amount) <td class="center">{{myRound($srecord->fined)}}</td> @endif
        @if($_fined_amount) <td class="center"> @if($srecord->fined_amount){{ myRound((float)$srecord->fined_amount * (float)$srecord->Rate)}} {{$srecord->Currency}} @endif </td> @endif
        @if($_fined_amount) <td class="center"> @if($srecord->fined_amount){{ myRound((float)$srecord->fined_amount * (float)$srecord->Rate/($srecord->Rate))}}  @endif </td> @endif
        @if($_total_transfer_fee) <td class="center"> {{myRound($srecord->Total)}} {{$srecord->Currency}} </td> @endif
        @if($_total_transfer_fee) <td class="center"> {{myRound($srecord->Total/$srecord->Rate)}} </td> @endif
    </tr>
    @endforeach
    <?php 
        $count = 0;
    ?>
    <tr class="bg">
      {{-- <td  class="center" style="border-left:none !important;"></td> --}}
     
      <td colspan="{{$colspan}}" class="center"> @lang('layout.Total') </td>
      @if($_load_quantity)<td colspan="1" class="center">{{myRound($qtySite)}}</td>@endif
       @if($_discharge_quantity)<td colspan="1" class="center">{{myRound($QtyOutSite)}}</td>@endif
       @if($_differ)<td colspan="1" class="center">{{myRound($DifferSite)}}</td>@endif
      @if($_over_load)<td colspan="1" class="center">{{myRound($overLoadSite)}}</td>@endif
      @if($_load_drop)<td colspan="1" class="center">{{myRound($leakageSite)}}</td>@endif
      @if($_fined_amount)<td colspan="1" class="center">{{myRound($finedSite)}}</td>@endif
      @if($_fined_amount) <td colspan="1" class="center">{{myRound($fined_amountSite)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
      @if($_fined_amount) <td colspan="1" class="center"> {{$total_base_fined_dollarSite}} {{getHomeCurrency()['code']}}  </td>@endif
      @if($_total_transfer_fee)<td colspan="1" class="center">{{myRound($totalesSite)}}  {{getHomeCurrency()[getCurrencyType()]}} </td>@endif
      @if($_total_transfer_fee)<td colspan="1" class="center">{{myRound($total_base_rent_amountSite) }}</td>@endif
    </tr>
    @endforeach

    <tr class="bg">
        {{-- <td  class="center" style="border-left:none !important;"></td> --}}
        
        <td colspan="{{$colspan}}" class="center"> @lang('layout.Total') </td>
        @if($_load_quantity)<td colspan="1" class="center">{{myRound($qty)}}</td>@endif
         @if($_discharge_quantity)<td colspan="1" class="center">{{myRound($QtyOut)}}</td>@endif
         @if($_differ)<td colspan="1" class="center">{{myRound($Differ)}}</td>@endif
        @if($_over_load)<td colspan="1" class="center">{{myRound($overLoad)}}</td>@endif
        @if($_load_drop)<td colspan="1" class="center">{{myRound($leakage)}}</td>@endif
        @if($_fined_amount)<td colspan="1" class="center">{{myRound($fined)}}</td>@endif
        @if($_fined_amount) <td colspan="1" class="center">{{myRound($fined_amount)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
        @if($_fined_amount) <td colspan="1" class="center"> {{$total_base_fined_dollar}} {{getHomeCurrency()['code']}}  </td>@endif
        @if($_total_transfer_fee)<td colspan="1" class="center">{{myRound($totales)}}  {{getHomeCurrency()[getCurrencyType()]}} </td>@endif
        @if($_total_transfer_fee)<td colspan="1" class="center">{{myRound($total_base_rent_amount) }}</td>@endif
    </tr>
</table>
@if($_total_loading)
<table class="main-table" style="margin-top:1%">
  <tr class="bg">
    <td colspan="5" class="center">
      <h3>@lang('layout.TotalAsCurrencies')</h3>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> @lang('layout.Record') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
    <td>
      <div class="center"> @lang('layout.AverageRate') </div>
    </td>
  </tr>
  <?php
  $count=0;
  foreach($currencies_in As $key=>$currency)
  {
  ?>
  <tr>
    <td>
      <div class="center">{{++$count}}</div>
    </td>
    <td>
      <div class="center">{{$key}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency['Total'])}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency['base_amount'])}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency['Total'] / $currency['base_amount'])}}</div>
    </td>

  </tr>
  <?php
  }
  ?>
</table>
@endif
@if($_total_loading)
<table class="main-table" style="margin-top:1%">
  <tr class="bg">
    <td colspan="5" class="center">
      <h3>@lang('layout.TotalFinedAsCurrencies')</h3>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> @lang('layout.Record') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
    <td>
      <div class="center"> @lang('layout.AverageRate') </div>
    </td>
  </tr>
  <?php
  $count=0;
  foreach($total_fined As $key=>$currency)
  {
  ?>
  <tr>
    <td>
      <div class="center">{{++$count}}</div>
    </td>
    <td>
      <div class="center">{{$key}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency['fined_amount'])}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency['base_fined'])}}</div>
    </td>
    <td>
      <div class="center">{{myRound($currency['fined_amount'] / $currency['base_fined'])}}</div>
    </td>

  </tr>
  <?php
  }
  ?>
</table>
@endif
{{-- <table class="main-table">
  <tr class="bg"> 
      <td colspan="9" class="center" style="width:335px;"> @lang('layout.Total') </td>
      <td colspan="1" class="center"style="width:50px;">{{myRound($qty)}}</td>
      <td colspan="1" class="center" style="width:150px;">{{myRound($QtyOut)}}</td>
      <td colspan="1" class="center">{{myRound($Differ)}}</td>
      <td colspan="1" class="center">{{myRound($overLoad)}}</td>
      <td colspan="1" class="center">{{myRound($leakage)}}</td>
      <td colspan="1" class="center">{{myRound($fined)}}</td>
      <td colspan="1" class="center">{{myRound($fined_amount)}} {{getReportCurrency()}}</td>
      <td colspan="1" class="center">{{myRound($totales)}} {{getReportCurrency()}}</td>
  </tr>
</table> --}}
@endsection