@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReport('contract_detail');
    $_name = in_array('name', $report);
    $_symbol = in_array('symbol', $report);
    $_quantity = in_array('quantity', $report);
    $_price = in_array('price', $report);
    $_total = in_array('total', $report);
    ?>
    <h3>@lang('layout.ContructReport')</h3>
    <table style="width: 100%; margin-bottom: 10px;">
        @if($info && $info !=[])

            <tr>
                <td>
                    <span>@lang('layout.Number')</span>:
                    <span>{{$info->contract_no}}</span>
                </td>
                <td>
                    <span>@lang('layout.MemberName')</span>:
                    <span>{{$info->name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Currency')</span>:
                    <span>{{$info->currency}}</span>
                </td>
                <td>
                    <span>@lang('layout.Rate')</span>:
                    <span>{{$info->rate}}</span>
                </td>
                <td>
                    <span>@lang('layout.Description')</span>:
                    <span>{{$info->description}}</span>
                </td>
            </tr>
        @endif

    </table>


    <table class="main-table">
        <thead>
        <tr class="bg">
            <td class="center" >
                <div > #</div>
            </td>
            @if($_name)
                <td class="center" >
                    <div > @lang('layout.Name')</div>
                </td>@endif
            @if($_symbol)
                <td class="center" >
                    <div > @lang('layout.Measure')</div>
                </td>@endif
            @if($_price)
                <td class="center" >
                    <div > @lang('layout.Cost')</div>
                </td>@endif
            @if($_quantity)
                <td class="center" >
                    <div > @lang('layout.Quantity')</div>
                </td>@endif
            @if($_quantity)
                <td class="center" >
                    <div > @lang('layout.PurchasedQuantity')</div>
                </td>@endif
            @if($_quantity)
                <td class="center" >
                    <div > @lang('layout.Remain')</div>
                </td>@endif
            @if($_total)
                <td class="center" >
                    <div > @lang('layout.Total')</div>
                </td>@endif

        </tr>
        </thead>
        <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                @if($_name)
                    <td class="center">{{$record->item_name}}</td>@endif
                @if($_symbol)
                    <td class="center">{{$record->item_measure}}</td>@endif
                @if($_price)
                    <td class="center">{{round($record->cost,2)}}</td>@endif
                @if($_quantity)
                    <td class="center">{{$record->qty}}</td>@endif
                @if($_quantity)
                    <td class="center">{{$record->qut_in}}</td>@endif
                @if($_quantity)
                    <td class="center">{{$record->qty-$record->qut_in}}</td>@endif
                @if($_total)
                    <td class="center">{{$record->Total}}</td>@endif

            </tr>
        @endforeach
        </tbody>
    </table>



@endsection