@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.ContractItems')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>


    @if($contract_name || $item_name || $inventory_site_name)
<table class="main-table" style="margin: 6px 0px;" >
   
    <tr>
      @if($contract_name)
      <td>
        <span>@lang('layout.Contract')</span>: {{$contract_name}}
      </td>
      @endif
   
      @if($item_name)
      <td>
        <span>@lang('layout.Name')</span>: {{$item_name}}
      </td>
      @endif

      @if($inventory_site_name)
      <td>
        <span>@lang('layout.SiteName')</span>: {{$inventory_site_name}}
      </td>
      @endif
      
    </tr>
   
</table>
@endif


    <br>
    <table class="main-table">
        <thead>

        <tr class="bg">
            <td class="center">
                <div >   @lang('layout.Record')  </div>
            </td>
            @if(!$contract_name)
            <td class="center">
                <div > @lang('layout.Contract')</div>
            </td>
            @endif
            @if(!$item_name)
            <td class="center">
                <div > @lang('layout.Name')</div>
            </td>
            @endif
            <td class="center">
                <div > @lang('layout.QutOut')</div>
            </td>
            <td class="center">
                <div > @lang('layout.QutIn')</div>
            </td>
            <td class="center">
                <div > @lang('layout.Measure')</div>
            </td>
            <td class="center">
                <div > @lang('layout.OnHand')</div>
            </td>
            <td class="center">
                <div > @lang('layout.UnitCost')</div>
            </td>
            <td class="center">
                <div > @lang('layout.Total')</div>
            </td>
            
        </tr>
        </thead>

        <?php
        $count = 0;

        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                @if(!$contract_name)
                <td class="center">{{$record['contract']}}</td>
                @endif
                @if(!$item_name)
                <td class="center">{{$record['name']}}</td>
                @endif
                <td class="center">{{$record['quantityOut']}}</td>
                <td class="center">{{$record['qut_in']}}</td>
                <td class="center">{{$record['measure']}}</td>
                <td class="center">{{myRound($record['onHand'])}}</td>
                <td class="center">{{myRound($record['costExpense'])}}</td>
                <td class="center">{{myRound($record['costExpense'] * $record['onHand'])}}</td>

            </tr>
        @endforeach
    </table>





@endsection