@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.LoadingDate')</h3>
 
@if($info && $info !=[])
    <table class="main-table">

    <tr>
        <td>
            <span>@lang('layout.ContractNumber')</span>:
            <span>{{$info->contract_no}}</span>
        </td>
        <td>
            <span>@lang('layout.ContractName')</span>:
            <span>{{$info->company_name}}</span>
        </td>
        <td>
            <span>@lang('layout.Vendor')</span>:
            <span>{{$info->name}}</span>
        </td>
        <td>
            <span>@lang('layout.Date')</span>:
            <span>{{convertDate($info->Date)}}</span>
        </td>
    </tr>
    {{-- <tr>

        <th>
            <span>@lang('layout.Currency')</span>:
            <span>{{$info->currency}}</span>
        </th>
        <th>
            <span>@lang('layout.Rate')</span>:
            <span>{{$info->rate}}</span>
        </th>
        <th>
            <span>@lang('layout.Amount')</span>:
            <span>{{$info->Amount}}</span>
        </th>
    </tr> --}}
    
</table>
<br>
@endif

    <table class="main-table">

        <thead>
        <tr class="bg">
            <th class="center" >@lang('layout.Record')</th>
            <th class="center" >@lang('layout.Number')</th>
            <th class="center" >@lang('layout.LoadingDate')</th>
            <th class="center" >@lang('layout.Description')</th>

        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{convertDate($record->date)}}</td>
                <td class="center">{{$record->description}}</td>
            </tr>
        @endforeach

    </table>



     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection