@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ContractInformation') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">
                <a href="" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                <a href="" class="reload" data-original-title="" title=""> </a>
                <a href="" class="remove" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="app" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::model($contract,['method' => 'PATCH','route' => ['contract.close',$contract->id],'class'=>'form-horizontal'])!!}
            {{ csrf_field() }}
            <div class="form-body">

                <div class="col-md-12">
                    <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                        <thead>
                            <tr>
                                <th class="hidden-xs">
                                    <i class="fa fa-bars"></i> @lang('layout.ContractNumber')
                                </th>
                                <th class="hidden-xs">
                                    <i class="fa fa-edit"></i> @lang('layout.CompanyName')
                                </th>
                                <th>
                                    <i class="icon-phone"></i> @lang('layout.Phone')
                                </th>
                                <th>
                                    <i class="fa fa-credit-card"></i> @lang('layout.Address')
                                </th>
                                <th>
                                    <i class="fa fa-envelope"> @lang('layout.Email') </i>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="hidden-xs"> {{ $contract->contract_no}} </td>
                                <td class="hidden-xs"> {{ $contract->company_name}} </td>
                                <td class="hidden-xs"> {{ $contract->phone}}</td>
                                <td class="hidden-xs"> {{ $contract->address1}}</td>
                                <td class="hidden-xs"> {{ $contract->email}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-12">
                    <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                        <thead>
                            <tr>
                                <th class="hidden-xs">
                                    <i class="fa fa-money"></i> @lang('layout.TotalContract')
                                </th>
                                <th class="hidden-xs">
                                    <i class="fa fa-money"></i> @lang('layout.TotalSale')
                                </th>
                                <th>
                                    <i class="fa fa-money"></i> @lang('layout.TotalGrossProfit')
                                </th>
                                <th>
                                    <i class="fa fa-credit-card"></i> @lang('layout.TotalAssets')
                                </th>
                                <th>
                                    <i class="fa fa-credit-card"></i> @lang('layout.TotalWastage')
                                </th>
                                <th>
                                    <i class="fa fa-money"></i> @lang('layout.TotalFined') 
                                </th>
                                <th>
                                    <i class="fa fa-money"></i> @lang('layout.Expense') 
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="hidden-xs"> {{ myRound($contract_money)}} </td>
                                <td class="hidden-xs"> {{ myRound($sale_money)}} </td>
                                <td class="hidden-xs"> {{ myRound($benifed)}} </td>
                                <td class="hidden-xs"> {{ myRound($stockMoney)}} </td>
                                <td class="hidden-xs"> {{ myRound($adjasment)}} </td>
                                <td class="hidden-xs"> {{ myRound($other_income)}} </td>
                                <td class="hidden-xs"> {{ myRound($totalExpense)}} </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-4">
                    <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                        <thead>
                            <tr>
                                <th>
                                    <i class="fa fa-money"></i> @lang('layout.TotalProfit')
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="hidden-xs"> {{ myRound($all_benifed)}} </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-4 col-sm-12">
                    <label class="control-label">@lang('layout.OtherIncome')</label>
                    <v-select label="name" :options="otherIncome"
                                v-model="selected_income"></v-select>
                    <input type="hidden" name="income_id"
                            :value="(selected_income==null)?null:selected_income.id">
                </div>
                <div class="col-md-4 col-sm-12">
                    <label class="control-label">@lang('layout.OtherExpense')</label>
                    <v-select label="name" :options="otherExpense"
                                v-model="selected_expense"></v-select>
                    <input type="hidden" name="expense_id"
                            :value="(selected_expense==null)?null:selected_expense.id">
                </div>

                <div class="col-md-12" style="padding: 0px;">
                    <div class="col-md-4">
                        <label class="control-label">@lang('layout.MainShareholder')</label>
                        <v-select label="name" v-model="selected_owner" :options="owner" placeholder="@lang('layout.Select')" disabled></v-select>
                        <input type="hidden" name="owner_id" :value="(!selected_owner)?null:selected_owner.id">
                    </div>

                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Date')</label>
                        <input class="form-control date" id="range-from-example" name="date" autocomplete="off" />
                    </div>
                    <div class="col-md-5">
                        <label class="control-label">@lang('layout.Description')</label>
                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}

                    </div>

                </div>
                <div class="col-md-12">
                    <!-- begin shareholder -->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Shareholder')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>


                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(record,index) in shareholderData">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="record.selected" :options="(record.shareholder_list)" placeholder="@lang('layout.Select')" disabled>

                                    </v-select>
                                    <input type="hidden" name="shareholder_id[]" :value="(record.selected==null)?null:record.selected.id">
                                </td>

                                <td>
                                    <input class="form-control" type="number" name="percentage[]" v-model.number="record.percentage" placeholder="@lang('layout.Percentage')" readonly="readonly">
                                </td>


                            </tr>
                        </tbody>
                    </table>
                    <!-- end shareholder -->
                </div>
            </div>
            <div class="col-md-4 col-md-offset-4 text-center">
                <br>
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                <a href="{{route('contract.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            <input type="hidden" name="timps" class="observer-example-alt">
            {!! Form::close() !!}

        </div>

        <!-- END FORM-->
    </div>
</div>

@endsection
@push('scripts')




<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component("v-select", VueSelect.VueSelect);

    var shareholder ={!! $shareholder!!};
    var owner ={!! $owner!!};
    var contractShareholder ={!! $contractShareholder!!};
    
    var otherIncome ={!! $otherIncome!!};
    var otherExpense ={!! $otherExpense!!};
    
    new Vue({
        el: '#app',
        data: {

            selectedMember: null,
            listAccounts: [],
            type: 'bank',
            account: {},
            contract: {!!$contract!!},
            shareholder: shareholder,
            contractShareholder: contractShareholder,
            owner: owner,
            selected_owner: null,
            otherIncome: otherIncome,
            selected_income: null,
            otherExpense: otherExpense,
            selected_expense: null,
            shareholderData: []
        },

        computed: {},
        mounted: function() {
            this.selected_owner = _.find(this.owner, (o) => o.id == this.contract.owner_id);

            for (var i = 0; i < this.contractShareholder.length; i++) {
                var percent = this.contractShareholder[i].percentage;
                var s = _.find(this.shareholder, (o) => o.id == this.contractShareholder[i].shareholder_id);
                this.shareholderData.push({
                    percentage: percent,
                    shareholder_list: this.shareholder,
                    selected: s
                });
            }


        },
        methods: {

            handleSubmit(e) {

                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
            onComplete: function() {
                document.getElementById("account-form").submit()
                //                this.$emit('on-complete')
                //                alert('Yay. Done!');
            },
            submitform() {
                swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("bill-submit").submit()
                        } else {}
                    });
            },
            // generic function for adding item to list
            addNew(type = null, index) {

                if (type != null) {
                    if (type == 'shareholder') {

                        if (this.shareholderData[index + 1] == undefined) {
                            //this.temp_items=[];
                            this.shareholderData.push({
                                percentage: 0,
                                shareholder_list: this.shareholder,
                                selected: null
                            });
                        }
                    }
                }
            },
            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'shareholder') {
                        this.shareholderData.splice(index, 1);
                    }

                }

            },
        }
    });
</script>

@endpush