@extends('layouts.factor-master')

@section('content')
 
<h3 class="table-caption" style="text-align: center;">@lang('menu.PayrollForm')</h3>


@if($info && $info !=[])
<table  class="main-table">
   
    <tr>
     <td>
       <span>@lang('layout.Number')</span> :
       <span>{{$info->contract_no}}</span>
     </td>
     <td>
       <span>@lang('menu.Contract')</span> :
       <span>{{$info->company_name}}</span>
     </td>
     
   </tr>
</table>
<br>
@endif

 <table class="main-table">
      <thead>
      <tr class="bg"> 
        <th>@lang('layout.Record')</th>
        <th>@lang('layout.Number')</th>
        <th>@lang('layout.Name')</th>
        @if(systemConfig()[5] != 0 )
        <th>@lang('layout.Project')</th>
        @endif
        <th>@lang('layout.NetPayable')</th>
        <th>@lang('layout.Currency')</th>
        <th>@lang('layout.FromDate')</th>
        <th>@lang('layout.ToDate')</th>
        <th>@lang('layout.Description')</th>
        <th>@lang('layout.User')</th>
    </tr>
  </thead>
    <?php
      $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
     <td  class="center">{{++$count}}</td>
     <td class="center">{{$record->number}}</td>
     <td class="center">{{$record->Employee}}</td>
     @if(systemConfig()[5] != 0 )
     <td class="center">{{$record->project_name}}</td>
     @endif
    <td  class="center">{{ myRound($record->net_payable)}}</td>
     <td class="center">{{$record->currency}}</td>
     <td class="center">{{convertDate($record->From_Date)}}</td>
     <td class="center">{{convertDate($record->To_Date)}}</td>
     <td class="center">{{$record->description}}</td>
    <td  class="center">{{$record->user}}</td>
    </tr>
    @endforeach
</table>

  <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection
