@extends('layouts.report')

@section('content')

    <?php
    $report = customeReport('contract', 'detail');
    ?>

    <table class="main-table">
        @if($data && $data !=[])

            <tr>
                <td>
                    <span>@lang('layout.ContractNumber')</span>:
                    <span>{{$data->contract_no}}</span>
                </td>
                <td>
                    <span>@lang('layout.Name')</span>:
                    <span>{{$data->company_name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Owner')</span>:
                    <span>{{$data->name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Phone')</span>:
                    <span>{{$data->phone}}</span>
                </td>
                <td>
                    <span>@lang('layout.Address')</span>:
                    <span>{{$data->address1}}</span>
                </td>
            </tr>
            <tr>

                <td>
                    <span>@lang('layout.Currency')</span>:
                    <span>{{$data->currency}}</span>
                </td>
                <td>
                    <span>@lang('layout.Amount')</span>:
                    <span>{{$data->Amount}}</span>
                </td>
                <td>
                    <span>@lang('layout.Rate')</span>:
                    <span>{{$data->rate}}</span>
                </td>


            </tr>
        @endif

    </table>


    <h3 class="table-caption" style="text-align: center;">@lang('layout.ContructReport')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">


            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Shareholder')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Percentage')</div>
            </td>


        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($info AS $record)
            <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record->member_name}}</td>
            <td class="center">{{$record->percentage}}</td>


            </tr>
        @endforeach
    </table>

    <table>
        <tr>

        </tr>
    </table>

@endsection