@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('contract', 'index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseReport')</h3>
<table class="main-table">
    <tr class="bg">
        <th colspan="4" style="font-weight: bold; font-size:20px">@lang('layout.Customer')</th>
    </tr>
    <tr class="bg">
        <th>@lang('layout.Code')</th>
        <th>@lang('layout.Name')</th>
        <th>@lang('layout.Phone')</th>
        <th>@lang('layout.FatherName')</th>
    </tr>
    <tr>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->code }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->name }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->phone }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->father_name }} </td>
    </tr>
    <tr class="bg">

        <!-- <th>@lang('layout.Country')</th> -->
        <th>@lang('layout.City')</th>
        <th>@lang('layout.District')</th>
        <th>@lang('layout.Village')</th>
        <th>@lang('layout.Address')</th>
    </tr>
    <tr>

        <!-- <td class="hidden-xs" style="text-align:center"> {{ $customer->country }}  </td> -->
        <td class="hidden-xs" style="text-align:center"> {{ $customer->city }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->district }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->village }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->address1 }} </td>
    </tr>


</table>
<hr />

<table class="main-table">
    <thead>
        <tr class="bg">
            <th>#</th>
            <th>@lang('layout.PurchaseNumber') </th>
            <th>@lang('layout.ItemName') </th>
            <th>@lang('layout.Type')</th>
            @if(getOtherMeasure()=="true")
            <th>@lang('layout.OMeasureValue1')</th>
            @endif
            @if(getOtherMeasure2()=="true")
            <th>@lang('layout.OMeasureValue2')</th>
            @endif
            <th>@lang('layout.Quantity') </th>
            <th>@lang('layout.Measure') </th>
            <th>@lang('layout.PurchaseCost') </th>
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Expense') </th>
            <th>@lang('layout.CostOfGoodSold') </th>
            <th>@lang('layout.TotalPurchaseCost') </th>
            <th>@lang('layout.TotalCostOfGoodSold') </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $total2 = 0;
    $total_home_currency = 0;
    $currencies = [];
    $measures = [];
    ?>
    @foreach($billDetails AS $record)
    <tr>
        <?php
            if (array_key_exists($record->Currency, $currencies)) {
                $currencies[$record->Currency] = $currencies[$record->Currency] + (($record->Amount + ($record->expense_cost * $record->Rate)) * $record->qty);
            } else {
                $currencies[$record->Currency] = (($record->Amount + ($record->expense_cost * $record->Rate)) * $record->qty);
            }
            if (array_key_exists($record->farmer_type, $measures)) {
                $measures[$record->farmer_type] = array('mea' => $record->measure, 'qut' => ($measures[$record->farmer_type]['qut'] + $record->qty));
            } else {
                $measures[$record->farmer_type] = array('mea' => $record->measure, 'qut' => $record->qty);
            }
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->p_number}}</td>
        <td class="center">{{$record->items}}</td>
        <td class="center">{{__('layout.'.$record->farmer_type)}}</td>
        @if(getOtherMeasure()=="true")
        <td class="center">{{$record->other_measure}}</td>
        @endif
        @if(getOtherMeasure2()=="true")
        <td class="center">{{$record->other_measure2}}</td>
        @endif
        <td class="center">{{($record->qty * $record->measureUnit / ($record->purchaeMeasureUnit))}}</td>
        <td class="center">{{$record->purchaseMeasure}}</td>
        <td class="center">{{$record->Amount}}</td>
        <td class="center">{{$record->Currency}}</td>
        <td class="center">{{($record->expense_cost * $record->Rate)}}</td>
        <td class="center">{{($record->Amount + ($record->expense_cost * $record->Rate))}}</td>
        <td class="center">{{$record->Total}}</td>
        <td class="center">{{(($record->Amount + ($record->expense_cost * $record->Rate)) * $record->qty)}}</td>
    </tr>

    @endforeach
    <tr class="bg">
        <td colspan="7">
            <div class="center">@lang('layout.PerUnit')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Measure') </div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Quantity') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    // dd($measures);
    foreach ($measures as $key => $meas) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{__('layout.'.$key)}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{round($meas['qut'],2)}} {{$meas['mea']}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr class="bg">
        <td colspan="7">
            <div class="center">@lang('layout.Currency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Category') </div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key1 => $curr) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{$key1}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{round($curr,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
</table>


@endsection