@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <!-- new modal -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'member_farmer_contract'"
                      @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="all_farmer_contract" value="all"/>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.SelectType')</label>
                                <select class="form-control" name="report_type">
                                    <option value="">@lang('layout.SelectType')</option>
                                    <option value="summary">@lang('layout.Summary')</option>
                                    <option value="details">@lang('layout.Details')</option>

                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.FarmerContract')</label>
                            <v-select class="vue-select2" label="name"
                                        :options="farmer_contract_list" v-model="selectedFarmerContract">
                            </v-select>
                            <input type="hidden" name="contract_farmer_id"
                                    v-model.number="(!selectedFarmerContract)?null:selectedFarmerContract.id">
                        </div>
                    </div>
                </div> 

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- /new modal -->
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.FarmerContractList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('contractFarmer-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('invoice-create')
                    <a href="{{route('invoice.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="FarmerContract_table">
                    <thead>
                    <tr>

                        <td><div class="center" style="color: white;"> @lang('layout.Number') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.ReferenceNumber') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.Member') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.Guarantor') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.LandSize') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.DrawingAmount') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.SeedAmount') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.Date') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.OverdueDate') </div></td>
                        <!-- <td><div class="center"> @lang('layout.Currency') </div></td>
                        <td><div class="center"> @lang('layout.Rate') </div></td> -->
                        <td><div class="center" style="color: white;"> @lang('layout.Status') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.Description') </div></td>
                        <td><div class="center" style="color: white;"> @lang('layout.Actions') </div></td>

                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

<!-- contract_farmer_all -->
 
    <script>
        var contract_farmer_all  = {!!json_encode($contract_farmer_all)!!}
        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#FarmerContract_table').DataTable({
                ajax: '{{route("contractFarmer.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:7}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'contract_farmer.number'},
                    {data: 'ref_no', name: 'contract_farmer.ref_no'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'gua_name', name: 'member_guarantor.name'},
                    {data: 'land_size', name: 'contract_farmer.land_size'},
                    {data: 'land_drawing_amount', name: 'contract_farmer.land_drawing_amount'},
                    {data: 'seed_amount', name: 'contract_farmer.seed_amount'},
                    {data: 'Date', name: 'contract_farmer.date'},
                    {data: 'overdueDate', name: 'overdueDate', searchable: false},
                    // {data: 'currency', name: 'currency', orderable: false, searchable: false},
                    // {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'Status', name: 'Status', orderable: false, searchable: false},
                    // {data: 'user', name: 'users.name'},
                    {data: 'sale_description', name: 'sale_description'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}



                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                member: null,
                farmer_contract_list:contract_farmer_all,
                selectedFarmerContract:null

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // register modal component

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush
