@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>


    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateContract') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>

            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($contract,['method' => 'PATCH','route' => ['contract.updateQty',$contract->id],'files'=> true,'id'=>'contract-form'])!!}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.ContractName')</label>

                                    {{Form::text('company_name',null,['class' => 'form-control','placeholder' => __('layout.ContractName'),'v-validate'=>'"required"','data-vv-as'=>__('layout.ContractName')])}}

                                    <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ContractCode')</label>
                                    {{Form::number('contract_no',null,['class' => 'form-control', 'readonly'])}}
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <v-select class="vue-select2" v-model="selectedMember" label="name"
                                              :options="member" disabled >
                                    </v-select>
                                    <input type="hidden" name="member_id"
                                           v-model.number="(!selectedMember)?null:selectedMember.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.SelectMember')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input class="form-control date" id="range-from-example" name="date"
                                           value="{{$contract->Date}}" autocomplete="off">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.MainShareholder')</label>
                                    <v-select label="name" v-model="selected_owner" :options="owner"
                                              placeholder="@lang('layout.Select')"></v-select>
                                    <input type="hidden" name="owner_id"
                                           :value="(!selected_owner)?null:selected_owner.id">
                                </div>

                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}

                                </div>

                            </div>
                        </div>


                    </div>

                    <!-- begin item -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 130px">@lang('layout.Category') </th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                            <!-- <th style="min-width: 100px">@lang('layout.SiteName') </th> -->
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th v-show="showWhat('expire_date')=='yes'"
                                    style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                            <!-- <th style="min-width: 100px">@lang('layout.OnHand') </th> -->
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue') </th>

                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                <th v-show="showWhat('sale_discount')=='yes'"
                                    style="min-width: 100px">@lang('layout.Discount') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)" disabled ></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" @Click.native="setIndex(index)" v-model="item.item"
                                              :options="temp_items" @search="onItemSearch" disabled></v-select>
                                    <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.ItemName')"
                                           :value="(!item.item)?null:item.item.id">
                                           <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                    <input type="hidden" :name="'contract_detail_id['+index+']'" :value="(!item.item)?null:item.item.contract_detail_id">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input class="purchase_description" type="text"
                                           placeholder="@lang('layout.Description')" name="inventory_description[]"
                                           class="form-control">
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
                                    <input type="text" placeholder="@lang('layout.ExpireDate')" name="expire_date[]"
                                           class="date form-control" readonly>
                                </td>
                                <td>
                                    <input type="number" :name="'quantity['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.Quantity')"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                    <span class="required">@{{ errors.first('quantity['+index+']') }}</span>
                                </td>

                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control" disabled
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                    </select>

                                    <input type="hidden" name="measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate)" readonly
                                               ref="in" @input="setNewRate(index)" class="form-control">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')" readonly
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               class="form-control">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                        @{{selected_currency.symbol}}
                                      </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                        %
                                      </span>
                                    </div>

                                </td>

                                <td>
                                    <div>
                                        <div class="input-group">
                                            <input type="number" class="form-control inner_input"
                                                   :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate,discountIsAmount,item.item.discount)"
                                                   placeholder="@lang('layout.Total')" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>

                    </div>
                    <span v-if="inventories.length==0">
                         <button type="button" @click="addNew('inventory',0)" class="btn btn-success"><i
                                     class="fa fa-plus"></i></button>
                      </span>

                    <!-- end item -->
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        Vue.component('v-select', VueSelect.VueSelect);

        var banks =
                {!! $banks!!}
        var member =
                {!!$member!!}
        var currency =
                {!! $currency!!}
        var shareholder ={!! $shareholder!!};
        var owner ={!! $owner!!};
        var inventory_category = {!! $inventory_category !!};
        var contract = {!! $contract !!};
        var contractShareholder ={!! $contractShareholder!!};

        var v = new Vue({
            el: '#app',
            data: {
                contract: contract,
                currency: currency,
                selected_currency: defaultCurrency(),
                selectedMember: null,
                listAccounts: [],
                member: member,
                selected_item:{!! $selectedItem !!},
                type: 'bank',
                banks: banks,
                selected_banks: null,
                shareholder: shareholder,
                contractShareholder: contractShareholder,
                owner: owner,
                selected_owner: null,
                shareholderData: [],
                rate: 0,
                temp_items: [],
                inventory_category: inventory_category,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,

                inventories: [],


                discountFiled: 0,
                discountIsAmount: true,
            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    return this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },


                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }


                        }
                        // this.totalAmountes=sum;

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    return sum;
                },


                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function () {
                this.selected_owner = _.find(this.owner, (o) => o.id == this.contract.owner_id);

                for (var i = 0; i < this.contractShareholder.length; i++) {
                    var percent = this.contractShareholder[i].percentage;
                    var s = _.find(this.shareholder, (o) => o.id == this.contractShareholder[i].shareholder_id);
                    this.shareholderData.push({percentage: percent, shareholder_list: this.shareholder, selected: s});
                }
                for (var m = 2; m > this.contractShareholder.length; m--) {
                    this.shareholderData.push({percentage: 0, shareholder_list: this.shareholder, selected: null});
                }

                this.selectedMember = _.find(member, (m) => m.id == contract.member_id);
				if(contract.currency != null){
					this.selected_currency = _.find(currency, (c) => c.code == contract.currency);
				} else if(contract.unit != null){
					this.selected_currency = _.find(currency, (c) => c.code == contract.unit);
				}
                this.selected_currency.rate = contract.rate;
                // initialize the selected item
                // initialize the selected item
                for (var i = 0; i < this.selected_item.length; i++) {
                    console.log('item', this.selected_item);
                    this.inventories.push({
                        item: this.selected_item[i],
                        item_category: this.selected_item[i].item_category
                    });
                }
                for (var m = 1; m > this.selected_item.length; m--) {
                    this.inventories.push({item: null});
                }

                // initialize payments

                for (var j = 0; j < this.banks.length; j++) {
                    if (this.banks[j].id == this.contract.account_id) {
                        this.selected_banks = this.banks[j];
                    }
                }

                // end payment

            },
            methods:
                {

                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // set new price
                    setNewRate(index) {

                        if (this.inventories[index].item) {
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        }
                    },
                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: "itemSearchPurchase",
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {

                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {

                            let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchPurchase',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }

                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: this.selected_iventory_category});
                                }
                            }
                            if (type == 'shareholder') {

                                if (this.shareholderData[index + 1] == undefined) {
                                    //this.temp_items=[];
                                    this.shareholderData.push({
                                        percentage: 0,
                                        shareholder_list: this.shareholder,
                                        selected: null
                                    });
                                }
                            }
                        }

                    },


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'shareholder') {
                                this.shareholderData.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {


                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("contract-form").submit()

                            }
                            else {

                            }
                        });

                    },

                    defaultValue() {

                        this.inventories = [
                            {item: null, item_category: this.selected_iventory_category},
                        ];


                        this.discountFiled = 0;
                        this.temp_items = [];
                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    var url = "{{route('contract.store')}}";
                                    form_id = 'purchase-form';
                                    var data = $('#' + form_id).serialize();

                                    axios.post(url, data)
                                        .then(function (response) {

                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                //$('#success-sound')[0].play();
                                                toastr.success('', response.data.message);

                                                v.defaultValue();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush