@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>

    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewContract') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>

            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'contract.store','method' => 'POST','class' => 'form-horizontal','id'=>'contract-form'])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.ContractName')</label>

                                    {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.ContractName'),'v-validate'=>'"required"','data-vv-as'=>__('layout.ContractName')])}}

                                    <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ContractCode')</label>
                                    {{Form::number('contract_no',$contract_no,['class' => 'form-control'])}}
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.SelectMember')</label>
                                    <v-select class="vue-select2" v-model="selectedMember" label="name"
                                              :options="{{$member}}">
                                    </v-select>
                                    <input type="hidden" name="member_id"
                                           v-model.number="(!selectedMember)?null:selectedMember.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.SelectMember')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input class="form-control date"  name="date"
                                           autocomplete="off">
                                </div>
                            </div>

                            <div class="row">

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-md-3' : 'col-md-4' }} col-sm-12">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="setRates"
                                              v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" v-validate="'required'"
                                           data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                    <span class="required">@{{ errors.first('currency') }}</span>
                                </div>

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-md-3' : 'col-md-4' }} col-sm-12">
                                    <label class="control-label">@lang('layout.Rate')</label>

                                    <input type="number" name="currency_rate" v-validate="'required'"
                                           data-vv-as="@lang('layout.Rate')"
                                           v-model="!selected_currency?0:selected_currency.rate" class="form-control"
                                           :class="{'has-error':rate<=0}">
                                    <span class="required">@{{ errors.first('currency_rate') }}</span>

                                </div>

                                @if(auth()->user()->company()->first()->tag != 1)

                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <label class="control-label">@lang('layout.ExchangeRateHQ')</label>

                                        <input type="number" name="currency_rate_hq"
                                               v-validate="'required'"
                                               data-vv-as="@lang('layout.RateHQ')"
                                               v-model="!selected_currency?0:selected_currency.hq_rate"
                                               class="form-control"
                                               :class="{'has-error':rate<=0}">
                                        <span class="required">@{{ errors.first('currency_rate') }}</span>
                                    </div>

                                @endif

                            </div>

                            <div class="row">

                                <div class="col-md-6 col-sm-12">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <v-select label="name" :options="approperiateBank"
                                              v-model="selected_banks"></v-select>
                                    <input type="hidden" name="account_id"
                                           :value="(this.selected_banks==null)?null:selected_banks.id">

                                </div>

                                <div class="col-md-6 col-sm-12">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    {{Form::number('amount',null,['class' => 'form-control','v-validate'=>"''",'data-vv-as'=>__('layout.Amount')])}}
                                    <span class="required">@{{ errors.first('amount') }}</span>

                                </div>

                            </div>


                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.MainShareholder')</label>
                                    <v-select label="name" v-model="selected_owner" :options="owner"
                                              placeholder="@lang('layout.Select')"></v-select>
                                    <input type="hidden" name="owner_id"
                                           :value="(!selected_owner)?null:selected_owner.id">
                                </div>

                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}

                                </div>

                            </div>
                        </div>


                    </div>

                    <!-- begin item -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 130px">@lang('layout.Category') </th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                <th v-show="showWhat('expire_date')=='yes'"
                                    style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                            <!-- <th style="min-width: 100px">@lang('layout.OnHand') </th> -->
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 100px">@lang('layout.OMeasureValue') </th>

                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                <th v-show="showWhat('sale_discount')=='yes'"
                                    style="min-width: 100px">@lang('layout.Discount') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" @Click.native="setIndex(index)" v-model="item.item"
                                              :options="temp_items" @search="onItemSearch"></v-select>
                                    <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.ItemName')"
                                           :value="(!item.item)?null:item.item.id">
                                    <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>
                                    <input type="hidden" name="inventory_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td v-show="showWhat('sale_description')=='yes'">
                                    <input class="purchase_description" type="text"
                                           placeholder="@lang('layout.Description')" name="inventory_description[]"
                                           class="form-control">
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
                                    <input type="text" placeholder="@lang('layout.ExpireDate')" name="expire_date[]"
                                           class="date form-control">
                                </td>
                                <td>


                                    <input type="number" :name="'quantity['+index+']'" v-validate="'required'"
                                           data-vv-as="@lang('layout.Quantity')"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                    <span class="required">@{{ errors.first('quantity['+index+']') }}</span>
                                </td>

                                <!--  <td>
                                    @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                                 </td> -->
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>


                                    </select>

                                    <input type="hidden" name="measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.Cost')"
                                               :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate)"
                                               ref="in" @input="setNewRate(index)" class="form-control">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <td v-show="showWhat('sale_discount')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="inventory_discount[]"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="(item.item==null)?null:item.item.discount"
                                               class="form-control">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                        @{{selected_currency.symbol}}
                                      </span>
                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                        %
                                      </span>
                                    </div>

                                </td>

                                <td>
                                    @{{
                                    (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate).result
                                    }}
                                    <b>@{{selected_currency.symbol}}</b>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>

                    </div>
                    <span v-if="inventories.length==0">
                         <button type="button" @click="addNew('inventory',0)" class="btn btn-success"><i
                                     class="fa fa-plus"></i></button>
                      </span>

                    <!-- end item -->

                    <!-- begin shareholder -->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                        <tr>
                            <th class="text-center" style="min-width: 8px;"> #</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.Shareholder')</th>
                            <th class="text-center" style="min-width: 160px;">@lang('layout.Percentage')</th>
                            <th></th>

                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(record,index) in shareholderData">
                            <td>@{{index+1}}</td>
                            <td class="highlight">
                                <v-select label="name" v-model="record.selected" :options="(record.shareholder_list)"
                                          @click.native="addNew('shareholder',index)"
                                          placeholder="@lang('layout.Select')">

                                </v-select>
                                <input type="hidden" name="shareholder_id[]"
                                       :value="(record.selected==null)?null:record.selected.id">
                            </td>

                            <td>
                                <input class="form-control" type="number" name="percentage[]"
                                       v-model.number="record.percentage" placeholder="@lang('layout.Percentage')">
                            </td>

                            <td>
                                <span v-on:click="deleteItem('shareholder',index)"><i
                                            class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <!-- end shareholder -->


                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                    <a href="{{route('contract.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        Vue.component('v-select', VueSelect.VueSelect);


        var banks = {!! $banks!!}
        var Member = {!!$member!!}
        var currency = {!! $currency!!}
        var shareholder ={!! $shareholder!!};
        var owner ={!! $owner!!};
        var inventory_category = {!! $inventory_category !!};
        // group of company
        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};

        var v = new Vue({
            el: '#app',
            data: {
                currency: currency,
                selected_currency: homeCurrency,
                selectedMember: null,
                listAccounts: [],
                type: 'bank',
                banks: banks,
                selected_banks: null,
                shareholder: shareholder,
                owner: owner,
                selected_owner: null,
                shareholderData: [
                    {percentage: 0, shareholder_list: this.shareholder, selected: null},
                    {percentage: 0, shareholder_list: this.shareholder, selected: null},
                ],
                rate: 0,
                temp_items: [],
                inventory_category: inventory_category,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,

                inventories: [
                    {item: null, item_category: null}
                ],


                discountFiled: 0,
                discountIsAmount: true,
            },
            computed: {

                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    this.banks = [];

                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });

                    return rates;

                },
                accountUpdate() {
                    var b = _.clone(Banks)
                    return this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },
                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }


                        }
                        // this.totalAmountes=sum;

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    return sum;
                },


                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            methods:
                {

                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // set new price
                    setNewRate(index) {

                        if (this.inventories[index].item) {
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        }
                    },
                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: "itemSearchPurchase",
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {

                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {

                            let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchPurchase',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }

                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: this.selected_iventory_category});
                                }
                            }
                            if (type == 'shareholder') {

                                if (this.shareholderData[index + 1] == undefined) {
                                    //this.temp_items=[];
                                    this.shareholderData.push({
                                        percentage: 0,
                                        shareholder_list: this.shareholder,
                                        selected: null
                                    });
                                }
                            }
                        }

                    },


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'shareholder') {
                                this.shareholderData.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {


                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("contract-form").submit()

                            }
                            else {

                            }
                        });

                    },

                    defaultValue() {

                        this.inventories = [
                            {item: null, item_category: this.selected_iventory_category},
                        ];


                        this.discountFiled = 0;
                        this.temp_items = [];
                    },
                    saveAndNew()
                    {
                        this.$validator.validate()
                        .then(valid =>{
                            if(valid)
                            {
                                var url="{{route('contract.store')}}";
                                form_id='contract-form';
                                var data= $('#'+form_id).serialize();
                                // console.log(444, data);
                                toggleBlock(true);
                                axios.post(url,data)
                                .then(function(response){
                                        toggleBlock(0);
                                        if(response.data.result==1)
                                        {
                                            $('#'+form_id).trigger('reset');
                                            
                                            toastr.success('',response.data.message); 
                                            location.reload();
                                        
                                        }
                                        else
                                        {
                                            var message="{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('',message);
                                        }
                                })
                                .catch(function(error){
                                toggleBlock(0);
                                    console.log(error);
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                });
                            
                            }
                        })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush