@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('contract', 'index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.FarmerContractReport')</h3>
<table class="main-table">
    <tr class="bg">
        <th colspan="4" style="font-weight: bold; font-size:20px">@lang('layout.Customer')</th>
    </tr>
    <tr class="bg">
        <th>@lang('layout.Code')</th>
        <th>@lang('layout.Name')</th>
        <th>@lang('layout.Phone')</th>
        <th>@lang('layout.FatherName')</th>
    </tr>
    <tr>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->code }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->name }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->phone }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->father_name }} </td>
    </tr>
    <tr class="bg">

        <!-- <th>@lang('layout.Country')</th> -->
        <th>@lang('layout.City')</th>
        <th>@lang('layout.District')</th>
        <th>@lang('layout.Village')</th>
        <th>@lang('layout.Address')</th>
    </tr>
    <tr>

        <!-- <td class="hidden-xs" style="text-align:center"> {{ $customer->country }}  </td> -->
        <td class="hidden-xs" style="text-align:center"> {{ $customer->city }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->district }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->village }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ $customer->address1 }} </td>
    </tr>


</table>
<hr />

<table class="main-table">
    <tr class="bg">
        <th colspan="4" style="font-weight: bold; font-size:20px">@lang('layout.Guarantor')</th>
    </tr>
    <tr class="bg">
        <th>@lang('layout.Name')</th>
        <th>@lang('layout.FatherName')</th>
        <th>@lang('layout.Phone')</th>
        <th>@lang('layout.Address')</th>
    </tr>
    <tr>
        <td class="hidden-xs" style="text-align:center"> {{ ($member_guar)? $member_guar->name:''}} </td>
        <td class="hidden-xs" style="text-align:center"> {{ ($member_guar)? $member_guar->father_name:''}} </td>
        <td class="hidden-xs" style="text-align:center"> {{ ($member_guar)? $member_guar->phone:'' }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ ($member_guar)? $member_guar->address:'' }} </td>
    </tr>
    <tr class="bg">
        <th>@lang('layout.Country')</th>
        <th>@lang('layout.City')</th>
        <th>@lang('layout.District')</th>
        <th>@lang('layout.Village')</th>
    </tr>
    <tr>
        <td class="hidden-xs" style="text-align:center"> {{ ($member_guar)? $member_guar->country:'' }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ ($member_guar)? $member_guar->city:'' }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ ($member_guar)? $member_guar->district:'' }} </td>
        <td class="hidden-xs" style="text-align:center"> {{ ($member_guar)? $member_guar->village:'' }} </td>
    </tr>


</table>
<hr />

<h3>@lang('layout.FarmerContract')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.LandSize')</th>
            <th>@lang('layout.DrawingAmount')</th>
            <th>@lang('layout.Unit')</th>
            <th>@lang('layout.SeedAmount')</th>
            <th>@lang('layout.Unit')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.OverdueDate')</th>
            <th>@lang('layout.Description')</th>

        </tr>
    </thead>
    <?php
    $count = 0;
    // dd($data);
    ?>
    <tr>
        <td class="center">{{$data->number}}</td>
        <td class="center">{{$data->ref_no}}</td>
        <td class="center">{{$data->land_size}}</td>
        <td class="center">{{$data->land_drawing_amount}}</td>
        <td class="center">{{$data->land_measure}}</td>
        <td class="center">{{$data->seed_amount}}</td>
        <td class="center">{{$data->measure}}</td>
        <td class="center">{{convertDate($data->Date)}}</td>
        <td class="center">{{convertDate($data->overdueDate)}}</td>
        <td class="center">{{$data->sale_description}}</td>

    </tr>
</table>
<hr />

<h3>@lang('layout.DeliveryItem')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>#</th>
            @if(getSerailNumber() =="true")
            <th>@lang('layout.SerialNum')</th>
            @endif
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Site')</th>
            <th>@lang('layout.PurchaseDate')</th>
            @if(getOtherMeasure()=="true")
            <th>@lang('layout.OMeasureValue1')</th>
            @endif
            @if(getOtherMeasure2()=="true")
            <th>@lang('layout.OMeasureValue2')</th>
            @endif
            <th>@lang('layout.Unit/M')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Price')</th>
            <th>@lang('layout.Cost')</th>
            <th>@lang('layout.GrossProfit')</th>
            <th>@lang('layout.Total')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($sales AS $record1)
    <tr>
        <td class="center">{{++$count}}</td>
        @if(getSerailNumber() == "true")
        <td class="center">{{$record1->number}}</td>
        @endif
        <td class="center">{{$record1->name}}</td>
        <td class="center">{{$record1->siteName}}</td>
        <td class="center">{{convertDate($record1->stocks_date)}}</td>
        @if(getOtherMeasure() == "true")
        <td class="center">{{$record1->other_measure}}</td>
        @endif
        @if(getOtherMeasure2() == "true")
        <td class="center">{{$record1->other_measure2}}</td>
        @endif
        <td class="center">{{$record1->symbol}}</td>
        <td class="center">{{$record1->qty}}</td>
        <td class="center">{{myRound($record1->price * $invoice->rate)}}</td>
        <td class="center">{{myRound(($record1->avgCost * $record1->saleUnit) / $record1->itemUnit * $invoice->rate)}}</td>
        <td class="center">{{myRound($record1->income * $invoice->rate)}}</td>
        <td class="center">{{myRound($record1->qty * $record1->price * $invoice->rate)}}</td>
    </tr>
    @endforeach
</table>
<hr />

<h3>@lang('layout.PaymentList')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>#</th>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Name')</th>
            <th>@lang('layout.Account')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.User')</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $currencies = [];
    ?>
    @foreach($pay AS $record2)
    <?php 
        if (array_key_exists($record2->currency, $currencies)) {
            $currencies[$record2->currency] = $currencies[$record2->currency] + $record2->amount;
        } else {
            $currencies[$record2->currency] = $record2->amount;
        }
    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record2->payment_number}}</td>
        <td class="center">{{$record2->ref_no}}</td>
        <td class="center">{{$record2->Name}}</td>
        <td class="center">{{$record2->Account}}</td>
        <td class="center">{{__('type.' . $record2->Payment_type)}}</td>
        <td class="center">{{$record2->amount}}</td>
        <td class="center">{{$record2->currency}}</td>
        <td class="center">{{$record2->Rate}}</td>
        <td class="center">{{convertDate($record2->Date)}}</td>
        <td class="center">{{$record2->username}}</td>
        <td class="center">{{$record2->Description}}</td>
    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="7">
            <div class="center">@lang('layout.Currency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Category') </div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key1 => $curr) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{$key1}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{round($curr,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
</table>
<hr />

<h3>@lang('layout.ReceiveList')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>#</th>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Name')</th>
            <th>@lang('layout.Account')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.User')</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $currencies = [];
    ?>
    @foreach($receive AS $record3)
    <?php 
        if (array_key_exists($record3->currency, $currencies)) {
            $currencies[$record3->currency] = $currencies[$record3->currency] + $record3->amount;
        } else {
            $currencies[$record3->currency] = $record3->amount;
        }
    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record3->number}}</td>
        <td class="center">{{$record3->ref_no}}</td>
        <td class="center">{{$record3->name}}</td>
        <td class="center">{{$record3->account}}</td>
        <td class="center">{{__('type.' . $record3->type)}}</td>
        <td class="center">{{$record3->amount}}</td>
        <td class="center">{{$record3->currency}}</td>
        <td class="center">{{$record3->rate}}</td>
        <td class="center">{{convertDate($record3->date)}}</td>
        <td class="center">{{$record3->username}}</td>
        <td class="center">{{$record3->description}}</td>
    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="7">
            <div class="center">@lang('layout.Currency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Category') </div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key1 => $curr) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{$key1}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{round($curr,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
</table>
<hr />

<h3>@lang('layout.ReceiveItem')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>#</th>
            <th>@lang('layout.PurchaseNumber') </th>
            <th>@lang('layout.ItemName') </th>
            <th>@lang('layout.Type')</th>
            @if(getOtherMeasure()=="true")
            <th>@lang('layout.OMeasureValue1')</th>
            @endif
            @if(getOtherMeasure2()=="true")
            <th>@lang('layout.OMeasureValue2')</th>
            @endif
            <th>@lang('layout.Quantity') </th>
            <th>@lang('layout.Measure') </th>
            <th>@lang('layout.PurchaseCost') </th>
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Expense') </th>
            <th>@lang('layout.CostOfGoodSold') </th>
            <th>@lang('layout.TotalPurchaseCost') </th>
            <th>@lang('layout.TotalCostOfGoodSold') </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $totalQty = 0;
    $total_home_currency = 0;
    $currencies = [];
    $measures = [];
    ?>
    @foreach($billDetails AS $record)
    <tr>
        <?php
            if (array_key_exists($record->Currency, $currencies)) {
                $currencies[$record->Currency] = $currencies[$record->Currency] + (($record->Amount + ($record->expense_cost * $record->Rate)) * $record->qty);
            } else {
                $currencies[$record->Currency] = (($record->Amount + ($record->expense_cost * $record->Rate)) * $record->qty);
            }
            if (array_key_exists($record->farmer_type, $measures)) {
                $measures[$record->farmer_type] = array('mea' => $record->measure, 'qut' => ($measures[$record->farmer_type]['qut'] + $record->qty));
            } else {
                $measures[$record->farmer_type] = array('mea' => $record->measure, 'qut' => $record->qty);
            }

            if ($record->farmer_type == 'Drawing') {
                $totalQty += ($record->qty * $record->measureUnit);
            }
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->p_number}}</td>
        <td class="center">{{$record->items}}</td>
        <td class="center">{{__('layout.'.$record->farmer_type)}}</td>
        @if(getOtherMeasure()=="true")
        <td class="center">{{$record->other_measure}}</td>
        @endif
        @if(getOtherMeasure2()=="true")
        <td class="center">{{$record->other_measure2}}</td>
        @endif
        <td class="center">{{($record->qty * $record->measureUnit / ($record->purchaeMeasureUnit))}}</td>
        <td class="center">{{$record->purchaseMeasure}}</td>
        <td class="center">{{$record->Amount}}</td>
        <td class="center">{{$record->Currency}}</td>
        <td class="center">{{($record->expense_cost * $record->Rate)}}</td>
        <td class="center">{{($record->Amount + ($record->expense_cost * $record->Rate))}}</td>
        <td class="center">{{$record->Total}}</td>
        <td class="center">{{(($record->Amount + ($record->expense_cost * $record->Rate)) * $record->qty)}}</td>
    </tr>

    @endforeach
    <tr class="bg">
        <td colspan="7">
            <div class="center">@lang('layout.PerUnit')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Measure') </div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Quantity') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    // dd($measures);
    foreach ($measures as $key => $meas) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{__('layout.'.$key)}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{round($meas['qut'],2)}} {{$meas['mea']}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr class="bg">
        <td colspan="7">
            <div class="center">@lang('layout.Currency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Category') </div>
        </td>
        <td colspan="3">
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key1 => $curr) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{$key1}}</div>
            </td>
            <td colspan="3">
                <div class="center">{{round($curr,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
</table>


<hr />

<h3>@lang('layout.Differ')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.LandSize')</th>
            <th>@lang('layout.ConfirmQuantity')</th>
            <th>@lang('layout.Unit')</th>
            <th>@lang('layout.DrawingQuantity')</th>
            <th>@lang('layout.Differ')</th>

        </tr>
    </thead>
    <?php
    $count = 0;
    if ($data->land_measure_unit > 0) {
        $totalQty = ($totalQty / $data->land_measure_unit);
    }
    ?>
    <tr>
        <td class="center">{{$data->land_size}}</td>
        <td class="center">{{$data->land_drawing_amount}}</td>
        <td class="center">{{$data->land_measure}}</td>
        <td class="center">{{$totalQty}}</td>
        <td class="center">{{$totalQty - $data->land_drawing_amount}} {{($totalQty - $data->land_drawing_amount > 0)? __('layout.ExtraQuantity'):__('layout.LeakageQuantity')}} </td>
    </tr>
</table>


@endsection