@extends('layouts.factor-master')

@section('content')



    <h3 class="table-caption" style="text-align: center;">@lang('layout.ContractItemExpenseReport')</h3>
    <table style="width: 100%; margin-bottom: 10px;">
        @if($info && $info !=[])

            <tr>
                <td>
                    <span>@lang('layout.ContractNumber')</span>:
                    <span>{{$info->contract_no}}</span>
                </td>
                <td>
                    <span>@lang('layout.MemberName')</span>:
                    <span>{{$info->name}}</span>
                </td>
                <td>
                    <span>@lang('layout.ContractName')</span>:
                    <span>{{$info->company_name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Description')</span>:
                    <span>{{$info->description}}</span>
                </td>
            </tr>

        @endif

    </table>
    @if($wagon_number)
        <span>@lang('layout.WagonNumber'): {{$wagon_number}}</span>
    @endif


    <table class="main-table">
        <thead>
        <tr class="bg">


            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Description')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Measure')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.ExpenseType')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Total')</th>


        </tr>
        </thead>
        <?php
        $count = 0;
        $total_expense = [];
        ?>
        @foreach($data AS $record)
        <?php
            $amount = 0;
            if ($record->category == 'perUnit') {
                $amount = $record->amount*$record->quantity;
            } else {
                $amount = $record->amount;
            }



            if (array_key_exists($record->currency, $total_expense)) {
                $total_expense[$record->currency] = $total_expense[$record->currency]+$amount;
            }
            else
            {
                $total_expense[$record->currency] = $amount;
            }
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->description}}</td>
                <td class="center">{{$record->item_name}}</td>
                <td class="center">{{$record->measure}}</td>
                <td class="center">{{$record->quantity}}</td>
                <td class="center">{{__('layout.'.ucfirst($record->category))}}</td>
                <td class="center">{{$record->currency}}</td>
                <td class="center">{{$record->rate}}</td>
                <td class="center">{{myRound($record->amount)}}</td>
                <td class="center">{{$record->itemExpenseCategory}}</td>
                <td class="center">{{myRound($amount)}}</td>


            </tr>
        @endforeach
    </table>

<br>
    <table class="main-table">
        <tr class="bg">
            <td colspan="2" style="text-align: center;font-size: 18px;font-weight: bold;">@lang('layout.TotalExpense')</td>
        </tr>

        <?php
            foreach ($total_expense as $key => $expense) {
            
        ?>
        <tr>
            <td>{{$key}}</td>
            <td>{{$expense}}</td>
        </tr>


    <?php 
    }
    ?>
    </table>


         <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection