@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('contract');
    $_code = in_array('code', $report);
    $_date = in_array('date', $report);
    $_contract_name = in_array('contract_name', $report);
    $_vendor = in_array('vendor', $report);
    $_bank = in_array('bank', $report);
    $_price = in_array('price', $report);
    $_amount = in_array('amount', $report);
    $_currency = in_array('currency', $report);
    $_rate = in_array('rate', $report);
    $_total_in_home_currency = in_array('total_in_home_currency', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.ContructReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">

            <!-- <td><div class="center"> #</div></td> -->
            @if($_code)
                <td>
                    <div class="center"> @lang('layout.Code') </div>
                </td>@endif
            @if($_date)
                <td>
                    <div class="center"> @lang('layout.Date')</div>
                </td>@endif
            @if($_contract_name)
                <td>
                    <div class="center"> @lang('layout.ContractName')</div>
                </td>@endif
            @if($_vendor)
                <td>
                    <div class="center"> @lang('layout.Vendor')</div>
                </td>@endif
            @if($_contract_name)
                <td>
                    <div class="center"> @lang('layout.Description')</div>
                </td>@endif
            @if($_bank)
                <td>
                    <div class="center"> @lang('layout.Bank')</div>
                </td>@endif
            @if($_amount)
                <td>
                    <div class="center"> @lang('layout.Amount')</div>
                </td>@endif
            @if($_currency)
                <td>
                    <div class="center"> @lang('layout.Currency')</div>
                </td>@endif
            @if($_rate)
                <td>
                    <div class="center"> @lang('layout.Rate')</div>
                </td>@endif
            {{-- <td><div class="center"> @lang('layout.DiscountType')</div></td> --}}
            @if($_total_in_home_currency)
                <td>
                    <div class="center"> @lang('layout.TotalInDollar')</div>
                </td> @endif
                <td>
                    <div class="center"> @lang('layout.User')</div>
                </td>

        </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <tr>
            <?php

            $total_home_currency += $record->Amount / $record->Rate;
            if (array_key_exists($record->Currency, $currencies)) {
                $currencies[$record->Currency] = $currencies[$record->Currency] + $record->Amount;
            } else {

                $currencies[$record->Currency] = $record->Amount;
            }
            ?>
            <tr>
            <!-- <td class="center">{{++$count}}</td> -->
                @if($_code)
                    <td class="center">{{$record->Contract_Code}}</td>@endif
                @if($_date)
                    <td class="center">{{convertDate($record->Date)}}</td>@endif
                @if($_contract_name)
                    <td class="center">{{$record->Contract_Name}}</td>@endif
                @if($_vendor)
                    <td class="center">{{$record->Customer}}</td>@endif
                @if($_contract_name)
                    <td class="center">{{$record->description}}</td>@endif
                @if($_bank)
                    <td class="center">{{$record->Account}}</td>@endif
                @if($_amount)
                    <td class="center">{{round($record->Amount,2)}}</td>@endif
                @if($_currency)
                    <td class="center">{{$record->Currency}}</td>@endif
                @if($_rate)
                    <td class="center">{{$record->Rate}}</td>@endif
                @if($_total_in_home_currency)
                    <td class="center">{{round($record->totalInDollar,2)}}</td>@endif
                    <td class="center">{{$record->user}}</td>
            </tr>
        @endforeach

    </table>
    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency )
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
        <?php
        }
        ?>
        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}}   {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection