@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CompanyLicenseEdit')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            {!! Form::model($companyLicense, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['companyLicense.update',$companyLicense->id]]) !!}
            <div class="form-body" id="app">

                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.Name'):</label>
                            <div class="col-md-9">
                                {{Form::text('license_name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Name'),'autofocus'=>'autofocus'])}}
                                <span class="required">@{{ errors.first('license_name') }}</span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.Number'):</label>
                            <div class="col-md-9">
                                {{Form::text('license_number',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Number')])}}
                                <span class="required">@{{ errors.first('license_number') }}</span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.LicenseType'):</label>
                            <div class="col-md-9">
                                {{Form::text('license_type',null,['class' => 'form-control'])}}
                                {{-- <span class="required">@{{ errors.first('license_number') }}</span> --}}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.LicenseIssueDate'):</label>
                            <div class="col-md-9">
                                {{Form::text('license_issue_date',null,['class' => 'form-control date', 'autocomplete' => 'off'])}}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label col-md-3">@lang('layout.LicenseExpireDate'):</label>
                            <div class="col-md-9">
                                {{Form::text('license_expire_date',null,['class' => 'form-control date', 'autocomplete' => 'off'])}}
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                <button href="{{url('companyLicense.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        let vu = new Vue({
        el: '#app',
        data: {
            amount_type: "",
        },
        methods: {

        }
    })


    </script>
@endpush