@extends('layouts.app')
@section('content')
@section('style')

@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomsExpenseOption')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="cloth_category" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'customsExpenseOption.store','method'=>'POST','class'=>'form-horizontal','id'=>'customsExpenseCategory-submit')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <input type="hidden" name="id" v-model="id">
                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-6">
                            <label class="control-label col-md-3">@lang('layout.CustomsAmount'):</label>
                            <div class="col-md-9">
                                {{Form::number('customs_amount', null,['class' => 'form-control','v-model' =>'customs_amount','v-validate' =>'"required"','data-vv-as' => __('layout.CustomsAmount'),'autofocus'=>'autofocus'])}}
                                <span class="required">@{{ errors.first('customs_amount') }}</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="control-label col-md-3">@lang('layout.CustomsPercent'):</label>
                            <div class="col-md-9">
                                {{Form::text('customs_percent',null,['class' => 'form-control','v-model' =>'customs_percent','v-validate' =>'"required"','data-vv-as' => __('layout.CustomsPercent')])}}
                                <span class="required">@{{ errors.first('customs_percent') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group" style="margin-bottom: 15px;">
                        <div class="col-md-6">
                            <label class="control-label col-md-3">@lang('layout.TaxPercent'):</label>
                            <div class="col-md-9">
                                {{Form::text('tax_percent',null,['class' => 'form-control','v-model' =>'tax_percent','v-validate' =>'"required"','data-vv-as' => __('layout.TaxPercent')])}}
                                <span class="required">@{{ errors.first('tax_percent') }}</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="control-label col-md-3">@lang('layout.HelalAhmarPercent'):</label>
                            <div class="col-md-9">
                                {{Form::text('helal_ahmar_percent',null,['class' => 'form-control','v-model' =>'helal_ahmar_percent','v-validate' =>'"required"','data-vv-as' => __('layout.HelalAhmarPercent')])}}
                                <span class="required">@{{ errors.first('helal_ahmar_percent') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                {{-- <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> --}}
                <a href="{{route('customsExpenseCategory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        let vu = new Vue({
                el: '#cloth_category',
                data: {
                    id: null,
                    customs_amount: null,
                    customs_percent: null,
                    tax_percent: null,
                    helal_ahmar_percent: null,
                },
                mounted() {
                    @if($customsExpenseOption)
                        @if($customsExpenseOption->customs_amount)
                        this.customs_amount = {{$customsExpenseOption->customs_amount}};
                        @endif
                        @if($customsExpenseOption->customs_percent)
                        this.customs_percent = {{$customsExpenseOption->customs_percent}};
                        @endif
                        @if($customsExpenseOption->tax_percent)
                        this.tax_percent = {{$customsExpenseOption->tax_percent}};
                        @endif
                        @if($customsExpenseOption->helal_ahmar_percent)
                        this.helal_ahmar_percent = {{$customsExpenseOption->helal_ahmar_percent}};
                        @endif
                        @if($customsExpenseOption->id)
                        this.id = {{$customsExpenseOption->id}};
                        @endif
                    @endif
                },
                methods: {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },
                    saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('customsExpenseCategory.store')}}";
                                form_id = 'customsExpenseCategory-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },
                }
            })
    </script>
@endpush
