@extends('layouts.app')
@section('style')
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-markdown/css/bootstrap-markdown.min.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.css') }}" rel="stylesheet" type="text/css"/>
@endsection
@section('content')
 
    <h3 style="color:red; ">@lang('layout.SomeOfThisInformationOnlyShowsInThisAccount')</h3>
    <hr/>
    {{Form::open(array('route'=>'company.store', 'method'=>'POST','enctype'=>'multipart/form-data'))}}
    <div style="margin-top: 10px" id="app" class="tabbable-line">
        <?php
            $logo = null;
            if($company && $company->logo!=null)
            {
                $logo =  $company->logo;
            }
        ?>
        <div class="row" style="padding: 10px;">
            <div style="border: 1px solid rgb(218, 218, 218);border-radius: 5px; padding: 10px;">
                <div class="col-md-4">
                    <div class="form-group">
                    {{Form::label('name', __('layout.CompanyName'))}}
                    <!-- <div class="col-md-9"> -->
                 {{--
                      {{Form::text('name',(!$company_details)?null: $company_details->company_name, ['class'=>'form-control', 'placeholder'=>__('layout.CompanyName')])}}  --}}
                    <!-- </div> -->
    
                    <textarea id="company_name_editor" class="form-control" name="name">{!! (!$company_details)?null: $company_details->company_name!!}
                    </textarea>
                    <input type="hidden" name="company_id" value="{{(!$company)?null: $company->id}}">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {{Form::label('city', __('layout.City'))}}
                      {{--
                         {{Form::text('city', (!$company_details)?null: $company_details->city, ['class'=>'form-control', 'placeholder'=>__('layout.City')])}} --}} 
    
                        <textarea id="city_editor" class="form-control" name="city">{!! (!$company_details)?null: $company_details->city!!}
                       </textarea>
    
                    </div>
                </div>
                <div class="col-md-4" style=" padding-top: 20px; display: flex; gap: 5px;">
                    <div class="form-group" style="width: 100%;">
                        <div class="fileinput fileinput-new" data-provides="fileinput"> 
                            <div class="fileinput-new thumbnail" style="width: 180px; height: 130px;">
                                <img src="{!!url('/uploads/'.$logo)!!}" alt=""/>
                            </div>
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 180px; max-height: 130px;"></div>
                            <div>
                                <span class="btn default btn-file">
                                    <span class="fileinput-new">@lang('layout.ComapyLogo')</span>
                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                    <!-- <input type="file" name="photo">  -->
                                    {!! Form::file('photo', []) !!}
                                </span>
                                {!! Form::hidden('photo1', (!$company)?null:$company->logo) !!}
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                            </div>
                        </div>
                    </div>
                    <div  style="width: 100%;">
                        <div class="form-group" style="margin-bottom: 10px;">
                            {{Form::label('color', __('layout.TextColor'))}}
                            {{Form::color('color', (!$company)?null: $company->color, ['class'=>'form-control'])}}
                        </div>
                        @if($company->tag == 1)
                            <div class="form-group">
                                <label class="control-label"><i class="fa fa-calendar" style="color: green;"></i> @lang('layout.FiscalYearDate')</label>
                                <input type="text" name="fiscal_year_date" class="form-control date" value="{{(!$fiscal_year_date)?null: $fiscal_year_date}}" autocomplete="off">
                            </div>
                        @endif
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {{Form::label('country', __('layout.Country'))}}

                        {{--
                        {{Form::text('country', (!$company_details)?null: $company_details->country, ['class'=>'form-control', 'placeholder'=>__('layout.Country')])}}
                        --}} 


                        <textarea id="country_editor" class="form-control" name="country">{!! (!$company_details)?null: $company_details->country!!}
                        </textarea>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {{Form::label('phone', __('layout.Phone'))}}
                        {{--
                            {{Form::text('phone', (!$company)?null: $company->phone, ['class'=>'form-control', 'placeholder'=>__('layout.Phone')])}}
                            --}}

                            <textarea id="phone_editor" class="form-control" name="phone">{!! (!$company)?null: $company->phone!!}
                        </textarea>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {{Form::label('email', __('layout.Email'))}}
                        {{--
                            {{Form::text('email', (!$company)?null:$company->email, ['class'=>'form-control', 'placeholder'=>__('layout.Email')])}}
                            --}}

                        <textarea id="email_editor" class="form-control" name="email">{!! (!$company)?null: $company->email!!}
                        </textarea>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {{Form::label('webSite', __('layout.WebSite'))}}
                        {{--
                            {{Form::text('webSite', (!$company)?null:$company->website, ['class'=>'form-control', 'placeholder'=> __('layout.WebSite')])}}

                            --}}

                        <textarea id="webSite_editor" class="form-control" name="webSite">{!! (!$company)?null: $company->website!!}
                        </textarea>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {{Form::label('bank', __('layout.BankNumber'))}} 
                        {{-- {{Form::text('bank', (!$company_details)?null: $company_details->bank, ['class'=>'form-control', 'placeholder'=>__('layout.BankNumber')])}}
                        --}} 
                        <textarea id="bank_editor" class="form-control" name="bank">{!! (!$company_details)?null: $company_details->bank!!}
                        </textarea>
                    </div>


                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        {{Form::label('streetAddress', __('layout.StreetAddress'))}}
                        {{--
                            {{Form::text('streetAddress',(!$company_details)?null: $company_details->street_address, ['class'=>'form-control', 'placeholder'=>__('layout.StreetAddress')])}}
                            --}}
                        

                        <textarea id="streetAddress_editor" class="form-control" name="streetAddress">{!! (!$company_details)?null: $company_details->street_address!!}
                        </textarea>
                    </div>
                </div> 
                <div class="col-md-4">
                    <div class="form-group last">
                        <label>@lang('layout.CompanyInformation')</label>
                        <textarea name="editor2" class="form-control" id="summernote_1">{!! (!$company_details)?null: $company_details->description!!}</textarea>
                    </div>
                </div>
                @if(systemConfig()[31] == 1)
                <div class="col-md-4">
                    <div>
                        {!! DNS2D::getBarcodeSVG("$mobile_qrcode", "QRCODE", 6, 6,$qr_color) !!}
                    </div>
                </div>
                @endif
                <div class="col-md-12 mt-radio-inline" >
                    <div style="border: 1px solid rgb(222, 222, 222);border-radius: 5px; padding: 5px;">
                        <h3 style="color:red; ">@lang('layout.CompanyType')</h3>
                        <div style="display: flex; justify-content: center; align-items: center;">
                            <div style=" width: 100%; display: flex; justify-content: center; align-items: center;align-content: center; padding-bottom: 0px !important;">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="sole" class="mt-radio">@lang('layout.SoleProprietorship')</label>
                                        <input type="radio" name="type" id="sole" v-model="type" value="sole">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="llp" class="mt-radio">@lang('layout.llp')</label>
                                        <input type="radio" name="type" id="llp" v-model="type" value="llp">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="llc" lass="mt-radio">@lang('layout.llc')</label>
                                        <input type="radio" name="type" id="llc" v-model="type" value="llc">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div style="border: 1px solid rgb(222, 222, 222);border-radius: 5px; padding: 5px;">
                        <h3 style="color:red; ">@lang('layout.Whatsapp')</h3>
                        <div style="display: flex; justify-content: center; align-items: center;">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label" for="back_site_link" > @lang('layout.Whatsapp') ID </label>
                                    <input type="number"  class="form-control" name="whatsapp_id" value="{{$company->whatsapp_id}}" />
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label" for="back_site_link" > @lang('layout.Phone') @lang('layout.Whatsapp') </label>
                                    <input type="number" class="form-control" name="whatsapp_number" value="{{$company->whatsapp_number}}" />
                                </div>
                            </div>
                        </div>
                        <div style="display: flex; justify-content: center; align-items: center;">
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label" for="back_site_link" > @lang('layout.Message') @lang('layout.Whatsapp') </label>
                                    <input type="number"  class="form-control" readonly value="{{$fileDataM}}" />
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label" for="back_site_link" > @lang('layout.SendMessage') @lang('layout.Whatsapp') </label>
                                    <input type="number" class="form-control" readonly value="{{$fileData}}" />
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="col-md-12">
                                    <label class="control-label" for="back_site_link" > @lang('layout.Message') @lang('layout.Remain') @lang('layout.Whatsapp') </label>
                                    <input type="number" class="form-control" readonly value="{{(round($fileDataM) - round($fileData))}}" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                @if (fingerprint() == 'true')
                <div class="row col-lg-8 col-md-12 col-sm-12 col-xs-12">
                    
                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                        <div class="">
                            <label class="control-label" for="back_site_link" > IP </label>
                            <input type="text" name="finger_ip" class="form-control" value="{{$company->finger_ip}}" placeholder="IP" />
                        </div>
                    </div>
                    <div class="col-lg-6  col-md-6 col-sm-12 col-xs-12">
                        <div class="">
                            <label class="control-label" for="back_site_link" > Port </label>
                            <input type="number" name="finger_port" class="form-control" value="{{$company->finger_port}}" placeholder="Port" />
                        </div>
                    </div>
                    <div class="col-md-12">
                        <p>@lang('layout.Fingerprint')</p>
                    </div>
                </div>
                @endif

                @if(getTelegramBot()=="true")
                
                <div class="row col-lg-4 col-md-12 col-sm-12 col-xs-12">
                    <div class="col-lg-12 col-md-4 col-sm-12 col-xs-12">
                        <br/>
                        <div class="">
                            <label class="control-label"  > @lang('layout.TelegramToken')</label>
                            <textarea name="telegram_bot_api" rows="1" class="form-control">{{$company->telegram_bot_api}}</textarea>
                            {{-- <input type="text" name="telegram_bot_api" class="form-control" value="{{$company->telegram_bot_api}}" /> --}}
                        </div>
                    </div>
                </div>
                @endif


                <div class="portlet light bordered">
                    <div class="portlet-title hidden-print">
                        <div class="caption font-dark">
                        </div>
                    </div>
                    <div class="portlet-body">
                        <?php
                        $fifo_check = "";
                        $lifo_check = "";
                        $average_check = "";
                        if ($company) {

                            $fifo_check = ($company->calculation_method == 'fifo') ? 'checked="checked"' : '';
                            $lifo_check = ($company->calculation_method == 'lifo') ? 'checked="checked"' : '';
                            $average_check = ($company->calculation_method == 'average') ? 'checked="checked"' : '';
                        }


                        ?>
                        <div class="row" style="border: 1px solid rgb(222, 222, 222);border-radius: 5px; padding: 10px;display: flex; justify-content: center; align-items: center; vertical-align: middle;">
                            <div class="col-md-3" style="display: flex; align-items: center;">
                                <div class="form-group">
                                    <h3 style="color:red">@lang('layout.SystemCalculationMethod')</h3>
                                </div>
                            </div>
                            <div class="col-md-3" style="margin-top: 15px;">
                                <div class="form-group">
                                    <label for="fifo" class="mt-radio">@lang('layout.FIFO')</label>
                                    <input type="radio" name="calculation_method" {{$fifo_check}} value="fifo" id="fifo">
                                </div>
                            </div>
                            <div class="col-md-3" style="margin-top: 15px;">
                                <div class="form-group">
                                    <label for="lifo" class="mt-radio">@lang('layout.LIFO')</label>
                                    <input type="radio" name="calculation_method" {{$lifo_check}}  value="lifo" id="lifo">
                                </div>
                            </div>
                            <div class="col-md-3" style="margin-top: 15px;">
                                <div class="form-group">
                                    <label for="average" lass="mt-radio">@lang('layout.AVERAGEMETHOD')</label>
                                    <input type="radio" name="calculation_method" {{$average_check}}  value="average" id="average">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="portlet light bordered">

                    <div class="portlet-body">
                        <h3 style="color:red">@lang('layout.VoucherMessage')</h3>


                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.InventoryTransferMessage')</label>
                                    <textarea class="form-control" id="transfer_message_editor" 
                                                name="inventory_transfer_message">{{(!$company_details)?null: $company_details->inventory_transfer_message}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.InvoiceMessage')</label>
                                    {{--
                                        <textarea class="form-control"
                                                name="invoice_message">{{(!$company_details)?null: $company_details->invoice_message}}</textarea>
                                        --}}

                                    <textarea id="invoice_message_editor" class="form-control" name="invoice_message">{!! (!$company_details)?null: $company_details->invoice_message!!}
                                        </textarea>

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.GrnMessage')</label>
                                    <textarea class="form-control" id="grn_message_editor" 
                                                name="grn_message">{{(!$company_details)?null: $company_details->grn_message}}</textarea>
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.ReceiverMessage')</label>
                                    <textarea class="form-control" id="receive_message_editor" 
                                                name="receiver_message">{{(!$company_details)?null: $company_details->receiver_message}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.PayMessage')</label>
                                    <textarea class="form-control" id="payment_message_editor" 
                                                name="pay_message">{{(!$company_details)?null: $company_details->pay_message}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.PaySalaryMessage')</label>
                                    <textarea class="form-control" id="paySalary_message_editor" 
                                                name="pay_salary_message">{{(!$company_details)?null: $company_details->pay_salary_message}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.Message') @lang('menu.Transactions')</label>
                                    <textarea class="form-control" id="exchange_message_editor" 
                                                name="exchange_message">{{(!$company_details)?null: $company_details->exchange_message}}</textarea>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>


                <div class="portlet light bordered">

                    <div class="portlet-body">
                        <h3 style="color:red">@lang('layout.WorkAmount')</h3>


                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.Shifty')</label>

                                                {{Form::number('shifty', (!$company_details)?null:$company_details->shifty, ['class'=>'form-control', 'placeholder'=>__('layout.Shifty')])}}
                                                
            
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('layout.Hourly')</label>
                                    {{Form::number('hourly', (!$company_details)?null:$company_details->hourly, ['class'=>'form-control', 'placeholder'=>__('layout.Hourly')])}}
                                </div>
                            </div>

                        </div>
                    </div>
                </div>


                <div class="col-md-7" style="margin-top: 10px;">
                    
                    <div class="dashboard-stat2 " style="border: 1px solid rgb(218, 218, 218);border-radius: 5px;" >
                        <div class="row">
                            <h3 style="color:red ;margin: 10px;">@lang('layout.Signature')</h3>
                            <div class="col-md-12">

                                <div class="col-md-4">
                                            {{Form::label('socialName', __('layout.Type'))}}

                                            
                                            <select name="info_type" class="form-control"  v-model="selectedType">
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="sign">@lang('layout.Signature')</option>
                                            </select>
                                        </div>
                                    </div>
                            
                        </div>
                        <div class="row">         
                            <div class="col-md-12">
                                <div v-for="(company_info,index) in company_infos">
                                    <div class="form-group" style="display: flex; justify-content: center; align-items: center;">
                                        <div class="col-md-5">
                                            {{-- {{Form::label('info_name', __('layout.Name'))}} --}}
                                            <label for="info_name" v-if="index==0">{{__('layout.Name')}}</label>
                                            <input type="text" name="info_name[]" class="form-control" v-model="company_info.info_name">
                                        </div>
                                        <div class="col-md-5">
                                            {{-- {{Form::label('voucher_name', __('layout.VoucherName'))}} --}}
                                            <label for="voucher_name" v-if="index==0">{{__('layout.VoucherName')}}</label>
                                            <select name="voucher_name[]" class="form-control" v-model = "company_info.voucher_name">
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="invoice">@lang('layout.Invoice')</option>
                                                <option value="reports">@lang('layout.Reports')</option>
                                                <option value="voucher">@lang('layout.Voucher')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-2" style="display: flex;gap: 3px;margin-top: 15px;">
                                            <a href="javascript:;" class="btn btn-circle btn-icon-only green" style="display: flex; justify-content: center; align-items: center;" @click="addNew('info',index)"><i class="fa fa-plus"></i></a>
                                            <a v-if="company_infos.length>1" href="javascript:;" style="display: flex; justify-content: center; align-items: center;" class="btn btn-circle btn-icon-only red " @click="deleteItem('info',index)"><i class="fa fa-minus"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-5" style="padding: 10px 0px;margin-top: 0px;">
                    <div style="border: 1px solid rgb(218, 218, 218);border-radius: 5px; padding: 10px;margin-bottom: 10px;">
                        <h4 style="color:red ;margin-bottom: 20px !important;">@lang('layout.SocialMedia')</h4>
                        <div v-for="(social,index) in socials" >
                            <div class="form-group" style="display: flex; justify-content: center; align-items: center;">
                                <div class="col-md-5">
                                    <label for="socialName" v-if="index==0">{{__('layout.SocialName')}}</label>
                                    <input type="text" name="socialName[]" class="form-control" v-model="social.socialName">
                                </div>
                                <div class="col-md-5">
                                    <label for="socialUrl" v-if="index==0">{{__('layout.SocialUrl')}}</label>
                                    <input type="text" name="socialUrl[]" class="form-control" v-model="social.socialUrl">
                                </div>
                                <div class="col-md-2" style="display: flex;gap: 3px;margin-top: 15px;">
                                    <a href="javascript:;" class="btn btn-circle btn-icon-only green" style="display: flex; justify-content: center; align-items: center;" @click="addrow"><i class="fa fa-plus"></i></a>
                                    <a href="javascript:;" class="btn btn-circle btn-icon-only red " style="display: flex; justify-content: center; align-items: center;" @click="removerow(index,1)"><i class="fa fa-minus"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div style="border: 1px solid rgb(218, 218, 218);border-radius: 5px; padding: 10px;">
                        <h4 style="color:red ;margin-bottom: 20px !important;">@lang('layout.Product')</h4>
                        <div v-for="(detail,index1) in products">
                            <div class="form-group" style="display: flex; justify-content: center; align-items: center;">
                                <div class="col-md-10">
                                    <label for="productName" v-if="index1==0">{{__('layout.ProductName')}}</label>
                                    <input type="text" name="productDetails[]" class="form-control" v-model="detail.details">
                                </div>
                                <div class="col-md-2" style="display: flex;gap: 3px;margin-top: 15px;">
                                    <a href="javascript:;" class="btn btn-circle btn-icon-only green" style="display: flex; justify-content: center; align-items: center;" @click="addProd"><i class="fa fa-plus"></i></a>
                                    <a href="javascript:;" class="btn btn-circle btn-icon-only red " style="display: flex; justify-content: center; align-items: center;" @click="removeProd(index1,1)"><i class="fa fa-minus"></i></a>
                                </div>
                            </div>
        
                        </div>
                    </div>
                </div>
                {{-- <div class="portlet light bordered">

                    <div class="row">

                        <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12" >
                            
                        </div>

                        <div class="col-md-5">
                            
                        </div>

                    </div>
                </div> --}}
                <br>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                @if(systemConfig()[18] == 1 )
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                @endif
                                    <a href="{{route('home.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{Form::close()}}

@endsection
@push('scripts')
    <script>

        $(document).ready(function () {

            $('#summernote_1').summernote({
                 toolbar: [
                    // [groupName, [list of button]]
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']]
                  ],
                  dialogsFade:true
            });
            $('#company_name_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#city_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#country_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#phone_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#email_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false
            });            

            $('#webSite_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,

            });            

            $('#streetAddress_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            

            $('#invoice_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#grn_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#transfer_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#receive_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#payment_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#paySalary_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            $('#exchange_message_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });            
            
            $('#bank_editor').summernote({
                 toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']]
                  ],
                  shortcuts: false,
                  
            });
        });









        var info = {!! $company !!};
        var company_contact = {!! $company_contact !!};
        var company_info    = {!! $company_info !!};
        var companyProduct    = {!! $companyProduct !!};


        new Vue({
            el: '#app',
            data: {
                socials: [],
                products: [],
                type: info['type'],
                check: false,
                info: info,
                company_contact: company_contact,
                company_info: company_info,

                 selectedType:'',
                  company_infos:[
                 
               ],
                temp_items:[]


            },
            created() {
                // console.log(1111,this.selectedType)
                if (this.company_contact.length) {
                    var len = this.company_contact.length;
                    for (var x = 0; x < len; x++) {

                        this.socials.push({
                            socialName: this.company_contact[x].social_name,
                            socialUrl: this.company_contact[x].social_address
                        });
                    }
                }
                else {

                    this.socials.push({socialName: null, socialUrl: null});
                } 
                
                if (companyProduct.length) {
                    var len = companyProduct.length;
                    for (var x = 0; x < len; x++) {

                        this.products.push({
                            details: companyProduct[x].details,
                        });
                    }
                }
                else {
                    this.products.push({details: null});
                }     

                if (this.company_info.length) {
                    var len = this.company_info.length;

                    for (var x = 0; x < len; x++) {

                        this.company_infos.push({
                            info_name: this.company_info[x].name,
                            voucher_name: this.company_info[x].voucher_name,
                        });
                        if (this.company_info[x].type) {
                        this.selectedType = this.company_info[x].type;
                        }
                    }

                }
                else {
                    this.company_infos.push({info_name: null,voucher_name: null});
                }


            },
            methods: {
                addrow() {
                    // console.log('test',this.socials);
                    this.socials.push({socialName: null, socialUrl: null});
                },
                removerow(index, id) {
                    if (this.socials.length > 1)
                        this.socials.splice(index, 1)
                },

                addProd() {
                    this.products.push({details: null});
                },
                removeProd(index, id) {
                    if (this.products.length > 1)
                        this.products.splice(index, 1)
                },


                       // generic function for adding item to list
                   addNew(type=null,index)
                   {
                      this.temp_items=[];
                      if(type !=null)
                      {
                         if(type=='info')
                         {
                            if(this.company_infos[index+1]==undefined)
                            {
                              this.temp_items=[];
                              this.company_infos.push({info_name:null,voucher_name:null});
                            }
                         }
                         
                         
                      }
                      
                   },
                   // delete item from list
                   deleteItem(type=null,index)
                   {
                     if(type !=null)
                     {
                         if(type=='info')
                         {
                            this.company_infos.splice(index, 1);
                         }
                         
                     }
                      
                   },
            }

        });


    </script>
    <script src="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/jquery.sparkline.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/app.min.js')}}" type="text/javascript"></script>
    <script src="{{url('/assets/bootstrap-fileinput/profile.min.js')}}" type="text/javascript"></script>

    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/lib/markdown.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-markdown/js/bootstrap-markdown.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.js') }}" type="text/javascript"></script>
    <script src="{{ url('/assets/pages/scripts/components-editors.js') }}" type="text/javascript"></script>
@endpush

