@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ClothStyleDetailsEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>

        
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($clothStyleDetail, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['clothStyleDetail.update',$clothStyleDetail->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('menu.ClothCategory')</label>
                                        <v-select 
                                                    label="name" 
                                                    :options="clothCategory"
                                                    v-model="selected_cloth_category"
                                                    disabled
                                                    >
                                                </v-select>
                                                <input type="hidden" name="cloth_category_id"
                                                :value="!selected_cloth_category?null:selected_cloth_category.id">
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.ClothStyle')</label>
                                        <v-select 
                                                    label="name" 
                                                    :options="clothStyle"
                                                    v-model="selected_cloth_style"
                                                    :disabled="!check"
                                                    >
                                                </v-select>
                                                <input type="hidden" name="cloth_style_id"
                                                :value="!selected_cloth_style?null:selected_cloth_style.id">
                                    </div>
                                </div>
                        </div>
                    </div>
                     <br>

                    <table id="table_content" class="table table-bordered">
                        <thead>
                        <tr>
                            <th style="min-width: 300px">@lang('layout.Name') <span class="required"> * </span></th>

                            <th>@lang('layout.Description') </th>

                        </tr>
                        </thead>
                        <tbody>
                        <tr >
                            <td class="highlight">
                                <input type="text"
                                        name="name" class="form-control" value="{{$clothStyleDetail->name}}">
                            </td>

                            <td class="highlight">
                            {{Form::textarea('description',$clothStyleDetail->description,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description')])}}
                            </td>
                            

                        </tr>
                        </tbody>
                    </table>                    
                    
                    <br>
                  
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{route('clothStyleDetail.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        let clothCategory           = {!! $clothCategory !!}
        let selected_cloth_category = {!! $selected_cloth_category !!}
        
        let clothStyle           = {!! $clothStyle !!}
        let selected_cloth_style = {!! $selected_cloth_style !!}
        let check = {!! $check !!}




     let v = new Vue({
            el: '#app',
            data: {
                clothCategory: clothCategory,
                selected_cloth_category:selected_cloth_category,
                clothStyle: clothStyle,
                selected_cloth_style:selected_cloth_style,
                check:check
            },
            mounted: function () {
            
            },
            methods: {
                // addNew(index) {
                //     if (this.note[index + 1] == undefined) {
                //         this.note.push({expense_description: null, expense_info_date: null});
                //     }

                // },

                // deleteItem(index) {
                //     this.note.splice(index, 1);
                // },
            }
        })
    </script>

@endpush
 