@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i> &nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ClothStyleCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'clothStyle.store','method'=>'POST','class'=>'form-horizontal','id'=>'clothStyle-submit')) !!}
                {{ csrf_field() }}

                <div class="form-body">
                <input type="hidden"  name="cloth_category_id" value="{{$clothCategory->id}}">
                                <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">@lang('menu.ClothCategory'):</label>
                                                <div class="col-md-9">
                                                    <input type="text" class="form-control" value="{{$clothCategory->name}}" readonly>
                                                </div>
                                            </div>
                                            </div>       
                                            
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                                <div class="col-md-9">
                                                    <textarea class="form-control" readonly>{{$clothCategory->description}}</textarea>

                                                </div>
                                            </div>
                                            </div>

                                            
               
                   
                                </div>
                                <br>

                                    <table id="table_content" class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.ClothStyle')</th>

                                        </tr>
                                        <tr>
                                            <th>#</th>
                                            <th>@lang('layout.DataOrder') <span class="required"> * </span></th>
                                            <th style="min-width: 300px">@lang('layout.Name') <span class="required"> * </span></th>

                                            <th>@lang('layout.Description') </th>
                                            <th></th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(item,index) in cloth_style">
                                            <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                                            <td class="highlight">
                                                <input type="number" 
                                                       :name="'style_order['+index+']'" v-model="(!item)?null:item.style_order" class="form-control"  autocomplete="off" >
                                            </td>
                                            <td class="highlight">
                                                <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)" 
                                                       :name="'name['+index+']'" class="form-control" autocomplete="off" >
                                            </td> 
                                          

                                           

                                            <td class="highlight">
                                                <textarea :name="'description['+index+']'" class="form-control" rows="1" placeholder="{{__('layout.Description')}}" @click="addNew(index)" @keyup="addNew(index)">

                                                </textarea>
                                            </td>

                                            <td>
                                                <span v-if="cloth_style.length >1 "  v-on:click="deleteItem(index)"><i
                                                            class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                                            </td>

                                        </tr> 
                                        <!-- <tr style="background-color: rgb(255, 255, 255);">
                                            <td>
                                                <center>
                                                    <button type="button" class="btn btn-success" @click="addNew()">
                                                        <i class="fa fa-plus" ></i>
                                                       </button>
                                                   </center>
                                               </td> 
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr> -->

                                        </tbody>
                                    </table>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" @click="handleSubmit($event)" class="btn green" >@lang('layout.Submit')</button>
                    <button type="button" class="btn blue"
                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('clothCategory.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        Vue.component('v-select', VueSelect.VueSelect);

        var max_s = {!!$max_s!!}


        let v = new Vue({
            el: '#app',
            data: {
                cloth_style:
                    [
                        {name: null, description: null,style_order:this.max_s+1}

                    ],
                    max_s:max_s
            },
            methods: {
                handleSubmit(e) {
                    console.log('dddddddddddd',this.max_s)
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('clothStyle.store')}}";
                                form_id = 'clothStyle-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },
                addNew(index) {
                    if (this.cloth_style[index + 1] == undefined) {
                        // console.log('ddddd',this.cloth_style[index + 1])
                        this.cloth_style.push({name: null, description: null,style_order:this.max_s+1+index+1});
                    }

                },

                deleteItem(index) {
                    this.cloth_style.splice(index, 1);
                },
            }
        })
    </script>

@endpush
 