@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i> &nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ClothPropertyCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'clothCategory.store','method'=>'POST','class'=>'form-horizontal','id'=>'clothCategory-submit')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                                <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">@lang('menu.ClothCategory'):</label>
                                                <div class="col-md-9">
                                                    {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Name'),'placeholder' => __('layout.Name'),'autofocus'=>'autofocus','autocomplete'=>"off"])}}
                                                    <span class="required">@{{ errors.first('name') }}</span>
                                                </div>
                                            </div>
                                            </div>       
                                            
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                                <div class="col-md-9">
                                                    {!! Form::textarea('cat_description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}

                                                </div>
                                            </div>
                                            </div>

                                           
               
                   
                                </div>
                                <br>


                                        <table id="table_content" class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>@lang('layout.ClothSize')</th>

                                               

                                            </tr>
                                            <tr>
                                                <th>#</th>
                                                <th>@lang('layout.DataOrder') <span class="required"> * </span></th>
                                                <th style="min-width: 300px">@lang('layout.Name') <span class="required"> * </span></th>

                                                <th>@lang('layout.Type') <span class="required"> * </span></th>
                                                <th>@lang('layout.Description') </th>
                                                <th></th>

                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr v-for="(item,index) in cloth_property">
                                                <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                                                <td class="highlight">
                                                    <input type="number" 
                                                        name="property_order[]" :value="index+1" class="form-control" readonly autocomplete="off" >
                                                </td>
                                                <td class="highlight">
                                                    <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)"
                                                        name="property_name[]" class="form-control" autocomplete="off" >
                                                </td> 
                                            

                                                <td class="highlight">
                                                    <select class="form-control" name="type[]"> 
                                                        <option value="size" selected>@lang('layout.ClothSize')</option>
                                                        <option value="style">@lang('layout.ClothStyle')</option>
                                                    </select>
                                                </td>
                                            

                                                <td class="highlight">
                                                {{Form::textarea('description[]',null,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description'),'@click'=>"addNew(index)",'@keyup'=>"addNew(index)"])}}
                                                    
                                                </td>

                                                <td>
                                                    <span v-if="cloth_property.length >1 "  v-on:click="deleteItem('index')"><i
                                                                class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                                                </td>

                                            </tr> 
                                            <tr style="background-color: rgb(255, 255, 255);">
                                                <td>
                                                    <center>
                                                        <button type="button" class="btn btn-success" @click="addNew('index')">
                                                            <i class="fa fa-plus" ></i>
                                                        </button>
                                                    </center>
                                                </td> 
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>

                                            </tbody>
                                        </table> 
                                        <table id="table_content" class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>@lang('layout.ClothStyle')</th>

                                            </tr>
                                            <tr>
                                                <th>#</th>
                                                <th>@lang('layout.DataOrder') <span class="required"> * </span></th>
                                                <th style="min-width: 300px">@lang('layout.Name') <span class="required"> * </span></th>

                                                <th>@lang('layout.Description') </th>
                                                <th></th>

                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr v-for="(item,index) in cloth_style">
                                                <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                                                <td class="highlight">
                                                    <input type="number" 
                                                        name="style_order[]" :value="index+1" class="form-control" readonly autocomplete="off" >
                                                </td>
                                                <td class="highlight">
                                                    <input type="text" @keyup="addNewStyle(index)" v-on:click="addNewStyle(index)"
                                                        name="style_name[]" class="form-control" autocomplete="off" >
                                                </td> 
                                            

                                                <td class="highlight">
                                                {{Form::textarea('style_description[]',null,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description'),'@click'=>"addNew(index)",'@keyup'=>"addNew(index)"])}}
                                                    
                                                </td>

                                                <td>
                                                    <span v-if="cloth_style.length >1 "  v-on:click="deleteStyle('index')"><i
                                                                class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                                                </td>

                                            </tr> 
                                            <tr style="background-color: rgb(255, 255, 255);">
                                                <td>
                                                    <center>
                                                        <button type="button" class="btn btn-success" @click="addNewStyle('index')">
                                                            <i class="fa fa-plus" ></i>
                                                        </button>
                                                    </center>
                                                </td> 
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>

                                            </tbody>
                                        </table>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" @click="handleSubmit($event)" class="btn green" >@lang('layout.Submit')</button>
                    <button type="button" class="btn blue"
                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('clothCategory.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        Vue.component('v-select', VueSelect.VueSelect);


        let v = new Vue({
            el: '#app',
            data: {
                cloth_property:
                    [
                        {property_name: null, description: null,type:null,property_order:null}

                    ] ,
                    cloth_style:
                    [
                        {style_name: null, style_description: null,style_order:null}

                    ]
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('clothCategory.store')}}";
                                form_id = 'clothCategory-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },
                addNew(index) {
                    if (this.cloth_property[index + 1] == undefined) {
                        this.cloth_property.push({property_name: null, description: null,type:null,property_order:null});
                    }

                },

                deleteItem(index) {
                    this.cloth_property.splice(index, 1);
                },                
                
                addNewStyle(index) {
                    if (this.cloth_style[index + 1] == undefined) {
                        this.cloth_style.push({property_name: null, description: null,type:null,property_order:null});
                    }

                },

                deleteStyle(index) {
                    this.cloth_style.splice(index, 1);
                },

                

            }
        })
    </script>

@endpush
 