@extends('layouts.app')

@section('content')


<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allClothPropertyReport'" @closed="closeModal">

        <div slot=body>



                <div class="row">
                    <div class="col-md-6">
                        <label class="control-label">@lang('menu.ClothCategory')</label>
                        <v-select class="vue-select2" label="name"
                                    :options="clothCategory" v-model="selectedClothCategory">
                        </v-select>
                        <input type="hidden" name="cloth_category_id"
                                v-model.number="(!selectedClothCategory)?null:selectedClothCategory.id">
                    </div>
                </div>

                

            <!-- <div class="row"> 
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group"> 
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->

        </div>
    </report-modal>
</div>



<!-- BEGIN TAB PORTLET-->
<div class="row">


    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.ClothPropertyList') </span>
            </div>
            <div class="tools"></div>
            <div class="actions">
                @permission('clothProperty-export')
                <span id="anchore-modal">
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                    </a>
                </span>
                @endpermission
            </div>
        </div>
        <div class="portlet-body">

            <div class="tabbable-line tabbable-custom-profile">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#both" data-toggle="tab" id="tab-on">
                            <i class="fa  "></i><b> @lang('layout.ClothSize') </b></a>
                    </li>
                    <li class="">
                        <a href="#ex-transport" data-toggle="tab" id="tab-trasnport">
                            <i class="fa  "></i><b> @lang('layout.ClothStyle') </b></a>
                    </li>
                </ul>
                <br>
                <div class="tab-content padding" style="padding: 0px;">
                    <div class="tab-pane active" id="both">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-body">

                                <template v-cloak id="company_all">
                                    <company @company="setCompany"></company>
                                </template>
                                <table class="table table-striped table-bordered table-hover" id="clothProperty">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>@lang('menu.ClothCategory')</th>
                                            <th>@lang('layout.Name')</th>
                                            <th>@lang('layout.Description')</th>
                                            <!-- <th>@lang('layout.Description')</th> -->
                                            <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>

                    <div class="tab-pane" id="ex-transport">
                        <div class="portlet light bordered">
                            <div class="portlet-body">
                                <template v-cloak id="company_all">
                                    <company @company="setCompany"></company>
                                </template>
                                <table class="table table-striped table-bordered table-hover" id="clothStyle">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>@lang('menu.ClothCategory')</th>
                                            <th>@lang('layout.Name')</th>
                                            <th>@lang('layout.Description')</th>
                                            <!-- <th>@lang('layout.Description')</th> -->
                                            <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>

</div>


<!-- END TAB PORTLET-->
<iframe id="payframe" style="display: none;"></iframe>
<!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

<script>
// 
var clothCategory  = {!!json_encode($clothCategory)!!}
Vue.component("v-select", VueSelect.VueSelect);
let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#clothProperty').DataTable({
                ajax:{
                        url:'{{route("clothProperty.index")}}',
                        data:{type:'size'}
                    },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                    {data: 'category_name', name: 'cloth_categories.name'},
                    {data: 'name', name: 'cloth_properties.name'},
                    {data: 'description', name: 'cloth_properties.description'},
                    // {data: 'category_description', name: 'category_description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},


                ]
            });            
            
            data_table =$('#clothStyle').DataTable({
                ajax:{
                        url:'{{route("clothProperty.index")}}',
                        data:{type:'style'}
                    },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                    {data: 'category_name', name: 'cloth_categories.name'},
                    {data: 'name', name: 'cloth_styles.name'},
                    {data: 'description', name: 'cloth_styles.description'},
                    // {data: 'category_description', name: 'category_description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},


                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                clothCategory:clothCategory,
                selectedClothCategory:null

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

</script>
@endpush