@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ClothPropertyEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
        
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($clothProperty, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['clothProperty.update',$clothProperty->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('menu.ClothCategory')</label>
                                        <v-select 
                                                    label="name" 
                                                    :options="clothCategory"
                                                    v-model="selected_cloth_category"
                                                    :disabled="!check"
                                                    >
                                                </v-select>
                                                <input type="hidden" name="cloth_category_id"
                                                :value="!selected_cloth_category?null:selected_cloth_category.id">
                                    </div>
                                </div>
                        </div>
                    </div>
                     <br>

                    <table id="table_content" class="table table-bordered">
                        <thead>
                        <tr>
                        <th>@lang('layout.DataOrder') <span class="required"> * </span></th>
                            <th style="min-width: 300px">@lang('layout.Name') <span class="required"> * </span></th>

                            <th>@lang('layout.Description') </th>

                        </tr>
                        </thead>
                        <tbody>
                        <tr >
                        <td class="highlight">
                            <input type="number" 
                                    name="property_order" value="{{$clothProperty->property_order}}" class="form-control"  autocomplete="off" >
                        </td>
                            <td class="highlight">
                                <input type="text"
                                        name="name" class="form-control" value="{{$clothProperty->name}}">
                            </td>
                            <td class="highlight">
                            {{Form::textarea('description',$clothProperty->description,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description')])}}
                            </td>
                            

                        </tr>
                        </tbody>
                    </table>                    
                    
                    <br>
                     
                    <!-- <table id="" class="table table-bordered">
                        <caption>@lang('layout.OtherClothProperty')</caption>
                        <thead>
                        <tr>
                        <th>@lang('layout.DataOrder') </th>
                            <th>@lang('layout.Name') </th>

                            <th>@lang('layout.Type') </th>
                            <th>@lang('layout.Description') </th>

                        </tr>
                        </thead>
                        <tbody>
                        
                        @foreach($AllclothProperty as $cp)
                        @if($cp->id !=$clothProperty->id)
                        <tr>
                            <td class="highlight">{{$cp->property_order}}</td>
                            <td class="highlight">{{$cp->name}}</td>
                            <td class="highlight">{{__('type.'.$cp->type)}}</td>
                            <td class="highlight">{{$cp->description}}</td>
                            
                        </tr>
                        @endif
                        @endforeach
                        </tbody>
                    </table> -->
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{route('clothProperty.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        let clothCategory           = {!! $clothCategory !!}
        let selected_cloth_category = {!! $selected_cloth_category !!}
        let check = {!! $check !!}





     let v = new Vue({
            el: '#app',
            data: {
                clothCategory: clothCategory,
                selected_cloth_category:selected_cloth_category,
                check:check
            },
            mounted: function () {
            
            },
            methods: {
                // addNew(index) {
                //     if (this.note[index + 1] == undefined) {
                //         this.note.push({expense_description: null, expense_info_date: null});
                //     }

                // },

                // deleteItem(index) {
                //     this.note.splice(index, 1);
                // },
            }
        })
    </script>

@endpush
 