@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i> &nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ClothPropertyCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'clothProperty.store','method'=>'POST','class'=>'form-horizontal','id'=>'clothProperty-submit')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                                <div class="row">
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="col-md-12">
                                                    <label class="control-label ">@lang('menu.ClothCategory')</label>
                                                    <v-select 
                                                        label="name" 
                                                        :options="clothCategory"
                                                        v-model="selected_cloth_category"
                                                        >
                                                    </v-select>
                                                            
                                                    <input type="hidden" name="cloth_category_id"
                                                    :value="!selected_cloth_category?null:selected_cloth_category.id"
                                                    v-validate="'required'" data-vv-as="@lang('menu.ClothCategory')">
                                                    <span class="required">@{{ errors.first('cloth_category_id') }}</span>
                                                </div>
                                            </div>
                                    </div>
                                </div>
                                <br>

                                    <table id="table_content" class="table table-bordered">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>@lang('layout.DataOrder') </th>
                                            <th style="min-width: 300px">@lang('layout.Name') </th>

                                            <th>@lang('layout.Type') </th>
                                            <th>@lang('layout.Description') </th>
                                            <th></th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(item,index) in cloth_property">
                                            <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                                            <td class="highlight">
                                                <input type="number" 
                                                       name="property_order[]" :value="index+1" class="form-control" readonly autocomplete="off" >
                                            </td>
                                            <td class="highlight">
                                                <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)"
                                                       name="name[]" class="form-control" autocomplete="off" >
                                            </td> 
                                          

                                            <td class="highlight">
                                                <select class="form-control" name="type[]"> 
                                                    <option value="size" selected>@lang('layout.ClothSize')</option>
                                                    <option value="style">@lang('layout.ClothStyle')</option>
                                                </select>
                                            </td>
                                           

                                            <td class="highlight">
                                            {{Form::textarea('description[]',null,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description'),'@click'=>"addNew(index)",'@keyup'=>"addNew(index)"])}}
                                                
                                            </td>

                                            <td>
                                                <span v-on:click="deleteItem('index')"><i
                                                            class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                                            </td>

                                        </tr>
                                        </tbody>
                                    </table>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" @click="handleSubmit($event)" class="btn green" >@lang('layout.Submit')</button>
                    <button type="button" class="btn blue"
                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('clothProperty.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        Vue.component('v-select', VueSelect.VueSelect);

 
        var clothCategory = {!! $clothCategory !!}

        let v = new Vue({
            el: '#app',
            data: {
                cloth_property:
                    [
                        {name: null, description: null,type:null,property_order:null},
                        {name: null, description: null,type:null,property_order:null},
                        {name: null, description: null,type:null,property_order:null},

                    ],
                    selected_cloth_category:null,
                    clothCategory:clothCategory
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('clothProperty.store')}}";
                                form_id = 'clothProperty-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },
                addNew(index) {
                    if (this.cloth_property[index + 1] == undefined) {
                        this.cloth_property.push({name: null, description: null,type:null,property_order:null});
                    }

                },

                deleteItem(index) {
                    this.cloth_property.splice(index, 1);
                },
            }
        })
    </script>

@endpush
 