@extends('layouts.app')
@section('style')
<style type="text/css">
    .setting_menu li.active a,
    .ver-inline-menu li.active i {
        background-color: #d4d7dc !important;
        color: #393a3d !important;
    }
    .ver-inline-menu li a {
        background: #eceef1 !important;
        border-left: solid 2px #eceef1;
        color: #393a3d !important;
    }
    .ver-inline-menu li i {
        background: #eceef1 !important;
    }
    .t_head {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
    .t_body {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
    .report_a_title{
        color: #393a3d;
    }
    a.report_a_title:hover{
        color: #393a3d;
        text-decoration: none;
    }
    .table-advance {
        text-align: center !important;
    }
    .container{
        margin-top: -5px;
        width: 100%;
        background-color: #f3f5f9;
        padding: 20px;
        /* border-radius: 8px; */
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    .content{
        transition: max-height 0.3s ease-out;
    }
    .toggle-button{
        position: absolute;
        text-align: center;
        cursor: pointer;
        font-size: 24px;
        margin-top: 10px;
    }
    #icon{
        font-size: 20px;
        background-color: #f3f5f9;
        padding: 7px;
        /* border-radius: 100%; */
    }
    .content.collapsed{
        max-height: 0;
        overflow:hidden; 
    }
    .content.expanded{
        max-height: 200px;
    }
    .shake-container{
        display: inline-block;
        /* animation: shake 6s ease-in-out infinite; */
        /* animation-delay: 2s; */
    }
    /* @keyframes shake{
        0%{
            transform: scale(1) translateY(0);
        }
        25%{
            transform: scale(1) translateY(-1.5rem);
        }
        75%{
            transform: scale(1) translateY(1.5rem);
        }
        100%{
            transform: scale(1) translateY(0);
        }
    } */
    .shake{
        display: block;
    }
    .topBtn{
        background-color: #2ca317; 
        color: white;
        transition: 1s;
    }
    .topBtn:hover{
        background-color: transparent;
        border: 1px solid #2ca317;
        color:#2ca317; 
        transition: 1s;
    }
    .titleBtn:hover{
        text-decoration: none;
    }
    .titleBtn:focus{
        text-decoration: none;
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="container" >
    <div class="content">
        <div style="display: flex;justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h3>@lang('layout.Sales')</h3>
            {{-- <a href="#" class="btn btn-lg topBtn">@lang('layout.AddNew')</a> --}}
            <div class="btn-group">
                @permission('sales-create')
                <a href="{{route('sale.create')}}" type="button" class="btn topBtn">@lang('layout.AddNew')</a>
                <button type="button" class="btn topBtn dropdown-toggle" data-toggle="dropdown" id="dropdownButton">
                    <span class="caret"></span>
                </button>
                @endpermission
                <ul class="dropdown-menu dropdown-menu-right" role="menu">
                    @permission('sales-create')
                    <li>
                        <a href="{{route('sale.create')}}">@lang('menu.SaleReceipt')</a>
                    </li>
                    @endpermission
                    @permission('invoice-create')
                    <li>
                        <a href="{{route('invoice.create')}}">@lang('menu.Invoice')</a>
                    </li>
                    @endpermission
                    @permission('invoiceRoll-create')
                    <li>
                        <a href="{{route('invoice_roll.create')}}">@lang('menu.InvoiceRoll')</a>
                    </li>
                    @endpermission
                    @permission('ProjectInvoice-create')
                    <li>
                        <a href="{{route('projectInvoice.create')}}">@lang('menu.ProjectInvoice')</a>
                    </li>
                    @endpermission
                    @permission('saleByType-create')
                    <li>
                        <a href="{{route('saleByType.create')}}">@lang('menu.SaleByType')</a>
                    </li>
                    @endpermission
                    @permission('salesOrder-create')
                    <li>
                        <a href="{{route('salesOrder.create')}}">@lang('menu.SalesOrder')</a>
                    </li>
                    @endpermission
                </ul>
            </div>
        </div>
        <div style="display: flex; justify-content: space-between;width: 100%;margin-top: 10px !important;flex-wrap: wrap;">
            @permission('sales-list')
            <div style="width: 19%;background-color: #7ccc04;margin-bottom: 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('sale.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important; color: white;">@lang('layout.SalesReceiptes')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_SalesReceipt)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('sale.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-money"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @permission('invoice-list')
            <div style="width: 19%;background-color: #b6babf;margin-bottom: 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('invoice.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: white;">@lang('layout.Invoice')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_Invoice)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('invoice.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-money"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @permission('invoiceRoll-create')
            <div style="width: 19%;background-color: #fb8001;margin-bottom: 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('invoice_roll.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: white;">@lang('menu.InvoiceRoll')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_InvoiceRoll)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('invoice_roll.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-money"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @permission('saleByType-list')
            <div style="width: 19%;background-color: #0175c0;margin-bottom: 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('saleByType.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: white;">@lang('menu.SaleByType')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($total_saleByType)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('saleByType.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-money"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @permission('salesOrder-list')
            <div style="width: 19%;background-color: #1fa7f2;margin-bottom: 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('salesOrder.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: white;">@lang('menu.SalesOrder')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">2000 دانه</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('salesOrder.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-money"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            {{-- <div style="width: 19%;background-color: black;border-radius: 8px;margin-bottom: 10px;color: white;">
                <div style="display: flex;justify-content: space-between;">
                    <div style="padding: 10px;">
                        <div>
                            <p>@lang('layout.TotalSale')</p>
                        </div>
                        <div>
                            <p>2000 دانه</p>
                        </div>
                    </div>
                    <div>
                        <i style="font-size: 35px;vertical-align: middle;margin: 1em 0px 0px 0.5em;" class="fa fa-book"></i>
                    </div>
                </div>
            </div>
            <div style="width: 19%;background-color: black;border-radius: 8px;margin-bottom: 10px;color: white;">
                <div style="display: flex;justify-content: space-between;">
                    <div style="padding: 10px;">
                        <div>
                            <p>@lang('layout.TotalSale')</p>
                        </div>
                        <div>
                            <p>2000 دانه</p>
                        </div>
                    </div>
                    <div>
                        <i style="font-size: 35px;vertical-align: middle;margin: 1em 0px 0px 0.5em;" class="fa fa-book"></i>
                    </div>
                </div>
            </div>
            <div style="width: 19%;background-color: black;border-radius: 8px;margin-bottom: 10px;color: white;">
                <div style="display: flex;justify-content: space-between;">
                    <div style="padding: 10px;">
                        <div>
                            <p>@lang('layout.TotalSale')</p>
                        </div>
                        <div>
                            <p>2000 دانه</p>
                        </div>
                    </div>
                    <div>
                        <i style="font-size: 35px;vertical-align: middle;margin: 1em 0px 0px 0.5em;" class="fa fa-book"></i>
                    </div>
                </div>
            </div>
            <div style="width: 19%;background-color: black;border-radius: 8px;margin-bottom: 10px;color: white;">
                <div style="display: flex;justify-content: space-between;">
                    <div style="padding: 10px;">
                        <div>
                            <p>@lang('layout.TotalSale')</p>
                        </div>
                        <div>
                            <p>2000 دانه</p>
                        </div>
                    </div>
                    <div>
                        <i style="font-size: 35px;vertical-align: middle;margin: 1em 0px 0px 0.5em;" class="fa fa-book"></i>
                    </div>
                </div>
            </div> --}}
        </div>
    </div>
    <div class="toggle-button" onclick="toggleContent()">
        <i id="icon" class="fa fa-chevron-up"></i>
    </div>
</div>
<div class="container1" style="margin-top: 3em;padding: 10px;border-radius: 8px;box-shadow: 0px 0px 5px #d7d7d7;">
    <div style="display: flex;justify-content: space-between;flex-wrap: wrap;">
        <div style="width: 100%;" class="shake-container">
            <img src="{{asset('menu_img/SaleImages/Capture6.PNG')}}" style="width: 100%;height: 60vh;border-radius: 8px;" alt="Image" class="shake">
        </div>
        {{-- <div style="width: 50%;display: flex;justify-content: center; align-items: center;">
            <h3>@lang('layout.Sales')</h3>
        </div> --}}
    </div>
</div>
{{-- <div class="portlet light ">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class="icon-equalizer font-green-haze"></i>&nbsp;
            <span class="caption-subject font-green-haze bold uppercase">@lang('menu.Tailoring')</span>
        </div>
    </div>
    <div class="portlet-body form">
        <div class="row" id="system_setting">
            <div id="tab_6" class="tab-pane active">
                <div id="accordion1" class="panel-group">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h4 class="panel-title">
                                <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1"><i class="fa fa-home"></i> </a>
                            </h4>
                        </div>
                        <div id="accordion1_1" class="panel-collapse collapse in">
                            <div class="panel-body">
                                @permission('clothCategory-list')
                                <a href="{{route('clothCategory.index')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 5px !important;">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.ClothCategory')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-tasks" style="font-size: 38px;"></i>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                @endpermission
                                @permission('clothProperty-list')
                                <a href="{{route('clothProperty.index')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 5px !important;">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.ClothProperty')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-reorder" style="font-size: 38px;"></i>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                @endpermission
                                @permission('membercloth-list')
                                <a href="{{route('memberCloth.index')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 5px !important;">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.Membercloth')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-user" style="font-size: 38px;"></i>
                                                    <!-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <i class="fa fa-scissors" style="font-size: 38px;"></i> -->
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                @endpermission 
                                
                                @permission('customers-list')
                                <a href="{{route('customer.index')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 5px !important;">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.Customers')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-user" style="font-size: 38px;"></i>
                                                    <!-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <i class="fa fa-scissors" style="font-size: 38px;"></i> -->
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                @endpermission
                                @permission('invoice-list')
                                <a href="{{route('invoice.index')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 5px !important;">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('menu.Invoice')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-shopping-cart" style="font-size: 38px;"></i>
                                                    <!-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <i class="fa fa-scissors" style="font-size: 38px;"></i> -->
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                @endpermission
                                @permission('invoice-list')
                                <a href="{{route('newDashboard.index')}}" class="report_a_title">
                                    <div class="col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 5px !important;">
                                        <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    New Design
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-shopping-cart" style="font-size: 38px;"></i>
                                                    <!-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <i class="fa fa-scissors" style="font-size: 38px;"></i> -->
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </a>
                                @endpermission
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> --}}
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush