@extends('layouts.app')

@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
 <style>

 
     
 </style>
@stop

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ClothPropertyEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
        
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($clothCategory, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['clothCategory.update',$clothCategory->id],'files'=> true]) !!}
                {{ csrf_field() }}
                <div class="form-body">
                <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">@lang('menu.ClothCategory'):</label>
                                                <div class="col-md-9">
                                                    <input  type="text" class="form-control" name="name" value="{{$clothCategory->name}}">
                                               
                                                </div>
                                            </div>
                                            </div>       
                                            
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                                <div class="col-md-9">
                                                    <textarea class="form-control" name="cat_description">{{$clothCategory->description}}</textarea>
                                                </div>
                                            </div>
                                            </div>
                                          

                                            <?php
                                                $photo = null;
                                                if($clothCategory && $clothCategory->image!=null)
                                                {
                                                    $photo =  $clothCategory->image;
                                                }
                                            ?>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                        <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                                    </div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                            style="max-width: 200px; max-height: 150px;"></div>
                                                        <div>
                                                                <span class="btn default btn-file">
                                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                    <!-- <input type="file" name="photo">  -->
                                                                    {!! Form::file('photo', []) !!}</span>
                                                            {!! Form::hidden('photo1', (!$clothCategory)?null:$clothCategory->image) !!}
                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                           
               
                   
                                </div>
                     <br>

                    <table id="table_content" class="table table-bordered">
                        <thead>
                        <tr>
                            <th>@lang('menu.ClothProperty')</th>

                        </tr>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.DataOrder') <span class="required"> * </span></th>
                            <th >@lang('layout.Name') <span class="required"> * </span></th>

                            <!-- <th>@lang('layout.Type') <span class="required"> * </span></th> -->
                            <th>@lang('layout.Description') </th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(item,index) in clothProperty">
                        <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                        <td class="highlight">
                            <input type="number" 
                                    :name="'property_order['+index+']'"  v-model="(!item)?null:item.property_order" class="form-control"  autocomplete="off" >
                        </td>
                            <td class="highlight">
                                <input type="text" 
                                :name="'property_name['+index+']'"
                                v-model="(!item)?null:item.name"
                                 class="form-control"
                                 @keyup="addNew(index)"
                                v-on:click="addNew(index)"
                                autocomplete="off"
                                      >
                            </td>

                            <!-- <td class="highlight">

                                 <select class="form-control" :name="'type['+index+']'" v-model="(!item)?null:item.type"> 
                                    <option value="size" selected>@lang('layout.ClothSize')</option>
                                    <option value="style">@lang('layout.ClothStyle')</option>
                                </select>
                            </td>  -->

                            <input type="hidden" name="type[]" value="size">
                            <td class="highlight">
                                <textarea  :name="'description['+index+']'" v-model="(!item)?null:item.description" class="form-control"  @keyup="addNew(index)" v-on:click="addNew(index)"></textarea>
                            </td>
                            <td>
                                <span v-if="clothProperty.length >1 " v-on:click="deleteItem(index)"><i
                                            class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                            </td>
                            

                        </tr>
                        <tr style="background-color: rgb(255, 255, 255);">
                            <td>
                                <center>
                                    <button type="button" class="btn btn-success" @click="addNew('index')">
                                        <i class="fa fa-plus" ></i>
                                        </button>
                                    </center>
                                </td> 
                            <!-- <td></td> -->
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        </tbody>
                    </table>    
                    
                    <table id="table_content" class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>@lang('layout.ClothStyle')</th>

                                            </tr>
                                            <tr>
                                                <th>#</th>
                                                <th>@lang('layout.DataOrder') <span class="required"> * </span></th>
                                                <th style="min-width: 300px">@lang('layout.Name') <span class="required"> * </span></th>

                                                <th>@lang('layout.Description') </th>
                                                <th></th>

                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr v-for="(item,index) in cloth_style">
                                                <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                                                <td class="highlight">
                                                    <input type="number" 
                                                         :name="'style_order['+index+']'"  v-model="(!item)?null:item.style_order" class="form-control"  autocomplete="off" >
                                                </td>
                                                <td class="highlight">
                                                    <input type="text" @keyup="addNewStyle(index)" v-on:click="addNewStyle(index)"
                                                    :name="'style_name['+index+']'"
                                                    v-model="(!item)?null:item.style_name" class="form-control" autocomplete="off" >
                                                </td> 
                                            

                                                <td class="highlight">
                                                <textarea  :name="'style_description['+index+']'" v-model="(!item)?null:item.style_description" class="form-control"  @keyup="addNewStyle(index)" v-on:click="addNewStyle(index)"></textarea>
                                                </td>

                                                <td>
                                                    <span v-if="cloth_style.length >1 "  v-on:click="deleteStyle('index')"><i
                                                                class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                                                </td>

                                            </tr> 
                                            <tr style="background-color: rgb(255, 255, 255);">
                                                <td>
                                                    <center>
                                                        <button type="button" class="btn btn-success" @click="addNewStyle('index')">
                                                            <i class="fa fa-plus" ></i>
                                                        </button>
                                                    </center>
                                                </td> 
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                            </tr>

                                            </tbody>
                                        </table>
                  
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{route('clothCategory.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);


       var clothPropertyDetails = {!!$clothProperty!!}
       var clothStyle = {!!$clothStyle !!}


     let v = new Vue({
            el: '#app',
            data: {
                clothPropertyDetails:clothPropertyDetails,
                clothStyle:clothStyle,
                clothProperty:[],
                cloth_style:[]
            },
            mounted: function () {

                for (var i = 0; i < this.clothPropertyDetails.length; i++) {
                    this.clothProperty.push({

                        property_order:this.clothPropertyDetails[i].property_order,
                        name:this.clothPropertyDetails[i].name,
                        type:this.clothPropertyDetails[i].type,
                        description:this.clothPropertyDetails[i].description


                    });
                }
                for (var i = 0; i < this.clothStyle.length; i++) {
                    this.cloth_style.push({

                        style_order:this.clothStyle[i].style_order,
                        style_name:this.clothStyle[i].name,
                        style_description:this.clothStyle[i].description






                    });
                }
                // for (var m = 4; m > this.clothPropertyDetails.length; m--) {
                //     this.clothProperty.push({
                //         property_order:null,
                //         property_name:null,
                //         type:null,
                //         description:null
                //     });
                // }
            },
            methods: {
                addNew(index) {
                    if (this.clothProperty[index + 1] == undefined) {
                        this.clothProperty.push({property_name: null,type:'size', description: null,property_order:null});
                    }

                },

                deleteItem(index) {
                    this.clothProperty.splice(index, 1);
                },

                addNewStyle(index) {
                    if (this.cloth_style[index + 1] == undefined) {
                        this.cloth_style.push({property_name: null, description: null,type:null,property_order:null});
                    }

                },

                deleteStyle(index) {
                    this.cloth_style.splice(index, 1);
                },
            }
        })
    </script>

@endpush
 