@extends('layouts.app')

@section('content')
  
    <div class="portlet ">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.AccountDetails')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                            <th>@lang('layout.Year')</th> 
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Drawing')</th>
                            <th>@lang('layout.NetProfit')</th>
                            <th>@lang('layout.Equity')</th>
                            <th>@lang('layout.Date')</th>
                    </tr> 
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs"> {{ $equity->year_name }}  </td>
                        <td class="hidden-xs"> {{ $equity->currency }}  </td>
                        <td class="hidden-xs"> {{ myRound($equity->drawing_amount) }}  </td>
                        <td class="hidden-xs"> {{ myRound($equity->total_income) }}  </td>
                        <td class="hidden-xs"> {{ myRound($equity->equity_amount) }}  </td>
                        <td class="hidden-xs"> {{ convertDate($equity->date) }}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.AccountDetails')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         {{Form::open(['route' => 'closeYearsEquity.report','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="closeYearsEquityAll"/>
                           <input type="hidden" name="report_format" value="excel"/>
                           <input type="hidden" name="exportType" value="details"/>
                           <input type="hidden" name="closeYear_id" value="{{$equity->year_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'closeYearsEquity.report','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="closeYearsEquityAll"/>
                           <input type="hidden" name="report_format" value="pdf"/>
                           <input type="hidden" name="exportType" value="details"/>
                           <input type="hidden" name="closeYear_id" value="{{$equity->year_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                        <tr>  
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Account')</th> 
                        <th>@lang('layout.LastPercentage')</th> 
                        <th>@lang('layout.LastEquityAmount')</th>
                        <th>@lang('layout.Drawing')</th>
                        <th>@lang('layout.NewPercentage')</th>
                        <th>@lang('layout.NewEquityAmount')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
 @push('scripts')
<script>
        $(document).ready(function () {
        $('#sales').DataTable({
            ajax:'{{route("closeYearsEquity.show",$equity->year_id)}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [
                { data: 'name', name: 'members.name' },
                { data: 'account_name', name: 'accounts.name' },
                { data: 'last_percentage', name: 'close_years_equity.last_percentage' },
                { data: 'last_equity_amount', name: 'close_years_equity.last_equity_amount' },
                { data: 'drawing_amount', name: 'close_years_equity.drawing_amount' },
                { data: 'new_percentage', name: 'close_years_equity.new_percentage' },
                { data: 'new_equity_amount', name: 'close_years_equity.new_equity_amount' }      
        ]
        });

    });
</script>


@endpush 