@extends('layouts.app')

@section('content')
    <!-- END PAGE HEADER-->

    @include('simple_modal.modal')
    <div id="create_app" v-cloak>
        {{Form::open(['route' => 'closeYearsEquity.create','method' => 'GET','class' => 'inline'])}}

        <button id="show-modal1" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <simple-modal :form_route="'closeYearsEquity.create'" v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                    </div>
                </div>
                <div class="row">
					<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('layout.CloseYear')</label>
							<v-select placeholder="@lang('layout.CloseYear')" tabindex="1" label="name" :options="{{ json_encode($closeYear) }}" v-model="closeYear"></v-select>
							<input type="hidden" name="closeYear_id" required="required" :value="(closeYear)?closeYear.id:null">
						</div>
					</div>
				</div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </simple-modal>
        {{Form::close()}}
    </div>
 
    <div id="print-modal">
         <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
             v-if="is_show" 
                :value-type="''"
                @closed="closeModal">

                <div slot="body">
                    <input type="hidden" name="type" value="closeYearsEquityAll"/>
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.CloseYear')</label>
                                <v-select placeholder="@lang('layout.CloseYear')" tabindex="1" label="name" :options="{{ json_encode($closeYears) }}" v-model="closeYear"></v-select>
                                <input type="hidden" name="closeYear_id" required="required" :value="(closeYear)?closeYear.id:null">
                            </div>
                            <!-- <div class="col-md-4">
                                <label class="control-label"> @lang('layout.Type')</label>
                                <select class="form-control" name="exportType">
                                    <option value="simple" selected>@lang('layout.Simple')</option>
                                    <option value="details">@lang('layout.Details')</option>
                                </select>
                            </div> -->
                        </div>
                    </div>
                    <!-- <div class="row">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" 
                                            autocomplete="off" name="from_date">
                                        
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" 
                                            autocomplete="off" name="to_date">
                                       
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> -->
                </div>
         </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Equity')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                    @permission('closeYear-export')

                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                    </span>
                        @endpermission
                    @permission('closeYear-create')
                        <!-- <a href="{{route('closeYearsEquity.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a> -->
                        <button type="button" id="create_id" class="btn btn-success"><i class="fa fa-plus"></i> @lang('layout.AddNew') </button> 
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="closeYearsEquity">
                    <thead>
                        <tr>
                            <th>@lang('layout.Year')</th> 
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Drawing')</th> 
                            <th>@lang('layout.NetProfit')</th>
                            <th>@lang('layout.Equity')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- <div id="factor-obj" >
        @if (Session('message'))
            <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif
    </div> -->



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

<script>

    let data_table = null;
    $(document).ready(function() {

        data_table =  $('#closeYearsEquity').DataTable({
            ajax: '{{route("closeYearsEquity.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [[ 1, "{{getRowOrder()}}" ]],
            scrollCollapse: true,
            serverSide: true, 
            paging:         true,
            columns: [
            { data: 'year_name', name: 'close_years.name' },
            { data: 'currency', name: 'close_years.base_currency' },
            { data: 'drawing_amount', name: 'drawing_amount', searchable: false },
            { data: 'total_income', name: 'close_years.total_income' },
            { data: 'equity_amount', name: 'equity_amount', searchable: false },
            { data: 'date', name: 'close_years_equity.date' },
            { data: 'user', name: 'users.name' },
            { data: 'actions', name: 'actions', searchable: false, orderable:false }
            ] 
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
 

var vm =new Vue({
            el: '#print-modal',
            data:{
                closeYear:null,
                is_show:false,
                pdfRoute: '{!!route('closeYearsEquity.report') !!}',
                excelRoute: '{!! route('closeYearsEquity.report') !!}',
            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },
            }
        });

new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
        }
    }
});




        $('#btnPrint').click(function() {
            $.ajax({
                // This PHP file will generate the PDF and save it to your server
                // $pdf->Output('path/to/pdf/file.pdf', 'F');
                url: '{{route("sale.show",1)}}',
                type: 'get',
                cache: false,

            }).done(function () {

                var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                $('#factor-obj').html(s);


                // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            })
                .fail(function () {
                    console.log("error");
                });

            // window.print();
            // window.open("data:application/pdf," + escape(data=""));
            $.ajax({
                // This PHP file will generate the PDF and save it to your server
                // $pdf->Output('path/to/pdf/file.pdf', 'F');
                url: '{{route("sale.show",1)}}',
                type: 'get',
                cache: false,

            }).done(function() {

                var s = ' <object  data="'+'{{url('factor22.pdf')}}'+'" type="application/pdf" width="0" height="0"> </object>'

                $('#factor-obj').html(s);





                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                .fail(function() {
                    console.log("error");
                });

        });


    } );

         // start app
 new Vue({
        el: '#create_app',
        data: {
            showModal: false,
            closeYear:null

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {

                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#create_id').on('click', function(e) {
        $('#show-modal1').click();
        e.preventDefault();
    });

   
    // start app
    Vue.component('v-select', VueSelect.VueSelect)
</script>


@endpush
