@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.CreateNewCloseYear')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-clock>
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'closeYearsEquity.store','method' => 'POST','id' => 'statement-form','files'=> true])}}
                {{ csrf_field() }}
                <div class="form-body">
                
                <div class="row">
					<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('layout.CloseYear')</label>
							<v-select placeholder="@lang('layout.CloseYear')" tabindex="1" label="name" :options="{{ json_encode($closeYear) }}" v-model="closeYear" @input="profit_equity()" ></v-select>
							<input type="hidden" name="closeYear_id" v-validate="'required'" data-vv-as="@lang('layout.CloseYear')" :value="(closeYear)?closeYear.id:null">
							<span class="required">@{{ errors.first('closeYear_id') }}</span>
                            
                            <input type="hidden" name="totaldrawing" value="{{ $drawingAmount }}">
							<input type="hidden" name="totalequity" :value="(closeYear)?closeYear.total_equity:0">
							<input type="hidden" name="totalnetProfit" :value="(closeYear)?closeYear.total_income:0">
							<input type="hidden" name="totalBalance" :value="(closeYear)?totalBalance:0">
						</div>
					</div>
                </div>
                <div class="row">
                    <div class="portlet-body">
                        <div class="table-scrollable">
                            <table class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                <tr>
                                        <th>@lang('layout.CloseDate')</th> 
                                        <th>@lang('layout.OpeningDate')</th> 
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.BaseCurrency')</th>
                                        <th>@lang('layout.TotalDrawing')</th>
                                        <th>@lang('layout.TotalInvestment')</th>
                                        <th>@lang('layout.OpeningBalance')</th>
                                        <th>@lang('layout.NetProfit')</th>
                                        <th>@lang('layout.Total')</th>
                                </tr> 
                                </thead>
                                <tbody>
                                <tr v-if="closeYear">  
                                    <td > @{{ closeYear.close_date }}  </td>
                                    <td > @{{ closeYear.opening_date }}  </td>
                                    <td > @{{ closeYear.description }}  </td>
                                    <td > @{{ closeYear.base_currency }}</td>
									<td > {{ $drawingAmount }}</td>
                                    <td > @{{ closeYear.total_equity }}</td>
                                    <td > {{ $openingBelanceEquity->balance }}</td>
                                    <td > @{{ closeYear.total_income }}</td>
                                    <td > @{{ totalBalance }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
				</div>
				
                <h2 v-if="closeYear" >@lang('layout.DrawingList')</h2>
                <div class="row" v-if="closeYear" >
                    <div class="portlet-body">
                        <div class="" v-if="drawingList.length > 0">
                            <table class="table table-striped table-bordered table-advance">
                                <thead>
                                <tr>
                                        <th>#</th> 
                                        <th>@lang('layout.Name')</th>
                                        <th>@lang('layout.Account')</th> 
                                        <th>@lang('layout.LastPercentage')</th> 
                                        <th>@lang('layout.LastEquityAmount')</th>
                                        <th>@lang('layout.Drawing')</th>
                                        <th>@lang('layout.EquityPluserofit')</th>
                                        <th>@lang('layout.NewPercentage')</th>
										<th>@lang('layout.NewEquityAmount')</th>
                                </tr> 
                                </thead>
                                <tbody>
                                <tr v-for="(row,index) in drawingList">  
                                    <td> @{{ index+1 }}  </td>
									<td> @{{ row.name }}  
									<input type="hidden" :name="'member_id['+index+']'" :value="(!row)?null:row.id">
									</td>
									
                                    <td>
										<v-select placeholder="@lang('layout.SelectAccount')" label="name" :options="{{ json_encode($accounts) }}" v-model="(!row)?null:row.select_account"></v-select>
							    		<input type="hidden" :name="'account_id['+index+']'" :value="(!row)?null:row.select_account.id">
                                    </td>
                                    <td >
										<div class="input-group">
										<input type="number"  class="form-control" :name="'last_percentage['+index+']'" @input="SetEquity(index)" v-model="(!row)?null:row.last_percentage" min="0" max="100" >
										<span class="input-group-addon" >%</span>
										</div>	
									</td>
                                    <td >
                                    <input type="number"  class="form-control" :name="'last_equity_amount['+index+']'" v-model="(!row)?null:row.last_equity_amount" readonly>
                                    </td>
									<td >
                                    <input type="number"  class="form-control" :name="'drawing['+index+']'" :value="(!row)?null:myRound(row.amount)" readonly>
                                    </td>
                                    <td >
                                    <input type="number"  class="form-control" :name="'equity_from_profit['+index+']'" v-model="(!row)?null:row.equity_from_profit" readonly>
                                    </td>
                                    <td >
										<div class="input-group">
										<input type="number"  class="form-control" :name="'new_percentage['+index+']'" @input="SetNewEquity(index)" v-model="(!row)?null:row.new_percentage" min="0" max="100">
										<span class="input-group-addon" >%</span>
										</div>
                                    </td>
                                    <td >
                                    <input type="number"  class="form-control" :name="'new_equity_amount['+index+']'" v-model="(!row)?null:row.new_equity_amount" readonly>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button v-if="!iserror && !is_error" type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <!-- <button type="button" class="btn blue"
                            @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> -->
                    <a href="{{route('closeYearsEquity.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        $(document).ready(function () {
            $('#initial-value-example').persianDatepicker({
                observer: true,
                format: 'YYYY/MM/DD',
                altField: '#observer-example-alt',
                altFormat: 'u',
                autoClose: true,
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);
        let vu = new Vue({
            el: '#app',
            data: {
                selectedOvertimeType : null,
                selectedEmployee     : null,
			    closeYear: {!!json_encode($selectYear) !!},
			    drawingList: {!!json_encode($ownerMember) !!},
			    drawingAmount: {!! $drawingAmount  !!},
			    openingBelanceEquity: {!!json_encode($openingBelanceEquity) !!},
                total:0,
                total_last_equity:0,
                equityAmount:null,
                select_account:null,
                netProfit:null,
                qty:null,
                iserror:false,
                is_error:false,
                amount:null
            },

			computed: {
				totalBalance: function () {
                    var sum = 0;
					
					if (this.closeYear) {
					var total_equity = this.closeYear.total_equity;
					var total_income = this.closeYear.total_income;
					var opening = this.openingBelanceEquity.balance;
					var drawingAmount = this.drawingAmount;
                    // console.log(123, Number.parseFloat(opening), Number.parseFloat(total_equity), Number.parseFloat(total_income) , Number.parseFloat(drawingAmount));
					
					sum = ((Number.parseFloat(opening) + Number.parseFloat(total_equity) + Number.parseFloat(total_income)) - Number.parseFloat(drawingAmount));
					this.total = myRound(sum);
					this.total_last_equity = myRound(Number.parseFloat(opening) + Number.parseFloat(total_equity));
					this.netProfit = myRound(Number.parseFloat(total_income));
					}

                    return myRound(sum);
                },
			},

            methods: {

                profit_equity() {
                    var closeYear_id = vu.closeYear.id;
                    // vu.drawingList = [];
                    axios.get("{{route('closeYear.profitAndEquity')}}", {
                        params: {
                            closeYear_id: closeYear_id
                        }
                    })
                        .then(function (response) {
                            if (response.data.length > 0) {
                                var data = response.data[0];
                                // console.log(123124,response.data);
                                // vu.drawingList = data.drawing;
                                // vu.drawingAmount = myRound(data.drawingAmount);
                                // vu.equityAmount = myRound(data.equityAmount);
                                // vu.netProfit = myRound(data.netProfit);
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

                SetEquity(index) {
                    
                    if(vu.drawingList.length > 0 && vu.drawingList[index].last_percentage > 0){
                        var last_per = 0;
                        var new_per = 0;
                        for (var i = 0; i < vu.drawingList.length; i++) {
                            if (vu.drawingList[i].last_percentage > 0 && vu.total > 0) {
                                // var total_all = vu.total;
                                var last_equity_am = (Number.parseFloat(vu.total_last_equity) * Number.parseFloat(vu.drawingList[i].last_percentage) / 100);
                                var netProfit = (Number.parseFloat(vu.netProfit) * Number.parseFloat(vu.drawingList[i].last_percentage) / 100);
                                vu.drawingList[i].last_equity_amount = myRound(last_equity_am);
                                var drawing = Number.parseFloat(vu.drawingList[i].amount);
                                vu.drawingList[i].equity_from_profit = myRound((last_equity_am + netProfit) - drawing);
                                var equity_from_profit = myRound((last_equity_am + netProfit) - drawing);
                                var total_all = (Number.parseFloat(vu.total) - Number.parseFloat(vu.drawingAmount));
                                vu.drawingList[i].new_percentage = (Number.parseFloat(equity_from_profit) * 100 / total_all).toFixed(2);
                                vu.SetNewEquity(i);
                                last_per += Number.parseFloat(vu.drawingList[i].last_percentage);
                                new_per += Number.parseFloat(vu.drawingList[i].new_percentage);
                            }
                        }
                        if (last_per != 100) {
                            vu.is_error = true;
                        }else{
                            vu.is_error = false;
                        }
                        if (new_per != 100) {
                            vu.iserror = true;
                        }else{
                            vu.iserror = false;
                        }
                    }
                    
                },
                SetNewEquity(index) {
                    
                    if(vu.drawingList.length > 0 && vu.drawingList[index].new_percentage > 0){
                        var last_per = 0;
                        for (var i = 0; i < vu.drawingList.length; i++) {
                            if (vu.drawingList[i].new_percentage > 0 && vu.total > 0) {
                                var total_all = Number.parseFloat(vu.total);
                                var new_equity_amount = (total_all * Number.parseFloat(vu.drawingList[i].new_percentage) / 100);
                                // console.log('12312',new_equity_amount);
                                vu.drawingList[i].new_equity_amount = myRound(new_equity_amount);
                                last_per += Number.parseFloat(vu.drawingList[i].new_percentage);
                            }
                        }
                        if (last_per != 100) {
                            vu.iserror = true;
                            // console.log(vu.iserror,last_per);
                        }else{
                            vu.iserror = false;
                        }
                    }
                    
                },

                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('overtime.store')}}";
                                form_id = 'overtime_form';
                                var data = $('#' + form_id).serialize();

                                axios.post(url, data)
                                    .then(function (response) {
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vu.selectedEmployee = null;
                                            vu.selectedOvertimeType = null;
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                }
            }
        })

    </script>
@endpush 