@extends('layouts.factor-master')
<?php
$reportTitle = __('layout.EquityDistribution');
?>
@section('content')


<h3 class="table-caption" style="text-align: center;">@lang('layout.EquityDistribution')</h3>

<table class="main-table">
  <thead>
    <tr class="bg">
      <th> @lang('layout.Record') </th>
      <th>@lang('layout.Year')</th> 
      <th>@lang('layout.Name')</th> 
      <th>@lang('layout.Account')</th> 
      <th>@lang('layout.Currency')</th>
      <th>@lang('layout.LastPercentage')</th> 
      <th>@lang('layout.LastEquityAmount')</th>
      <th>@lang('layout.Drawing')</th>
      <th>@lang('layout.NewPercentage')</th>
      <th>@lang('layout.NewEquityAmount')</th>
      <th>@lang('layout.Date')</th>
    </tr>
  </thead>
  <tbody>
    <?php
    $count = 1;
    ?>
    @foreach($data AS $record)
    <tr>
      <td class="center">{{ $count++ }}</td>
      <td class="hidden-xs"> {{ $record->year_name }}  </td>
      <td class="hidden-xs"> {{ $record->name }}  </td>
      <td class="hidden-xs"> {{ $record->account_name }}  </td>
      <td class="hidden-xs"> {{ $record->currency }}  </td>
      <td class="hidden-xs"> {{ $record->last_percentage }}  </td>
      <td class="hidden-xs"> {{ myRound($record->last_equity_amount) }}  </td>
      <td class="hidden-xs"> {{ myRound($record->drawing_amount) }}  </td>
      <td class="hidden-xs"> {{ $record->new_percentage }}  </td>
      <td class="hidden-xs"> {{ myRound($record->new_equity_amount) }}  </td>
      <td class="hidden-xs"> {{ convertDate($record->date) }}</td>
    </tr>
    @endforeach
  </tbody>
</table>
<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection