@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.CreateNewCloseYear')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'closeYear.putProfitAndEquity','method'=>'POST','class'=>'form-horizontal', 'id'=>'overtime_form')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                
                <div class="row">
					<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('layout.CloseYear')</label>
							<v-select placeholder="@lang('layout.CloseYear')" tabindex="1" label="name" :options="{{ json_encode($closeYear) }}" v-model="closeYear" @input="profit_equity()" ></v-select>
							<input type="hidden" name="closeYear_id" v-validate="'required'" data-vv-as="@lang('layout.CloseYear')" :value="(closeYear)?closeYear.id:null">
							<span class="required">@{{ errors.first('closeYear_id') }}</span>
                            
                            <input type="hidden" name="drawing" :value="(drawingAmount)?drawingAmount:0">
							<input type="hidden" name="equity" :value="(equityAmount)?equityAmount:0">
							<input type="hidden" name="netProfit" :value="(netProfit)?netProfit:0">
						</div>
					</div>
					<!-- <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('backup.create')</label>
							<input type="text" name="file_name"  class="form-control" placeholder="{{ date('Y-m-d_Hi') }}" v-validate="'required'" data-vv-as="@lang('backup.create')" />
							<span class="required">@{{ errors.first('file_name') }}</span>
						</div>
					</div> -->
                </div>
                <div class="row">
                    <div class="portlet-body">
                        <div class="table-scrollable">
                            <table class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                <tr>
                                        <th>@lang('layout.CloseDate')</th> 
                                        <th>@lang('layout.OpeningDate')</th> 
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.BaseCurrency')</th>
                                        <th>@lang('layout.TotalDrawing')</th>
                                        <th>@lang('layout.TotalInvestment')</th>
                                        <th>@lang('layout.NetProfit')</th>
                                </tr> 
                                </thead>
                                <tbody>
                                <tr v-if="closeYear">  
                                    <td class="hidden-xs"> @{{ closeYear.close_date }}  </td>
                                    <td class="hidden-xs"> @{{ closeYear.opening_date }}  </td>
                                    <td class="hidden-xs"> @{{ closeYear.description }}  </td>
                                    <td class="hidden-xs"> @{{ closeYear.base_currency }}</td>
                                    <td class="hidden-xs"> @{{ drawingAmount }}</td>
                                    <td class="hidden-xs"> @{{ equityAmount }}</td>
                                    <td class="hidden-xs"> @{{ netProfit }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <h2 v-if="closeYear" >@lang('layout.DrawingList')</h2>
                <div class="row" v-if="closeYear" >
                    <div class="portlet-body">
                        <div class="table-scrollable" v-if="drawingList.length > 0">
                            <table class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                <tr>
                                        <th>#</th> 
                                        <th>@lang('layout.Number')</th> 
                                        <th>@lang('layout.Name')</th>
                                        <th>@lang('layout.Amount')</th>
                                </tr> 
                                </thead>
                                <tbody>
                                <tr v-for="(row,index) in drawingList">  
                                    <td class="hidden-xs"> @{{ index+1 }}  </td>
                                    <td class="hidden-xs"> @{{ row.code }}  </td>
                                    <td class="hidden-xs"> @{{ row.name }}  </td>
                                    <td class="hidden-xs">
                                    <input type="number"  class="form-control" :name="'amount['+index+']'" :value="(!row)?null:myRound(row.amount)" readonly>
                                    <input type="hidden" :name="'id['+index+']'" :value="(!row)?null:row.member_id">
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <!-- <button type="button" class="btn blue"
                            @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> -->
                    <a href="{{route('closeYear.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        $(document).ready(function () {
            $('#initial-value-example').persianDatepicker({
                observer: true,
                format: 'YYYY/MM/DD',
                altField: '#observer-example-alt',
                altFormat: 'u',
                autoClose: true,
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);
        let vu = new Vue({
            el: '#app',
            data: {
                selectedOvertimeType : null,
                selectedEmployee     : null,
			    closeYear: null,
			    drawingList: [],
                drawingAmount:null,
                equityAmount:null,
                netProfit:null,
                qty:null,
                amount:null
            },


            methods: {

                profit_equity() {
                    var closeYear_id = vu.closeYear.id;
                    vu.drawingList = [];
                    axios.get("{{route('closeYear.profitAndEquity')}}", {
                        params: {
                            closeYear_id: closeYear_id
                        }
                    })
                        .then(function (response) {
                            if (response.data.length > 0) {
                                var data = response.data[0];
                                // console.log(123124,response.data);
                                vu.drawingList = data.drawing;
                                vu.drawingAmount = myRound(data.drawingAmount);
                                vu.equityAmount = myRound(data.equityAmount);
                                vu.netProfit = myRound(data.netProfit);
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('overtime.store')}}";
                                form_id = 'overtime_form';
                                var data = $('#' + form_id).serialize();

                                axios.post(url, data)
                                    .then(function (response) {
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vu.selectedEmployee = null;
                                            vu.selectedOvertimeType = null;
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                }
            }
        })

    </script>
@endpush 