@extends('layouts.app')

@section('content')

@include('simple_modal.modal')
    <div id="create_app" v-cloak>
        {{Form::open(['route' => 'closeYear.openingYear','method' => 'POST','class' => 'inline'])}}

        <button id="show-modal1" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <simple-modal :form_route="'closeYear.openingYear'" v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                    </div>
                </div>
                <div class="row">
					<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('layout.CloseYear')</label>
							<v-select placeholder="@lang('layout.CloseYear')" tabindex="1" label="name" :options="{{ json_encode($close_year) }}" v-model="closeYear"></v-select>
							<input type="hidden" name="closeYear_id" required="required" :value="(closeYear)?closeYear.id:null">
						</div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('backup.create')</label>
							<input type="text" name="file_name"  class="form-control" placeholder="{{ date('Y-m-d_Hi') }}" />
						</div>
					</div>
				</div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </simple-modal>
        {{Form::close()}}
    </div>    
    
    <div id="create_clearDatabase" v-cloak>
        {{Form::open(['route' => 'closeYear.clearDatabaseByCompany','method' => 'POST','class' => 'inline'])}}

        <button id="show-clearDatabase" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <simple-modal :form_route="'closeYear.clearDatabaseByCompany'" v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                    </div>
                </div>
                <div class="row">
					<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('layout.Company')</label>
							<v-select placeholder="@lang('layout.Company')" tabindex="1" label="name" :options="companies" v-model="company" @Click.native="getAllCompany()"></v-select>
							<input type="hidden" name="company_id" required="required" :value="(company)?company.id:null">
						</div>
                    </div>
				</div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </simple-modal>
        {{Form::close()}}
    </div>

<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" 
        :value-type="'overtimes'"
        @closed="closeModal">

        <div slot="body">
            <div class="row">
                
            </div>

            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                               
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date">
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>            
    </report-modal>
</div>

    <!-- END PAGE HEADER-->


    

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.CloseYearList')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                @permission('closeYear-create')
                    <a href="{{route('lastYear.openLastYear')}}">
						<button class="btn btn-info">
							<i class="fa"></i> @lang('layout.OpenLastYear')
						</button>
                    </a>
                    <form action="{{route('closeYear.clearDatabase')}}" method="get" class="inline">
                        <input type="hidden" name="_token" value="' . csrf_token() . '"/>
                        <button type="button" onclick="deleteItem(this)" class="btn btn-danger " role="button">@lang('layout.ClearSystemDatabase')</button>
                    </form>
                    <button type="button" id="clearDatabase" class="btn btn-danger"><i class="fa fa-setting"></i> @lang('layout.ClearSystemDatabaseByCampany') </button>  
                    <button type="button" id="create_id" class="btn btn-warning"><i class="fa fa-setting"></i> @lang('layout.StartNewYear') </button>  
                    <a href="{{route('closeYear.openYear')}}">
						<button class="btn btn-success">
							<i class="fa "></i> @lang('layout.TransferProfitAndEquity')
						</button>
                    </a>
                    <a href="{{route('closeYear.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button></a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="fiscal_year">
                    <thead>
                    <tr>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.CloseDate')</th>
                        <th>@lang('layout.OpeningDate')</th>
                        <th>@lang('layout.BaseCurrency')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
 @include('print.modal')
@push('scripts')
<script>
    $(document).ready(function() {
        $('#fiscal_year').DataTable( {
            ajax:'{{route("closeYear.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [[ 0, "{{getRowOrder()}}" ]],
            scrollCollapse: true,
            paging:         true,
            serverSide: true,


            columns: [  
                { data: 'name',                 name: 'name',orderable:false,searchable:false },
                { data: 'close_date',           name: 'close_date',orderable:false,searchable:false },
                { data: 'opening_date',         name: 'opening_date',orderable:false,searchable:false },
                { data: 'base_currency',        name: 'base_currency',orderable:false,searchable:false },
                { data: 'status',               name: 'status',orderable:false,searchable:false },
                { data: 'description',          name: 'description',orderable:false,searchable:false},
                { data: 'user',                 name: 'users.name'},
                { data: 'actions',              name: 'actions',orderable:false,searchable:false },



            ]
        });
    });
      Vue.component('v-select', VueSelect.VueSelect)


      // new for modal


var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },


    
            }
        });


new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
            
        }
    }
});


 // start app
 new Vue({
        el: '#create_app',
        data: {
            showModal: false,
            closeYear:null

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {

                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    }); 

    $('#create_id').on('click', function(e) {
        $('#show-modal1').click();
        e.preventDefault();
    });
    
    new Vue({
        el: '#create_clearDatabase',
        data: {
            showModal: false,
            company:null,
            companies:[]

        },
        methods: {
            getAllCompany() {
                var vs = this;
                axios.get("{!! route('group.company.all') !!}")
                .then((response) => {
                    console.log(21);
                    vs.companies = response.data;
                });
            },
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {

                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    
    $('#clearDatabase').on('click', function(e) {
        $('#show-clearDatabase').click();
        e.preventDefault();
    });
 
    Vue.component('v-select', VueSelect.VueSelect)

    
</script>
@endpush
