@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('salary_details');
$_date=in_array('date', $report);
$_name=in_array('name', $report);
$_phone=in_array('phone', $report);
$_currency=in_array('currency', $report);
$_amount=in_array('amount', $report);
?>


<h3 class="table-caption" style="text-align: center;">@lang('layout.OvertimeReport')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
    <td class="center"><div> @lang('layout.Record')  </div></td>
    @if($_date)<td class="center"><div> @lang('layout.Employee_ID')</div></td>@endif
    @if($_date)<td class="center"><div> @lang('layout.EmployeeName')</div></td>@endif
    @if($_date)<td class="center"><div> @lang('menu.OvertimeType')</div></td>@endif
    @if($_name)<td class="center"><div> @lang('layout.Quantity') </div></td>@endif
    @if($_name)<td class="center"><div> @lang('layout.Currency') </div></td>@endif
    @if($_phone)<td class="center"><div> @lang('layout.Amount')</div></td>@endif
    @if($_phone)<td class="center"><div> @lang('layout.Total')</div></td>@endif
    @if($_date)<td class="center"><div> @lang('layout.Date')</div></td>@endif
    @if($_currency)<td class="center"><div> @lang('layout.Description')</div></td>@endif
  </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency=0;
  $currencies=[];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;
  }
  ?>
    <td class="center">{{++$count}}</td>
    @if($_name)<td class="center">{{$record->Employee_ID}}</td>@endif
    @if($_name)<td class="center">{{$record->employee}}</td>@endif
    @if($_name)<td class="center">{{$record->type}}</td>@endif
    @if($_name)<td class="center">{{$record->qty}}</td>@endif
    @if($_name)<td class="center">{{$record->currency}}</td>@endif
    @if($_name)<td class="center">{{$record->amount}}</td>@endif
    @if($_name)<td class="center">{{$record->amount*$record->qty}}</td>@endif
    @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
    @if($_name)<td class="center">{{$record->description}}</td>@endif

  </tr>
  @endforeach
</table>

   <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection